/*
 * Decompiled with CFR 0.152.
 */
package csplugins.biomodules.view;

import csplugins.biomodules.Biomodule;
import csplugins.biomodules.BiomodulesManager;
import csplugins.biomodules.view.BiomoduleNetworkView;
import csplugins.biomodules.view.SpecificNodeSizeCalculator;
import csplugins.graphAlgo.MetaNode;
import csplugins.graphAlgo.NodeCollapser;
import cytoscape.GraphObjAttributes;
import cytoscape.data.GraphProps;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.GenericEdgeArrowCalculator;
import cytoscape.visual.calculators.GenericEdgeColorCalculator;
import cytoscape.visual.calculators.GenericEdgeLabelCalculator;
import cytoscape.visual.calculators.GenericEdgeLineTypeCalculator;
import cytoscape.visual.calculators.GenericNodeColorCalculator;
import cytoscape.visual.calculators.GenericNodeFontSizeCalculator;
import cytoscape.visual.calculators.GenericNodeLabelCalculator;
import cytoscape.visual.calculators.GenericNodeLineTypeCalculator;
import cytoscape.visual.calculators.GenericNodeShapeCalculator;
import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.DiscreteMapping;
import cytoscape.visual.mappings.LinearNumberToColorInterpolator;
import cytoscape.visual.mappings.PassThroughMapping;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CollapsingBiomodulesView
extends BiomoduleNetworkView
implements ActionListener {
    public static final Color g = new Color(204, 204, 204);
    public static final Color c = Color.BLACK;
    public NodeCollapser h;
    public Map d;
    public boolean a;
    public MetaNode[] f;
    public boolean e;

    public CollapsingBiomodulesView(BiomodulesManager biomodulesManager) {
        super(biomodulesManager);
        this.setCollapse(true);
        this.setVisualMappings();
        mB mB2 = this.b.getCytoscapeWindow().getGraphView();
        mB2.a(0.0);
        this.b.getBiomoduleNetwork().addListener(this);
    }

    public void updateViewableGraph() {
        GraphProps graphProps = new GraphProps(this.b.getGraph(), this.b.getNodeAttributes(), this.b.getEdgeAttributes());
        this.h = new NodeCollapser(graphProps);
        this.h.setUpdateMembersPositions(true);
        this.d = new HashMap();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("removed")) {
            Object object = actionEvent.getSource();
            GraphObjAttributes graphObjAttributes = this.b.getNodeAttributes();
            if (object instanceof Biomodule) {
                Biomodule biomodule = (Biomodule)object;
                this.setCollapse(false);
                this.drawBiomodule(biomodule, false);
                MetaNode metaNode = (MetaNode)this.d.remove(biomodule);
                String string2 = metaNode.getUniqueID();
                graphObjAttributes.removeNameMapping(string2);
                graphObjAttributes.deleteAttribute("metaNode", string2);
            } else if (object instanceof Biomodule[]) {
                Biomodule[] biomoduleArray = (Biomodule[])object;
                this.setCollapse(false);
                for (int i2 = 0; i2 < biomoduleArray.length; ++i2) {
                    this.b(biomoduleArray[i2]);
                    MetaNode metaNode = (MetaNode)this.d.remove(biomoduleArray[i2]);
                    String string3 = metaNode.getUniqueID();
                    graphObjAttributes.removeNameMapping(string3);
                    graphObjAttributes.deleteAttribute("metaNode", string3);
                }
                VisualMappingManager visualMappingManager = this.b.getCytoscapeWindow().getVizMapManager();
                visualMappingManager.applyNodeAppearances();
                visualMappingManager.applyEdgeAppearances();
                this.redrawGraph(false, false);
            }
        }
    }

    public void setCollapse(boolean bl2) {
        this.a = bl2;
    }

    public void draw(boolean bl2, boolean bl3, boolean bl4) {
        Biomodule[] biomoduleArray = this.b.getBiomoduleNetwork().getAllBiomodules();
        this.draw(biomoduleArray, bl2, bl3, bl4);
    }

    public void draw(Biomodule[] biomoduleArray, boolean bl2, boolean bl3, boolean bl4) {
        this.b.getCytoscapeWindow().setInteractivity(false);
        if (bl4) {
            for (int i2 = 0; i2 < biomoduleArray.length; ++i2) {
                this.drawBiomodule(biomoduleArray[i2], bl3);
            }
        } else {
            for (int i3 = 0; i3 < biomoduleArray.length; ++i3) {
                this.b(biomoduleArray[i3]);
            }
            if (bl3) {
                this.spreadMultipleEdges();
            }
            VisualMappingManager visualMappingManager = this.b.getCytoscapeWindow().getVizMapManager();
            visualMappingManager.applyNodeAppearances();
            visualMappingManager.applyEdgeAppearances();
        }
        this.redrawGraph(bl2, false);
        this.b.getCytoscapeWindow().setInteractivity(true);
    }

    public void drawMultipleEdges() {
        this.spreadMultipleEdges();
        this.redrawGraph(false, false);
    }

    public void spreadMultipleEdges() {
        nn nn2 = new nn();
        nn2.doLayout(this.b.getCytoscapeWindow().getGraph());
    }

    public boolean b(Biomodule biomodule) {
        MetaNode metaNode;
        if (this.h == null) {
            this.updateViewableGraph();
        }
        if ((metaNode = (MetaNode)this.d.get(biomodule)) == null) {
            GraphProps graphProps = new GraphProps(this.b.getGraph(), this.b.getNodeAttributes(), this.b.getEdgeAttributes());
            metaNode = new MetaNode(this.b.getCytoscapeWindow(), graphProps, biomodule.getUniqueID(), this.h);
            metaNode.addNodes(biomodule.getNodes());
            this.d.put(biomodule, metaNode);
            this.b.getGraph().n(metaNode.node());
            this.a(biomodule);
            this.c(biomodule);
            this.setFillColorAsExpressionAverage(biomodule);
        } else {
            metaNode.setCytoscapeWindow(this.b.getCytoscapeWindow());
        }
        boolean bl2 = true;
        bl2 = this.a ? this.h.collapse(metaNode) : this.h.expand(metaNode, true);
        return bl2;
    }

    public void drawBiomodule(Biomodule biomodule, boolean bl2) {
        boolean bl3 = this.b(biomodule);
        if (bl3 && this.a && bl2) {
            this.spreadMultipleEdges();
        }
        if (bl3) {
            VisualMappingManager visualMappingManager = this.b.getCytoscapeWindow().getVizMapManager();
            visualMappingManager.applyNodeAppearances();
            visualMappingManager.applyEdgeAppearances();
            this.redrawGraph(false, false);
        }
    }

    public void setVisualMappings() {
        Cloneable cloneable;
        VisualMappingManager visualMappingManager = this.b.getCytoscapeWindow().getVizMapManager();
        CalculatorCatalog calculatorCatalog = visualMappingManager.getCalculatorCatalog();
        VisualStyle visualStyle = calculatorCatalog.getVisualStyle("Collapsing_Biomodules_View");
        if (visualStyle != null) {
            visualMappingManager.setVisualStyle(visualStyle);
            System.out.println("VISUAL STYLE Collapsing_Biomodules_View ALREADY EXISTS, RETURNING");
            return;
        }
        System.out.println("VISUAL STYLE Collapsing_Biomodules_View DOES NOT EXIST.");
        NodeAppearanceCalculator nodeAppearanceCalculator = visualMappingManager.getVisualStyle().getNodeAppearanceCalculator();
        EdgeAppearanceCalculator edgeAppearanceCalculator = visualMappingManager.getVisualStyle().getEdgeAppearanceCalculator();
        LinearNumberToColorInterpolator linearNumberToColorInterpolator = new LinearNumberToColorInterpolator();
        ContinuousMapping continuousMapping = new ContinuousMapping(g, "expression", linearNumberToColorInterpolator, 1);
        BoundaryRangeValues boundaryRangeValues = new BoundaryRangeValues();
        boundaryRangeValues.a = new Color(0, 0, 255);
        boundaryRangeValues.b = new Color(0, 0, 255);
        boundaryRangeValues.c = new Color(0, 0, 255);
        continuousMapping.put(new Double(-1.0), boundaryRangeValues);
        boundaryRangeValues = new BoundaryRangeValues();
        boundaryRangeValues.a = new Color(255, 255, 255);
        boundaryRangeValues.b = new Color(255, 255, 255);
        boundaryRangeValues.c = new Color(255, 255, 255);
        continuousMapping.put(new Double(0.0), boundaryRangeValues);
        boundaryRangeValues = new BoundaryRangeValues();
        boundaryRangeValues.a = new Color(255, 0, 0);
        boundaryRangeValues.b = new Color(255, 0, 0);
        boundaryRangeValues.c = new Color(255, 0, 0);
        continuousMapping.put(new Double(1.0), boundaryRangeValues);
        GenericNodeColorCalculator genericNodeColorCalculator = new GenericNodeColorCalculator("Mean Expression Color Calculator", continuousMapping);
        nodeAppearanceCalculator.setNodeFillColorCalculator(genericNodeColorCalculator);
        LinearNumberToColorInterpolator linearNumberToColorInterpolator2 = new LinearNumberToColorInterpolator();
        ContinuousMapping continuousMapping2 = new ContinuousMapping(c, "icatProb", linearNumberToColorInterpolator2, 1);
        BoundaryRangeValues boundaryRangeValues2 = new BoundaryRangeValues();
        boundaryRangeValues2 = new BoundaryRangeValues();
        boundaryRangeValues2.a = new Color(0, 0, 0);
        boundaryRangeValues2.b = new Color(0, 0, 0);
        boundaryRangeValues2.c = new Color(0, 0, 0);
        continuousMapping2.put(new Double(0.0), boundaryRangeValues2);
        boundaryRangeValues2 = new BoundaryRangeValues();
        boundaryRangeValues2.a = new Color(0, 255, 0);
        boundaryRangeValues2.b = new Color(0, 255, 0);
        boundaryRangeValues2.c = new Color(0, 255, 0);
        continuousMapping2.put(new Double(1.0), boundaryRangeValues2);
        GenericNodeColorCalculator genericNodeColorCalculator2 = new GenericNodeColorCalculator("ICAT probability", continuousMapping2);
        nodeAppearanceCalculator.setNodeBorderColorCalculator(genericNodeColorCalculator2);
        DiscreteMapping discreteMapping = new DiscreteMapping(new Byte(0), 1);
        discreteMapping.setControllingAttributeName("moleculeType", visualMappingManager.getNetwork(), false);
        discreteMapping.put("biomodule", new Byte(2));
        discreteMapping.put("protein", new Byte(0));
        discreteMapping.put("metabolite", new Byte(5));
        discreteMapping.put("unknown", new Byte(0));
        GenericNodeShapeCalculator genericNodeShapeCalculator = new GenericNodeShapeCalculator("moleculeType", discreteMapping);
        nodeAppearanceCalculator.setNodeShapeCalculator(genericNodeShapeCalculator);
        DiscreteMapping discreteMapping2 = new DiscreteMapping(eS.j, 1);
        discreteMapping2.setControllingAttributeName("moleculeType", visualMappingManager.getNetwork(), false);
        discreteMapping2.put("biomodule", eS.g);
        GenericNodeLineTypeCalculator genericNodeLineTypeCalculator = new GenericNodeLineTypeCalculator("Biomodule Border", discreteMapping2);
        nodeAppearanceCalculator.setNodeLineTypeCalculator(genericNodeLineTypeCalculator);
        Double d2 = new Double(110.0);
        DiscreteMapping discreteMapping3 = new DiscreteMapping(d2, 1);
        discreteMapping3.setControllingAttributeName("moleculeType", visualMappingManager.getNetwork(), true);
        discreteMapping3.put("protein", d2);
        discreteMapping3.put("metabolite", d2);
        discreteMapping3.put("unknown", d2);
        discreteMapping3.put("dna", d2);
        SpecificNodeSizeCalculator specificNodeSizeCalculator = new SpecificNodeSizeCalculator("Biomodule Width", discreteMapping3);
        specificNodeSizeCalculator.setSpecialAttrName("node.width");
        nodeAppearanceCalculator.setNodeWidthCalculator(specificNodeSizeCalculator);
        Double d3 = new Double(50.0);
        DiscreteMapping discreteMapping4 = new DiscreteMapping(d3, 1);
        discreteMapping4.setControllingAttributeName("moleculeType", visualMappingManager.getNetwork(), true);
        discreteMapping4.put("protein", d3);
        discreteMapping4.put("metabolite", d3);
        discreteMapping4.put("unknown", d3);
        discreteMapping4.put("dna", d3);
        SpecificNodeSizeCalculator specificNodeSizeCalculator2 = new SpecificNodeSizeCalculator("Biomodule height", discreteMapping4);
        specificNodeSizeCalculator2.setSpecialAttrName("node.height");
        nodeAppearanceCalculator.setNodeHeightCalculator(specificNodeSizeCalculator2);
        DiscreteMapping discreteMapping5 = new DiscreteMapping(Color.BLACK, 0);
        discreteMapping5.setControllingAttributeName("interaction", visualMappingManager.getNetwork(), false);
        discreteMapping5.put("pp", Color.BLUE);
        discreteMapping5.put("(pp)", Color.BLUE);
        discreteMapping5.put("pm", Color.GREEN);
        discreteMapping5.put("(pm)", Color.GREEN);
        discreteMapping5.put("pd", Color.BLACK);
        discreteMapping5.put("(pd)", Color.BLACK);
        discreteMapping5.put("positive", Color.GREEN);
        discreteMapping5.put("negative", Color.RED);
        discreteMapping5.put("annotation", Color.RED);
        discreteMapping5.put("(annotation)", Color.RED);
        GenericEdgeColorCalculator genericEdgeColorCalculator = new GenericEdgeColorCalculator("Biomodules Edges", discreteMapping5);
        edgeAppearanceCalculator.setEdgeColorCalculator(genericEdgeColorCalculator);
        DiscreteMapping discreteMapping6 = new DiscreteMapping(new Integer(20), 1);
        discreteMapping6.setControllingAttributeName("moleculeType", visualMappingManager.getNetwork(), false);
        discreteMapping6.put("biomodule", new Integer(160));
        discreteMapping6.put("protein", new Integer(20));
        discreteMapping6.put("metabolite", new Integer(20));
        discreteMapping6.put("unknown", new Integer(20));
        GenericNodeFontSizeCalculator genericNodeFontSizeCalculator = new GenericNodeFontSizeCalculator("Biomodules Font Size Calculator", discreteMapping6);
        nodeAppearanceCalculator.setNodeFontSizeCalculator(genericNodeFontSizeCalculator);
        DiscreteMapping discreteMapping7 = new DiscreteMapping(eS.a, 0);
        discreteMapping7.setControllingAttributeName("interaction", visualMappingManager.getNetwork(), false);
        discreteMapping7.put("pp", eS.a);
        discreteMapping7.put("pm", eS.a);
        discreteMapping7.put("positive", eS.a);
        discreteMapping7.put("negative", eS.a);
        discreteMapping7.put("annotation", eS.c);
        GenericEdgeLineTypeCalculator genericEdgeLineTypeCalculator = new GenericEdgeLineTypeCalculator("Biomodules Line Type Map", discreteMapping7);
        edgeAppearanceCalculator.setEdgeLineTypeCalculator(genericEdgeLineTypeCalculator);
        DiscreteMapping discreteMapping8 = new DiscreteMapping(nh.g, 0);
        discreteMapping8.setControllingAttributeName("interaction", visualMappingManager.getNetwork(), false);
        discreteMapping8.put("pp", nh.g);
        discreteMapping8.put("pm", nh.g);
        discreteMapping8.put("pd", nh.f);
        discreteMapping8.put("positive", nh.f);
        discreteMapping8.put("negative", nh.f);
        GenericEdgeArrowCalculator genericEdgeArrowCalculator = new GenericEdgeArrowCalculator("Biomodules Arrow Map", discreteMapping8);
        edgeAppearanceCalculator.setEdgeTargetArrowCalculator(genericEdgeArrowCalculator);
        PassThroughMapping passThroughMapping = new PassThroughMapping((Object)"", "annotation");
        GenericEdgeLabelCalculator genericEdgeLabelCalculator = new GenericEdgeLabelCalculator("Biomodules Edge Label Map", passThroughMapping);
        edgeAppearanceCalculator.setEdgeLabelCalculator(genericEdgeLabelCalculator);
        PassThroughMapping passThroughMapping2 = new PassThroughMapping((Object)"", "commonName");
        GenericNodeLabelCalculator genericNodeLabelCalculator = new GenericNodeLabelCalculator("Common Name", passThroughMapping2);
        nodeAppearanceCalculator.setNodeLabelCalculator(genericNodeLabelCalculator);
        nodeAppearanceCalculator.setNodeSizeLocked(false);
        if (visualStyle == null) {
            System.out.println("VISUAL STYLE Collapsing_Biomodules_View DID NOT EXIST, CREATING IT");
            cloneable = visualMappingManager.getVisualStyle().getGlobalAppearanceCalculator();
            visualStyle = new VisualStyle("Collapsing_Biomodules_View", nodeAppearanceCalculator, edgeAppearanceCalculator, (GlobalAppearanceCalculator)cloneable);
            calculatorCatalog.addVisualStyle(visualStyle);
            visualMappingManager.setVisualStyle(visualStyle);
        }
        if ((cloneable = visualMappingManager.getVisualStyle()) != visualStyle) {
            throw new IllegalStateException("Oops! The set style and my style are not equal.");
        }
        System.out.println("Visual style set:" + cloneable + " with node app calculator: " + ((VisualStyle)cloneable).getNodeAppearanceCalculator().getDescription());
    }

    public void c(Biomodule biomodule) {
        MetaNode metaNode = (MetaNode)this.d.get(biomodule);
        if (metaNode.isEmpty()) {
            return;
        }
        switch (2) {
            case 2: {
                double d2 = (double)metaNode.getNumNodes() * this.d(biomodule);
                double d3 = 2.0 * Math.sqrt(d2 / Math.PI);
                metaNode.setSize(d3, d3);
                break;
            }
            default: {
                System.out.println("Dimension for this shape not implemented yet");
                return;
            }
        }
    }

    public double d(Biomodule biomodule) {
        hm[] hmArray = biomodule.getNodes();
        ny ny2 = this.b.getCytoscapeWindow().getGraph().m(hmArray[0]);
        double d2 = ny2.u();
        double d3 = ny2.n();
        double d4 = d2 * d3;
        if (ny2 instanceof M) {
            M m2 = (M)ny2;
            byte by2 = m2.B();
            switch (by2) {
                case 2: {
                    d4 = Math.PI * (d2 / 2.0) * (d2 / 2.0);
                    break;
                }
            }
        }
        return d4;
    }

    public void setFillColorAsExpressionAverage(Biomodule biomodule) {
        if (!this.b.getNodeAttributes().hasAttribute("expression")) {
            return;
        }
        hm[] hmArray = biomodule.getNodes();
        double d2 = 0.0;
        int n2 = 0;
        GraphObjAttributes graphObjAttributes = this.b.getNodeAttributes();
        for (int i2 = 0; i2 < hmArray.length; ++i2) {
            hm hm2 = hmArray[i2];
            String string = graphObjAttributes.getCanonicalName(hm2);
            Double d3 = (Double)graphObjAttributes.getValue("expression", string);
            if (d3 == null) continue;
            d2 += d3.doubleValue();
            ++n2;
        }
        if (n2 == 0) {
            return;
        }
        MetaNode metaNode = (MetaNode)this.d.get(biomodule);
        String string = metaNode.getUniqueID();
        graphObjAttributes.deleteAttribute("node.fillColor", string);
        graphObjAttributes.set("expression", string, d2 /= (double)n2);
    }

    public void a(Biomodule biomodule) {
        String string = biomodule.getName();
        MetaNode metaNode = (MetaNode)this.d.get(biomodule);
        metaNode.setLabelText(string);
    }

    public int getNumCollapsedBiomodules() {
        if (this.h == null) {
            return 0;
        }
        MetaNode[] metaNodeArray = this.h.getCollapsedMetaNodesArray();
        return metaNodeArray.length;
    }

    public Biomodule[] getCollapsedBiomodules() {
        if (this.h == null) {
            return new Biomodule[0];
        }
        Set set = this.h.getCollapsedMetaNodesSet();
        Biomodule[] biomoduleArray = this.b.getBiomoduleNetwork().getAllBiomodules();
        ArrayList<Biomodule> arrayList = new ArrayList<Biomodule>();
        for (int i2 = 0; i2 < biomoduleArray.length; ++i2) {
            MetaNode metaNode = (MetaNode)this.d.get(biomoduleArray[i2]);
            if (metaNode == null || !set.contains(metaNode)) continue;
            arrayList.add(biomoduleArray[i2]);
        }
        return arrayList.toArray(new Biomodule[arrayList.size()]);
    }

    public Map getBiomodulesToMetaNodes() {
        return this.d;
    }

    public void switchCollapsedState(boolean bl2) {
        if (this.h == null) {
            return;
        }
        this.e = bl2;
        if (!bl2) {
            Set set = this.h.getCollapsedMetaNodesSet();
            this.f = set.toArray(new MetaNode[set.size()]);
            for (int i2 = 0; i2 < this.f.length; ++i2) {
                this.h.expand(this.f[i2], false);
            }
        } else {
            throw new UnsupportedOperationException("switchCollapsedState(false) is not supported");
        }
    }

    public void undoSwitchCollapsedState() {
        if (this.h == null || this.f == null) {
            return;
        }
        if (!this.e) {
            for (int i2 = 0; i2 < this.f.length; ++i2) {
                this.h.collapse(this.f[i2]);
            }
            this.f = null;
        }
    }
}

