/*
 * Decompiled with CFR 0.152.
 */
package csplugins.biomodules.calculator.ui;

import csplugins.biomodules.calculator.RGBiomodulesCalculator;
import csplugins.biomodules.calculator.ui.HCPlot;
import csplugins.biomodules.ui.BiomodulesHelpDialog;
import csplugins.biomodules.view.ClusteringBiomodulesView;
import csplugins.biomodules.view.CollapsingBiomodulesView;
import csplugins.graphAlgo.hierarchicalClustering.HCAnimator;
import csplugins.util.SwingWorker;
import cytoscape.CytoscapeWindow;
import cytoscape.GraphObjAttributes;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class RGBiomodulesCalculatorDialog
extends JDialog {
    public RGBiomodulesCalculator J;
    public CollapsingBiomodulesView m;
    public ClusteringBiomodulesView t;
    public JPanel v;
    public JTabbedPane i;
    public JPanel c;
    public JPanel e;
    public JPanel I;
    public JLabel q;
    public JTextField B;
    public JPanel f;
    public JPanel H;
    public JPanel E;
    public JLabel l;
    public JComboBox D;
    public JLabel h;
    public JPanel j;
    public JLabel k;
    public JButton b;
    public JButton C;
    public JButton s;
    public JButton r;
    public JButton n;
    public JButton a;
    public Border u;
    public Component K;
    public int p;
    public CytoscapeWindow w;
    public HCPlot y;
    public HCPlot A;
    public boolean g;
    public double[] d;
    public double[] F;
    public NumberFormat x;
    public File o;
    public JDialog G;
    public JDialog z;

    public RGBiomodulesCalculatorDialog(CytoscapeWindow cytoscapeWindow, Dialog dialog, RGBiomodulesCalculator rGBiomodulesCalculator, CollapsingBiomodulesView collapsingBiomodulesView, String string) {
        super(dialog, string);
        this.w = cytoscapeWindow;
        this.K = dialog;
        this.J = rGBiomodulesCalculator;
        this.m = collapsingBiomodulesView;
        this.x = NumberFormat.getInstance();
        this.x.setMaximumFractionDigits(2);
        this.b();
    }

    public RGBiomodulesCalculatorDialog(CytoscapeWindow cytoscapeWindow, Frame frame, RGBiomodulesCalculator rGBiomodulesCalculator, CollapsingBiomodulesView collapsingBiomodulesView, String string) {
        super(frame, string);
        this.w = cytoscapeWindow;
        this.K = frame;
        this.J = rGBiomodulesCalculator;
        this.m = collapsingBiomodulesView;
        this.x = NumberFormat.getInstance();
        this.x.setMaximumFractionDigits(2);
        this.b();
    }

    public void b() {
        if (this.v != null) {
            this.v.removeAll();
        }
        this.v = new JPanel();
        this.v.setLayout(new BoxLayout(this.v, 1));
        this.c = new JPanel();
        this.c.setLayout(new BoxLayout(this.c, 1));
        this.u = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.c.setBorder(this.u);
        this.f = new JPanel();
        this.f.setLayout(new BoxLayout(this.f, 1));
        this.f.setBorder(BorderFactory.createTitledBorder("Biomodules Parameters"));
        this.I = new JPanel();
        this.I.setLayout(new FlowLayout(1));
        this.q = this.J.usingMinNumProtsCond() ? new JLabel("Minimum member proteins:") : new JLabel("Minimum member nodes:");
        this.I.add(this.q);
        String string = Integer.toString(this.J.getMinNumProts());
        this.B = new JTextField(string, 2);
        this.B.addActionListener(new MinBioSizeListener(this));
        this.I.add(this.B);
        this.f.add(this.I);
        this.E = new JPanel();
        this.E.setLayout(new FlowLayout(1));
        this.u = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        this.E.setBorder(this.u);
        this.l = new JLabel("Join Number vs. ");
        this.E.add(this.l);
        String[] stringArray = new String[]{"Num Biomodules", "Join Distance"};
        this.D = new JComboBox<String>(stringArray);
        this.D.addActionListener(new PlotOptionsListener(this));
        this.E.add(this.D);
        this.f.add(this.E);
        this.H = new JPanel();
        this.H.setLayout(new FlowLayout(1));
        this.H.setBorder(this.u);
        this.k = new JLabel();
        this.h = new JLabel();
        this.updatePlots(false);
        this.f.add(this.H);
        this.j = new JPanel();
        this.j.setLayout(new FlowLayout(1));
        if (this.y != null && this.p != this.y.getSelectedJoinNumber()) {
            System.out.println("ERROR in RGBiomodulesCalculatorDialog : nNumber != bioNumPlot.getSelectedJoinNumber()");
        }
        this.j.add(this.k);
        this.j.add(this.h);
        this.f.add(this.j);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        this.b = new JButton("Cluster");
        this.b.addActionListener(new ClusterButtonListener(this));
        jPanel.add(this.b);
        this.C = new JButton("Collapse");
        this.C.addActionListener(new CollapseAction(this));
        jPanel.add(this.C);
        this.f.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1));
        this.s = new JButton("Dismiss");
        this.s.addActionListener(new DismissAction(this));
        this.n = new JButton("Help");
        this.n.addActionListener(new HelpButtonAction(this));
        jPanel2.add(this.n);
        jPanel2.add(this.s);
        this.c.add(this.f);
        this.e = new JPanel();
        this.e.setLayout(new BoxLayout(this.e, 1));
        this.e.setBorder(this.u);
        this.e.setBorder(BorderFactory.createTitledBorder("Algorithm Data"));
        JButton jButton = new JButton("Show All Pairs Shortest Paths Table");
        JButton jButton2 = new JButton("Show Manhattan Distances Table");
        JButton jButton3 = new JButton("Show Hierarchical-Tree Viewer");
        jButton.addActionListener(new ApspListener(this));
        jButton2.addActionListener(new DistancesListener(this));
        jButton3.addActionListener(new HCTreeButtonListener(this));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(5, 0, 20, 60));
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel3.add(jButton3);
        this.r = new JButton("Write Biomodules To File...");
        this.r.addActionListener(new WriteListener(this));
        if (this.J.getBiomoduleNetwork().getNumBiomodules() == 0) {
            this.r.setEnabled(false);
        }
        jPanel3.add(this.r);
        this.a = new JButton("Write Membership Node Attributes...");
        this.a.addActionListener(new NodeAttsListener(this));
        if (this.J.getBiomoduleNetwork().getNumBiomodules() == 0) {
            this.a.setEnabled(false);
        }
        jPanel3.add(this.a);
        this.e.add(jPanel3);
        this.i = new JTabbedPane();
        this.i.add("Plots", this.c);
        this.i.add("Data", this.e);
        this.v.add(this.i);
        this.v.add(jPanel2);
        this.setContentPane(this.v);
    }

    public String[] a() {
        int n2;
        String string = this.B.getText();
        try {
            n2 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Minimum number of proteins is not an integer.", "Incorrect Input", 0);
            this.B.setText(Integer.toString(this.J.getMinNumProts()));
            n2 = this.J.getMinNumProts();
        }
        if (this.J.getMinNumProts() != n2) {
            this.J.setMinNumProts(n2);
            this.updatePlots(true);
        }
        String[] stringArray = this.J.calculateRGBiomodules(this.p, n2);
        return stringArray;
    }

    public void acceptInput(boolean bl2) {
        this.b.setEnabled(bl2);
        this.C.setEnabled(bl2);
        this.r.setEnabled(bl2);
        this.a.setEnabled(bl2);
    }

    public void updatePlots(boolean bl2) {
        int[] nArray = bl2 ? this.J.getHierarchicalClustering().updateNumClustersAtEachRowItr() : this.J.getHierarchicalClustering().getNumClustersAtIterations();
        this.d = new double[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.d[i2] = nArray[i2];
        }
        this.p = this.J.getHierarchicalClustering().getJoinNumberWithMaxNumClusters();
        if (this.d.length > 0) {
            this.y = new HCPlot(this.d, this.J.getHierarchicalClustering().getMinNumClusters(), this.J.getHierarchicalClustering().getMaxNumClusters(), this.p, "Join_Number", "Num_Biomods");
            this.y.setSize(500, 500);
            this.y.addJoinBarListener(new JoinNumberListener(this));
        }
        if (!bl2 || this.F.length == 0) {
            this.F = this.J.getHierarchicalClustering().getJoinDistances();
            if (this.F.length > 0) {
                this.A = new HCPlot(this.F, this.J.getMinJoiningValue(), this.J.getMaxJoiningValue(), this.p, "Join_Number", "Join_Distance");
                this.A.setSize(500, 500);
                this.A.addJoinBarListener(new JoinNumberListener(this));
            }
        }
        this.H.removeAll();
        if (this.g && this.d.length > 0) {
            this.H.add(this.A.getContentPane());
        } else if (this.F.length > 0) {
            this.H.add(this.y.getContentPane());
        }
        this.H.validate();
        if (this.g) {
            this.p = this.A != null ? this.A.getSelectedJoinNumber() : 0;
            this.k.setText("Join Number = " + this.p + ", ");
            if (this.F.length == 0) {
                this.h.setText("Join Dist = NaN");
            } else {
                this.h.setText("Join Dist = " + this.x.format(this.F[this.p]));
            }
        } else {
            this.p = this.y != null ? this.y.getSelectedJoinNumber() : 0;
            this.k.setText("Join Number = " + this.p + ", ");
            if (this.d.length == 0) {
                this.h.setText("Num Biomods = 0");
            } else {
                this.h.setText("Num Biomods = " + (int)this.d[this.p]);
            }
        }
        if (this.isShowing()) {
            this.repaint();
        }
        if (!bl2) {
            this.G = null;
            this.z = null;
        }
    }

    public String[][] a(int[][] nArray) {
        int n2;
        eI eI2 = this.J.getBiomodulesManager().getGraph();
        GraphObjAttributes graphObjAttributes = this.J.getBiomodulesManager().getNodeAttributes();
        hm[] hmArray = eI2.R();
        int n3 = hmArray.length;
        String[][] stringArray = new String[n3][n3 + 1];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[n2][0] = graphObjAttributes.getCanonicalName(hmArray[n2]);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = nArray[this.J.getNodeIndex(hmArray[n2])][this.J.getNodeIndex(hmArray[i2])];
                stringArray[n2][i2 + 1] = n4 >= Integer.MAX_VALUE ? "Infinity" : Integer.toString(n4);
            }
        }
        return stringArray;
    }

    public String[] c() {
        eI eI2 = this.J.getBiomodulesManager().getGraph();
        GraphObjAttributes graphObjAttributes = this.J.getBiomodulesManager().getNodeAttributes();
        hm[] hmArray = eI2.R();
        String[] stringArray = new String[hmArray.length + 1];
        stringArray[0] = "          ";
        for (int i2 = 0; i2 < hmArray.length; ++i2) {
            stringArray[i2 + 1] = graphObjAttributes.getCanonicalName(hmArray[i2]);
        }
        return stringArray;
    }

    public String[][] a(double[][] dArray) {
        int n2;
        eI eI2 = this.J.getBiomodulesManager().getGraph();
        GraphObjAttributes graphObjAttributes = this.J.getBiomodulesManager().getNodeAttributes();
        hm[] hmArray = eI2.R();
        int n3 = hmArray.length;
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(3);
        String[][] stringArray = new String[n3][n3 + 1];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[n2][0] = graphObjAttributes.getCanonicalName(hmArray[n2]);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i2 = 0; i2 < n3; ++i2) {
                double d2 = 0.0;
                if (dArray == null) {
                    System.out.println("Oh, Oh. matrix is null!");
                }
                stringArray[n2][i2 + 1] = (d2 = dArray[this.J.getNodeIndex(hmArray[n2])][this.J.getNodeIndex(hmArray[i2])]) >= Double.MAX_VALUE ? "Infinity" : numberFormat.format(d2);
            }
        }
        return stringArray;
    }

    public JDialog a(int n2) {
        Object[][] objectArray;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        if (n2 == 0) {
            objectArray = this.a(this.J.getAPSP());
        } else if (n2 == 1) {
            objectArray = this.a(this.J.getManhattanDistances());
        } else {
            return null;
        }
        JDialog jDialog = new JDialog();
        Object[] objectArray2 = this.c();
        JTable jTable = new JTable(objectArray, objectArray2);
        jTable.setAutoResizeMode(0);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(jTable);
        jScrollPane.setVisible(true);
        jPanel.add(jScrollPane);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1));
        JButton jButton = new JButton("Write To File");
        String[] stringArray = new String[objectArray2.length - 1];
        System.arraycopy(objectArray2, 1, stringArray, 0, objectArray2.length - 1);
        AbstractAction abstractAction = new AbstractAction(this, jDialog, n2, stringArray){
            private final JDialog b;
            private final int d;
            private final String[] a;
            private final RGBiomodulesCalculatorDialog c;
            {
                this.c = rGBiomodulesCalculatorDialog;
                this.b = jDialog;
                this.d = n2;
                this.a = stringArray;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(this.c.o);
                if (jFileChooser.showSaveDialog(this.b) == 0) {
                    this.c.o = jFileChooser.getCurrentDirectory();
                    String string = jFileChooser.getSelectedFile().toString();
                    if (this.d == 0) {
                        this.c.J.writeAPSP(this.a, string);
                    } else if (this.d == 1) {
                        this.c.J.writeManhattanDistances(this.a, string);
                    }
                }
            }
        };
        jButton.addActionListener(abstractAction);
        jPanel2.add(jButton);
        JButton jButton2 = new JButton("Dismiss");
        AbstractAction abstractAction2 = new AbstractAction(this, jDialog){
            private final JDialog a;
            private final RGBiomodulesCalculatorDialog b;
            {
                this.b = rGBiomodulesCalculatorDialog;
                this.a = jDialog;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.a.dispose();
            }
        };
        jButton2.addActionListener(abstractAction2);
        jPanel2.add(jButton2);
        jPanel.add(jPanel2);
        jDialog.getContentPane().add(jPanel);
        return jDialog;
    }

    public class DistancesListener
    extends AbstractAction {
        private final RGBiomodulesCalculatorDialog a;

        public DistancesListener(RGBiomodulesCalculatorDialog rGBiomodulesCalculatorDialog) {
            this.a = rGBiomodulesCalculatorDialog;
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.a.z == null) {
                CollapsingBiomodulesView collapsingBiomodulesView = this.a.J.getBiomodulesManager().getBiomoduleNetworkView();
                CollapsingBiomodulesView collapsingBiomodulesView2 = null;
                if (collapsingBiomodulesView instanceof CollapsingBiomodulesView) {
                    collapsingBiomodulesView2 = collapsingBiomodulesView;
                    collapsingBiomodulesView2.switchCollapsedState(false);
                }
                this.a.z = this.a.a(1);
                if (collapsingBiomodulesView2 != null) {
                    collapsingBiomodulesView2.undoSwitchCollapsedState();
                    collapsingBiomodulesView2.redrawGraph(false, true);
                }
            }
            this.a.z.setTitle("Distance Values");
            this.a.z.pack();
            this.a.z.show();
        }
    }

    public class ApspListener
    extends AbstractAction {
        private final RGBiomodulesCalculatorDialog a;

        public ApspListener(RGBiomodulesCalculatorDialog rGBiomodulesCalculatorDialog) {
            this.a = rGBiomodulesCalculatorDialog;
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.a.G == null) {
                CollapsingBiomodulesView collapsingBiomodulesView = this.a.J.getBiomodulesManager().getBiomoduleNetworkView();
                CollapsingBiomodulesView collapsingBiomodulesView2 = null;
                if (collapsingBiomodulesView instanceof CollapsingBiomodulesView) {
                    collapsingBiomodulesView2 = collapsingBiomodulesView;
                    collapsingBiomodulesView2.switchCollapsedState(false);
                }
                this.a.G = this.a.a(0);
                if (collapsingBiomodulesView2 != null) {
                    collapsingBiomodulesView2.undoSwitchCollapsedState();
                    collapsingBiomodulesView2.redrawGraph(false, true);
                }
            }
            this.a.G.setTitle("APSP Values");
            this.a.G.pack();
            this.a.G.show();
        }
    }

    protected class HCTreeButtonListener
    extends AbstractAction {
        private final RGBiomodulesCalculatorDialog a;

        public HCTreeButtonListener(RGBiomodulesCalculatorDialog rGBiomodulesCalculatorDialog) {
            this.a = rGBiomodulesCalculatorDialog;
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.a.J.getHierarchicalClustering() == null || this.a.J.getHierarchicalClustering().getHCAnimator() == null) {
                JOptionPane.showMessageDialog(null, "The Hierarchical-Tree viewer is not available.", "Message", 1);
                return;
            }
            HCAnimator hCAnimator = this.a.J.getHierarchicalClustering().getHCAnimator();
            hCAnimator.setVisible(true);
        }
    }

    public class HelpButtonAction
    extends AbstractAction {
        private final RGBiomodulesCalculatorDialog a;

        public HelpButtonAction(RGBiomodulesCalculatorDialog rGBiomodulesCalculatorDialog) {
            this.a = rGBiomodulesCalculatorDialog;
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = System.getProperty("line.separator");
            String string2 = string + "In order to find biomodules you must:" + string + "1. Set the minimum number of proteins in a biomodule (or leave the default)." + string + "2. Choose a join number by dragging the vertical line on the plot." + string + "3. Press the \"Cluster\" or \"Collapse\" buttons." + string + string + "How do I drag the vertical line?" + string + "With your mouse, right click on top of the green cursor, and drag the line right or left. " + "The line will snap to the closest join (red point) once you release it." + string + string + "How do I know which join number to choose?" + string + "The higher the join number you choose, the higher the level of biological organization you will get. " + "Through empirical experience, we have found that choosing the join that is located just before the plot's " + "slope decreases dramatically (look at the rightmost region of the plot) produces the biomodules with the highest " + "agreement with known modular organization." + string + string + "What is the difference between \"Cluster\" and \"Collapse\"?" + string + "The only difference between these two is the way they visualize biomodules. Clustering spatially brings together members of " + "the same biomodule. Collapsing abstracts biomodules by creating metanodes that represent biomodules." + string + string + "Cool things you can do with the plot:" + string + "Zoom In/Out. Press the \"Shift\" key, and drag the mouse up or down." + string + "Move the plot. Right click on the plot, and drag it." + string + "Get a cursor. If you have a wheel in your mouse, press it. If you don't, press the right and left buttons. " + "Drag while pressing and you will see on the top left corner cursor x and y values." + string;
            BiomodulesHelpDialog biomodulesHelpDialog = new BiomodulesHelpDialog(this.a, "Find Biomodules Help", string2);
            biomodulesHelpDialog.pack();
            biomodulesHelpDialog.setLocationRelativeTo(this.a);
            biomodulesHelpDialog.setVisible(true);
        }
    }

    public class MinBioSizeListener
    extends AbstractAction {
        private final RGBiomodulesCalculatorDialog a;

        public MinBioSizeListener(RGBiomodulesCalculatorDialog rGBiomodulesCalculatorDialog) {
            this.a = rGBiomodulesCalculatorDialog;
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n2;
            String string = this.a.B.getText();
            try {
                n2 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "You must enter an integer.", "Error", 0);
                this.a.B.setText(Integer.toString(this.a.J.getMinNumProts()));
                return;
            }
            if (n2 != this.a.J.getMinNumProts()) {
                this.a.J.setMinNumProts(n2);
                this.a.updatePlots(true);
            }
        }
    }

    public class ClusterButtonListener
    extends AbstractAction {
        private final RGBiomodulesCalculatorDialog a;

        public ClusterButtonListener(RGBiomodulesCalculatorDialog rGBiomodulesCalculatorDialog) {
            this.a = rGBiomodulesCalculatorDialog;
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.a.acceptInput(false);
            SwingWorker swingWorker = new SwingWorker(this){
                private final ClusterButtonListener a;
                {
                    this.a = clusterButtonListener;
                }

                public Object construct() {
                    ClusterButtonListener.a(this.a).a();
                    if (ClusterButtonListener.a((ClusterButtonListener)this.a).t == null) {
                        ClusterButtonListener.a((ClusterButtonListener)this.a).t = new ClusteringBiomodulesView(ClusterButtonListener.a((ClusterButtonListener)this.a).m.getBiomodulesManager());
                    }
                    ClusterButtonListener.a((ClusterButtonListener)this.a).t.setMaximumConfidence(ClusterButtonListener.a((ClusterButtonListener)this.a).J.getMaxConfidence());
                    ClusterButtonListener.a((ClusterButtonListener)this.a).t.draw(false, false, false);
                    ClusterButtonListener.a((ClusterButtonListener)this.a).r.setEnabled(true);
                    ClusterButtonListener.a((ClusterButtonListener)this.a).r.setEnabled(true);
                    ClusterButtonListener.a(this.a).acceptInput(true);
                    return null;
                }
            };
            swingWorker.start();
        }

        public static RGBiomodulesCalculatorDialog a(ClusterButtonListener clusterButtonListener) {
            return clusterButtonListener.a;
        }
    }

    public class JoinNumberListener
    extends AbstractAction {
        private final RGBiomodulesCalculatorDialog a;

        public JoinNumberListener(RGBiomodulesCalculatorDialog rGBiomodulesCalculatorDialog) {
            this.a = rGBiomodulesCalculatorDialog;
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HCPlot hCPlot = (HCPlot)actionEvent.getSource();
            this.a.p = hCPlot.getSelectedJoinNumber();
            int n2 = this.a.J.getHierarchicalClustering().getNumInternalNodes(1);
            if (this.a.p < 0) {
                this.a.p = 0;
            } else if (this.a.p > n2 - 1) {
                this.a.p = n2 - 1;
            }
            this.a.k.setText("Join Number = " + this.a.p + ", ");
            if (this.a.g) {
                this.a.h.setText("Join Dist = " + this.a.x.format(this.a.F[this.a.p]));
            } else {
                this.a.h.setText("Num Biomods = " + (int)this.a.d[this.a.p]);
            }
            if (this.a.J.getHierarchicalClustering() != null && this.a.J.getHierarchicalClustering().getHCAnimator() != null && this.a.J.getHierarchicalClustering().getHCAnimator().isVisible()) {
                String string = "NODE" + Integer.toString(this.a.p) + "X";
                this.a.J.getHierarchicalClustering().getHCAnimator().selectNode(string);
                this.a.J.getHierarchicalClustering().getHCAnimator().zoomSelected();
            }
        }
    }

    public class PlotOptionsListener
    extends AbstractAction {
        private final RGBiomodulesCalculatorDialog a;

        public PlotOptionsListener(RGBiomodulesCalculatorDialog rGBiomodulesCalculatorDialog) {
            this.a = rGBiomodulesCalculatorDialog;
            super("PlotOptionsListener");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)this.a.D.getSelectedItem();
            this.a.H.removeAll();
            if (string.equals("Num Biomodules") && this.a.g) {
                this.a.g = false;
                if (this.a.y != null) {
                    this.a.y.moveVerticalBarTo(this.a.p);
                    this.a.H.add(this.a.y.getContentPane());
                }
            } else if (string.equals("Join Distance") && !this.a.g) {
                this.a.g = true;
                if (this.a.A != null) {
                    this.a.A.moveVerticalBarTo(this.a.p);
                    this.a.H.add(this.a.A.getContentPane());
                }
            }
            this.a.H.validate();
        }
    }

    public class DismissAction
    extends AbstractAction {
        private final RGBiomodulesCalculatorDialog a;

        public DismissAction(RGBiomodulesCalculatorDialog rGBiomodulesCalculatorDialog) {
            this.a = rGBiomodulesCalculatorDialog;
            super("Dismiss");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.a.dispose();
        }
    }

    public class NodeAttsListener
    extends AbstractAction {
        private final RGBiomodulesCalculatorDialog a;

        public NodeAttsListener(RGBiomodulesCalculatorDialog rGBiomodulesCalculatorDialog) {
            this.a = rGBiomodulesCalculatorDialog;
            super("Node Attributes Listener");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(this.a.w.getCurrentDirectory());
            if (jFileChooser.showSaveDialog(this.a) == 0) {
                String string = jFileChooser.getSelectedFile().toString();
                this.a.J.printMembershipNodeAttributes(string);
            }
        }
    }

    public class WriteListener
    extends AbstractAction {
        private final RGBiomodulesCalculatorDialog a;

        public WriteListener(RGBiomodulesCalculatorDialog rGBiomodulesCalculatorDialog) {
            this.a = rGBiomodulesCalculatorDialog;
            super("Write");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(this.a.w.getCurrentDirectory());
            if (jFileChooser.showSaveDialog(this.a) == 0) {
                String string = jFileChooser.getSelectedFile().toString();
                this.a.J.printBiomodulesToFile(string);
            }
        }
    }

    public class CollapseAction
    extends AbstractAction {
        private final RGBiomodulesCalculatorDialog a;

        public CollapseAction(RGBiomodulesCalculatorDialog rGBiomodulesCalculatorDialog) {
            this.a = rGBiomodulesCalculatorDialog;
            super("Collapse");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.a.acceptInput(false);
            SwingWorker swingWorker = new SwingWorker(this){
                private final CollapseAction a;
                {
                    this.a = collapseAction;
                }

                public Object construct() {
                    CollapseAction.a(this.a).a();
                    CollapseAction.a((CollapseAction)this.a).m.setCollapse(true);
                    CollapseAction.a((CollapseAction)this.a).m.draw(true, true, false);
                    CollapseAction.a(this.a).acceptInput(true);
                    return null;
                }
            };
            swingWorker.start();
        }

        public static RGBiomodulesCalculatorDialog a(CollapseAction collapseAction) {
            return collapseAction.a;
        }
    }
}

