/*
 * Decompiled with CFR 0.152.
 */
package csplugins.biomodules.calculator;

import csplugins.apsp.NodeDistances;
import csplugins.biomodules.Biomodule;
import csplugins.biomodules.BiomoduleNetwork;
import csplugins.biomodules.BiomodulesManager;
import csplugins.biomodules.calculator.BiomodulesCalculator;
import csplugins.biomodules.calculator.ui.RGBiomodulesCalculatorDialog;
import csplugins.biomodules.filter.YGraphFilter;
import csplugins.biomodules.view.CollapsingBiomodulesView;
import csplugins.graphAlgo.hierarchicalClustering.ClusterNode;
import csplugins.graphAlgo.hierarchicalClustering.EisenClustering;
import csplugins.graphAlgo.hierarchicalClustering.HierarchicalClustering;
import csplugins.graphAlgo.hierarchicalClustering.SimilarityCalculator;
import csplugins.util.IndeterminateProgressBar;
import csplugins.util.MoleculeTypeNodeAttribute;
import csplugins.util.SwingWorker;
import cytoscape.CytoscapeWindow;
import cytoscape.GraphObjAttributes;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.tree.TreeNode;

public class RGBiomodulesCalculator
implements BiomodulesCalculator {
    public static final String p = "This calculator creates hypothetical biomodules based on " + System.getProperty("line.separator") + "how similar the positions of the nodes are in the network." + System.getProperty("line.separator") + "If two nodes' distances to all other nodes are very similar," + System.getProperty("line.separator") + "then they will very likely belong to the same biomodule.";
    public int[][] f;
    public double[][] q;
    public double c;
    public double r;
    public double h;
    public HashMap i;
    public BiomodulesManager m;
    public transient Component n;
    public HierarchicalClustering o;
    public transient EisenClustering.JoiningCondition k;
    public transient EisenClustering.ClusterCondition e;
    public transient double j;
    public transient double g;
    public int d;
    public transient RGBiomodulesCalculatorDialog a;
    public boolean b;
    public YGraphFilter l;
    public YGraphFilter s;

    public RGBiomodulesCalculator(BiomodulesManager biomodulesManager) {
        this.setBiomodulesManager(biomodulesManager);
        this.setMinNumProts(3);
        this.m.getCytoGraphListener().addGraphChangeListener(this);
    }

    public RGBiomodulesCalculator(BiomodulesManager biomodulesManager, Component component) {
        this(biomodulesManager);
        this.setParentComponent(component);
    }

    public boolean initialize() {
        boolean bl2 = this.calculateData();
        if (bl2 && this.a != null) {
            this.a.updatePlots(false);
        }
        return bl2;
    }

    public Biomodule[] calculateBiomodules(eI eI2) {
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        System.out.println("In RGBiomodulesCalculator.actionPerformed()");
        ActionEvent actionEvent2 = actionEvent;
        SwingWorker swingWorker = new SwingWorker(this, actionEvent2){
            private final ActionEvent a;
            private final RGBiomodulesCalculator d;
            {
                this.d = rGBiomodulesCalculator;
                this.a = actionEvent;
            }

            /*
             * Enabled aggressive block sorting
             */
            public Object construct() {
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                if (this.a.getActionCommand().equals("Graph Changed")) {
                    if (this.d.f == null) {
                        this.d.b = false;
                        return null;
                    }
                    bl2 = true;
                } else if (!this.a.getActionCommand().equals("Bio Removed") && !this.a.getActionCommand().equals("Bio Member Removed")) {
                    bl4 = true;
                    if (!this.d.b && this.d.f == null) {
                        bl3 = true;
                    } else if (!this.d.b) {
                        bl2 = true;
                    }
                }
                boolean bl5 = true;
                if (bl3) {
                    Object[] objectArray = new String[]{"Initialize", "Cancel"};
                    String string = "Internal calculator data must be initialized.";
                    int n2 = JOptionPane.showOptionDialog(this.d.m.getCytoscapeWindow().getMainFrame(), string, "Rives & Galitski Calculator", 0, 3, null, objectArray, objectArray[0]);
                    if (n2 != 0) {
                        this.d.b = false;
                        return null;
                    }
                    bl5 = this.d.calculateData();
                } else if (bl2) {
                    Object[] objectArray = new String[]{"Update Now", "Update Later"};
                    String string = "Internal calculator data must be updated.";
                    int n3 = JOptionPane.showOptionDialog(this.d.m.getCytoscapeWindow().getMainFrame(), string, "Rives & Galitski Calculator", 0, 3, null, objectArray, objectArray[0]);
                    if (n3 != 0) {
                        this.d.b = false;
                        return null;
                    }
                    bl5 = this.d.calculateData();
                }
                if (bl5 && (bl3 || bl2)) {
                    JOptionPane.showMessageDialog(this.d.m.getCytoscapeWindow().getMainFrame(), "Successful internal data operation.", "Internal Data", 1);
                } else if (!bl5) {
                    JOptionPane.showMessageDialog(this.d.m.getCytoscapeWindow().getMainFrame(), "Unsuccessful internal data operation.", "Internal Data", 0);
                    return null;
                }
                if (bl4) {
                    if (bl2 && this.d.a != null) {
                        this.d.a.updatePlots(false);
                    } else if (this.d.a == null) {
                        this.d.a = new RGBiomodulesCalculatorDialog(this.d.m.getCytoscapeWindow(), this.d.m.getCytoscapeWindow().getMainFrame(), this.d, this.d.m.getBiomoduleNetworkView(), "RG Biomodules");
                        this.d.a.pack();
                        this.d.a.setLocationRelativeTo(this.d.m.getCytoscapeWindow().getMainFrame());
                    }
                    this.d.a.setVisible(true);
                }
                return null;
            }
        };
        swingWorker.start();
    }

    public boolean b() {
        eI eI2 = this.m.getGraph();
        GraphObjAttributes graphObjAttributes = this.m.getNodeAttributes();
        this.m.getCytoscapeWindow().setInteractivity(false);
        NodeDistances nodeDistances = new NodeDistances(eI2);
        nodeDistances.calculateAllNodeDistancesAndMonitor(this.m.getCytoscapeWindow());
        this.f = nodeDistances.getDistances();
        if (this.f == null || nodeDistances.wasCanceled()) {
            this.b = false;
            this.m.getCytoscapeWindow().setInteractivity(true);
            return false;
        }
        this.i = new HashMap();
        hm[] hmArray = eI2.R();
        for (int i2 = 0; i2 < hmArray.length; ++i2) {
            int n2 = nodeDistances.getIndex(hmArray[i2]);
            String string = graphObjAttributes.getCanonicalName(hmArray[i2]);
            Integer n3 = new Integer(n2);
            if (string == null) {
                System.out.println("nodeToIndex[" + string + "]=" + n3);
            }
            this.i.put(string, n3);
        }
        this.m.getCytoscapeWindow().setInteractivity(true);
        return true;
    }

    public boolean c() {
        System.out.println("Calculating Manhattan Distances...");
        this.m.getCytoscapeWindow().setInteractivity(false);
        SimilarityCalculator similarityCalculator = new SimilarityCalculator(this.f, 3, false);
        similarityCalculator.calculateSimsAndMonitor(this.m.getCytoscapeWindow());
        this.q = similarityCalculator.getSimilarities();
        if (this.q == null || similarityCalculator.wasCanceled()) {
            this.b = false;
            this.m.getCytoscapeWindow().setInteractivity(true);
            return false;
        }
        this.c = similarityCalculator.getMaxSimilarity();
        this.r = similarityCalculator.getNonSelfMaxSimilarity();
        this.h = similarityCalculator.getMinSimilarity();
        this.m.getCytoscapeWindow().setInteractivity(true);
        System.out.println("...Done Calculating Manhattan Distances.");
        return true;
    }

    public boolean calculateHierarchicalTree() {
        System.out.println("Calculating Hierarchical Tree...");
        if (this.m.getCytoscapeWindow() != null) {
            this.m.getCytoscapeWindow().setInteractivity(false);
        }
        GraphObjAttributes graphObjAttributes = this.m.getNodeAttributes();
        hm[] hmArray = this.getOrderedNodes();
        Object[] objectArray = new String[hmArray.length];
        for (int i2 = 0; i2 < hmArray.length; ++i2) {
            objectArray[i2] = graphObjAttributes.getCanonicalName(hmArray[i2]);
        }
        this.o = new HierarchicalClustering(objectArray, this.getManhattanDistances(), 1, 1, EisenClustering.K);
        this.o.setLeafReorderingEnabled(false);
        this.a();
        this.o.setRowJoiningCondition(this.k);
        this.o.setRowClusterCondition(this.e);
        this.o.clusterAndMonitor(this.m.getCytoscapeWindow());
        if (this.o.wasCanceled()) {
            this.b = false;
            if (this.m.getCytoscapeWindow() != null) {
                this.m.getCytoscapeWindow().setInteractivity(true);
            }
            return false;
        }
        this.j = this.o.getMaximumRowJoiningValue();
        this.g = this.o.getMinimumRowJoiningValue();
        if (this.m.getCytoscapeWindow() != null) {
            this.m.getCytoscapeWindow().setInteractivity(true);
        }
        System.out.println("...Done calculating Hierarchical Tree.");
        return true;
    }

    public boolean calculateData() {
        boolean bl2;
        CollapsingBiomodulesView collapsingBiomodulesView = this.m.getBiomoduleNetworkView();
        Object var2_2 = null;
        BiomoduleNetwork biomoduleNetwork = this.m.getBiomoduleNetwork();
        biomoduleNetwork.removeAll();
        this.setSimilarityMetric(3);
        if (this.l != null) {
            this.l.hideNodes(this.getGraph(), this.m.getNodeAttributes());
        }
        if (this.s != null) {
            this.s.hideEdges(this.getGraph(), this.m.getEdgeAttributes());
        }
        boolean bl3 = bl2 = this.b() && this.c() && this.calculateHierarchicalTree();
        if (bl2) {
            this.b = true;
        }
        if (this.l != null) {
            this.l.unhideNodes(this.getGraph(), this.m.getNodeAttributes());
        }
        if (this.s != null) {
            this.s.unhideEdges(this.getGraph(), this.m.getEdgeAttributes());
        }
        return bl2;
    }

    public void calculateTreeDoneCallBack(double d2, double d3) {
        System.out.println("---calculateTreeDoneCallBack: " + d2 + " " + d3);
        System.out.flush();
        this.j = d2;
        this.g = d3;
    }

    public int[][] getAPSP() {
        return this.f;
    }

    public double[][] getManhattanDistances() {
        return this.q;
    }

    public BiomodulesManager getBiomodulesManager() {
        return this.m;
    }

    public CytoscapeWindow getCytoscapeWindow() {
        return this.m.getCytoscapeWindow();
    }

    public GraphObjAttributes getEdgeAttributes() {
        return this.m.getEdgeAttributes();
    }

    public HierarchicalClustering getHierarchicalClustering() {
        return this.o;
    }

    public GraphObjAttributes getNodeAttributes() {
        return this.m.getNodeAttributes();
    }

    public eI getGraph() {
        return this.m.getGraph();
    }

    public int getNumOfBioNodes() {
        return this.getGraph().K();
    }

    public int getNodeIndex(hm hm2) {
        String string = this.m.getNodeAttributes().getCanonicalName(hm2);
        if (string == null) {
            System.out.println("Oops! in RGBiomodulesCalculator getNodeIndex(): node [" + hm2 + "] has a null canonical name.");
        }
        return (Integer)this.i.get(string);
    }

    public int getNodeIndex(String string) {
        return (Integer)this.i.get(string);
    }

    public HashMap getNodeToIndexMap() {
        return this.i;
    }

    public double getMaxDistance() {
        return this.c;
    }

    public double getMaxConfidence() {
        return this.getMaxDistance();
    }

    public double getMaxJoiningValue() {
        return this.j;
    }

    public double getMinJoiningValue() {
        return this.g;
    }

    public double getNonSelfMaxDistance() {
        return this.r;
    }

    public double getMinDistance() {
        return this.h;
    }

    public hm[] getOrderedNodes() {
        eI eI2 = this.m.getGraph();
        hm[] hmArray = eI2.R();
        hm[] hmArray2 = new hm[hmArray.length];
        for (int i2 = 0; i2 < hmArray.length; ++i2) {
            int n2 = this.getNodeIndex(hmArray[i2]);
            hmArray2[n2] = hmArray[i2];
        }
        return hmArray2;
    }

    public void setNodeFilter(YGraphFilter yGraphFilter) {
        this.l = yGraphFilter;
    }

    public YGraphFilter getNodeFilter() {
        return this.l;
    }

    public YGraphFilter getEdgeFilter() {
        return this.s;
    }

    public void setEdgeFilter(YGraphFilter yGraphFilter) {
        this.s = yGraphFilter;
    }

    public void a() {
        this.k = new EisenClustering.JoiningCondition(this){
            private final RGBiomodulesCalculator a;
            {
                this.a = rGBiomodulesCalculator;
            }

            public boolean join(EisenClustering.EisenClusterNode eisenClusterNode, EisenClustering.EisenClusterNode eisenClusterNode2) {
                Enumeration<TreeNode> enumeration;
                Object object;
                if (eisenClusterNode.getChildCount() == 2) {
                    object = eisenClusterNode2.i.get(eisenClusterNode.getChildAt(0));
                    enumeration = eisenClusterNode2.i.get(eisenClusterNode.getChildAt(1));
                    if (object != null && enumeration != null) {
                        boolean bl2 = (Boolean)object;
                        boolean bl3 = (Boolean)((Object)enumeration);
                        return bl2 || bl3;
                    }
                }
                if (eisenClusterNode2.getChildCount() == 2) {
                    object = eisenClusterNode.i.get(eisenClusterNode2.getChildAt(0));
                    enumeration = eisenClusterNode.i.get(eisenClusterNode2.getChildAt(1));
                    if (object != null && enumeration != null) {
                        boolean bl4 = (Boolean)object;
                        boolean bl5 = (Boolean)((Object)enumeration);
                        return bl4 || bl5;
                    }
                }
                object = this.a.m.getNodeAttributes();
                enumeration = eisenClusterNode.depthFirstEnumeration();
                while (enumeration.hasMoreElements()) {
                    EisenClustering.EisenClusterNode eisenClusterNode3 = (EisenClustering.EisenClusterNode)enumeration.nextElement();
                    if (!eisenClusterNode3.isLeaf() || !(eisenClusterNode3.getUserObject() instanceof String)) continue;
                    String string = (String)eisenClusterNode3.getUserObject();
                    hm hm2 = (hm)((GraphObjAttributes)object).getGraphObject(string);
                    if (hm2 == null) {
                        throw new IllegalStateException("The y.base.Node object that corresponds to [" + string + "] is null in node attributes.");
                    }
                    Enumeration<TreeNode> enumeration2 = eisenClusterNode2.depthFirstEnumeration();
                    while (enumeration2.hasMoreElements()) {
                        EisenClustering.EisenClusterNode eisenClusterNode4 = (EisenClustering.EisenClusterNode)enumeration2.nextElement();
                        if (!eisenClusterNode4.isLeaf() || !(eisenClusterNode4.getUserObject() instanceof String)) continue;
                        String string2 = (String)eisenClusterNode4.getUserObject();
                        hm hm3 = (hm)((GraphObjAttributes)object).getGraphObject(string2);
                        if (hm3 == null) {
                            throw new IllegalStateException("The y.base.Node object that corresponds to [" + string2 + "] is null in node attributes.");
                        }
                        if (hm2.a(hm3) == null) continue;
                        return true;
                    }
                }
                return false;
            }
        };
        int n2 = MoleculeTypeNodeAttribute.getNumMTypeNodes(this.m.getGraph(), this.getNodeAttributes(), "protein");
        this.e = n2 > 0 ? new EisenClustering.ClusterCondition(this){
            private final RGBiomodulesCalculator a;
            {
                this.a = rGBiomodulesCalculator;
            }

            public boolean isCluster(EisenClustering.EisenClusterNode eisenClusterNode) {
                return RGBiomodulesCalculator.isBiomodule(eisenClusterNode, this.a.getMinNumProts(), this.a.getNodeAttributes());
            }
        } : new EisenClustering.ClusterCondition(this){
            private final RGBiomodulesCalculator a;
            {
                this.a = rGBiomodulesCalculator;
            }

            public boolean isCluster(EisenClustering.EisenClusterNode eisenClusterNode) {
                return eisenClusterNode.getLeafCount() >= this.a.getMinNumProts();
            }
        };
    }

    public void setManhattanDistances(double[][] dArray, double d2, double d3, double d4) {
        this.q = dArray;
        this.c = d2;
        this.r = d3;
        this.h = d4;
    }

    public void setBiomodulesManager(BiomodulesManager biomodulesManager) {
        this.m = biomodulesManager;
    }

    public void setParentComponent(Component component) {
        this.n = component;
    }

    public void setMinNumProts(int n2) {
        this.d = n2;
    }

    public int getMinNumProts() {
        return this.d;
    }

    public void setSimilarityMetric(int n2) {
    }

    public int getSimilarityMetric() {
        return 0;
    }

    public void writeAPSP(String[] stringArray, String string) {
        if (this.f == null) {
            return;
        }
        this.a(true, stringArray, string);
    }

    public void writeManhattanDistances(String[] stringArray, String string) {
        if (this.q == null) {
            return;
        }
        this.a(false, stringArray, string);
    }

    public void a(boolean bl2, String[] stringArray, String string) {
        eI eI2 = this.getGraph();
        GraphObjAttributes graphObjAttributes = this.getNodeAttributes();
        try {
            int n2;
            int[] nArray;
            Object object;
            File file = new File(string);
            if (file.exists()) {
                System.out.println("The file " + string + " already exists. It will be overwritten.");
                System.out.flush();
            }
            FileWriter fileWriter = new FileWriter(file);
            StringBuffer stringBuffer = new StringBuffer();
            if (stringArray == null) {
                object = eI2.R();
                stringArray = new String[((hm[])object).length];
                nArray = new int[stringArray.length];
                for (n2 = 0; n2 < ((hm[])object).length; ++n2) {
                    stringBuffer.append("\t");
                    stringBuffer.append(graphObjAttributes.getCanonicalName(object[n2]));
                    stringArray[n2] = graphObjAttributes.getCanonicalName(object[n2]);
                    nArray[n2] = this.getNodeIndex((hm)object[n2]);
                }
            } else {
                nArray = new int[stringArray.length];
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    stringBuffer.append("\t");
                    stringBuffer.append(stringArray[i2]);
                    nArray[i2] = this.getNodeIndex(stringArray[i2]);
                }
            }
            if (bl2) {
                for (int i3 = 0; i3 < stringArray.length; ++i3) {
                    stringBuffer.append("\n");
                    stringBuffer.append(stringArray[i3]);
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        int n3 = this.f[nArray[i3]][nArray[n2]];
                        stringBuffer.append("\t");
                        if (n3 == Integer.MAX_VALUE) {
                            stringBuffer.append("INFINITY");
                            continue;
                        }
                        stringBuffer.append(Integer.toString(n3));
                    }
                }
            } else {
                object = NumberFormat.getInstance();
                ((NumberFormat)object).setMaximumFractionDigits(3);
                for (int i4 = 0; i4 < stringArray.length; ++i4) {
                    stringBuffer.append("\n");
                    stringBuffer.append(stringArray[i4]);
                    for (int i5 = 0; i5 < stringArray.length; ++i5) {
                        double d2 = this.q[nArray[i4]][nArray[i5]];
                        stringBuffer.append("\t");
                        stringBuffer.append(((NumberFormat)object).format(d2));
                    }
                }
            }
            fileWriter.write(stringBuffer.toString(), 0, stringBuffer.length());
            fileWriter.flush();
        }
        catch (IOException iOException) {
            System.out.println(iOException + " caught in method BiomodulesData::writeMatrix");
            System.out.flush();
            iOException.printStackTrace();
        }
    }

    public double calculateMeanDistance(Biomodule biomodule) {
        double[][] dArray = this.getManhattanDistances();
        hm[] hmArray = biomodule.getNodes();
        double d2 = 0.0;
        int n2 = 0;
        for (int i2 = 0; i2 < hmArray.length; ++i2) {
            int n3 = this.getNodeIndex(hmArray[i2]);
            for (int i3 = i2 + 1; i3 < hmArray.length; ++i3) {
                int n4 = this.getNodeIndex(hmArray[i3]);
                d2 += dArray[n3][n4];
                ++n2;
            }
        }
        return d2 / (double)n2;
    }

    public String[] calculateRGBiomodules(int n2, int n3) {
        Object object;
        this.setMinNumProts(n3);
        if (!this.b) {
            object = new Object[]{"Update Now", "Update Later"};
            int n4 = JOptionPane.showOptionDialog(this.m.getCytoscapeWindow().getMainFrame(), "Internal data and network are not consistent.", "Inconsistency Detected", 0, 3, null, (Object[])object, object[0]);
            boolean bl2 = false;
            if (n4 == 0) {
                bl2 = this.calculateData();
            }
            if (!bl2) {
                JOptionPane.showMessageDialog(this.m.getCytoscapeWindow().getMainFrame(), "Internal data is not updated. Cannot calculate Biomodules.", "ERROR", 0);
                return new String[0];
            }
            if (this.a != null) {
                this.a.updatePlots(false);
            }
        }
        this.m.getCytoscapeWindow().setInteractivity(false);
        object = new IndeterminateProgressBar((Frame)this.m.getCytoscapeWindow().getMainFrame(), "Biomodules", "Calculating Biomodules...");
        ((Window)object).pack();
        ((Window)object).setLocationRelativeTo(this.m.getCytoscapeWindow());
        ((Dialog)object).setVisible(true);
        BiomoduleNetwork biomoduleNetwork = this.m.getBiomoduleNetwork();
        biomoduleNetwork.removeAll();
        HierarchicalClustering.HierarchicalClusterNode hierarchicalClusterNode = (HierarchicalClustering.HierarchicalClusterNode)this.o.getRowRoot();
        HashSet hashSet = new HashSet();
        HierarchicalClustering.clustersCreatedBeforeNode(hierarchicalClusterNode, n2, hashSet);
        Iterator iterator = hashSet.iterator();
        Vector<String> vector = new Vector<String>();
        Vector<hm> vector2 = new Vector<hm>();
        GraphObjAttributes graphObjAttributes = this.m.getNodeAttributes();
        if (this.l != null) {
            this.l.hideNodes(this.getGraph(), this.m.getNodeAttributes());
        }
        if (this.s != null) {
            this.s.hideEdges(this.getGraph(), this.m.getEdgeAttributes());
        }
        while (iterator.hasNext()) {
            ClusterNode clusterNode = (ClusterNode)iterator.next();
            if (!RGBiomodulesCalculator.isBiomodule((EisenClustering.EisenClusterNode)clusterNode, this.d, graphObjAttributes)) continue;
            Iterator iterator2 = clusterNode.leafIterator();
            vector2.clear();
            while (iterator2.hasNext()) {
                String string = (String)((ClusterNode)iterator2.next()).getUserObject();
                hm hm2 = (hm)graphObjAttributes.getGraphObject(string);
                if (hm2 == null) {
                    throw new IllegalStateException("The y.base.Node object that corresponds to [" + string + "] is null in graph node attributes.");
                }
                vector2.add(hm2);
            }
            String string = biomoduleNetwork.add(vector2);
            Biomodule biomodule = biomoduleNetwork.getBiomodule(string);
            biomodule.setConfidence(this.calculateMeanDistance(biomodule));
            vector.add(string);
        }
        if (this.l != null) {
            this.l.unhideNodes(this.getGraph(), this.m.getNodeAttributes());
        }
        if (this.s != null) {
            this.s.unhideEdges(this.getGraph(), this.m.getEdgeAttributes());
        }
        ((Window)object).dispose();
        this.m.getCytoscapeWindow().setInteractivity(true);
        return vector.toArray(new String[vector.size()]);
    }

    public static boolean isBiomodule(EisenClustering.EisenClusterNode eisenClusterNode, int n2, GraphObjAttributes graphObjAttributes) {
        if (eisenClusterNode.getLeafCount() < n2) {
            return false;
        }
        int n3 = eisenClusterNode.getChildCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            EisenClustering.EisenClusterNode eisenClusterNode2 = (EisenClustering.EisenClusterNode)eisenClusterNode.getChildAt(i2);
            if (!eisenClusterNode2.c) continue;
            return true;
        }
        Iterator iterator = eisenClusterNode.leafIterator();
        int n4 = 0;
        while (iterator.hasNext()) {
            String string = (String)((ClusterNode)iterator.next()).getUserObject();
            hm hm2 = (hm)graphObjAttributes.getGraphObject(string);
            if (hm2 == null) {
                throw new IllegalStateException("The y.base.Node object that corresponds to [" + string + "] is null in node attributes.");
            }
            String string2 = (String)graphObjAttributes.getValue("moleculeType", string);
            if (string2 != null && string2.equals("protein")) {
                ++n4;
            }
            if (n4 < n2) continue;
            return true;
        }
        return false;
    }

    public BiomoduleNetwork getBiomoduleNetwork() {
        return this.m.getBiomoduleNetwork();
    }

    public boolean usingMinNumProtsCond() {
        int n2 = MoleculeTypeNodeAttribute.getNumMTypeNodes(this.m.getGraph(), this.m.getNodeAttributes(), "protein");
        return n2 != 0;
    }

    public void printBiomodulesToFile(String string) {
        this.m.getBiomoduleNetwork().printBiomodulesToFile(string);
    }

    public void printMembershipNodeAttributes(String string) {
        this.m.getBiomoduleNetwork().printMembershipNodeAttributes(string);
    }

    public String getName() {
        return "Rives & Galitski Calculator";
    }

    public String getDescription() {
        return p;
    }

    public String toString() {
        return this.getName();
    }
}

