/*
 * Decompiled with CFR 0.152.
 */
package csplugins.biomodules;

import csplugins.biomodules.Biomodule;
import csplugins.biomodules.BiomoduleNetwork;
import csplugins.biomodules.BiomodulesManager;
import csplugins.biomodules.view.CollapsingBiomodulesView;
import csplugins.biomodules.view.CommonAnnotationEdgeDrawer;
import csplugins.moduleAnnotations.ModuleAnnotationsCalculator;
import csplugins.moduleAnnotations.ui.ModuleAnnotationsDialog;
import csplugins.moduleAnnotations.ui.ModuleAnnotationsTable;
import cytoscape.GraphObjAttributes;
import cytoscape.data.servers.BioDataServer;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public class BiomoduleAnnotations
extends AbstractAction {
    public BiomodulesManager a;

    public BiomoduleAnnotations(BiomodulesManager biomodulesManager) {
        super("Find Biomodule Annotations...");
        this.setBiomodulesManager(biomodulesManager);
    }

    public void setBiomodulesManager(BiomodulesManager biomodulesManager) {
        this.a = biomodulesManager;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        AbstractAction[] abstractActionArray;
        Cloneable cloneable;
        BioDataServer bioDataServer = this.a.getCytoscapeWindow().getBioDataServer();
        if (bioDataServer == null) {
            JOptionPane.showMessageDialog(this.a.getCytoscapeWindow().getMainFrame(), "The server is not available. No annotations.", "Server Error", 0);
            return;
        }
        BiomoduleNetwork biomoduleNetwork = this.a.getBiomoduleNetwork();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        Biomodule[] biomoduleArray = biomoduleNetwork.getAllBiomodules();
        Object[] objectArray = new String[biomoduleArray.length];
        GraphObjAttributes graphObjAttributes = this.a.getNodeAttributes();
        for (int i2 = 0; i2 < biomoduleArray.length; ++i2) {
            String[] stringArray = biomoduleArray[i2].getNodeCanonicalNames();
            objectArray[i2] = biomoduleArray[i2].getName();
            cloneable = new Vector();
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                abstractActionArray = (AbstractAction[])graphObjAttributes.getValue("moleculeType", stringArray[i3]);
                if (abstractActionArray == null || !abstractActionArray.equals("protein")) continue;
                ((Vector)cloneable).add(stringArray[i3]);
            }
            if (((Vector)cloneable).size() <= 0) continue;
            arrayList.add(i2, ((Vector)cloneable).toArray(new String[((Vector)cloneable).size()]));
        }
        String[][] stringArray = new String[arrayList.size()][];
        for (int i4 = 0; i4 < arrayList.size(); ++i4) {
            stringArray[i4] = (String[])arrayList.get(i4);
        }
        ModuleAnnotationsCalculator moduleAnnotationsCalculator = new ModuleAnnotationsCalculator();
        moduleAnnotationsCalculator.setGeneModules(stringArray);
        moduleAnnotationsCalculator.setModuleIDs(objectArray);
        cloneable = new SaveBiomoduleAnnotationsAction(this);
        CommonAnnotationsAction commonAnnotationsAction = new CommonAnnotationsAction(this);
        abstractActionArray = new AbstractAction[]{cloneable, commonAnnotationsAction};
        ModuleAnnotationsDialog moduleAnnotationsDialog = new ModuleAnnotationsDialog(moduleAnnotationsCalculator, bioDataServer);
        moduleAnnotationsDialog.setActionsForTable(abstractActionArray);
        moduleAnnotationsDialog.setFavoriteAnnotation("GO", "Biological Process");
        moduleAnnotationsDialog.pack();
        moduleAnnotationsDialog.setLocationRelativeTo(this.a.getCytoscapeWindow());
        moduleAnnotationsDialog.setVisible(true);
    }

    protected class CommonAnnotationsAction
    extends AbstractAction {
        private final BiomoduleAnnotations a;

        public CommonAnnotationsAction(BiomoduleAnnotations biomoduleAnnotations) {
            this.a = biomoduleAnnotations;
            super("Draw Annotation Edges");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton;
            int n2;
            Object object;
            Object object2 = actionEvent.getSource();
            if (object2 instanceof JButton && (object = this.getValue(String.valueOf(n2 = (jButton = (JButton)object2).hashCode()))) != null && object instanceof ModuleAnnotationsTable) {
                ModuleAnnotationsTable moduleAnnotationsTable = (ModuleAnnotationsTable)object;
                CollapsingBiomodulesView collapsingBiomodulesView = this.a.a.getBiomoduleNetworkView();
                String[][] stringArray = moduleAnnotationsTable.getData();
                CommonAnnotationEdgeDrawer.createAnnotationEdges(collapsingBiomodulesView, stringArray);
            }
        }
    }

    protected class SaveBiomoduleAnnotationsAction
    extends AbstractAction {
        private final BiomoduleAnnotations a;

        public SaveBiomoduleAnnotationsAction(BiomoduleAnnotations biomoduleAnnotations) {
            this.a = biomoduleAnnotations;
            super("Save Annotations To Biomodules");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton;
            int n2;
            Object object;
            Object object2 = actionEvent.getSource();
            if (object2 instanceof JButton && (object = this.getValue(String.valueOf(n2 = (jButton = (JButton)object2).hashCode()))) != null && object instanceof ModuleAnnotationsTable) {
                ModuleAnnotationsTable moduleAnnotationsTable = (ModuleAnnotationsTable)object;
                BiomoduleNetwork biomoduleNetwork = this.a.a.getBiomoduleNetwork();
                String[][] stringArray = moduleAnnotationsTable.getData();
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    String string = stringArray[i2][0];
                    Biomodule[] biomoduleArray = biomoduleNetwork.getBiomodulesNamedAs(string);
                    for (int i3 = 0; i3 < biomoduleArray.length; ++i3) {
                        String string2 = "";
                        if (biomoduleArray[i3].getAnnotations() != null) {
                            string2 = biomoduleArray[i3].getAnnotations();
                        }
                        string2 = string2 + System.getProperty("line.separator") + stringArray[i2][1] + " pVal = " + stringArray[i2][2];
                        biomoduleArray[i3].setAnnotations(string2);
                    }
                }
            }
        }
    }
}

