/*
 * Decompiled with CFR 0.152.
 */
package jgraph;

import cern.colt.map.PrimeFinder;
import cytoscape.view.CyNetworkView;
import giny.model.Edge;
import giny.model.GraphPerspective;
import giny.model.Node;
import giny.view.GraphView;
import giny.view.NodeView;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.Port;
import org.jgraph.graph.VertexView;
import org.jgraph.layout.CircleGraphLayout;
import org.jgraph.layout.RadialTreeLayoutAlgorithm;
import org.jgraph.layout.SpringEmbeddedLayoutAlgorithm;
import org.jgraph.layout.SugiyamaLayoutAlgorithm;

public class JGraphLayout {
    int AnnealingLayoutAlgorithm = 0;
    int MoenLayoutAlgorithm = 1;
    int CircleGraphLayout = 2;
    int RadialTreeLayoutAlgorithm = 3;
    int GEMLayoutAlgorithm = 4;
    int SpringEmbeddedLayoutAlgorithm = 5;
    int SugiyamaLayoutAlgorithm = 6;
    int TreeLayoutAlgorithm = 7;
    int layout_type = 0;
    protected GraphView graphView;

    public JGraphLayout(CyNetworkView view, int layout_type, double extra_dat) {
        this.graphView = view;
        this.layout_type = layout_type;
    }

    public void doLayout() {
        Node giny;
        GraphPerspective perspective = this.graphView.getGraphPerspective();
        HashMap<DefaultGraphCell, Node> j_giny_node_map = new HashMap<DefaultGraphCell, Node>(PrimeFinder.nextPrime((int)perspective.getNodeCount()));
        HashMap<Node, DefaultGraphCell> giny_j_node_map = new HashMap<Node, DefaultGraphCell>(PrimeFinder.nextPrime((int)perspective.getNodeCount()));
        HashMap<DefaultEdge, Node> j_giny_edge_map = new HashMap<DefaultEdge, Node>(PrimeFinder.nextPrime((int)perspective.getEdgeCount()));
        Iterator node_iterator = perspective.nodesIterator();
        Iterator edge_iterator = perspective.edgesIterator();
        DefaultGraphModel model = new DefaultGraphModel();
        JGraph graph = new JGraph((GraphModel)model);
        Hashtable<Object, AttributeMap> attributes = new Hashtable<Object, AttributeMap>();
        HashSet<Object> cells = new HashSet<Object>();
        while (node_iterator.hasNext()) {
            giny = (Node)node_iterator.next();
            NodeView node_view = this.graphView.getNodeView(giny);
            DefaultGraphCell jcell = new DefaultGraphCell((Object)giny.getIdentifier());
            AttributeMap attrib = new AttributeMap();
            attributes.put(jcell, attrib);
            Rectangle2D.Double bounds = new Rectangle2D.Double(node_view.getXPosition(), node_view.getYPosition(), node_view.getWidth(), node_view.getHeight());
            GraphConstants.setBounds((Map)attrib, (Rectangle2D)bounds);
            j_giny_node_map.put(jcell, giny);
            giny_j_node_map.put(giny, jcell);
            cells.add(jcell);
        }
        while (edge_iterator.hasNext()) {
            giny = (Edge)edge_iterator.next();
            DefaultGraphCell j_source = (DefaultGraphCell)giny_j_node_map.get(giny.getSource());
            DefaultGraphCell j_target = (DefaultGraphCell)giny_j_node_map.get(giny.getTarget());
            DefaultPort source_port = new DefaultPort();
            DefaultPort target_port = new DefaultPort();
            j_source.add((MutableTreeNode)source_port);
            j_target.add((MutableTreeNode)target_port);
            DefaultEdge jedge = new DefaultEdge();
            j_giny_edge_map.put(jedge, giny);
            AttributeMap edgeAttrib = new AttributeMap();
            attributes.put(jedge, edgeAttrib);
            ConnectionSet cs = new ConnectionSet((org.jgraph.graph.Edge)jedge, (Port)source_port, (Port)target_port);
            Object[] ecells = new Object[]{jedge, j_source, j_target};
            model.insert(ecells, attributes, cs, null, null);
            cells.add(jedge);
        }
        CircleGraphLayout layout = null;
        if (this.layout_type == 2) {
            layout = new CircleGraphLayout();
        } else if (this.layout_type == 3) {
            layout = new RadialTreeLayoutAlgorithm();
        } else if (this.layout_type == 5) {
            layout = new SpringEmbeddedLayoutAlgorithm();
        } else if (this.layout_type == 6) {
            layout = new SugiyamaLayoutAlgorithm();
        }
        layout.run(graph, cells.toArray());
        GraphLayoutCache cache = graph.getGraphLayoutCache();
        Iterator i = cells.iterator();
        while (i.hasNext()) {
            Object cell = i.next();
            CellView cell_view = cache.getMapping(cell, false);
            if (!(cell_view instanceof VertexView)) continue;
            Rectangle2D rect = cell_view.getBounds();
            Node giny2 = (Node)j_giny_node_map.get(cell);
            NodeView node_view = this.graphView.getNodeView(giny2);
            node_view.setXPosition(rect.getX(), false);
            node_view.setYPosition(rect.getY(), false);
            node_view.setNodePosition(true);
        }
        model = null;
        graph = null;
        attributes = null;
        cells = null;
        System.gc();
    }
}

