/*
 * Decompiled with CFR 0.152.
 */
package jgraph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import jgraph.AnnealingLayoutAlgorithm;
import org.jgraph.JGraph;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.VertexView;
import org.jgraph.layout.AnnealingLayoutAlgorithm;
import org.jgraph.layout.JGraphLayoutAlgorithm;

public class GEMLayoutAlgorithm
extends JGraphLayoutAlgorithm
implements GraphModelListener {
    public static final String KEY_TITLE = "GEM";
    public static final String KEY_CONFIG_NAME = "CONFIG_NAME";
    public static final String KEY_INIT_TEMPERATURE = "init temperature";
    public static final String KEY_MIN_TEMPERATURE = "min temperature";
    public static final String KEY_MAX_TEMPERATURE = "max temperature";
    public static final String KEY_PREF_EDGE_LENGTH = "preferred Edge length";
    public static final String KEY_GRAVITATION = "gravitation to barycenter";
    public static final String KEY_RANDOM_IMPULSE_RANGE = "random impulse range";
    public static final String KEY_COMPUTE_PERMUTATION = "compute permutation";
    public static final String KEY_END_CONDITION_AVERAGE = "end condition average";
    public static final String KEY_AVOID_OVERLAPPING = "avoid overlapping";
    public static final String KEY_OVERLAPPING_DETECTION_WIDTH = "overlapping detection width";
    public static final String KEY_OVERLAPPING_PREF_DISTANCE = "overlapping preferred distance";
    public static final String KEY_ALPHA_OSC = "alpha oscillation";
    public static final String KEY_ALPHA_ROT = "alpha rotation";
    public static final String KEY_SIGMA_OSC = "sigma oscillation";
    public static final String KEY_SIGMA_ROT = "sigma rotation";
    public static final String KEY_OPTIMIZE_ALGORITHM_ENABLED = "optimization algorithm enabled";
    public static final String KEY_OPTIMIZE_ALGORITHM_CONFIG = "optimization algorithm configuration";
    public static final String KEY_LAYOUT_UPDATE_INIT_TEMPERATURE = "Layout Update init temperature";
    public static final String KEY_LAYOUT_UPDATE_MIN_TEMPERATURE = "Layout Update min temperature";
    public static final String KEY_LAYOUT_UPDATE_MAX_TEMPERATURE = "Layout Update max temperature";
    public static final String KEY_LAYOUT_UPDATE_PREF_EDGE_LENGTH = "Layout Update preferred Edge length";
    public static final String KEY_LAYOUT_UPDATE_GRAVITATION = "Layout Update gravitation to barycenter";
    public static final String KEY_LAYOUT_UPDATE_RANDOM_IMPULSE_RANGE = "Layout Update random impulse range";
    public static final String KEY_LAYOUT_UPDATE_COMPUTE_PERMUTATION = "Layout Update compute permutation";
    public static final String KEY_LAYOUT_UPDATE_END_CONDITION_AVERAGE = "Layout Update end condition average";
    public static final String KEY_LAYOUT_UPDATE_AVOID_OVERLAPPING = "Layout Update avoid overlapping";
    public static final String KEY_LAYOUT_UPDATE_OVERLAPPING_DETECTION_WIDTH = "Layout Update overlapping detection width";
    public static final String KEY_LAYOUT_UPDATE_OVERLAPPING_PREF_DISTANCE = "Layout Update overlapping preferred distance";
    public static final String KEY_LAYOUT_UPDATE_ALPHA_ROT = "Layout Update alpha oscillation";
    public static final String KEY_LAYOUT_UPDATE_ALPHA_OSC = "Layout Update alpha rotation";
    public static final String KEY_LAYOUT_UPDATE_SIGMA_ROT = "Layout Update sigma oscillation";
    public static final String KEY_LAYOUT_UPDATE_SIGMA_OSC = "Layout Update sigma rotation";
    public static final String KEY_LAYOUT_UPDATE_ENABLED = "Layout Update enabled";
    public static final String KEY_LAYOUT_UPDATE_METHOD = "Layout Update method";
    public static final String KEY_LAYOUT_UPDATE_OPTIMIZE_ALGORITHM_ENABLED = "Layout Update optimization algorithm enabled";
    public static final String KEY_LAYOUT_UPDATE_OPTIMIZE_ALGORITHM_CONFIG = "Layout Update optimization algorithm configuration";
    public static final String KEY_LAYOUT_UPDATE_METHOD_NEIGHBORS_ONLY = "Neighbors only";
    public static final String KEY_LAYOUT_UPDATE_METHOD_PERIMETERS = "Perimeter";
    public static final String KEY_LAYOUT_UPDATE_DEPTH = "Layout Update depth";
    public static final String KEY_LAYOUT_UPDATE_METHOD_PERIMETER_INIT_SIZE = "Layout Update method perimeter initial size";
    public static final String KEY_LAYOUT_UPDATE_METHOD_PERIMETER_SIZE_INC = "Layout Update method perimeter size increase value";
    public static final String KEY_LAYOUT_UPDATE_CLUSTERING_ENABLED = "clustering enabled";
    public static final String KEY_LAYOUT_UPDATE_CLUSTERING_INIT_TEMPERATURE = "cluster init temperature";
    public static final String KEY_LAYOUT_UPDATE_CLUSTERING_FORCE_SCALING_FACTOR = "clustering force scaling factor";
    public static final String KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR = "cluster size factor";
    public static final String KEY_CAPTION = "GEM-TEMPORARY-DATA";
    public static final String KEY_TEMPERATURE = "Temperature";
    public static final String KEY_CURRENT_IMPULSE = "Current_Impulse";
    public static final String KEY_LAST_IMPULSE = "Last_Impulse";
    public static final String KEY_POSITION = "Position";
    public static final String KEY_SKEWGAUGE = "Skew_Gauge";
    public static final String KEY_RELATIVES = "Relatives";
    public static final String KEY_MASSINDEX = "Mass_Index";
    public static final String KEY_CLUSTERED_VERTICES = "Clustered Vertices";
    public static final String KEY_CLUSTER = "Cluster";
    public static final String KEY_IS_CLUSTER = "is Cluster";
    public static final String KEY_CLUSTER_INIT_POSITION = "initial Position of the Cluster";
    private ArrayList cellList;
    private ArrayList applyCellList;
    private ArrayList edgeList;
    private double equalsNull = 1.0E-17;
    protected double initTemperature = 10.0;
    protected double minTemperature = 3.0;
    protected double maxTemperature = 256.0;
    protected double prefEdgeLength = 100.0;
    protected double gravitation = 0.0625;
    protected double randomImpulseRange = 32.0;
    protected double alphaOsc = Math.toRadians(90.0);
    protected double alphaRot = Math.toRadians(60.0);
    protected double sigmaOsc = 0.3333333333333333;
    protected double sigmaRot = 0.5;
    private int maxRounds = 4;
    private int countRounds = 0;
    private int recursionDepth = 4;
    private double overlapDetectWidth = 5.0;
    private double overlapPrefDistance = 4.0;
    private boolean avoidOverlapping = true;
    private String layoutUpdateMethod = "Neighbors only";
    private boolean shouldEndPerAverage = true;
    private boolean shouldComputePermutation = true;
    private boolean isActive = true;
    private boolean isRunning = false;
    private JGraph jgraph;
    protected Properties config;
    protected static final int VALUES_PUR = 0;
    protected static final int VALUES_INC = 1;
    private AnnealingLayoutAlgorithm optimizationAlgorithm;
    private boolean useOptimizeAlgorithm = true;
    private Properties optimizationAlgorithmConfig;
    private boolean isClusteringEnabled = true;
    private double clusterInitTemperature = 8.0;
    private double clusterForceScalingFactor = 0.5;
    private double clusteringFactor = 5.0;
    private double perimeterInitSize = 30.0;
    private double perimeterSizeInc = 3.0;
    private boolean isDebugging = false;

    public GEMLayoutAlgorithm(AnnealingLayoutAlgorithm optimizer) {
        this.cellList = new ArrayList();
        this.applyCellList = new ArrayList();
        this.edgeList = new ArrayList();
        this.optimizationAlgorithm = optimizer;
    }

    public void run(JGraph graph, Object[] cells) {
        this.isRunning = true;
        this.jgraph = graph;
        this.jgraph.getModel().addGraphModelListener((GraphModelListener)this);
        this.cellList = new ArrayList();
        this.applyCellList = new ArrayList();
        this.getNodes(this.jgraph, cells);
        this.loadRuntimeValues(0);
        long starttime = System.currentTimeMillis();
        boolean isCanceled = this.initialize();
        if (!isCanceled) {
            isCanceled = this.calculate();
        }
        if (!isCanceled && this.useOptimizeAlgorithm) {
            this.optimizationAlgorithm.performOptimization(this.applyCellList, this.cellList, this.edgeList, this.optimizationAlgorithmConfig);
        }
        if (!isCanceled) {
            this.correctCoordinates();
        }
        if (!isCanceled) {
            isCanceled = this.setNewCoordinates(this.jgraph);
        }
        this.removeTemporaryLayoutDataFromCells();
        this.isRunning = false;
    }

    protected void loadRuntimeValues(int valueID) {
        this.maxRounds = this.applyCellList.size() * 4;
        this.countRounds = 0;
        this.sigmaRot *= 1.0 / (double)(this.applyCellList.size() == 0 ? 1 : this.applyCellList.size());
    }

    protected boolean isTrue(String boolValue) {
        if (boolValue != null) {
            if ("TRUE".equals(boolValue.toUpperCase())) {
                return true;
            }
            if ("FALSE".equals(boolValue.toUpperCase())) {
                return false;
            }
        }
        return false;
    }

    private void getNodes(JGraph jgraph, Object[] cells) {
        int i;
        Object[] all = jgraph.getRoots();
        CellView[] view = jgraph.getGraphLayoutCache().getMapping(all, false);
        CellView[] selectedView = jgraph.getGraphLayoutCache().getMapping(cells, false);
        for (i = 0; i < view.length; ++i) {
            if (view[i] instanceof VertexView) {
                this.cellList.add(view[i]);
                this.applyCellList.add(view[i]);
                continue;
            }
            if (!(view[i] instanceof EdgeView)) continue;
            this.edgeList.add(view[i]);
        }
        for (i = 0; i < selectedView.length; ++i) {
            if (!(selectedView[i] instanceof VertexView)) continue;
            this.applyCellList.add(selectedView[i]);
        }
    }

    private boolean initialize() {
        int i;
        int length = this.cellList.size();
        for (i = 0; i < length; ++i) {
            CellView view = (CellView)this.cellList.get(i);
            this.initializeVertice(view);
        }
        for (i = 0; i < this.applyCellList.size(); ++i) {
            this.computeLastImpulse((CellView)this.applyCellList.get(i));
        }
        return false;
    }

    private void initializeVertice(CellView view) {
        Object attributes = view.getAttributes();
        if (attributes == null) {
            attributes = new Hashtable();
        }
        attributes.put(KEY_CAPTION, KEY_CAPTION);
        this.initPosition(view);
        if (this.isCluster(view)) {
            attributes.put(KEY_TEMPERATURE, new Double(this.clusterInitTemperature));
        } else {
            attributes.put(KEY_TEMPERATURE, new Double(this.initTemperature));
        }
        attributes.put(KEY_SKEWGAUGE, new Double(0.0));
        attributes.put(KEY_CURRENT_IMPULSE, new Point2D.Double());
        attributes.put(KEY_LAST_IMPULSE, new Point2D.Double());
    }

    private boolean calculate() {
        int i;
        int length = this.applyCellList.size();
        int[] sequence = new int[length];
        boolean isCanceled = false;
        if (!this.shouldComputePermutation) {
            for (i = 0; i < length; ++i) {
                sequence[i] = i;
            }
        }
        while (!this.isFrozen() && this.countRounds <= this.maxRounds && !isCanceled) {
            if (this.shouldComputePermutation) {
                sequence = this.createPermutation(length);
            }
            for (i = 0; i < sequence.length; ++i) {
                CellView view = (CellView)this.applyCellList.get(sequence[i]);
                this.computeCurrentImpulse(view);
                this.updatePosAndTemp(view);
            }
            ++this.countRounds;
        }
        return false;
    }

    private void computeCurrentImpulse(CellView view) {
        Point2D.Double impulse = this.computeImpulse(view);
        view.getAttributes().put((Object)KEY_CURRENT_IMPULSE, (Object)impulse);
    }

    private void computeLastImpulse(CellView view) {
        Point2D.Double impulse = this.computeImpulse(view);
        view.getAttributes().put((Object)KEY_LAST_IMPULSE, (Object)impulse);
    }

    private Point2D.Double computeImpulse(CellView view) {
        int i;
        Point2D.Double impulse = new Point2D.Double();
        Point2D.Double pos = this.getPosition(view);
        boolean isCellACluster = this.isCluster(view);
        double massIndex = this.getNodeWeight(view);
        Point2D.Double barycenter = this.computeBarycenter(this.cellList);
        Point2D.Double gravitationForce = new Point2D.Double((barycenter.getX() - pos.getX()) * this.gravitation * massIndex, (barycenter.getY() - pos.getY()) * this.gravitation * massIndex);
        Point2D.Double randomImpulse = this.getRandomVector(this.randomImpulseRange);
        ArrayList<Point2D.Double> repulsiveForce = new ArrayList<Point2D.Double>();
        for (int i2 = 0; i2 < this.cellList.size(); ++i2) {
            double deltaY;
            if (this.cellList.get(i2) == view) continue;
            Point2D.Double uPos = this.getPosition(i2, this.cellList);
            double deltaX = pos.getX() - uPos.getX();
            double absDelta = AnnealingLayoutAlgorithm.MathExtensions.abs((double)deltaX, (double)(deltaY = pos.getY() - uPos.getY()));
            if (!(absDelta > this.equalsNull)) continue;
            repulsiveForce.add(new Point2D.Double(deltaX * (this.prefEdgeLength * this.prefEdgeLength / (absDelta * absDelta)), deltaY * (this.prefEdgeLength * this.prefEdgeLength / (absDelta * absDelta))));
        }
        ArrayList relatives = this.getRelativesFrom(this.cellList, view);
        ArrayList<Point2D.Double> attractiveForce = new ArrayList<Point2D.Double>(relatives.size());
        for (int i3 = 0; i3 < relatives.size(); ++i3) {
            Point2D.Double cPos = this.getPosition(i3, relatives);
            double deltaX = pos.getX() - cPos.getX();
            double deltaY = pos.getY() - cPos.getY();
            double absDelta = AnnealingLayoutAlgorithm.MathExtensions.abs((double)deltaX, (double)deltaY);
            attractiveForce.add(new Point2D.Double(deltaX * (absDelta * absDelta / (this.prefEdgeLength * this.prefEdgeLength * massIndex)), deltaY * (absDelta * absDelta / (this.prefEdgeLength * this.prefEdgeLength * massIndex))));
        }
        ArrayList<Point2D.Double> forcesByOverlapping = new ArrayList<Point2D.Double>();
        if (this.avoidOverlapping) {
            Rectangle viewBounds = new Rectangle((int)pos.x, (int)pos.y, (int)view.getBounds().getWidth(), (int)view.getBounds().getHeight());
            Rectangle viewBorder = new Rectangle((int)(viewBounds.getX() - this.overlapDetectWidth), (int)(viewBounds.getY() - this.overlapDetectWidth), (int)(viewBounds.getWidth() + 2.0 * this.overlapDetectWidth), (int)(viewBounds.getHeight() + 2.0 * this.overlapDetectWidth));
            for (int i4 = 0; i4 < this.cellList.size(); ++i4) {
                Point2D.Double uPos = this.getPosition(i4, this.cellList);
                Rectangle uBounds = new Rectangle((int)uPos.x, (int)uPos.y, (int)((CellView)this.cellList.get(i4)).getBounds().getWidth(), (int)((CellView)this.cellList.get(i4)).getBounds().getHeight());
                if (view == this.cellList.get(i4) || !viewBorder.intersects(uBounds)) continue;
                Dimension viewSize = viewBounds.getSize();
                Dimension uSize = uBounds.getSize();
                double minDistance = Math.max(viewSize.getWidth(), viewSize.getHeight()) / 2.0 + Math.max(uSize.getWidth(), uSize.getHeight()) / 2.0 + this.overlapPrefDistance;
                double deltaX = pos.x - uPos.x;
                double deltaY = pos.y - uPos.y;
                if (deltaX < this.equalsNull && deltaX >= 0.0) {
                    deltaX = this.equalsNull;
                } else if (deltaX > -this.equalsNull && deltaX <= 0.0) {
                    deltaX = -this.equalsNull;
                }
                if (deltaY < this.equalsNull && deltaY >= 0.0) {
                    deltaY = this.equalsNull;
                } else if (deltaY > -this.equalsNull && deltaY <= 0.0) {
                    deltaY = -this.equalsNull;
                }
                double absDelta = AnnealingLayoutAlgorithm.MathExtensions.abs((double)deltaX, (double)deltaY);
                Point2D.Double force = new Point2D.Double(deltaX * (minDistance * minDistance) / (absDelta * absDelta), deltaY * (minDistance * minDistance) / (absDelta * absDelta));
                forcesByOverlapping.add(force);
            }
        }
        ArrayList additionalForce = this.getAdditionalForces((VertexView)view);
        impulse = this.add(impulse, gravitationForce);
        impulse = this.add(impulse, randomImpulse);
        for (i = 0; i < repulsiveForce.size(); ++i) {
            impulse = this.add(impulse, (Point2D.Double)repulsiveForce.get(i));
        }
        for (i = 0; i < attractiveForce.size(); ++i) {
            impulse = this.sub(impulse, (Point2D.Double)attractiveForce.get(i));
        }
        for (i = 0; i < forcesByOverlapping.size(); ++i) {
            impulse = this.add(impulse, (Point2D.Double)forcesByOverlapping.get(i));
        }
        for (i = 0; i < additionalForce.size(); ++i) {
            impulse = this.add(impulse, (Point2D.Double)additionalForce.get(i));
        }
        return impulse;
    }

    private void updatePosAndTemp(CellView view) {
        Point2D.Double impulse = (Point2D.Double)view.getAttributes().get((Object)KEY_CURRENT_IMPULSE);
        Point2D.Double lastImpulse = (Point2D.Double)view.getAttributes().get((Object)KEY_LAST_IMPULSE);
        Point2D.Double position = this.getPosition(view);
        double localTemperature = (Double)view.getAttributes().get((Object)KEY_TEMPERATURE);
        double skewGauge = (Double)view.getAttributes().get((Object)KEY_SKEWGAUGE);
        double absImpulse = AnnealingLayoutAlgorithm.MathExtensions.abs((Point2D.Double)impulse);
        double absLastImpulse = AnnealingLayoutAlgorithm.MathExtensions.abs((Point2D.Double)lastImpulse);
        if (absImpulse > this.equalsNull) {
            if (this.isCluster(view)) {
                impulse.setLocation(impulse.getX() * localTemperature * this.clusterForceScalingFactor / absImpulse, impulse.getY() * localTemperature * this.clusterForceScalingFactor / absImpulse);
            } else {
                impulse.setLocation(impulse.getX() * localTemperature / absImpulse, impulse.getY() * localTemperature / absImpulse);
            }
            view.getAttributes().put((Object)KEY_CURRENT_IMPULSE, (Object)impulse);
            position.setLocation(position.getX() + impulse.getX(), position.getY() + impulse.getY());
            view.getAttributes().put((Object)KEY_POSITION, (Object)position);
        }
        if (absLastImpulse > this.equalsNull) {
            double beta = AnnealingLayoutAlgorithm.MathExtensions.angleBetween((Point2D.Double)impulse, (Point2D.Double)lastImpulse);
            double sinBeta = Math.sin(beta);
            double cosBeta = Math.cos(beta);
            if (Math.abs(sinBeta) >= Math.sin(1.5707963267948966 + this.alphaRot / 2.0)) {
                skewGauge += this.sigmaRot * AnnealingLayoutAlgorithm.MathExtensions.sgn((double)sinBeta);
            }
            if (cosBeta < Math.cos(Math.PI + this.alphaOsc / 2.0)) {
                localTemperature *= this.sigmaOsc * Math.abs(cosBeta);
            }
            localTemperature *= 1.0 - Math.abs(skewGauge);
            localTemperature = Math.min(localTemperature, this.maxTemperature);
        }
        view.getAttributes().put((Object)KEY_TEMPERATURE, (Object)new Double(localTemperature));
        view.getAttributes().put((Object)KEY_POSITION, (Object)position);
        view.getAttributes().put((Object)KEY_SKEWGAUGE, (Object)new Double(skewGauge));
        view.getAttributes().put((Object)KEY_LAST_IMPULSE, (Object)new Point2D.Double(impulse.getX(), impulse.getY()));
    }

    private Point2D.Double add(Point2D.Double v1, Point2D.Double v2) {
        return new Point2D.Double(v1.getX() + v2.getX(), v1.getY() + v2.getY());
    }

    private Point2D.Double sub(Point2D.Double v1, Point2D.Double v2) {
        return new Point2D.Double(v1.getX() - v2.getX(), v1.getY() - v2.getY());
    }

    private ArrayList getRelativesFrom(ArrayList list, CellView view) {
        ArrayList relatives = this.getRelatives(view);
        ArrayList result = new ArrayList();
        for (int i = 0; i < relatives.size(); ++i) {
            if (!list.contains(relatives.get(i))) continue;
            result.add(relatives.get(i));
        }
        return result;
    }

    private ArrayList getRelatives(CellView view) {
        if (!(view instanceof VertexView)) {
            new Exception("getRelatives 1").printStackTrace();
            return null;
        }
        if (view.getAttributes().containsKey((Object)KEY_RELATIVES)) {
            return (ArrayList)view.getAttributes().get((Object)KEY_RELATIVES);
        }
        ArrayList<CellView> relatives = new ArrayList<CellView>();
        if (this.isCluster(view)) {
            ArrayList clusteredVertices = (ArrayList)view.getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
            for (int i = 0; i < clusteredVertices.size(); ++i) {
                ArrayList vertexRelatives = this.getRelatives((CellView)clusteredVertices.get(i));
                for (int j = 0; j < vertexRelatives.size(); ++j) {
                    CellView relative = (CellView)vertexRelatives.get(j);
                    if (clusteredVertices.contains(relative) || relatives.contains(relative)) continue;
                    relatives.add(relative);
                }
            }
        } else {
            Object portCell;
            int i;
            ArrayList<Object> portsCells = new ArrayList<Object>();
            VertexView vertexView = (VertexView)view;
            GraphModel model = vertexView.getModel();
            CellMapper mapper = vertexView.getMapper();
            Object vertexCell = vertexView.getCell();
            for (i = 0; i < model.getChildCount(vertexCell); ++i) {
                portCell = model.getChild(vertexCell, i);
                portsCells.add(portCell);
            }
            for (i = 0; i < portsCells.size(); ++i) {
                portCell = portsCells.get(i);
                Iterator edges = model.edges(portCell);
                while (edges.hasNext()) {
                    Object edge = edges.next();
                    Object nextPort = null;
                    nextPort = model.getSource(edge) != portCell ? model.getSource(edge) : model.getTarget(edge);
                    CellView nextVertex = mapper.getMapping(model.getParent(nextPort), true);
                    relatives.add(nextVertex);
                }
            }
        }
        view.getAttributes().put((Object)KEY_RELATIVES, relatives);
        return relatives;
    }

    private double getNodeWeight(CellView view) {
        if (view.getAttributes().containsKey((Object)KEY_MASSINDEX)) {
            return (Double)view.getAttributes().get((Object)KEY_MASSINDEX);
        }
        int childCount = this.getRelatives(view).size();
        double massIndex = (double)(childCount + 1) / 2.0;
        view.getAttributes().put((Object)KEY_MASSINDEX, (Object)new Double(massIndex));
        return massIndex;
    }

    private boolean setNewCoordinates(JGraph jgraph) {
        Hashtable<Object, AttributeMap> viewMap = new Hashtable<Object, AttributeMap>();
        for (int i = 0; i < this.cellList.size(); ++i) {
            Point2D.Double pos = this.getPosition(i, this.cellList);
            Rectangle2D r = ((CellView)this.cellList.get(i)).getBounds();
            r.setFrame(pos.getX() - r.getWidth() / 2.0, pos.getY() - r.getHeight() / 2.0, r.getWidth(), r.getHeight());
            Object cell = ((CellView)this.cellList.get(i)).getCell();
            AttributeMap map = jgraph.getModel().createAttributes();
            GraphConstants.setBounds((Map)map, (Rectangle2D)r);
            viewMap.put(cell, map);
        }
        jgraph.getGraphLayoutCache().edit(viewMap, null, null, null);
        return false;
    }

    private void removeTemporaryLayoutDataFromCells() {
        for (int i = 0; i < this.cellList.size(); ++i) {
            ((CellView)this.cellList.get(i)).getAttributes().clear();
        }
    }

    private boolean isFrozen() {
        double sumOfTemp = 0.0;
        double globalTemp = 0.0;
        boolean isFrozen = true;
        for (int i = 0; i < this.applyCellList.size(); ++i) {
            double temperature = this.getTemperature(i, this.applyCellList);
            sumOfTemp += temperature;
            boolean bl = isFrozen = isFrozen && temperature <= this.minTemperature;
            if (!isFrozen && !this.shouldEndPerAverage) break;
        }
        if (this.shouldEndPerAverage) {
            globalTemp = sumOfTemp / (double)this.applyCellList.size();
            return globalTemp < this.minTemperature;
        }
        return isFrozen;
    }

    private int[] createPermutation(int length) {
        int[] permutation = new int[length];
        for (int i = 0; i < permutation.length; ++i) {
            int newValue = (int)(Math.random() * (double)length);
            for (int j = 0; j < i; ++j) {
                if (newValue != permutation[j]) continue;
                newValue = (int)(Math.random() * (double)length);
                j = -1;
            }
            permutation[i] = newValue;
        }
        return permutation;
    }

    private Point2D.Double getRandomVector(double length) {
        double alpha = Math.random() * Math.PI * 2.0;
        return new Point2D.Double(length * Math.cos(alpha), length * Math.sin(alpha));
    }

    private Point2D.Double computeBarycenter(ArrayList list) {
        double sumX = 0.0;
        double sumY = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            CellView view = (CellView)list.get(i);
            this.initPosition(view);
            Point2D.Double pos = this.getPosition(view);
            sumX += pos.x;
            sumY += pos.y;
        }
        return new Point2D.Double(sumX / (double)list.size(), sumY / (double)list.size());
    }

    private void initPosition(CellView view) {
        if (!view.getAttributes().containsKey((Object)KEY_POSITION)) {
            view.getAttributes().put((Object)KEY_POSITION, (Object)new Point2D.Double(view.getBounds().getCenterX(), view.getBounds().getCenterY()));
        }
    }

    private void correctCoordinates() {
        Rectangle boundingBox = this.getBoundingBox();
        if (boundingBox != null) {
            for (int i = 0; i < this.cellList.size(); ++i) {
                CellView view = (CellView)this.cellList.get(i);
                Point2D.Double pos = this.getPosition(view);
                Point2D.Double newPos = new Point2D.Double(pos.x - boundingBox.getX(), pos.y - boundingBox.getY());
                view.getAttributes().put((Object)KEY_POSITION, (Object)newPos);
            }
        }
    }

    private Rectangle getBoundingBox() {
        return this.getBoundingBox(this.cellList);
    }

    private Rectangle getBoundingBox(ArrayList verticeList) {
        if (verticeList.size() > 0) {
            Point2D.Double vertexPos = this.getPosition(0, verticeList);
            Rectangle2D vertexSize = ((CellView)verticeList.get(0)).getBounds();
            double minX = vertexPos.getX();
            double minY = vertexPos.getX();
            double maxX = vertexPos.getX() + vertexSize.getWidth();
            double maxY = vertexPos.getX() + vertexSize.getHeight();
            for (int i = 1; i < verticeList.size(); ++i) {
                vertexPos = this.getPosition(i, verticeList);
                vertexSize = ((CellView)verticeList.get(i)).getBounds();
                if (minX > vertexPos.getX()) {
                    minX = vertexPos.getX();
                }
                if (minY > vertexPos.getY()) {
                    minY = vertexPos.getY();
                }
                if (maxX < vertexPos.getX() + vertexSize.getWidth()) {
                    maxX = vertexPos.getX() + vertexSize.getWidth();
                }
                if (!(maxY < vertexPos.getY() + vertexSize.getHeight())) continue;
                maxY = vertexPos.getY() + vertexSize.getHeight();
            }
            Rectangle boundingBox = new Rectangle((int)minX, (int)minY, (int)(maxX - minX), (int)(maxY - minY));
            return boundingBox;
        }
        return null;
    }

    private Point2D.Double getPosition(int index, ArrayList list) {
        return (Point2D.Double)this.getAttribute(index, KEY_POSITION, list);
    }

    private double getTemperature(int index, ArrayList list) {
        Double temperature = (Double)this.getAttribute(index, KEY_TEMPERATURE, list);
        return temperature;
    }

    private Point2D.Double getPosition(CellView cell) {
        return (Point2D.Double)cell.getAttributes().get((Object)KEY_POSITION);
    }

    private Object getAttribute(int index, String key, ArrayList list) {
        CellView view = (CellView)list.get(index);
        return view.getAttributes().get((Object)key);
    }

    private void arrangePlacement(CellView[] views) {
        for (int i = 0; i < this.cellList.size(); ++i) {
            this.initPosition((CellView)this.cellList.get(i));
        }
        if (views != null && views.length > 0) {
            int i;
            ArrayList<CellView> cellLevelList = new ArrayList<CellView>();
            for (i = 0; i < views.length; ++i) {
                ArrayList relatives;
                if (!(views[i] instanceof VertexView) || (relatives = this.getRelativesFrom(this.cellList, views[i])).size() <= 0) continue;
                if (views[i].getAttributes() == null) {
                    views[i].setAttributes(new AttributeMap());
                }
                views[i].getAttributes().put((Object)KEY_POSITION, (Object)this.computeBarycenter(relatives));
                cellLevelList.add(views[i]);
            }
            for (i = 0; i < cellLevelList.size(); ++i) {
                this.cellList.add(cellLevelList.get(i));
            }
            int childViewCount = 0;
            CellView[] possibleChildViews = new CellView[views.length - cellLevelList.size()];
            for (int i2 = 0; i2 < views.length; ++i2) {
                if (cellLevelList.contains(views[i2])) continue;
                possibleChildViews[childViewCount++] = views[i2];
            }
            this.arrangePlacement(possibleChildViews);
        }
    }

    public void addApplyableVertices(VertexView[] vertexList) {
        int i;
        for (i = 0; i < vertexList.length; ++i) {
            if (!this.applyCellList.contains(vertexList[i])) {
                this.applyCellList.add(vertexList[i]);
            }
            if (this.cellList.contains(vertexList[i])) continue;
            this.cellList.add(vertexList[i]);
        }
        if (KEY_LAYOUT_UPDATE_METHOD_PERIMETERS.equals(this.layoutUpdateMethod)) {
            for (i = 0; i < vertexList.length; ++i) {
                int j;
                double perimeterSize = this.perimeterInitSize;
                Point2D.Double pos = this.getPosition((CellView)vertexList[i]);
                for (j = 0; j < vertexList.length; ++j) {
                    Point2D.Double oPos;
                    if (i == j || !(Math.abs(pos.distance(oPos = this.getPosition((CellView)vertexList[j]))) < this.perimeterInitSize / 2.0)) continue;
                    perimeterSize += this.perimeterSizeInc;
                }
                for (j = 0; j < this.cellList.size(); ++j) {
                    Point2D.Double uPos = this.getPosition(j, this.cellList);
                    if (!(Math.abs(pos.distance(uPos)) < perimeterSize / 2.0) || this.applyCellList.contains(this.cellList.get(j))) continue;
                    this.applyCellList.add(this.cellList.get(j));
                }
            }
            vertexList = new VertexView[this.applyCellList.size()];
            for (i = 0; i < this.applyCellList.size(); ++i) {
                vertexList[i] = (VertexView)this.applyCellList.get(i);
            }
        }
        if (this.recursionDepth > 0) {
            this.addRelativesToList(vertexList, this.recursionDepth);
        }
    }

    private void addRelativesToList(VertexView[] vertexList, int depth) {
        if (vertexList == null) {
            return;
        }
        if (vertexList.length == 0) {
            return;
        }
        if (depth == 0) {
            return;
        }
        for (int i = 0; i < vertexList.length; ++i) {
            ArrayList relatives = this.getRelatives((CellView)vertexList[i]);
            VertexView[] relativeList = new VertexView[relatives.size()];
            for (int j = 0; j < relatives.size(); ++j) {
                if (!this.applyCellList.contains(relatives.get(j))) {
                    this.applyCellList.add(relatives.get(j));
                }
                if (!this.cellList.contains(relatives.get(j))) {
                    this.cellList.add(relatives.get(j));
                }
                relativeList[j] = (VertexView)relatives.get(j);
            }
            this.addRelativesToList(relativeList, depth - 1);
        }
    }

    protected ArrayList getAdditionalForces(VertexView view) {
        return new ArrayList();
    }

    public void graphChanged(GraphModelEvent e) {
        if (!this.isRunning && this.isActive) {
            this.isRunning = true;
            GraphModelEvent.GraphModelChange change = e.getChange();
            Object[] objRem = change.getRemoved();
            Object[] objIns = change.getInserted();
            if (objRem == null && objIns != null) {
                for (int i = 0; i < this.cellList.size(); ++i) {
                    this.initPosition((CellView)this.cellList.get(i));
                }
                CellView[] viewInserted = this.jgraph.getGraphLayoutCache().getMapping(objIns, false);
                this.applyCellList = new ArrayList();
                int vertexViewCount = 0;
                for (int i = 0; i < viewInserted.length; ++i) {
                    if (!(viewInserted[i] instanceof VertexView)) continue;
                    ++vertexViewCount;
                }
                VertexView[] vertexList = new VertexView[vertexViewCount];
                vertexViewCount = 0;
                for (int i = 0; i < viewInserted.length; ++i) {
                    if (!(viewInserted[i] instanceof VertexView)) continue;
                    vertexList[vertexViewCount++] = (VertexView)viewInserted[i];
                }
                if (vertexList.length == 0) {
                    this.isRunning = false;
                    return;
                }
                this.loadRuntimeValues(1);
                this.sigmaRot /= 1.0 / (double)this.applyCellList.size();
                this.arrangePlacement((CellView[])vertexList);
                this.addApplyableVertices(vertexList);
                if (this.applyCellList.size() == 0) {
                    this.isRunning = false;
                    return;
                }
                if (this.isClusteringEnabled) {
                    this.clusterGraph();
                }
                this.sigmaRot *= 1.0 / (double)this.applyCellList.size();
                this.maxRounds = this.applyCellList.size() * 4;
                this.initialize();
                this.calculate();
                if (this.isClusteringEnabled) {
                    this.declusterGraph();
                }
                if (this.useOptimizeAlgorithm) {
                    this.optimizationAlgorithm.run(this.jgraph, this.jgraph.getRoots());
                }
                this.correctCoordinates();
                this.setNewCoordinates(this.jgraph);
                this.removeTemporaryLayoutDataFromCells();
            } else if (objRem != null && objIns == null) {
                CellView[] viewRemoved = this.jgraph.getGraphLayoutCache().getMapping(objRem, false);
                for (int i = 0; i < viewRemoved.length; ++i) {
                    if (!(viewRemoved[i] instanceof VertexView) || !this.cellList.contains(viewRemoved[i])) continue;
                    this.applyCellList.remove(viewRemoved[i]);
                    this.cellList.remove(viewRemoved[i]);
                }
            }
            this.isRunning = false;
        }
    }

    protected void clusterGraph() {
        VertexView cluster;
        int i;
        Point2D.Double clusterPos;
        int i2;
        int maxClusters = (int)((double)(this.cellList.size() - this.applyCellList.size()) / this.clusteringFactor);
        if (maxClusters == 0) {
            System.out.println("maxClusters = 0");
            return;
        }
        if (this.cellList.size() <= 1) {
            System.out.println("cellList.size() <= 1");
            return;
        }
        ArrayList<VertexView> clusterList = new ArrayList<VertexView>();
        ArrayList cellsToCluster = new ArrayList();
        for (int i3 = 0; i3 < this.cellList.size(); ++i3) {
            if (this.applyCellList.contains(this.cellList.get(i3))) continue;
            cellsToCluster.add(this.cellList.get(i3));
        }
        VertexView[] clusters = new VertexView[maxClusters];
        CellMapper mapper = ((VertexView)this.cellList.get(0)).getMapper();
        Rectangle boundingBox = this.getBoundingBox();
        for (i2 = 0; i2 < clusters.length; ++i2) {
            clusters[i2] = new VertexView(null, this.jgraph, mapper);
            AttributeMap attributes = clusters[i2].getAttributes();
            attributes.put(KEY_IS_CLUSTER, "true");
            attributes.put(KEY_POSITION, new Point2D.Double(Math.random() * (double)boundingBox.width, Math.random() * (double)boundingBox.height));
            clusterList.add(clusters[i2]);
        }
        for (i2 = 0; i2 < cellsToCluster.size(); ++i2) {
            VertexView cell = (VertexView)cellsToCluster.get(i2);
            Point2D.Double cellPos = this.getPosition((CellView)cell);
            int clusterID = 0;
            clusterPos = this.getPosition((CellView)clusterList.get(0));
            double minDistance = AnnealingLayoutAlgorithm.MathExtensions.getEuclideanDistance((Point2D.Double)cellPos, (Point2D.Double)clusterPos);
            for (int j = 1; j < clusterList.size(); ++j) {
                clusterPos = this.getPosition(j, clusterList);
                double distance = AnnealingLayoutAlgorithm.MathExtensions.getEuclideanDistance((Point2D.Double)cellPos, (Point2D.Double)clusterPos);
                if (!(minDistance > distance)) continue;
                minDistance = distance;
                clusterID = j;
            }
            VertexView cluster2 = (VertexView)clusterList.get(clusterID);
            this.moveVerticeToCluster(cell, cluster2);
        }
        boolean couldMakeItBetter = false;
        do {
            couldMakeItBetter = false;
            block5: for (i = 0; i < cellsToCluster.size(); ++i) {
                VertexView cell = (VertexView)cellsToCluster.get(i);
                VertexView oldCluster = (VertexView)cell.getAttributes().get((Object)KEY_CLUSTER);
                Point2D.Double cellPos = this.getPosition((CellView)cell);
                Point2D.Double clusterPos2 = this.getPosition((CellView)oldCluster);
                double distance = AnnealingLayoutAlgorithm.MathExtensions.getEuclideanDistance((Point2D.Double)cellPos, (Point2D.Double)clusterPos2);
                for (int j = 0; j < clusterList.size(); ++j) {
                    double newDistance;
                    VertexView cluster3 = (VertexView)clusterList.get(j);
                    if (cluster3 == oldCluster || !((newDistance = AnnealingLayoutAlgorithm.MathExtensions.getEuclideanDistance((Point2D.Double)cellPos, (Point2D.Double)(clusterPos2 = this.getPosition((CellView)cluster3)))) < distance)) continue;
                    this.moveVerticeToCluster(cell, cluster3);
                    couldMakeItBetter = true;
                    continue block5;
                }
            }
        } while (couldMakeItBetter);
        for (i = 0; i < clusterList.size(); ++i) {
            if (!((VertexView)clusterList.get(i)).getAttributes().containsKey((Object)KEY_CLUSTERED_VERTICES)) {
                clusterList.remove(i--);
                continue;
            }
            if (((ArrayList)((VertexView)clusterList.get(i)).getAttributes().get((Object)KEY_CLUSTERED_VERTICES)).size() != 0) continue;
            clusterList.remove(i--);
        }
        for (i = 0; i < cellsToCluster.size(); ++i) {
            this.cellList.remove(cellsToCluster.get(i));
        }
        for (i = 0; i < clusterList.size(); ++i) {
            this.applyCellList.add(clusterList.get(i));
            this.cellList.add(clusterList.get(i));
        }
        for (i = 0; i < clusterList.size(); ++i) {
            cluster = (VertexView)clusterList.get(i);
            AttributeMap attribs = cluster.getAttributes();
            clusterPos = (Point2D.Double)attribs.get(KEY_POSITION);
            attribs.put(KEY_CLUSTER_INIT_POSITION, new Point2D.Double(clusterPos.x, clusterPos.y));
        }
        for (i = 0; i < clusterList.size(); ++i) {
            cluster = (VertexView)clusterList.get(i);
            cluster.setCachedBounds((Rectangle2D)this.getBoundingBox((ArrayList)cluster.getAttributes().get((Object)KEY_CLUSTERED_VERTICES)));
        }
        this.colorizeClusters(clusterList);
        this.stop(20);
    }

    protected void moveVerticeToCluster(VertexView vertice, VertexView cluster) {
        if (!cluster.getAttributes().containsKey((Object)KEY_CLUSTERED_VERTICES)) {
            cluster.getAttributes().put((Object)KEY_CLUSTERED_VERTICES, new ArrayList());
        }
        ArrayList clusteredVertices = (ArrayList)cluster.getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
        clusteredVertices.add(vertice);
        if (vertice.getAttributes().containsKey((Object)KEY_CLUSTER)) {
            VertexView oldCluster = (VertexView)vertice.getAttributes().get((Object)KEY_CLUSTER);
            ArrayList list = (ArrayList)oldCluster.getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
            list.remove(vertice);
            this.computeClusterPosition(oldCluster);
        }
        vertice.getAttributes().put((Object)KEY_CLUSTER, (Object)cluster);
        this.computeClusterPosition(cluster);
    }

    protected void computeClusterPosition(VertexView cluster) {
        ArrayList clusteredVertices = (ArrayList)cluster.getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
        Point2D.Double clusterPos = this.computeBarycenter(clusteredVertices);
        cluster.getAttributes().put((Object)KEY_POSITION, (Object)clusterPos);
    }

    protected void declusterGraph() {
        int i;
        if (this.cellList.size() <= 1) {
            return;
        }
        ArrayList<VertexView> clusterList = new ArrayList<VertexView>();
        for (i = 0; i < this.cellList.size(); ++i) {
            VertexView cell = (VertexView)this.cellList.get(i);
            if (!this.isCluster((CellView)cell)) continue;
            clusterList.add(cell);
        }
        if (clusterList.size() == 0) {
            return;
        }
        for (i = 0; i < clusterList.size(); ++i) {
            this.cellList.remove(clusterList.get(i));
            this.applyCellList.remove(clusterList.get(i));
        }
        for (i = 0; i < clusterList.size(); ++i) {
            VertexView cluster = (VertexView)clusterList.get(i);
            AttributeMap attribs = cluster.getAttributes();
            Point2D.Double newClusterPos = this.getPosition((CellView)cluster);
            Point2D.Double oldClusterPos = (Point2D.Double)attribs.get(KEY_CLUSTER_INIT_POSITION);
            Point2D.Double move = new Point2D.Double(newClusterPos.x - oldClusterPos.x, newClusterPos.y - oldClusterPos.y);
            ArrayList vertexList = (ArrayList)attribs.get(KEY_CLUSTERED_VERTICES);
            for (int j = 0; j < vertexList.size(); ++j) {
                VertexView cell = (VertexView)vertexList.get(j);
                Point2D.Double cellPos = this.getPosition((CellView)cell);
                Point2D.Double newCellPos = new Point2D.Double(cellPos.x + move.x, cellPos.y + move.y);
                cell.getAttributes().put((Object)KEY_POSITION, (Object)newCellPos);
                this.cellList.add(cell);
            }
        }
    }

    protected boolean isCluster(CellView cell) {
        if (cell.getAttributes().containsKey((Object)KEY_IS_CLUSTER)) {
            if (this.isTrue((String)cell.getAttributes().get((Object)KEY_IS_CLUSTER))) {
                return true;
            }
            System.err.println("FATAL ERROR: CELL CANNOT CLEARLY BE IDENTIFIED AS A CLUSTER!!!");
            return false;
        }
        return false;
    }

    private void colorizeClusters(ArrayList clusterList) {
        Color[] colorList = new Color[]{Color.black, Color.magenta, Color.yellow, Color.blue, Color.green, Color.gray, Color.cyan, Color.red, Color.darkGray, Color.lightGray, Color.orange, Color.pink};
        for (int i = 0; i < clusterList.size(); ++i) {
            if (i >= colorList.length) continue;
            ArrayList clusteredVertices = (ArrayList)((CellView)clusterList.get(i)).getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
            this.showCellList(clusteredVertices, colorList[i]);
        }
    }

    private void showCellList(ArrayList list, Color color) {
        Hashtable<Object, AttributeMap> viewMap = new Hashtable<Object, AttributeMap>();
        for (int i = 0; i < list.size(); ++i) {
            CellView view = (CellView)list.get(i);
            Point2D.Double pos = this.getPosition(i, list);
            Rectangle2D r = view.getBounds();
            r.setFrame(pos.getX() - r.getWidth() / 2.0, pos.getY() - r.getHeight() / 2.0, r.getWidth(), r.getHeight());
            Object cell = view.getCell();
            AttributeMap attributes = new AttributeMap();
            GraphConstants.setBackground((Map)attributes, (Color)color);
            GraphConstants.setBounds((Map)attributes, (Rectangle2D)r);
            viewMap.put(cell, attributes);
        }
        this.jgraph.getGraphLayoutCache().edit(viewMap, null, null, null);
    }

    private synchronized void stop(double sec) {
        try {
            ((Object)((Object)this)).wait((long)(sec * 1000.0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void stop(int sec) {
        this.stop((double)sec);
    }
}

