/*
 * Decompiled with CFR 0.152.
 */
package jgraph;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jgraph.JGraph;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.VertexView;
import org.jgraph.layout.JGraphLayoutAlgorithm;

public class AnnealingLayoutAlgorithm
extends JGraphLayoutAlgorithm
implements GraphModelListener {
    public static final String KEY_TITLE = "Simulated Annealing";
    public static final String KEY_CONFIG_NAME = "CONFIG_NAME";
    public static final String KEY_INIT_TEMPERATURE = "Start Temperature";
    public static final String KEY_MIN_TEMPERATURE = "min. Temperature";
    public static final String KEY_MIN_DISTANCE = "min. Distance";
    public static final String KEY_TEMP_SCALE_FACTOR = "Temperature Scalefactor";
    public static final String KEY_COMPUTE_PERMUTATION = "should compute per Permutation";
    public static final String KEY_IS_UPHILL_MOVE_ALLOWED = "are Uphill-Moves allowed";
    public static final String KEY_MAX_ROUNDS = "max. Rounds";
    public static final String KEY_TRIES_PER_CELL = "tries per cell";
    public static final String KEY_COST_FUNCTION_CONFIG = "Costfunction Config";
    public static final String KEY_LAMBDA = "Lambda";
    public static final String KEY_BOUNDS = "Bounds of resulting graph";
    public static final String KEY_LAYOUT_UPDATE_INIT_TEMPERATURE = "Layout Update Start Temperature";
    public static final String KEY_LAYOUT_UPDATE_MIN_TEMPERATURE = "Layout Update min. Temperature";
    public static final String KEY_LAYOUT_UPDATE_MIN_DISTANCE = "Layout Update min. Distance";
    public static final String KEY_LAYOUT_UPDATE_TEMP_SCALE_FACTOR = "Layout Update Temperature Scalefactor";
    public static final String KEY_LAYOUT_UPDATE_COMPUTE_PERMUTATION = "Layout Update should compute per Permutation";
    public static final String KEY_LAYOUT_UPDATE_IS_UPHILL_MOVE_ALLOWED = "Layout Update are Uphill-Moves allowed";
    public static final String KEY_LAYOUT_UPDATE_MAX_ROUNDS = "Layout Update max. Rounds";
    public static final String KEY_LAYOUT_UPDATE_TRIES_PER_CELL = "Layout Update tries per cell";
    public static final String KEY_LAYOUT_UPDATE_COST_FUNCTION_CONFIG = "Layout Update Costfunction Config";
    public static final String KEY_LAYOUT_UPDATE_LAMBDA = "Layout Update Lambda";
    public static final String KEY_LAYOUT_UPDATE_BOUNDS = "Layout Update Bounds of resulting graph";
    public static final String KEY_LAYOUT_UPDATE_METHOD = "Layout Update Method";
    public static final String KEY_LAYOUT_UPDATE_METHOD_NEIGHBORS_ONLY = "Layout Update Method Neighbors only";
    public static final String KEY_LAYOUT_UPDATE_METHOD_PERIMETER = "Layout Update Method Perimeter";
    public static final String KEY_LAYOUT_UPDATE_METHOD_NEIGHBORS_DEPTH = "Layout Update Method Neighbors depth";
    public static final String KEY_LAYOUT_UPDATE_METHOD_PERIMETER_RADIUS = "Layout Update Method Perimeter radius";
    public static final String KEY_LAYOUT_UPDATE_METHOD_PERIMETER_RADIUS_INCREASE = "Layout Update Method Perimeter radius increase";
    public static final String KEY_LAYOUT_UPDATE_ENABLED = "Layout Update enabled";
    public static final String KEY_LAYOUT_UPDATE_CLUSTERING_ENABLED = "Layout Update clustering enabled";
    public static final String KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR = "Layout Update clustering factor";
    public static final String KEY_LAYOUT_UPDATE_CLUSTERING_MOVE_SCALE = "Layout Update clustering move scaling factor";
    public static final int COUT_COSTFUNCTION = 6;
    public static final int COSTFUNCTION_EDGE_DISTANCE = 1;
    public static final int COSTFUNCTION_EDGE_CROSSING = 2;
    public static final int COSTFUNCTION_EDGE_LENGTH = 4;
    public static final int COSTFUNCTION_BORDERLINE = 8;
    public static final int COSTFUNCTION_NODE_DISTRIBUTION = 16;
    public static final int COSTFUNCTION_NODE_DISTANCE = 32;
    public static final String KEY_CAPTION = "Annealing Layoutalgorithm Attributes";
    public static final String KEY_POSITION = "Position";
    public static final String KEY_RELATIVES = "Relatives";
    public static final String CF_KEY_EDGE_DISTANCE_RELEVANT_EDGES = "costfunction edge distance key for relevant edges";
    public static final String KEY_CLUSTERED_VERTICES = "Clustered Vertices";
    public static final String KEY_CLUSTER = "Cluster";
    public static final String KEY_IS_CLUSTER = "is Cluster";
    public static final String KEY_CLUSTER_INIT_POSITION = "initial Position of the Cluster";
    protected static final int CONFIG_KEY_RUN = 0;
    protected static final int CONFIG_KEY_LAYOUT_UPDATE = 1;
    private double temperature;
    private double initTemperature = 300.0;
    private double minTemperature = 2.0;
    private double minDistance = 50.0;
    private double tempScaleFactor = 0.95;
    private int maxRounds = 10000;
    protected double[] lambdaList;
    private Rectangle bounds;
    private boolean computePermutation;
    private boolean uphillMovesAllowed;
    private boolean isLayoutUpdateEnabled;
    private int costFunctionConfig;
    private int round;
    private int triesPerCell;
    protected ArrayList cellList;
    protected ArrayList edgeList;
    protected ArrayList applyCellList;
    private JGraph jgraph;
    protected Properties presetConfig;
    private long time = 0L;
    private boolean isDebugging = false;
    private boolean isRunning = false;
    private int luRecursionDepth;
    private double luPerimeterRadius;
    private double luPerimeterRadiusInc;
    private String luMethod;
    private double equalsNull = 0.05;
    private boolean isClusteringEnabled;
    private double clusterMoveScaleFactor;
    private double clusteringFactor;

    public void run(JGraph graph, Object[] cells) {
        this.isRunning = true;
        this.jgraph = graph;
        this.cellList = new ArrayList();
        this.edgeList = new ArrayList();
        this.applyCellList = new ArrayList();
        this.loadConfiguration(0);
        this.getNodes(this.jgraph, cells);
        if (this.applyCellList.size() == 0) {
            return;
        }
        if (this.isLayoutUpdateEnabled) {
            this.jgraph.getModel().addGraphModelListener((GraphModelListener)this);
        }
        this.init(true);
        this.run();
        this.moveGraphToNW();
        this.applyChanges();
        this.removeTemporaryData();
        this.isRunning = false;
    }

    public void performOptimization(ArrayList applyList, ArrayList allCellList, ArrayList allEdgeList, Properties config) {
        this.cellList = allCellList;
        this.applyCellList = applyList;
        this.edgeList = allEdgeList;
        this.presetConfig = config;
        this.loadConfiguration(0);
        this.init(false);
        this.run();
    }

    private void loadConfiguration(int configSwitch) {
        this.isLayoutUpdateEnabled = false;
        this.initTemperature = 40.0;
        this.minTemperature = 2.0;
        this.minDistance = 50.0;
        this.tempScaleFactor = 0.95;
        this.maxRounds = 10000;
        this.triesPerCell = 8;
        ArrayList<Double> lambda = new ArrayList<Double>();
        lambda.add(new Double(1000.0));
        lambda.add(new Double(100000.0));
        lambda.add(new Double(0.02));
        lambda.add(new Double(2000.0));
        lambda.add(new Double(150.0));
        lambda.add(new Double(1000000.0));
        this.lambdaList = new double[lambda.size()];
        for (int i = 0; i < this.lambdaList.length; ++i) {
            this.lambdaList[i] = (Double)lambda.get(i);
        }
        this.bounds = new Rectangle(0, 0, 10000, 10000);
        this.costFunctionConfig = 0;
        this.computePermutation = true;
        this.uphillMovesAllowed = true;
        this.loadAdditionalConfiguration(configSwitch);
    }

    protected void loadAdditionalConfiguration(int configSwitch) {
    }

    private boolean isTrue(String boolValue) {
        if (boolValue != null) {
            if ("TRUE".equals(boolValue.toUpperCase())) {
                return true;
            }
            if ("FALSE".equals(boolValue.toUpperCase())) {
                return false;
            }
        }
        return false;
    }

    private void getNodes(JGraph jgraph, Object[] cells) {
        int i;
        Object[] all = jgraph.getRoots();
        CellView[] view = jgraph.getGraphLayoutCache().getMapping(all, false);
        CellView[] selectedView = jgraph.getGraphLayoutCache().getMapping(cells, false);
        for (i = 0; i < view.length; ++i) {
            if (view[i] instanceof VertexView) {
                this.cellList.add(view[i]);
                this.applyCellList.add(view[i]);
                continue;
            }
            if (!(view[i] instanceof EdgeView)) continue;
            this.edgeList.add(view[i]);
        }
        for (i = 0; i < selectedView.length; ++i) {
            if (!(selectedView[i] instanceof VertexView)) continue;
            this.applyCellList.add(selectedView[i]);
        }
    }

    private void applyChanges() {
        Hashtable<Object, AttributeMap> viewMap = new Hashtable<Object, AttributeMap>();
        for (int i = 0; i < this.applyCellList.size(); ++i) {
            CellView view = (CellView)this.applyCellList.get(i);
            Point2D.Double pos = this.getPosition(view);
            Rectangle2D r = view.getBounds();
            r.setFrame(pos.getX() - r.getWidth() / 2.0, pos.getY() - r.getHeight() / 2.0, r.getWidth(), r.getHeight());
            Object cell = ((CellView)this.applyCellList.get(i)).getCell();
            AttributeMap attributes = new AttributeMap();
            GraphConstants.setBounds((Map)attributes, (Rectangle2D)r);
            viewMap.put(cell, attributes);
        }
        this.jgraph.getGraphLayoutCache().edit(viewMap, null, null, null);
    }

    private void removeTemporaryData() {
        for (int i = 0; i < this.applyCellList.size(); ++i) {
            ((CellView)this.applyCellList.get(i)).getAttributes().clear();
        }
    }

    private void init(boolean setInitPositions) {
        if (setInitPositions) {
            int i;
            for (i = 0; i < this.applyCellList.size(); ++i) {
                if (((CellView)this.applyCellList.get(i)).getAttributes().containsKey((Object)KEY_POSITION)) continue;
                this.setPosition(i, Math.random() * this.bounds.getWidth() + this.bounds.getX(), Math.random() * this.bounds.getHeight() + this.bounds.getY());
            }
            for (i = 0; i < this.cellList.size(); ++i) {
                if (((CellView)this.cellList.get(i)).getAttributes().containsKey((Object)KEY_POSITION)) continue;
                this.setPosition((CellView)this.cellList.get(i), Math.random() * this.bounds.getWidth() + this.bounds.getX(), Math.random() * this.bounds.getHeight() + this.bounds.getY());
            }
        }
        this.temperature = this.initTemperature;
        this.maxRounds = Math.min(100 * this.applyCellList.size(), this.getMaxRoundsByTemperature(this.temperature));
        this.round = 0;
    }

    private void run() {
        while (this.round <= this.maxRounds) {
            this.performRound();
        }
    }

    private void performRound() {
        int i;
        double startEnergy;
        Point2D.Double[] config = this.getConfig();
        double globalEnergy = startEnergy = this.getGlobalCosts(this.lambdaList);
        double newGlobalEnergy = globalEnergy * 1.1;
        int[] sequence = new int[this.applyCellList.size()];
        if (!this.computePermutation) {
            for (i = 0; i < this.applyCellList.size(); ++i) {
                sequence[i] = i;
            }
        }
        for (i = 0; i < this.applyCellList.size(); ++i) {
            if (this.computePermutation) {
                sequence = this.createPermutation(this.applyCellList.size());
            }
            double offset = Math.random() * 2.0 * Math.PI;
            for (int j = 0; j < this.triesPerCell; ++j) {
                double angle = (double)j * (Math.PI * 2 / (double)this.triesPerCell);
                Point2D.Double move = null;
                move = this.isCluster((CellView)this.applyCellList.get(i)) ? new Point2D.Double(this.clusterMoveScaleFactor * this.temperature * Math.cos(angle), this.clusterMoveScaleFactor * this.temperature * Math.sin(angle)) : new Point2D.Double(this.temperature * Math.cos(angle += offset), this.temperature * Math.sin(angle));
                this.setPosition(sequence[i], config[sequence[i]].x + move.x, config[sequence[i]].y + move.y);
                newGlobalEnergy = this.getGlobalCosts(this.lambdaList);
                if (newGlobalEnergy < globalEnergy || this.getBolzmanBreak(globalEnergy, newGlobalEnergy) && this.uphillMovesAllowed) {
                    globalEnergy = newGlobalEnergy;
                    config[sequence[i]] = new Point2D.Double(config[sequence[i]].x + move.x, config[sequence[i]].y + move.y);
                    break;
                }
                this.setPosition(sequence[i], config[sequence[i]].x, config[sequence[i]].y);
            }
            if (globalEnergy == startEnergy * 0.05) break;
        }
        this.temperature *= this.tempScaleFactor;
        ++this.round;
    }

    private Point2D.Double[] getConfig() {
        Point2D.Double[] config = new Point2D.Double[this.applyCellList.size()];
        for (int i = 0; i < this.applyCellList.size(); ++i) {
            Point2D.Double pos = this.getPosition((CellView)this.applyCellList.get(i));
            config[i] = new Point2D.Double(pos.x, pos.y);
        }
        return config;
    }

    private double getGlobalCosts(double[] lambda) {
        double energy = 0.0;
        if ((this.costFunctionConfig & 0x20) != 0) {
            energy += this.getNodeDistance(lambda[5]);
        }
        if ((this.costFunctionConfig & 0x10) != 0) {
            energy += this.getNodeDistribution(lambda[0]);
        }
        if ((this.costFunctionConfig & 8) != 0) {
            energy += this.getBorderline(lambda[1]);
        }
        if ((this.costFunctionConfig & 4) != 0) {
            energy += this.getEdgeLength(lambda[2]);
        }
        if ((this.costFunctionConfig & 2) != 0) {
            energy += this.getEdgeCrossing(1.0, lambda[3]);
        }
        if ((this.costFunctionConfig & 1) != 0) {
            energy += this.getEdgeDistance(lambda[4]);
        }
        return energy += this.getAdditionalCosts(this.costFunctionConfig, lambda);
    }

    protected double getAdditionalCosts(int cfConfig, double[] lambda) {
        return 0.0;
    }

    public int[] createPermutation(int length) {
        int[] permutation = new int[length];
        for (int i = 0; i < permutation.length; ++i) {
            int newValue = (int)(Math.random() * (double)length);
            for (int j = 0; j < i; ++j) {
                if (newValue != permutation[j]) continue;
                newValue = (int)(Math.random() * (double)length);
                j = -1;
            }
            permutation[i] = newValue;
        }
        return permutation;
    }

    private boolean getBolzmanBreak(double oldEnergy, double newEnergy) {
        return Math.random() < Math.pow(Math.E, (oldEnergy - newEnergy) / this.temperature);
    }

    private int getMaxRoundsByTemperature(double actualTemperature) {
        return (int)Math.ceil(Math.log(this.minTemperature / actualTemperature) / Math.log(this.tempScaleFactor));
    }

    private double getNodeDistribution(double lambda) {
        double energy = 0.0;
        for (int i = 0; i < this.applyCellList.size(); ++i) {
            for (int j = 0; j < this.cellList.size(); ++j) {
                if (this.applyCellList.get(i) == this.cellList.get(j)) continue;
                double distance = MathExtensions.getEuclideanDistance(this.getPosition((CellView)this.applyCellList.get(i)), this.getPosition((CellView)this.cellList.get(j)));
                if (Math.abs(distance) < this.equalsNull) {
                    distance = this.equalsNull;
                }
                energy += lambda / (distance * distance);
            }
        }
        return energy;
    }

    private double getBorderline(double lambda) {
        double energy = 0.0;
        for (int i = 0; i < this.applyCellList.size(); ++i) {
            Point2D.Double pos = this.getPosition((CellView)this.applyCellList.get(i));
            double t = pos.y - (double)this.bounds.y;
            double l = pos.x - (double)this.bounds.x;
            double b = (double)(this.bounds.y + this.bounds.height) - pos.y;
            double r = (double)(this.bounds.x + this.bounds.width) - pos.x;
            energy += lambda * (1.0 / (t * t) + 1.0 / (l * l) + 1.0 / (b * b) + 1.0 / (r * r));
        }
        return energy;
    }

    private double getEdgeLength(double lambda) {
        double energy = 0.0;
        Line2D.Double[] lineList = this.getEdgeLines(this.edgeList);
        for (int i = 0; i < lineList.length; ++i) {
            Point2D p1 = lineList[i].getP1();
            Point2D p2 = lineList[i].getP2();
            double edgeLength = p1.distance(p2);
            energy += lambda * edgeLength * edgeLength;
        }
        return energy;
    }

    private double getEdgeCrossing(double f, double lambda) {
        int n = 0;
        Line2D.Double[] lineList = this.getEdgeLines(this.edgeList);
        for (int i = 0; i < lineList.length; ++i) {
            for (int j = i; j < lineList.length; ++j) {
                if (j == i || !lineList[i].intersectsLine(lineList[j]) || lineList[i].getP1().getX() == lineList[j].getP1().getX() || lineList[i].getP1().getY() == lineList[j].getP1().getY() || lineList[i].getP1().getX() == lineList[j].getP2().getX() || lineList[i].getP1().getY() == lineList[j].getP2().getY() || lineList[i].getP2().getX() == lineList[j].getP1().getX() || lineList[i].getP2().getY() == lineList[j].getP1().getY() || lineList[i].getP2().getX() == lineList[j].getP2().getX() || lineList[i].getP2().getY() == lineList[j].getP2().getY()) continue;
                ++n;
            }
        }
        return lambda * f * (double)n;
    }

    private double getEdgeDistance(double lambda) {
        double energy = 0.0;
        for (int i = 0; i < this.applyCellList.size(); ++i) {
            double h = 0.0;
            CellView view = (CellView)this.applyCellList.get(i);
            ArrayList relevantEdges = null;
            if (view.getAttributes().containsKey((Object)CF_KEY_EDGE_DISTANCE_RELEVANT_EDGES)) {
                relevantEdges = (ArrayList)view.getAttributes().get((Object)CF_KEY_EDGE_DISTANCE_RELEVANT_EDGES);
            } else {
                relevantEdges = this.getRelevantEdges(view);
                view.getAttributes().put((Object)CF_KEY_EDGE_DISTANCE_RELEVANT_EDGES, (Object)relevantEdges);
            }
            Line2D.Double[] lineList = this.getEdgeLines(this.getRelevantEdges(view));
            for (int j = 0; j < lineList.length; ++j) {
                double distance = lineList[j].ptSegDist(this.getPosition(view));
                if (Math.abs(distance) < this.equalsNull) {
                    distance = this.equalsNull;
                }
                if (distance != 0.0) {
                    h += lambda / (distance * distance);
                }
                if (!(distance < this.minDistance)) continue;
                h += lambda / (this.minDistance * this.minDistance);
            }
            energy += h;
        }
        return energy;
    }

    private double getNodeDistance(double lambda) {
        double energy = 0.0;
        double radiusInc = 30.0;
        int overlapCount = 0;
        for (int i = 0; i < this.applyCellList.size(); ++i) {
            Point2D.Double pos = (Point2D.Double)((CellView)this.applyCellList.get(i)).getAttributes().get((Object)KEY_POSITION);
            Rectangle2D vertex = ((CellView)this.applyCellList.get(i)).getBounds();
            for (int j = 0; j < this.cellList.size(); ++j) {
                if (this.applyCellList.get(i) == this.cellList.get(j)) continue;
                Point2D.Double uPos = (Point2D.Double)((CellView)this.cellList.get(j)).getAttributes().get((Object)KEY_POSITION);
                Rectangle2D uVertex = ((CellView)this.cellList.get(j)).getBounds();
                double minDist = Math.max(2.0 * radiusInc + Math.max(vertex.getWidth(), vertex.getHeight()) / 2.0 + Math.max(uVertex.getWidth(), uVertex.getHeight()) / 2.0, this.minDistance);
                double distance = Math.abs(pos.distance(uPos));
                if (Math.abs(distance) < this.equalsNull) {
                    distance = this.equalsNull;
                }
                if (!(distance < minDist)) continue;
                energy += lambda / (distance * distance);
                ++overlapCount;
            }
        }
        return energy;
    }

    private Line2D.Double[] getEdgeLines(ArrayList edges) {
        Line2D.Double[] lines = new Line2D.Double[edges.size()];
        for (int i = 0; i < edges.size(); ++i) {
            EdgeView edge = (EdgeView)edges.get(i);
            GraphModel model = edge.getModel();
            CellMapper mapper = edge.getMapper();
            CellView source = edge.getSource().getParentView();
            CellView target = edge.getTarget().getParentView();
            lines[i] = new Line2D.Double(this.getPosition(source), this.getPosition(target));
        }
        return lines;
    }

    private ArrayList getRelevantEdges(CellView except) {
        ArrayList relevantEdgeList = new ArrayList();
        for (int i = 0; i < this.edgeList.size(); ++i) {
            CellView view = ((EdgeView)this.edgeList.get(i)).getSource().getParentView();
            if (view != except && this.applyCellList.contains(view)) {
                relevantEdgeList.add(this.edgeList.get(i));
                continue;
            }
            view = ((EdgeView)this.edgeList.get(i)).getTarget().getParentView();
            if (view == except || !this.applyCellList.contains(view)) continue;
            relevantEdgeList.add(this.edgeList.get(i));
        }
        return relevantEdgeList;
    }

    public Point2D.Double getRandomVector(double maxLength) {
        double alpha = Math.random() * Math.PI * 2.0;
        double length = Math.random() * maxLength;
        return new Point2D.Double(length * Math.cos(alpha), length * Math.sin(alpha));
    }

    private void setPosition(CellView view, Point2D.Double pos) {
        this.setAttribute(view, KEY_POSITION, pos);
    }

    private void setPosition(int index, double x, double y) {
        this.setPosition((CellView)this.applyCellList.get(index), x, y);
    }

    private void setPosition(CellView view, double x, double y) {
        this.setPosition(view, new Point2D.Double(x, y));
    }

    private Point2D.Double getPosition(CellView view) {
        return (Point2D.Double)this.getAttribute(view, KEY_POSITION);
    }

    private void setAttribute(CellView view, String key, Object obj) {
        if (view.getAttributes() == null) {
            view.setAttributes(new AttributeMap());
        }
        AttributeMap attributes = view.getAttributes();
        attributes.put(key, obj);
    }

    private Object getAttribute(CellView view, String key) {
        return view.getAttributes().get((Object)key);
    }

    private void moveGraphToNW() {
        CellView view;
        int i;
        Point2D.Double firstPos = this.getPosition((CellView)this.cellList.get(0));
        double minX = firstPos.x;
        double minY = firstPos.y;
        double maxX = minX;
        double maxY = minY;
        for (i = 0; i < this.cellList.size(); ++i) {
            view = (CellView)this.cellList.get(i);
            Point2D.Double viewPos = this.getPosition((CellView)this.cellList.get(i));
            Rectangle2D viewBounds = view.getAttributes().createRect(view.getBounds());
            if (viewPos.getX() < minX) {
                minX = viewPos.getX();
            } else if (viewPos.getX() + viewBounds.getWidth() > maxX) {
                maxX = viewPos.getX() + viewBounds.getWidth();
            }
            if (viewPos.getY() < minY) {
                minY = viewPos.getY();
                continue;
            }
            if (!(viewPos.getY() + viewBounds.getHeight() > maxY)) continue;
            maxY = viewPos.getY() + viewBounds.getHeight();
        }
        minX -= 50.0;
        minY -= 50.0;
        for (i = 0; i < this.cellList.size(); ++i) {
            view = (CellView)this.cellList.get(i);
            Point2D.Double pos = this.getPosition(view);
            this.setPosition(view, new Point2D.Double(pos.x - minX, pos.y - minY));
        }
    }

    protected ArrayList getRelativesFrom(ArrayList list, CellView view) {
        ArrayList relatives = this.getRelatives(view);
        ArrayList result = new ArrayList();
        for (int i = 0; i < relatives.size(); ++i) {
            if (!list.contains(relatives.get(i))) continue;
            result.add(relatives.get(i));
        }
        return result;
    }

    protected ArrayList getRelatives(CellView view) {
        if (view.getAttributes().containsKey((Object)KEY_RELATIVES)) {
            return (ArrayList)view.getAttributes().get((Object)KEY_RELATIVES);
        }
        ArrayList relatives = new ArrayList();
        ArrayList<Object> portsCells = new ArrayList<Object>();
        VertexView vertexView = (VertexView)view;
        if (this.isCluster(view)) {
            ArrayList clusteredVertices = (ArrayList)vertexView.getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
            for (int i = 0; i < clusteredVertices.size(); ++i) {
                ArrayList clusterRelatives = this.getRelatives((CellView)clusteredVertices.get(i));
                for (int j = 0; j < clusterRelatives.size(); ++j) {
                    if (relatives.contains(clusterRelatives.get(j)) || clusteredVertices.contains(clusterRelatives.get(j))) continue;
                    relatives.add(clusterRelatives.get(j));
                }
            }
        } else {
            Object portCell;
            int i;
            GraphModel model = vertexView.getModel();
            CellMapper mapper = vertexView.getMapper();
            Object vertexCell = vertexView.getCell();
            for (i = 0; i < model.getChildCount(vertexCell); ++i) {
                portCell = model.getChild(vertexCell, i);
                portsCells.add(portCell);
            }
            for (i = 0; i < portsCells.size(); ++i) {
                portCell = portsCells.get(i);
                Iterator edges = model.edges(portCell);
                while (edges.hasNext()) {
                    Object edge = edges.next();
                    Object nextPort = null;
                    nextPort = model.getSource(edge) != portCell ? model.getSource(edge) : model.getTarget(edge);
                    CellView nextVertex = mapper.getMapping(model.getParent(nextPort), false);
                    relatives.add(nextVertex);
                }
            }
        }
        view.getAttributes().put((Object)KEY_RELATIVES, relatives);
        return relatives;
    }

    private void arrangeLayoutUpdateInsertPlacement(CellView[] viewList) {
        for (int i = 0; i < this.cellList.size(); ++i) {
            CellView view = (CellView)this.cellList.get(i);
            if (view.getAttributes().containsKey((Object)KEY_POSITION)) continue;
            Point2D.Double pos = new Point2D.Double(view.getBounds().getCenterX(), view.getBounds().getCenterY());
            view.getAttributes().put((Object)KEY_POSITION, (Object)pos);
        }
        ArrayList<CellView> placableCells = new ArrayList<CellView>();
        for (int i = 0; i < viewList.length; ++i) {
            placableCells.add(viewList[i]);
        }
        this.arrangeLayoutUpdateInsertedCellsPlacement(placableCells);
    }

    private void arrangeLayoutUpdateInsertedCellsPlacement(ArrayList placableCells) {
        CellView view;
        int i;
        ArrayList<CellView> notPlacedCells = new ArrayList<CellView>();
        for (i = 0; i < placableCells.size(); ++i) {
            view = (CellView)placableCells.get(i);
            if (!(view instanceof VertexView)) continue;
            ArrayList relatives = this.getRelativesFrom(this.cellList, view);
            if (relatives.size() != 0) {
                double sumX = 0.0;
                double sumY = 0.0;
                for (int j = 0; j < relatives.size(); ++j) {
                    Point2D.Double pos = (Point2D.Double)((CellView)relatives.get(j)).getAttributes().get((Object)KEY_POSITION);
                    sumX += pos.x;
                    sumY += pos.y;
                }
                Point2D.Double randomVector = new Point2D.Double(Math.cos(Math.random() * 2.0 * Math.PI) * 10.0, Math.sin(Math.random() * 2.0 * Math.PI) * 10.0);
                view.getAttributes().put((Object)KEY_POSITION, (Object)new Point2D.Double(sumX / (double)relatives.size() + randomVector.x, sumY / (double)relatives.size() + randomVector.y));
                continue;
            }
            notPlacedCells.add(view);
        }
        for (i = 0; i < placableCells.size(); ++i) {
            if (placableCells.get(i) == null || ((CellView)placableCells.get(i)).getAttributes() == null || !((CellView)placableCells.get(i)).getAttributes().containsKey((Object)KEY_POSITION)) continue;
            this.cellList.add(placableCells.get(i));
        }
        if (notPlacedCells.size() != placableCells.size()) {
            this.arrangeLayoutUpdateInsertedCellsPlacement(notPlacedCells);
        } else {
            for (i = 0; i < notPlacedCells.size(); ++i) {
                view = (CellView)notPlacedCells.get(i);
                if (view.getAttributes().containsKey((Object)KEY_POSITION)) continue;
                view.getAttributes().put((Object)KEY_POSITION, (Object)new Point2D.Double(0.0, 0.0));
            }
        }
        for (i = 0; i < this.cellList.size(); ++i) {
            if (((CellView)this.cellList.get(i)).getAttributes().get((Object)KEY_POSITION) != null) continue;
            System.err.println("WHATCH OUT!!! NODE " + i + " == NULL");
        }
    }

    private void getLayoutUpdateCells(CellView[] viewList) {
        int i;
        for (int i2 = 0; i2 < viewList.length; ++i2) {
            if (viewList[i2] instanceof VertexView) {
                if (!this.applyCellList.contains(viewList[i2])) {
                    this.applyCellList.add(viewList[i2]);
                }
                if (this.cellList.contains(viewList[i2])) continue;
                this.cellList.add(viewList[i2]);
                continue;
            }
            if (!(viewList[i2] instanceof EdgeView) || viewList[i2] == null || this.edgeList.contains(viewList[i2])) continue;
            this.edgeList.add(viewList[i2]);
            System.out.println("edge added");
        }
        if (KEY_LAYOUT_UPDATE_METHOD_PERIMETER.equals(this.luMethod)) {
            Point2D.Double pos;
            VertexView vertex;
            ArrayList<Ellipse2D.Double> perimeterList = new ArrayList<Ellipse2D.Double>();
            for (i = 0; i < this.applyCellList.size(); ++i) {
                vertex = (VertexView)this.applyCellList.get(i);
                pos = (Point2D.Double)vertex.getAttributes().get((Object)KEY_POSITION);
                int intersectionCount = 0;
                for (int j = 0; j < this.applyCellList.size(); ++j) {
                    VertexView uVertex;
                    Point2D.Double uPos;
                    if (i == j || !(pos.distance(uPos = (Point2D.Double)(uVertex = (VertexView)this.applyCellList.get(j)).getAttributes().get((Object)KEY_POSITION)) < this.luPerimeterRadius)) continue;
                    ++intersectionCount;
                }
                perimeterList.add(new Ellipse2D.Double(pos.x - (this.luPerimeterRadius + (double)intersectionCount * this.luPerimeterRadiusInc), pos.y - (this.luPerimeterRadius + (double)intersectionCount * this.luPerimeterRadiusInc), 2.0 * (this.luPerimeterRadius + (double)intersectionCount * this.luPerimeterRadiusInc), 2.0 * (this.luPerimeterRadius + (double)intersectionCount * this.luPerimeterRadiusInc)));
            }
            for (i = 0; i < this.cellList.size(); ++i) {
                vertex = (VertexView)this.cellList.get(i);
                pos = (Point2D.Double)vertex.getAttributes().get((Object)KEY_POSITION);
                for (int j = 0; j < perimeterList.size(); ++j) {
                    Ellipse2D.Double perimeter = (Ellipse2D.Double)perimeterList.get(j);
                    Point2D.Double center = new Point2D.Double(perimeter.getCenterX(), perimeter.getCenterY());
                    double radius = perimeter.getCenterX() - perimeter.getX();
                    if (!(center.distance(pos) < radius) || this.applyCellList.contains(vertex)) continue;
                    this.applyCellList.add(vertex);
                }
            }
        }
        if (this.luRecursionDepth > 0) {
            int vertexCount = 0;
            for (i = 0; i < viewList.length; ++i) {
                if (!(viewList[i] instanceof VertexView)) continue;
                ++vertexCount;
            }
            VertexView[] vertexList = new VertexView[vertexCount];
            vertexCount = 0;
            for (int i3 = 0; i3 < viewList.length; ++i3) {
                if (!(viewList[i3] instanceof VertexView)) continue;
                vertexList[vertexCount++] = (VertexView)viewList[i3];
            }
            this.addRelativesToList(vertexList, this.luRecursionDepth);
        }
    }

    private void addRelativesToList(VertexView[] vertexList, int depth) {
        if (vertexList == null) {
            return;
        }
        if (vertexList.length == 0) {
            return;
        }
        if (depth == 0) {
            return;
        }
        for (int i = 0; i < vertexList.length; ++i) {
            ArrayList relatives = this.getRelatives((CellView)vertexList[i]);
            VertexView[] relativeList = new VertexView[relatives.size()];
            for (int j = 0; j < relatives.size(); ++j) {
                if (!this.applyCellList.contains(relatives.get(j))) {
                    this.applyCellList.add(relatives.get(j));
                }
                if (!this.cellList.contains(relatives.get(j))) {
                    this.cellList.add(relatives.get(j));
                }
                relativeList[j] = (VertexView)relatives.get(j);
            }
            this.addRelativesToList(relativeList, depth - 1);
        }
    }

    public void graphChanged(GraphModelEvent e) {
        if (!this.isRunning) {
            this.isRunning = true;
            Object[] vertexIns = e.getChange().getInserted();
            Object[] vertexRem = e.getChange().getRemoved();
            if (vertexIns != null && vertexRem == null) {
                if (vertexIns.length == 0) {
                    this.isRunning = false;
                    return;
                }
                CellView[] viewList = this.jgraph.getGraphLayoutCache().getMapping(vertexIns, false);
                if (viewList.length == 0) {
                    this.isRunning = false;
                    return;
                }
                this.applyCellList.clear();
                this.loadConfiguration(1);
                boolean bugPresent = false;
                for (int i = 0; i < viewList.length; ++i) {
                    if (viewList[i] != null) continue;
                    bugPresent = true;
                    break;
                }
                if (bugPresent) {
                    this.getAllEdges();
                }
                this.arrangeLayoutUpdateInsertPlacement(viewList);
                this.getLayoutUpdateCells(viewList);
                if (this.applyCellList.size() == 0) {
                    this.isRunning = false;
                    return;
                }
                this.round = 0;
                if (this.isClusteringEnabled) {
                    this.clusterGraph();
                }
                this.init(false);
                this.run();
                if (this.isClusteringEnabled) {
                    this.declusterGraph();
                }
                this.applyChanges();
                this.removeTemporaryData();
            } else if (vertexIns == null && vertexRem != null) {
                this.isRunning = true;
                CellView[] viewList = this.jgraph.getGraphLayoutCache().getMapping(vertexRem, false);
                for (int i = 0; i < viewList.length; ++i) {
                    if (viewList[i] instanceof VertexView) {
                        if (this.applyCellList.contains(viewList[i])) {
                            this.applyCellList.remove(viewList[i]);
                        }
                        if (!this.cellList.contains(viewList[i])) continue;
                        this.cellList.remove(viewList[i]);
                        continue;
                    }
                    if (!(viewList[i] instanceof EdgeView)) continue;
                }
            }
            this.isRunning = false;
        }
    }

    private void showCell(CellView view, Color color) {
        Hashtable<Object, AttributeMap> viewMap = new Hashtable<Object, AttributeMap>();
        Point2D.Double pos = this.getPosition(view);
        Rectangle2D r = view.getBounds();
        r.setFrame(pos.getX() - r.getWidth() / 2.0, pos.getY() - r.getHeight() / 2.0, r.getWidth(), r.getHeight());
        Object cell = view.getCell();
        AttributeMap attributes = new AttributeMap();
        GraphConstants.setBackground((Map)attributes, (Color)color);
        GraphConstants.setBounds((Map)attributes, (Rectangle2D)r);
        viewMap.put(cell, attributes);
        this.jgraph.getGraphLayoutCache().edit(viewMap, null, null, null);
    }

    private void colorizeClusters(ArrayList clusterList) {
        Color[] colorList = new Color[]{Color.black, Color.magenta, Color.yellow, Color.blue, Color.green, Color.gray, Color.cyan, Color.red, Color.darkGray, Color.lightGray, Color.orange, Color.pink};
        for (int i = 0; i < clusterList.size() && i < colorList.length; ++i) {
            ArrayList clusteredVertices = (ArrayList)((VertexView)clusterList.get(i)).getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
            this.showCellList(clusteredVertices, colorList[i]);
        }
    }

    private void showCellList(ArrayList list, Color color) {
        Hashtable<Object, AttributeMap> viewMap = new Hashtable<Object, AttributeMap>();
        for (int i = 0; i < list.size(); ++i) {
            CellView view = (CellView)list.get(i);
            Point2D.Double pos = this.getPosition(view);
            Rectangle2D r = view.getBounds();
            r.setFrame(pos.getX() - r.getWidth() / 2.0, pos.getY() - r.getHeight() / 2.0, r.getWidth(), r.getHeight());
            Object cell = view.getCell();
            AttributeMap attributes = new AttributeMap();
            GraphConstants.setBackground((Map)attributes, (Color)color);
            GraphConstants.setBounds((Map)attributes, (Rectangle2D)r);
            viewMap.put(cell, attributes);
        }
        this.jgraph.getGraphLayoutCache().edit(viewMap, null, null, null);
    }

    private void getAllEdges() {
        Object[] cells = this.jgraph.getRoots();
        CellView[] views = this.jgraph.getGraphLayoutCache().getMapping(cells, false);
        for (int i = 0; i < views.length; ++i) {
            if (views[i] instanceof VertexView) {
                Object portCell;
                int j;
                VertexView vertexView = (VertexView)views[i];
                GraphModel model = vertexView.getModel();
                CellMapper mapper = vertexView.getMapper();
                Object vertexCell = vertexView.getCell();
                ArrayList<Object> portsCells = new ArrayList<Object>();
                for (j = 0; j < model.getChildCount(vertexCell); ++j) {
                    portCell = model.getChild(vertexCell, j);
                    portsCells.add(portCell);
                }
                for (j = 0; j < portsCells.size(); ++j) {
                    portCell = portsCells.get(j);
                    Iterator edges = model.edges(portCell);
                    while (edges.hasNext()) {
                        Object edge = edges.next();
                        CellView e = mapper.getMapping(edge, false);
                        if (this.edgeList.contains(e) || e == null) continue;
                        this.edgeList.add(e);
                    }
                }
                continue;
            }
            if (!(views[i] instanceof EdgeView) || this.edgeList.contains(views[i]) || views[i] == null) continue;
            this.edgeList.add(views[i]);
        }
    }

    private synchronized void stop(long ms) {
        try {
            ((Object)((Object)this)).wait(ms);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void clusterGraph() {
        VertexView cluster;
        int i;
        Point2D.Double clusterPos;
        int i2;
        int maxClusters = Math.max((int)((double)(this.cellList.size() - this.applyCellList.size()) / this.clusteringFactor), 2);
        if (this.cellList.size() <= 1) {
            System.out.println("cellList.size() <= 1");
            return;
        }
        ArrayList<VertexView> clusterList = new ArrayList<VertexView>();
        ArrayList cellsToCluster = new ArrayList();
        for (int i3 = 0; i3 < this.cellList.size(); ++i3) {
            if (this.applyCellList.contains(this.cellList.get(i3))) continue;
            cellsToCluster.add(this.cellList.get(i3));
        }
        VertexView[] clusters = new VertexView[maxClusters];
        CellMapper mapper = ((VertexView)this.cellList.get(0)).getMapper();
        Rectangle boundingBox = this.getBoundingBox();
        for (i2 = 0; i2 < clusters.length; ++i2) {
            clusters[i2] = new VertexView(null, this.jgraph, mapper);
            AttributeMap attributes = clusters[i2].getAttributes();
            attributes.put(KEY_IS_CLUSTER, "true");
            attributes.put(KEY_POSITION, new Point2D.Double(Math.random() * (double)boundingBox.width, Math.random() * (double)boundingBox.height));
            clusterList.add(clusters[i2]);
        }
        for (i2 = 0; i2 < cellsToCluster.size(); ++i2) {
            VertexView cell = (VertexView)cellsToCluster.get(i2);
            Point2D.Double cellPos = this.getPosition((CellView)cell);
            int clusterID = 0;
            clusterPos = this.getPosition((CellView)clusterList.get(0));
            double minDistance = MathExtensions.getEuclideanDistance(cellPos, clusterPos);
            for (int j = 1; j < clusterList.size(); ++j) {
                clusterPos = this.getPosition((CellView)((VertexView)clusterList.get(j)));
                double distance = MathExtensions.getEuclideanDistance(cellPos, clusterPos);
                if (!(minDistance > distance)) continue;
                minDistance = distance;
                clusterID = j;
            }
            VertexView cluster2 = (VertexView)clusterList.get(clusterID);
            this.moveVerticeToCluster(cell, cluster2);
        }
        boolean couldMakeItBetter = false;
        do {
            couldMakeItBetter = false;
            block5: for (i = 0; i < cellsToCluster.size(); ++i) {
                VertexView cell = (VertexView)cellsToCluster.get(i);
                VertexView oldCluster = (VertexView)cell.getAttributes().get((Object)KEY_CLUSTER);
                Point2D.Double cellPos = this.getPosition((CellView)cell);
                Point2D.Double clusterPos2 = this.getPosition((CellView)oldCluster);
                double distance = MathExtensions.getEuclideanDistance(cellPos, clusterPos2);
                for (int j = 0; j < clusterList.size(); ++j) {
                    double newDistance;
                    VertexView cluster3 = (VertexView)clusterList.get(j);
                    if (cluster3 == oldCluster || !((newDistance = MathExtensions.getEuclideanDistance(cellPos, clusterPos2 = this.getPosition((CellView)cluster3))) < distance)) continue;
                    this.moveVerticeToCluster(cell, cluster3);
                    couldMakeItBetter = true;
                    continue block5;
                }
            }
        } while (couldMakeItBetter);
        for (i = 0; i < clusterList.size(); ++i) {
            if (!((VertexView)clusterList.get(i)).getAttributes().containsKey((Object)KEY_CLUSTERED_VERTICES)) {
                clusterList.remove(i--);
                continue;
            }
            if (((ArrayList)((VertexView)clusterList.get(i)).getAttributes().get((Object)KEY_CLUSTERED_VERTICES)).size() != 0) continue;
            clusterList.remove(i--);
        }
        for (i = 0; i < cellsToCluster.size(); ++i) {
            this.cellList.remove(cellsToCluster.get(i));
        }
        for (i = 0; i < clusterList.size(); ++i) {
            this.applyCellList.add(clusterList.get(i));
            this.cellList.add(clusterList.get(i));
        }
        for (i = 0; i < clusterList.size(); ++i) {
            cluster = (VertexView)clusterList.get(i);
            AttributeMap attribs = cluster.getAttributes();
            clusterPos = (Point2D.Double)attribs.get(KEY_POSITION);
            attribs.put(KEY_CLUSTER_INIT_POSITION, new Point2D.Double(clusterPos.x, clusterPos.y));
        }
        for (i = 0; i < clusterList.size(); ++i) {
            cluster = (VertexView)clusterList.get(i);
            cluster.setCachedBounds((Rectangle2D)this.getBoundingBox((ArrayList)cluster.getAttributes().get((Object)KEY_CLUSTERED_VERTICES)));
        }
    }

    protected void moveVerticeToCluster(VertexView vertice, VertexView cluster) {
        if (!cluster.getAttributes().containsKey((Object)KEY_CLUSTERED_VERTICES)) {
            cluster.getAttributes().put((Object)KEY_CLUSTERED_VERTICES, new ArrayList());
        }
        ArrayList clusteredVertices = (ArrayList)cluster.getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
        clusteredVertices.add(vertice);
        if (vertice.getAttributes().containsKey((Object)KEY_CLUSTER)) {
            VertexView oldCluster = (VertexView)vertice.getAttributes().get((Object)KEY_CLUSTER);
            ArrayList list = (ArrayList)oldCluster.getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
            list.remove(vertice);
            this.computeClusterPosition(oldCluster);
        }
        vertice.getAttributes().put((Object)KEY_CLUSTER, (Object)cluster);
        this.computeClusterPosition(cluster);
    }

    protected void computeClusterPosition(VertexView cluster) {
        ArrayList clusteredVertices = (ArrayList)cluster.getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
        Point2D.Double clusterPos = this.computeBarycenter(clusteredVertices);
        cluster.getAttributes().put((Object)KEY_POSITION, (Object)clusterPos);
    }

    protected void declusterGraph() {
        int i;
        if (this.cellList.size() <= 1) {
            return;
        }
        ArrayList<VertexView> clusterList = new ArrayList<VertexView>();
        for (i = 0; i < this.cellList.size(); ++i) {
            VertexView cell = (VertexView)this.cellList.get(i);
            if (!this.isCluster((CellView)cell)) continue;
            clusterList.add(cell);
        }
        if (clusterList.size() == 0) {
            return;
        }
        for (i = 0; i < clusterList.size(); ++i) {
            this.cellList.remove(clusterList.get(i));
            this.applyCellList.remove(clusterList.get(i));
        }
        for (i = 0; i < clusterList.size(); ++i) {
            VertexView cluster = (VertexView)clusterList.get(i);
            AttributeMap attribs = cluster.getAttributes();
            Point2D.Double newClusterPos = this.getPosition((CellView)cluster);
            Point2D.Double oldClusterPos = (Point2D.Double)attribs.get(KEY_CLUSTER_INIT_POSITION);
            Point2D.Double move = new Point2D.Double(newClusterPos.x - oldClusterPos.x, newClusterPos.y - oldClusterPos.y);
            ArrayList vertexList = (ArrayList)attribs.get(KEY_CLUSTERED_VERTICES);
            for (int j = 0; j < vertexList.size(); ++j) {
                VertexView cell = (VertexView)vertexList.get(j);
                Point2D.Double cellPos = this.getPosition((CellView)cell);
                Point2D.Double newCellPos = new Point2D.Double(cellPos.x + move.x, cellPos.y + move.y);
                cell.getAttributes().put((Object)KEY_POSITION, (Object)newCellPos);
                this.cellList.add(cell);
            }
        }
    }

    protected boolean isCluster(CellView cell) {
        if (cell.getAttributes().containsKey((Object)KEY_IS_CLUSTER)) {
            if (this.isTrue((String)cell.getAttributes().get((Object)KEY_IS_CLUSTER))) {
                return true;
            }
            System.err.println("FATAL ERROR: CELL CANNOT CLEARLY BE IDENTIFIED AS A CLUSTER!!!");
            return false;
        }
        return false;
    }

    private Point2D.Double computeBarycenter(ArrayList list) {
        double sumX = 0.0;
        double sumY = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            CellView view = (CellView)list.get(i);
            Point2D.Double pos = this.getPosition(view);
            sumX += pos.x;
            sumY += pos.y;
        }
        return new Point2D.Double(sumX / (double)list.size(), sumY / (double)list.size());
    }

    private Rectangle getBoundingBox(ArrayList verticeList) {
        if (verticeList.size() > 0) {
            Point2D.Double vertexPos = this.getPosition((CellView)((VertexView)verticeList.get(0)));
            Rectangle2D vertexSize = ((CellView)verticeList.get(0)).getBounds();
            double minX = vertexPos.getX();
            double minY = vertexPos.getX();
            double maxX = vertexPos.getX() + vertexSize.getWidth();
            double maxY = vertexPos.getX() + vertexSize.getHeight();
            for (int i = 1; i < verticeList.size(); ++i) {
                vertexPos = this.getPosition((CellView)((VertexView)verticeList.get(i)));
                vertexSize = ((CellView)verticeList.get(i)).getBounds();
                if (minX > vertexPos.getX()) {
                    minX = vertexPos.getX();
                }
                if (minY > vertexPos.getY()) {
                    minY = vertexPos.getY();
                }
                if (maxX < vertexPos.getX() + vertexSize.getWidth()) {
                    maxX = vertexPos.getX() + vertexSize.getWidth();
                }
                if (!(maxY < vertexPos.getY() + vertexSize.getHeight())) continue;
                maxY = vertexPos.getY() + vertexSize.getHeight();
            }
            Rectangle boundingBox = new Rectangle((int)minX, (int)minY, (int)(maxX - minX), (int)(maxY - minY));
            return boundingBox;
        }
        return null;
    }

    private Rectangle getBoundingBox() {
        return this.getBoundingBox(this.cellList);
    }

    public static abstract class MathExtensions {
        public static double sgn(double x) {
            if (x < 0.0) {
                return -1.0;
            }
            if (x > 0.0) {
                return 1.0;
            }
            return 0.0;
        }

        public static double abs(Point2D.Double v) {
            return Math.sqrt(MathExtensions.getTransposed(v, v));
        }

        public static double abs(double x, double y) {
            return Math.sqrt(x * x + y * y);
        }

        public static double angleBetween(Point2D.Double v1, Point2D.Double v2) {
            double ly;
            double lx;
            double xty = MathExtensions.getTransposed(v1, v2);
            double result = xty / ((lx = Math.sqrt(MathExtensions.getTransposed(v1, v1))) * (ly = Math.sqrt(MathExtensions.getTransposed(v2, v2))));
            if (result > 1.0) {
                result = 1.0;
            }
            if (result < -1.0) {
                result = -1.0;
            }
            return Math.acos(result);
        }

        public static double getTransposed(Point2D.Double v1, Point2D.Double v2) {
            return v1.getX() * v2.getX() + v1.getY() * v2.getY();
        }

        public static double getEuclideanDistance(Point2D.Double p1, Point2D.Double p2) {
            return Math.sqrt((p1.x - p2.x) * (p1.x - p2.x) + (p1.y - p2.y) * (p1.y - p2.y));
        }

        public static Point2D.Double getNormalizedVector(Point2D.Double v) {
            double length = MathExtensions.abs(v);
            return new Point2D.Double(v.x / length, v.y / length);
        }
    }
}

