/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.sequence;

import csplugins.isb.dreiss.cytoTalk.CytoTalkHandler;
import csplugins.isb.dreiss.httpdata.client.DataClientFactory;
import csplugins.isb.dreiss.httpdata.client.SetHttpDataHost;
import csplugins.isb.dreiss.httpdata.client.SetUsernamePassword;
import csplugins.isb.dreiss.httpdata.client.SynonymClient;
import csplugins.isb.dreiss.httpdata.xmlrpc.DataClient;
import csplugins.isb.dreiss.util.MonitoredAction;
import cytoscape.CytoscapeWindow;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SynonymPlugin {
    CytoscapeWindow cWindow;
    SynonymClient synonymFetcher;
    CytoTalkHandler handler;

    public SynonymPlugin() throws Exception {
    }

    public SynonymPlugin(CytoscapeWindow cWindow) throws Exception {
        this(cWindow, cWindow.getOperationsMenu());
    }

    public SynonymPlugin(CytoscapeWindow cWindow, JMenu menu) throws Exception {
        this.cWindow = cWindow;
        this.handler = new CytoTalkHandler(cWindow, null);
        JMenu menu2 = new JMenu("Synonyms...");
        menu.add(menu2);
        menu2.add(new GetSynonyms());
        menu2.add(new SelectNodesWithoutSyns());
        menu2.add(new JMenuItem(new SetUsernamePassword(cWindow.getMainFrame())));
        menu2.add(new JMenuItem(new SetHttpDataHost(cWindow.getMainFrame())));
        menu2.add(new AboutSynonymPlugin());
    }

    protected void loadFetchers() {
        this.synonymFetcher = (SynonymClient)this.loadDataFetcher("synonym");
    }

    protected DataClient loadDataFetcher(String type) {
        DataClient out = null;
        try {
            out = DataClientFactory.getClient(type);
        }
        catch (Exception eee) {
            String msg = "<html> Failed to contact " + type + " fetcher<p>";
            msg = msg + "<p> exception message: " + eee.getMessage() + "</html>";
            JOptionPane.showMessageDialog(this.cWindow.getMainFrame(), msg);
            eee.printStackTrace();
        }
        return out;
    }

    protected static Vector getSynonymsStartingWith(String canonicalName, String prefix, CytoTalkHandler handler) {
        Vector<String> out = new Vector<String>();
        if (canonicalName.startsWith(prefix)) {
            out.add(canonicalName);
            return out;
        }
        Vector syns = handler.getNodeAttribute(canonicalName, "synonym");
        for (int i = 0; i < syns.size(); ++i) {
            String syn;
            if (!(syns.get(i) instanceof String) || !(syn = ((String)syns.get(i)).trim()).startsWith(prefix)) continue;
            out.add(syn);
        }
        return out;
    }

    public static Vector getRefSeqsFromSynonyms(String canonicalName, CytoTalkHandler handler) {
        int i;
        Vector out3;
        Vector out2;
        Vector out = SynonymPlugin.getSynonymsStartingWith(canonicalName, "ref=NP_", handler);
        if (!(out != null && out.size() > 0 || (out = SynonymPlugin.getSynonymsStartingWith(canonicalName, "ref=XP_", handler)) != null && out.size() > 0)) {
            out = SynonymPlugin.getSynonymsStartingWith(canonicalName, "ref=NM_", handler);
        }
        if ((out2 = SynonymPlugin.getSynonymsStartingWith(canonicalName, "NP_", handler)) == null || out2.size() <= 0) {
            out2 = SynonymPlugin.getSynonymsStartingWith(canonicalName, "XP_", handler);
        }
        if (out2 == null || out2.size() <= 0) {
            out2 = SynonymPlugin.getSynonymsStartingWith(canonicalName, "NM_", handler);
        }
        if ((out2 == null || out2.size() <= 0) && (canonicalName.startsWith("NP_") || canonicalName.startsWith("XP_"))) {
            out2.add(canonicalName);
        }
        if ((out3 = SynonymPlugin.getSynonymsStartingWith(canonicalName, "version=NP_", handler)) == null || out3.size() <= 0) {
            out3 = SynonymPlugin.getSynonymsStartingWith(canonicalName, "version=XP_", handler);
        }
        if (out3 == null || out3.size() <= 0) {
            out3 = SynonymPlugin.getSynonymsStartingWith(canonicalName, "version=NM_", handler);
        }
        int sz = out2.size();
        for (i = 0; i < sz; ++i) {
            if (out.contains(out2.get(i))) continue;
            out.add(out2.get(i));
        }
        sz = out3.size();
        for (i = 0; i < sz; ++i) {
            if (out.contains(out3.get(i))) continue;
            out.add(out3.get(i));
        }
        sz = out.size();
        for (i = 0; i < sz; ++i) {
            String s = (String)out.get(i);
            if (s.startsWith("ref=")) {
                s = s.substring(4);
            } else if (s.startsWith("version=")) {
                s = s.substring(8);
            }
            if (s.indexOf(46) > 0) {
                s = s.substring(0, s.indexOf(46));
            }
            out.set(i, s);
        }
        return out;
    }

    public class GetSynonyms
    extends MonitoredAction {
        GetSynonyms() {
            super((JPanel)SynonymPlugin.this.cWindow, "Get all known synonyms for selected nodes", "Fetching synonyms for selected nodes...");
        }

        public void actionPerformed(ActionEvent e) {
            SynonymPlugin.this.loadFetchers();
            new Thread(this){
                private final /* synthetic */ GetSynonyms this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    Vector nodes = GetSynonyms.access$000((GetSynonyms)this.this$1).handler.getSelectedNodes();
                    Vector nodeNames = GetSynonyms.access$000((GetSynonyms)this.this$1).handler.getSelectedNodeNames();
                    for (int i = 0; i < nodes.size(); ++i) {
                        String nodeName = (String)nodeNames.get(i);
                        String canonicalName = (String)nodes.get(i);
                        if (nodeName.startsWith("node index")) {
                            nodeName = canonicalName;
                        }
                        this.this$1.setProgress(i, nodes.size(), nodeName + " (" + canonicalName + ")");
                        if (GetSynonyms.access$100(this.this$1)) break;
                        if (GetSynonyms.access$000((GetSynonyms)this.this$1).handler.hasNodeAttribute(canonicalName, "synonym")) continue;
                        String species = GetSynonyms.access$000((GetSynonyms)this.this$1).handler.getNodeSpecies(canonicalName);
                        Vector response = null;
                        try {
                            response = GetSynonyms.access$000((GetSynonyms)this.this$1).synonymFetcher.getSynonyms(canonicalName, species);
                        }
                        catch (Exception ee) {
                            String msg = "Exception while fetching synonyms in synonym fetcher for node " + canonicalName + ": " + ee.getMessage();
                            System.err.println(msg);
                            ee.printStackTrace();
                            response = null;
                        }
                        Vector v = GetSynonyms.access$000((GetSynonyms)this.this$1).handler.getNodeAttribute(canonicalName, "commonName");
                        String commonName = v.size() > 0 ? (String)v.get(0) : null;
                        Vector syns = response;
                        if (syns == null || syns.size() <= 0) continue;
                        int sz = syns.size();
                        for (int j = 0; j < sz; ++j) {
                            String name = (String)syns.get(j);
                            if (name.equalsIgnoreCase(canonicalName) || name.equalsIgnoreCase(nodeName) || name.equalsIgnoreCase("Unknown") || name.equalsIgnoreCase("None") || name.equalsIgnoreCase("Null")) continue;
                            GetSynonyms.access$000((GetSynonyms)this.this$1).handler.addNodeAttribute(canonicalName, "synonym", name);
                            if (commonName != null && !"".equals(commonName) && !commonName.equalsIgnoreCase(canonicalName) && !commonName.equalsIgnoreCase(nodeName) && !commonName.startsWith("NP_") && !commonName.startsWith("XP_") && !commonName.startsWith("LOC") && !commonName.startsWith("GI")) continue;
                            if (name.startsWith("gene=")) {
                                if (name.indexOf(";") > 0) {
                                    name = name.substring(0, name.indexOf(";"));
                                }
                                commonName = name.substring(5);
                                GetSynonyms.access$000((GetSynonyms)this.this$1).handler.setNodeAttribute(canonicalName, "commonName", commonName);
                                continue;
                            }
                            if (!name.startsWith("short=")) continue;
                            if (name.indexOf(";") > 0) {
                                name = name.substring(0, name.indexOf(";"));
                            }
                            commonName = name.substring(6);
                            GetSynonyms.access$000((GetSynonyms)this.this$1).handler.setNodeAttribute(canonicalName, "commonName", commonName);
                        }
                    }
                    GetSynonyms.access$000((GetSynonyms)this.this$1).handler.redrawGraph();
                    this.this$1.setProgress(nodes.size() + 1, nodes.size(), "Done");
                }
            }.start();
        }

        static /* synthetic */ SynonymPlugin access$000(GetSynonyms x0) {
            return x0.SynonymPlugin.this;
        }

        static /* synthetic */ boolean access$100(GetSynonyms x0) {
            return x0.done;
        }
    }

    public class SelectNodesWithoutSyns
    extends AbstractAction {
        SelectNodesWithoutSyns() {
            super("Highlight nodes without any known synonyms");
        }

        public void actionPerformed(ActionEvent e) {
            SynonymPlugin.this.loadFetchers();
            SynonymPlugin.this.handler.selectNodesWithoutAttribute("synonym");
        }
    }

    protected class AboutSynonymPlugin
    extends AbstractAction {
        AboutSynonymPlugin() {
            super("About Synonyms Plugin...");
        }

        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog((Component)SynonymPlugin.this.cWindow, new Object[]{"Synonym plugin by David Reiss", "Fetch protein/gene synonyms from a remote database.", "Questions or comments: dreiss@systemsbiology.org"}, "About Synonym plugin", 1);
        }
    }
}

