/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.sequence;

import csplugins.isb.dreiss.cytoTalk.CytoTalkHandler;
import csplugins.isb.dreiss.httpdata.NCBIUtils;
import csplugins.isb.dreiss.httpdata.client.SequenceClient;
import csplugins.isb.dreiss.httpdata.client.SetHttpDataHost;
import csplugins.isb.dreiss.httpdata.client.SetUsernamePassword;
import csplugins.isb.dreiss.sequence.SynonymPlugin;
import csplugins.isb.dreiss.util.MonitoredAction;
import cytoscape.CytoscapeWindow;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SequencePlugin
extends SynonymPlugin {
    SequenceClient sequenceFetcher;

    public SequencePlugin(CytoscapeWindow cWindow) throws Exception {
        this(cWindow, cWindow.getOperationsMenu());
    }

    public SequencePlugin(CytoscapeWindow cWindow, JMenu menu) throws Exception {
        this.cWindow = cWindow;
        this.handler = new CytoTalkHandler(cWindow, null);
        JMenu menu2 = new JMenu("Sequences...");
        menu.add(menu2);
        menu2.add(new GetSequences("gene"));
        menu2.add(new GetSequences("protein"));
        menu2.add(new GetSequences("upstream"));
        menu2.add(new SelectNodesWithoutSequence());
        menu2.add(new JMenuItem(new SetUsernamePassword(cWindow.getMainFrame())));
        menu2.add(new JMenuItem(new SetHttpDataHost(cWindow.getMainFrame())));
        menu2.add(new AboutSequencePlugin());
    }

    protected void loadFetchers() {
        if (this.sequenceFetcher == null) {
            this.sequenceFetcher = (SequenceClient)this.loadDataFetcher("sequence");
        }
    }

    private String getSequenceFromNCBI(String proteinCanonicalName, String species) throws Exception {
        return NCBIUtils.getSequence(proteinCanonicalName, species);
    }

    static /* synthetic */ String access$400(SequencePlugin x0, String x1, String x2) throws Exception {
        return x0.getSequenceFromNCBI(x1, x2);
    }

    public class FetchNewSequences
    extends MonitoredAction {
        FetchNewSequences() {
            super((JPanel)SequencePlugin.this.cWindow, "Try to find new sequences for selected nodes", "Fetching new sequences from NCBI...");
        }

        public void actionPerformed(ActionEvent e) {
            SequencePlugin.this.loadFetchers();
            new Thread(this){
                private final /* synthetic */ FetchNewSequences this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    Vector nodes = FetchNewSequences.access$200((FetchNewSequences)this.this$1).handler.getSelectedNodes();
                    Vector nodeNames = FetchNewSequences.access$200((FetchNewSequences)this.this$1).handler.getSelectedNodeNames();
                    for (int i = 0; i < nodes.size(); ++i) {
                        String msg;
                        String nodeName = (String)nodeNames.get(i);
                        String canonicalName = (String)nodes.get(i);
                        if (nodeName.startsWith("node index")) {
                            nodeName = canonicalName;
                        }
                        this.this$1.setProgress(i, nodes.size(), nodeName + " (" + canonicalName + ")");
                        if (FetchNewSequences.access$300(this.this$1)) break;
                        if (FetchNewSequences.access$200((FetchNewSequences)this.this$1).handler.hasNodeAttribute(canonicalName, "sequence")) continue;
                        String species = FetchNewSequences.access$200((FetchNewSequences)this.this$1).handler.getNodeSpecies(canonicalName);
                        String sequence = null;
                        try {
                            sequence = SequencePlugin.access$400(FetchNewSequences.access$200(this.this$1), canonicalName, species);
                        }
                        catch (Exception e1) {
                            msg = "NCBI exception fetching sequence for " + canonicalName + ": " + e1.getMessage();
                            System.err.println(msg);
                            continue;
                        }
                        try {
                            if (sequence != null && !"".equals(sequence)) {
                                FetchNewSequences.access$200((FetchNewSequences)this.this$1).sequenceFetcher.put(canonicalName, species, sequence);
                                continue;
                            }
                            if (sequence != null && !"UNKNOWN".equals(sequence)) continue;
                            FetchNewSequences.access$200((FetchNewSequences)this.this$1).sequenceFetcher.put(canonicalName, species, "UNKNOWN");
                            continue;
                        }
                        catch (Exception e2) {
                            msg = "<html>Exception while saving sequence for " + canonicalName + " <p>";
                            msg = msg + "to sequence fetcher: <p>";
                            msg = msg + e2.getMessage() + "</html>";
                            JOptionPane.showMessageDialog(FetchNewSequences.access$200((FetchNewSequences)this.this$1).cWindow.getMainFrame(), msg);
                        }
                    }
                    this.this$1.setProgress(nodes.size() + 1, nodes.size(), "Done");
                }
            }.start();
        }

        static /* synthetic */ SequencePlugin access$200(FetchNewSequences x0) {
            return x0.SequencePlugin.this;
        }

        static /* synthetic */ boolean access$300(FetchNewSequences x0) {
            return x0.done;
        }
    }

    public class SelectNodesWithoutSequence
    extends AbstractAction {
        SelectNodesWithoutSequence() {
            super("Highlight nodes without any cached sequence");
        }

        public void actionPerformed(ActionEvent e) {
            SequencePlugin.this.loadFetchers();
            SequencePlugin.this.handler.selectNodesWithoutAttribute("sequence");
        }
    }

    public class GetSequences
    extends MonitoredAction {
        String type;

        GetSequences(String type) {
            super((JPanel)SequencePlugin.this.cWindow, "Get known " + type + " sequences for selected nodes", "Fetching sequences for selected nodes...");
            this.type = type;
        }

        public void actionPerformed(ActionEvent e) {
            SequencePlugin.this.loadFetchers();
            new Thread(this){
                private final /* synthetic */ GetSequences this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    Vector nodes = GetSequences.access$000((GetSequences)this.this$1).handler.getSelectedNodes();
                    Vector nodeNames = GetSequences.access$000((GetSequences)this.this$1).handler.getSelectedNodeNames();
                    for (int i = 0; i < nodes.size(); ++i) {
                        String seq;
                        String nodeName = (String)nodeNames.get(i);
                        String canonicalName = (String)nodes.get(i);
                        if (nodeName.startsWith("node index")) {
                            nodeName = canonicalName;
                        }
                        this.this$1.setProgress(i, nodes.size(), nodeName + " (" + canonicalName + ")");
                        if (GetSequences.access$100(this.this$1)) break;
                        String species = GetSequences.access$000((GetSequences)this.this$1).handler.getNodeSpecies(canonicalName);
                        GetSequences.access$000((GetSequences)this.this$1).handler.deleteNodeAttribute(canonicalName, "sequence");
                        Vector v = GetSequences.access$000((GetSequences)this.this$1).handler.getNodeAttribute(canonicalName, this.this$1.type + "_sequence");
                        String string = seq = v.size() > 0 ? (String)v.get(0) : null;
                        if (seq == null || seq.length() <= 0) {
                            try {
                                Vector refseqs = SynonymPlugin.getRefSeqsFromSynonyms(canonicalName, GetSequences.access$000((GetSequences)this.this$1).handler);
                                seq = GetSequences.access$000((GetSequences)this.this$1).sequenceFetcher.get((String)refseqs.get(0), species, this.this$1.type);
                            }
                            catch (Exception ee) {
                                String msg = "Exception while fetching " + this.this$1.type + " sequences in sequence fetcher " + "for node " + canonicalName + ": " + ee.getMessage();
                                System.err.println(msg);
                                ee.printStackTrace();
                                continue;
                            }
                        }
                        if (seq == null || seq.length() <= 0) continue;
                        if (seq.equals("UNKNOWN")) {
                            seq = "";
                        }
                        GetSequences.access$000((GetSequences)this.this$1).handler.setNodeAttribute(canonicalName, this.this$1.type + "_sequence", seq);
                        GetSequences.access$000((GetSequences)this.this$1).handler.setNodeAttribute(canonicalName, "sequence", seq);
                    }
                    this.this$1.setProgress(nodes.size() + 1, nodes.size(), "Done");
                }
            }.start();
        }

        static /* synthetic */ SequencePlugin access$000(GetSequences x0) {
            return x0.SequencePlugin.this;
        }

        static /* synthetic */ boolean access$100(GetSequences x0) {
            return x0.done;
        }
    }

    protected class AboutSequencePlugin
    extends AbstractAction {
        AboutSequencePlugin() {
            super("About Sequences Plugin...");
        }

        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog((Component)SequencePlugin.this.cWindow, new Object[]{"Sequences plugin by David Reiss", "Fetch genome/protein sequences from a remote database.", "Questions or comments: dreiss@systemsbiology.org"}, "About Sequences plugin", 1);
        }
    }
}

