/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.sequence;

import csplugins.isb.dreiss.cytoTalk.CytoTalkHandler;
import csplugins.isb.dreiss.httpdata.client.HomologClient;
import csplugins.isb.dreiss.httpdata.client.SetHttpDataHost;
import csplugins.isb.dreiss.httpdata.client.SetUsernamePassword;
import csplugins.isb.dreiss.sequence.SynonymPlugin;
import csplugins.isb.dreiss.util.MonitoredAction;
import cytoscape.CytoscapeWindow;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class HomologPlugin
extends SynonymPlugin {
    HomologClient homologFetcher;

    public HomologPlugin(CytoscapeWindow cWindow) throws Exception {
        this(cWindow, cWindow.getOperationsMenu());
    }

    public HomologPlugin(CytoscapeWindow cWindow, JMenu menu) throws Exception {
        this.cWindow = cWindow;
        this.handler = new CytoTalkHandler(cWindow, null);
        JMenu menu2 = new JMenu("Homologs...");
        menu.add(menu2);
        menu2.add(new GetHomologs());
        menu2.add(new SelectNodesWithoutHoms());
        menu2.add(new JMenuItem(new SetUsernamePassword(cWindow.getMainFrame())));
        menu2.add(new JMenuItem(new SetHttpDataHost(cWindow.getMainFrame())));
        menu2.add(new AboutHomologPlugin());
    }

    protected void loadFetchers() {
        if (this.homologFetcher == null) {
            this.homologFetcher = (HomologClient)this.loadDataFetcher("homolog");
        }
    }

    protected String getInfoArg(String param, String infoString) {
        String[] toks = infoString.split("\\|");
        for (int j = 0; j < toks.length; ++j) {
            if (!toks[j].startsWith(param + "=")) continue;
            return toks[j].substring((param + "=").length());
        }
        return "";
    }

    public class GetHomologs
    extends MonitoredAction {
        GetHomologs() {
            super((JPanel)HomologPlugin.this.cWindow, "Get all known homologs for selected nodes", "Fetching homologs for selected nodes...");
        }

        public void actionPerformed(ActionEvent e) {
            HomologPlugin.this.loadFetchers();
            new Thread(this){
                private final /* synthetic */ GetHomologs this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    Vector nodes = GetHomologs.access$000((GetHomologs)this.this$1).handler.getSelectedNodes();
                    Vector nodeNames = GetHomologs.access$000((GetHomologs)this.this$1).handler.getSelectedNodeNames();
                    for (int i = 0; i < nodes.size(); ++i) {
                        String nodeName = (String)nodeNames.get(i);
                        String canonicalName = (String)nodes.get(i);
                        if (nodeName.startsWith("node index")) {
                            nodeName = canonicalName;
                        }
                        this.this$1.setProgress(i, nodes.size(), nodeName + " (" + canonicalName + ")");
                        if (GetHomologs.access$100(this.this$1)) break;
                        if (GetHomologs.access$000((GetHomologs)this.this$1).handler.hasNodeAttribute(canonicalName, "homolog")) continue;
                        String species = GetHomologs.access$000((GetHomologs)this.this$1).handler.getNodeSpecies(canonicalName);
                        Vector response = null;
                        Vector rseqs = SynonymPlugin.getRefSeqsFromSynonyms(canonicalName, GetHomologs.access$000((GetHomologs)this.this$1).handler);
                        int qsz = rseqs.size();
                        for (int qq = 0; qq < qsz; ++qq) {
                            try {
                                response = GetHomologs.access$000((GetHomologs)this.this$1).homologFetcher.getAllHomologsAndInfo((String)rseqs.get(qq), species);
                            }
                            catch (Exception ee) {
                                String msg = "Exception while fetching homologs in homolog fetcher for node " + canonicalName + ": " + ee.getMessage();
                                System.err.println(msg);
                                ee.printStackTrace();
                                response = null;
                            }
                            Vector homs = response;
                            if (homs == null || homs.size() <= 0) continue;
                            int sz = homs.size();
                            for (int j = 0; j < sz; ++j) {
                                Vector alreadyHas = GetHomologs.access$000((GetHomologs)this.this$1).handler.getNodeAttribute(canonicalName, "homolog");
                                Map map = (Map)homs.get(j);
                                String homolog = (String)map.get("homolog");
                                if (alreadyHas != null && alreadyHas.contains(homolog)) continue;
                                String info = (String)map.get("info");
                                String cname2 = GetHomologs.access$000(this.this$1).getInfoArg("commonName2", info);
                                GetHomologs.access$000((GetHomologs)this.this$1).handler.addNodeAttribute(canonicalName, "homolog", homolog);
                                GetHomologs.access$000((GetHomologs)this.this$1).handler.addNodeAttribute(canonicalName, "homolog species", (String)map.get("species"));
                                GetHomologs.access$000((GetHomologs)this.this$1).handler.addNodeAttribute(canonicalName, "homolog score", map.get("score") + "%");
                                if (cname2 == null || "".equals(cname2) || "--".equals(cname2)) continue;
                                GetHomologs.access$000((GetHomologs)this.this$1).handler.addNodeAttribute(canonicalName, "homolog common name", cname2);
                            }
                        }
                    }
                    this.this$1.setProgress(nodes.size() + 1, nodes.size(), "Done");
                }
            }.start();
        }

        static /* synthetic */ HomologPlugin access$000(GetHomologs x0) {
            return x0.HomologPlugin.this;
        }

        static /* synthetic */ boolean access$100(GetHomologs x0) {
            return x0.done;
        }
    }

    public class SelectNodesWithoutHoms
    extends AbstractAction {
        SelectNodesWithoutHoms() {
            super("Highlight nodes without any known homologs");
        }

        public void actionPerformed(ActionEvent e) {
            HomologPlugin.this.loadFetchers();
            HomologPlugin.this.handler.selectNodesWithoutAttribute("homolog");
        }
    }

    protected class AboutHomologPlugin
    extends AbstractAction {
        AboutHomologPlugin() {
            super("About Homologs Plugin...");
        }

        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog((Component)HomologPlugin.this.cWindow, new Object[]{"Homolog plugin by David Reiss", "Fetch protein/gene homologs from a remote database.", "Questions or comments: dreiss@systemsbiology.org"}, "About Homolog plugin", 1);
        }
    }
}

