/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.httpdata.xmlrpc;

import csplugins.isb.dreiss.httpdata.xmlrpc.MyXmlRpcServer;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.xmlrpc.XmlRpcClient;

public class XmlRpcUtils {
    public static Hashtable GetObjectAsStruct(Object obj) {
        Hashtable<String, Object> out = new Hashtable<String, Object>();
        try {
            Class<?> c = obj.getClass();
            Field[] fields = c.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                out.put(fields[i].getName(), XmlRpcUtils.translateField(fields[i].getName(), fields[i].get(obj)));
            }
            out.put("className", c.getName());
        }
        catch (Exception e) {
            out.clear();
            try {
                out.put("encoded", XmlRpcUtils.GetObjectAsBytes(obj));
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        return out;
    }

    public static Object GetObjectFromStruct(Hashtable tab) {
        Object out = null;
        try {
            String className = (String)tab.get("className");
            Class<?> c = Class.forName(className);
            Constructor<?> constr = c.getDeclaredConstructor(null);
            if (constr == null) {
                throw new Exception("Could not create new object of class " + className);
            }
            out = constr.newInstance(null);
            Field[] fields = c.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                fields[i].set(out, XmlRpcUtils.untranslateField(fields[i].getName(), tab.get(fields[i].getName()), fields[i].getType()));
            }
        }
        catch (Exception e) {
            out = null;
            try {
                out = XmlRpcUtils.GetObjectFromBytes((byte[])tab.get("encoded"));
            }
            catch (Exception ee) {
                System.err.println(ee.toString());
            }
        }
        return out;
    }

    protected static Object translateField(String fname, Object inobj) throws Exception {
        if (inobj instanceof String || inobj instanceof Boolean || inobj instanceof Integer || inobj instanceof Double || inobj instanceof Hashtable || inobj instanceof Vector || inobj instanceof Date) {
            return inobj;
        }
        if (inobj instanceof Float) {
            return new Double(((Float)inobj).floatValue());
        }
        if (inobj instanceof Long) {
            return new Integer((int)((Long)inobj).longValue());
        }
        if (inobj instanceof Short) {
            return new Integer(((Short)inobj).shortValue());
        }
        throw new Exception("Object type " + inobj.getClass() + " for field " + fname + " not supported by XML-RPC.");
    }

    protected static Object untranslateField(String fname, Object inobj, Class toType) throws Exception {
        if (toType.equals(String.class) || toType.equals(Boolean.TYPE) || toType.equals(Integer.TYPE) || toType.equals(Double.TYPE) || toType.equals(Hashtable.class) || toType.equals(Vector.class) || toType.equals(Date.class)) {
            return inobj;
        }
        if (toType.equals(Float.TYPE)) {
            return new Float((float)((Double)inobj).doubleValue());
        }
        if (toType.equals(Long.TYPE)) {
            return new Long(((Integer)inobj).intValue());
        }
        if (toType.equals(Short.TYPE)) {
            return new Short((short)((Integer)inobj).intValue());
        }
        throw new Exception("Object type " + toType + " for field " + fname + " not supported by XML-RPC.");
    }

    public static byte[] GetObjectAsBytes(Object obj) {
        return XmlRpcUtils.GetObjectAsBytes(obj, false);
    }

    public static byte[] GetObjectAsBytes(Object obj, boolean gzip) {
        if (!(obj instanceof Serializable)) {
            return new byte[0];
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            GZIPOutputStream gos = gzip ? new GZIPOutputStream(bos) : null;
            ObjectOutputStream out = gzip ? new ObjectOutputStream(gos) : new ObjectOutputStream(bos);
            out.writeObject(obj);
            bos.flush();
            if (gos != null) {
                gos.finish();
                gos.flush();
            }
            out.flush();
            return bos.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object GetObjectFromBytes(byte[] bytes) {
        try {
            BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(bytes));
            ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(bis));
            return in.readObject();
        }
        catch (Exception e) {
            try {
                BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(bytes));
                ObjectInputStream in = new ObjectInputStream(bis);
                return in.readObject();
            }
            catch (Exception ee) {
                return null;
            }
        }
    }

    public static boolean isServiceRunning(String service, String hostURL) {
        boolean running = false;
        try {
            XmlRpcClient client = new XmlRpcClient(hostURL);
            Boolean out = (Boolean)client.execute("server.hasService", new Vector());
            running = out;
        }
        catch (Exception e) {
            running = false;
        }
        return running;
    }

    public static boolean startService(String service, String hostURL, String className, String[] args) {
        if (XmlRpcUtils.isServiceRunning(service, hostURL)) {
            return true;
        }
        boolean out = false;
        try {
            XmlRpcClient client = new XmlRpcClient(hostURL);
            Vector<Object> argv = new Vector<Object>();
            argv.add(service);
            argv.add(className);
            if (args != null) {
                Vector<String> v = new Vector<String>();
                argv.add(v);
                for (int i = 0; i < args.length; ++i) {
                    v.add(args[i]);
                }
            }
            Boolean outb = (Boolean)client.execute("server.addService", argv);
            out = outb;
        }
        catch (Exception e) {
            out = false;
        }
        return out;
    }

    public static boolean startWebServerIfNeeded(int port) {
        if (XmlRpcUtils.isLocalWebServerRunning(port)) {
            return true;
        }
        boolean out = false;
        try {
            MyXmlRpcServer server = new MyXmlRpcServer(port);
            if (server != null) {
                out = true;
            }
        }
        catch (Exception e) {
            out = false;
        }
        return out;
    }

    public static boolean isLocalWebServerRunning(int port) {
        boolean running = false;
        try {
            XmlRpcClient client = new XmlRpcClient("http://localhost:" + port);
            Boolean out = (Boolean)client.execute("server.status", new Vector());
            running = out;
        }
        catch (Exception e) {
            running = false;
        }
        return running;
    }

    public static void main(String[] args) {
        Serializable testObj = new Serializable(){
            public int int1 = 3;
            public double d1 = 6.4;
            public long l1 = 13498753L;
            public float f1 = 1.234f;
            public String name = "myname";

            public String toString() {
                return this.int1 + " " + this.d1 + " " + this.l1 + " " + this.f1 + " " + this.name;
            }
        };
        System.out.println(testObj);
        Hashtable tab = XmlRpcUtils.GetObjectAsStruct(testObj);
        System.out.println(tab);
        Object obj = XmlRpcUtils.GetObjectFromStruct(tab);
        System.out.println(obj.toString());
    }
}

