/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.httpdata;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

public class NCBIUtils {
    public static String getPage(String urlString) throws Exception {
        return NCBIUtils.getPage(new URL(urlString));
    }

    public static String getPage(URL url) throws Exception {
        String thisLine;
        boolean characterCount = false;
        StringBuffer result = new StringBuffer();
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        int responseCode = urlConnection.getResponseCode();
        String contentType = urlConnection.getContentType();
        int contentLength = urlConnection.getContentLength();
        String contentEncoding = urlConnection.getContentEncoding();
        if (responseCode != 200) {
            throw new IOException("\nHTTP response code: " + responseCode);
        }
        BufferedReader theHTML = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
        while ((thisLine = theHTML.readLine()) != null) {
            result.append(thisLine);
            result.append(" ");
        }
        return result.toString();
    }

    public static String getGINumber(String name) throws Exception {
        return NCBIUtils.getGINumber(name, "Saccharomyces cerevisiae");
    }

    public static String getGINumber(String pname, String species) throws Exception {
        String pname2 = null;
        if (!pname.startsWith("NP_") && !pname.startsWith("XP_")) {
            pname2 = NCBIUtils.getRefSeqFromOrfName(pname);
        }
        if (pname2 != null && !"".equals(pname2) && pname2.length() > 0) {
            pname = pname2;
        }
        String searchURL = "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=Protein&cmd=search&doptcmdl=DocSum&term=";
        species = species.replace(' ', '+');
        String rawSearchPage = NCBIUtils.getPage(searchURL + pname + "+" + species);
        int ind1 = rawSearchPage.indexOf("gi|");
        if (ind1 < 0) {
            return "";
        }
        int ind2 = rawSearchPage.indexOf("|", ind1 + 3);
        if (ind2 < 0 || ind2 <= ind1) {
            return "";
        }
        String giNum = rawSearchPage.substring(ind1 + 3, ind2);
        return giNum;
    }

    public static String getCommonNameFromGINumber(String giNumber) throws Exception {
        if (giNumber == null || "".equals(giNumber) || giNumber.indexOf(32) >= 0) {
            return "";
        }
        String searchURL = "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=Protein&cmd=search&doptcmdl=DocSum&term=";
        String rawSearchPage = NCBIUtils.getPage(searchURL + giNumber);
        int ind1 = rawSearchPage.indexOf("p [Saccharomyces cerevisiae]");
        int ind2 = ind1 - 1;
        while (rawSearchPage.charAt(ind2) != ';') {
            --ind2;
        }
        return rawSearchPage.substring(ind2 += 2, ind1);
    }

    public static String getOrfNameFromRefSeq(String refSeq) throws Exception {
        String searchURL = "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=Protein&cmd=search&doptcmdl=DocSum&term=";
        String rawSearchPage = NCBIUtils.getPage(searchURL + refSeq + "+Saccharomyces+cerevisiae");
        int ind1 = rawSearchPage.indexOf("p [Saccharomyces cerevisiae]");
        int ind2 = ind1 - 1;
        while (rawSearchPage.charAt(ind2) != ';') {
            --ind2;
        }
        return rawSearchPage.substring(ind2 += 2, ind1);
    }

    public static String getRefSeqFromOrfName(String yeastOrf) throws Exception {
        int ind2;
        String rawSearchPage;
        int ind1;
        String searchURL = "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=Protein&cmd=search&doptcmdl=DocSum&term=";
        searchURL = searchURL + yeastOrf;
        if (!yeastOrf.endsWith("p")) {
            searchURL = searchURL + "p";
        }
        if ((ind1 = (rawSearchPage = NCBIUtils.getPage(searchURL = searchURL + "+Saccharomyces+cerevisiae")).indexOf("|NP_")) < 0) {
            ind1 = rawSearchPage.indexOf("|XP_");
        }
        if ((ind2 = rawSearchPage.indexOf(46, ind1)) - ind1 > 10 || ind2 - ind1 <= 0) {
            ind2 = rawSearchPage.indexOf(124, ind1);
        }
        return rawSearchPage.substring(ind1 + 1, ind2);
    }

    public static String getSequenceFromGINumber(String giNumber) throws Exception {
        return NCBIUtils.getSequenceFromGINumber(giNumber, null);
    }

    public static String getOrfNameFromGINumber(String giNumber) throws Exception {
        String signature;
        if (giNumber == null || "".equals(giNumber) || giNumber.indexOf(32) >= 0) {
            return "";
        }
        String url = "http://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?db=Protein&dopt=GenPept&val=";
        String rawPage = NCBIUtils.getPage(url + giNumber);
        int start = rawPage.indexOf(signature = "/locus_tag=\"");
        if (start < 0) {
            return "";
        }
        int end = rawPage.indexOf("\"", (start += signature.length()) + 1);
        String seqText = rawPage.substring(start, end);
        return seqText;
    }

    public static String getSequenceFromGINumber(String giNumber, String species) throws Exception {
        String signature;
        int start;
        if (giNumber == null || "".equals(giNumber) || giNumber.indexOf(32) >= 0) {
            return "";
        }
        String url = "http://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?db=Protein&dopt=GenPept&val=";
        String rawPage = NCBIUtils.getPage(url + giNumber);
        if (species != null && !"".equals(species) && rawPage.toLowerCase().indexOf(species.toLowerCase()) < 0) {
            System.err.println("Uh oh -- sequence retrieved may not be of species " + species);
        }
        if ((start = rawPage.indexOf(signature = "ORIGIN")) < 0) {
            return "";
        }
        int end = rawPage.indexOf("//", (start += signature.length()) + 1);
        String seqText = rawPage.substring(start, end);
        String[] seqLines = seqText.split("\n");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < seqLines.length; ++i) {
            String line = seqLines[i].trim();
            if (line.length() == 0) continue;
            String[] tokens = line.split("\\s+");
            for (int j = 0; j < tokens.length; ++j) {
                String token = tokens[j];
                if (token.matches("\\d+")) continue;
                sb.append(token);
            }
        }
        return sb.toString().toUpperCase();
    }

    public static String getSequence(String name) throws Exception {
        return NCBIUtils.getSequence(name, "Saccharomyces cerevisiae");
    }

    public static String getSequence(String name, String species) throws Exception {
        String out;
        block10: {
            out = "";
            try {
                if (name.startsWith("EST")) {
                    System.err.println("Unknown sequence type: EST");
                    break block10;
                }
                if (name.startsWith("IPI")) {
                    System.err.println("Unknown sequence type: IPI");
                    break block10;
                }
                if (name.startsWith("Hs.")) {
                    System.err.println("Unknown sequence type: Hs.");
                    break block10;
                }
                try {
                    if (name.startsWith("GI")) {
                        name = name.substring(2);
                    }
                    Integer.parseInt(name);
                    out = NCBIUtils.getSequenceFromGINumber(name, species);
                }
                catch (Exception ee) {
                    try {
                        out = NCBIUtils.getSequenceFromGINumber(NCBIUtils.getGINumber(name, species));
                    }
                    catch (Exception eee) {
                        out = "";
                    }
                }
            }
            catch (Exception e) {
                out = "";
            }
        }
        return out;
    }

    public static void main(String[] args) {
        try {
            System.out.println(NCBIUtils.getGINumber("Ref2"));
            System.out.println(NCBIUtils.getSequence(NCBIUtils.getGINumber("Ref2")));
            System.out.println(NCBIUtils.getRefSeqFromOrfName("Ref2") + "\n");
            System.out.println(NCBIUtils.getGINumber("NP_010481"));
            System.out.println(NCBIUtils.getSequence(NCBIUtils.getGINumber("NP_010481")));
            System.out.println(NCBIUtils.getOrfNameFromRefSeq("NP_010481"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

