/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.cytoTalk;

import csplugins.isb.dreiss.cytoTalk.CytoTalkHandler;
import csplugins.isb.dreiss.cytoTalk.CytoTalkPlugin;
import csplugins.isb.dreiss.httpdata.xmlrpc.MyXmlRpcServer;
import csplugins.isb.dreiss.util.ExecRunner;
import csplugins.isb.dreiss.util.IndeterminateProgressBar;
import csplugins.isb.dreiss.util.MyUtils;
import cytoscape.CytoscapeWindow;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.InetAddress;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.xmlrpc.WebServer;

public class CytoTalkPlugin {
    public static final String service = "cy";
    static final int DEFAULT_PORT = 8082;
    public static int STATIC_PORT = 8082;
    public static boolean alreadyStartedCytoTalkAutomatically = false;
    MyXmlRpcServer server = null;
    CytoscapeWindow cWindow;
    int localPort = STATIC_PORT;
    String lastChoice = "test.pl";
    String lastDir = System.getProperty("user.dir");
    String clientFilter = null;
    boolean addLocalHost = true;

    public CytoTalkPlugin() throws Exception {
    }

    public CytoTalkPlugin(CytoscapeWindow cWindow) throws Exception {
        this(cWindow, cWindow.getOperationsMenu());
    }

    public CytoTalkPlugin(CytoscapeWindow cWindow, JMenu menu) throws Exception {
        this.cWindow = cWindow;
        JMenu menu2 = new JMenu("CytoTalk...");
        menu.add(menu2);
        menu2.add(new StartCytoTalk());
        menu2.add(new StopCytoTalk());
        menu2.add(new SetCytoTalkPort());
        menu2.add(new SetCytoTalkClientFilter());
        menu2.add(new RunPerlScript());
        menu2.add(new AboutCytoTalkPlugin());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    CytoTalkPlugin.this.shutdown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        cWindow.getMainFrame().addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                try {
                    CytoTalkPlugin.this.shutdown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        if (!alreadyStartedCytoTalkAutomatically) {
            String[] args = cWindow.getConfiguration().getArgs();
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].equals("--startCytoTalk")) continue;
                alreadyStartedCytoTalkAutomatically = true;
                if (i < args.length - 1) {
                    int port = CytoTalkHandler.isIntParseable(args[i + 1]);
                    if (port == Integer.MIN_VALUE) {
                        port = STATIC_PORT;
                    }
                    this.startCytoTalk(false, port);
                    break;
                }
                this.startCytoTalk(false, STATIC_PORT);
                break;
            }
        }
    }

    public void finalize() {
        try {
            this.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void startCytoTalk() {
        this.startCytoTalk(true, STATIC_PORT);
    }

    protected void startCytoTalk(boolean showMessage, int port) {
        if (this.server != null) {
            return;
        }
        try {
            this.localPort = port;
            STATIC_PORT = port + 1;
            this.server = new MyXmlRpcServer(this.localPort);
            this.server.addService(service, new CytoTalkHandler(this.cWindow, this.server));
            if (this.clientFilter != null || this.addLocalHost) {
                WebServer wserver = this.server.getServer();
                wserver.setParanoid(true);
                if (this.clientFilter != null) {
                    wserver.acceptClient(this.clientFilter);
                    System.err.println("Accepting clients from " + this.clientFilter);
                }
                if (this.addLocalHost) {
                    wserver.acceptClient("127.0.0.1");
                    System.err.println("Accepting clients from localhost");
                }
            }
            if (showMessage) {
                JOptionPane.showMessageDialog((Component)this.cWindow, "Started a CytoTalk handler listening on port " + this.localPort);
            } else {
                System.out.println("Started a CytoTalk handler listening on port " + this.localPort);
            }
        }
        catch (Exception ee) {
            System.err.println("Could not start service: " + ee.getMessage());
        }
    }

    protected void shutdown() {
        if (this.server == null) {
            return;
        }
        this.server.removeService(service);
        this.server.shutdown();
        this.server = null;
    }

    protected void setPort() {
        final JDialog dialog = new JDialog();
        JPanel cp = (JPanel)dialog.getContentPane();
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new FlowLayout());
        centerPanel.add(new JLabel("Use this port: "));
        final JTextField portField = new JTextField(10);
        portField.setText("" + this.localPort);
        centerPanel.add(portField);
        cp.add((Component)centerPanel, "North");
        centerPanel = new JPanel();
        JPanel butPanel = new JPanel();
        butPanel.setLayout(new FlowLayout());
        JButton but = new JButton("Default");
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                portField.setText("8082");
            }
        });
        butPanel.add(but);
        but = new JButton("Cancel");
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        butPanel.add(but);
        but = new JButton("OK");
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    int port = Integer.parseInt(portField.getText());
                    if (port < 8082) {
                        JOptionPane.showMessageDialog((Component)CytoTalkPlugin.this.cWindow, "Please enter a port number greater than 8082.");
                    } else {
                        dialog.dispose();
                    }
                    CytoTalkPlugin.this.localPort = STATIC_PORT = port;
                }
                catch (Exception ee) {
                    JOptionPane.showMessageDialog((Component)CytoTalkPlugin.this.cWindow, "Please enter a port number as an integer greater than 8082.");
                }
            }
        });
        butPanel.add(but);
        cp.add((Component)butPanel, "South");
        dialog.doLayout();
        dialog.pack();
        dialog.setLocationRelativeTo(this.cWindow.getMainFrame());
        dialog.setVisible(true);
    }

    protected void setClientFilter() {
        final JDialog dialog = new JDialog();
        JPanel cp = (JPanel)dialog.getContentPane();
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new FlowLayout());
        centerPanel.add(new JLabel("Only allow these IP addresses to connect: "));
        final JTextField hostField = new JTextField(20);
        hostField.setText(CytoTalkPlugin.getLocalHostAddr());
        centerPanel.add(hostField);
        cp.add((Component)centerPanel, "North");
        final JCheckBox addLocalHostCB = new JCheckBox("Allow localhost connections by default?", this.addLocalHost);
        cp.add((Component)addLocalHostCB, "Center");
        centerPanel = new JPanel();
        JPanel butPanel = new JPanel();
        butPanel.setLayout(new FlowLayout());
        JButton but = new JButton("Default");
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                hostField.setText(CytoTalkPlugin.getLocalHostAddr());
            }
        });
        butPanel.add(but);
        but = new JButton("Cancel");
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        butPanel.add(but);
        but = new JButton("OK");
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    CytoTalkPlugin.this.clientFilter = hostField.getText();
                    dialog.dispose();
                    if (CytoTalkPlugin.this.server != null && !"".equals(CytoTalkPlugin.this.clientFilter)) {
                        System.err.println("Accepting clients from " + CytoTalkPlugin.this.clientFilter);
                        CytoTalkPlugin.this.server.getServer().setParanoid(true);
                        CytoTalkPlugin.this.server.getServer().acceptClient(CytoTalkPlugin.this.clientFilter);
                        CytoTalkPlugin.this.addLocalHost = addLocalHostCB.isSelected();
                        if (CytoTalkPlugin.this.addLocalHost) {
                            CytoTalkPlugin.this.server.getServer().acceptClient("127.0.0.1");
                            System.err.println("Accepting clients from localhost");
                        }
                    }
                }
                catch (Exception ee) {
                    JOptionPane.showMessageDialog((Component)CytoTalkPlugin.this.cWindow, "Please enter an IP address filter (e.g. 192.168.0.*).");
                }
            }
        });
        butPanel.add(but);
        cp.add((Component)butPanel, "South");
        dialog.doLayout();
        dialog.pack();
        dialog.setLocationRelativeTo(this.cWindow.getMainFrame());
        dialog.setVisible(true);
    }

    static String getLocalHostAddr() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        Properties properties = MyUtils.readProperties("csplugins/isb/dreiss/cytoTalk.properties");
        try {
            STATIC_PORT = Integer.parseInt((String)properties.get("cytoTalk.port"));
        }
        catch (Exception ee) {
            ee.printStackTrace();
            STATIC_PORT = 8082;
        }
    }

    public class RunPerlScript
    extends AbstractAction {
        JTextField fileField;
        JTextField argsField;

        RunPerlScript() {
            super("Execute an R, Perl, or Python script...");
        }

        public void actionPerformed(ActionEvent e) {
            JDialog dialog = new JDialog();
            JPanel cp = (JPanel)dialog.getContentPane();
            JPanel centerPanel = new JPanel();
            centerPanel.setLayout(new FlowLayout());
            this.fileField = new JTextField(30);
            this.fileField.setText(CytoTalkPlugin.this.lastChoice);
            centerPanel.add(this.fileField);
            JButton but = new JButton("Browse");
            centerPanel.add(but);
            but.addActionListener(new ActionListener(this, dialog){
                private final /* synthetic */ JDialog val$dialog;
                private final /* synthetic */ RunPerlScript this$1;
                {
                    this.this$1 = this$1;
                    this.val$dialog = val$dialog;
                }

                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser(new File(RunPerlScript.access$000((RunPerlScript)this.this$1).lastDir));
                    if (chooser.showOpenDialog(this.val$dialog) == 0) {
                        RunPerlScript.access$000((RunPerlScript)this.this$1).lastChoice = chooser.getSelectedFile().toString();
                        RunPerlScript.access$000((RunPerlScript)this.this$1).lastDir = chooser.getCurrentDirectory().toString();
                        this.this$1.fileField.setText(RunPerlScript.access$000((RunPerlScript)this.this$1).lastChoice);
                    }
                }
            });
            cp.add((Component)centerPanel, "North");
            centerPanel = new JPanel();
            this.argsField = new JTextField(25);
            centerPanel.setLayout(new FlowLayout());
            centerPanel.add(new JLabel("Arguments: "));
            centerPanel.add(this.argsField);
            cp.add((Component)centerPanel, "Center");
            JPanel butPanel = new JPanel();
            butPanel.setLayout(new FlowLayout());
            but = new JButton("Cancel");
            but.addActionListener(new ActionListener(this, dialog){
                private final /* synthetic */ JDialog val$dialog;
                private final /* synthetic */ RunPerlScript this$1;
                {
                    this.this$1 = this$1;
                    this.val$dialog = val$dialog;
                }

                public void actionPerformed(ActionEvent e) {
                    this.val$dialog.dispose();
                }
            });
            butPanel.add(but);
            but = new JButton("GO");
            but.addActionListener(new ActionListener(this, dialog){
                private final /* synthetic */ JDialog val$dialog;
                private final /* synthetic */ RunPerlScript this$1;
                {
                    this.this$1 = this$1;
                    this.val$dialog = val$dialog;
                }

                public void actionPerformed(ActionEvent e) {
                    boolean started;
                    this.val$dialog.dispose();
                    boolean bl = started = RunPerlScript.access$000((RunPerlScript)this.this$1).server == null;
                    if (RunPerlScript.access$000((RunPerlScript)this.this$1).server == null) {
                        RunPerlScript.access$000(this.this$1).startCytoTalk();
                    }
                    String fname = this.this$1.fileField.getText();
                    String args = this.this$1.argsField.getText();
                    String shortName = fname.substring(fname.lastIndexOf(File.separator) + 1);
                    IndeterminateProgressBar prog = new IndeterminateProgressBar((Frame)RunPerlScript.access$000((RunPerlScript)this.this$1).cWindow.getMainFrame(), fname, "Executing the script \"" + shortName + "\"...");
                    prog.doLayout();
                    prog.pack();
                    prog.setLocationRelativeTo(RunPerlScript.access$000((RunPerlScript)this.this$1).cWindow.getMainFrame());
                    prog.show();
                    new Thread(this, fname, args, prog, started){
                        private final /* synthetic */ String val$fname;
                        private final /* synthetic */ String val$args;
                        private final /* synthetic */ JDialog val$prog;
                        private final /* synthetic */ boolean val$started;
                        private final /* synthetic */ 11 this$2;
                        {
                            this.this$2 = this$2;
                            this.val$fname = val$fname;
                            this.val$args = val$args;
                            this.val$prog = val$prog;
                            this.val$started = val$started;
                        }

                        public void run() {
                            try {
                                int result;
                                ExecRunner child = new ExecRunner();
                                if (!this.val$fname.toUpperCase().endsWith(".R")) {
                                    result = child.exec(this.val$fname + " " + this.val$args + " -port " + RunPerlScript.access$000((RunPerlScript)11.access$100(this.this$2)).localPort, System.out, System.err);
                                } else {
                                    String file = MyUtils.ReadFile(this.val$fname);
                                    file = "port <- " + RunPerlScript.access$000((RunPerlScript)11.access$100(this.this$2)).localPort + "\n" + file;
                                    file = file + "q()\n";
                                    Properties props = MyUtils.readProperties("csplugins/isb/dreiss/cytoTalk.properties");
                                    String cp = System.getProperty("java.class.path");
                                    String r_libs = (String)props.get("cytoTalk.R_LIBS");
                                    String lib_path = (String)props.get("cytoTalk.LD_LIBRARY_PATH");
                                    String[] env = new String[]{"CLASSPATH=" + cp, "R_LIBS=" + r_libs, "LD_LIBRARY_PATH=" + lib_path};
                                    child.setEnvironment(env);
                                    String rCommand = (String)props.get("cytoTalk.R_COMMAND");
                                    result = child.exec(rCommand, file, System.out, System.err);
                                }
                                System.err.println("RESULT: " + result);
                            }
                            catch (Exception ee) {
                                ee.printStackTrace();
                            }
                            this.val$prog.dispose();
                            if (this.val$started) {
                                RunPerlScript.access$000(11.access$100(this.this$2)).shutdown();
                            }
                        }
                    }.start();
                }

                static /* synthetic */ RunPerlScript access$100(11 x0) {
                    return x0.this$1;
                }
            });
            butPanel.add(but);
            cp.add((Component)butPanel, "South");
            dialog.doLayout();
            dialog.pack();
            dialog.setLocationRelativeTo(CytoTalkPlugin.this.cWindow.getMainFrame());
            dialog.setVisible(true);
        }

        static /* synthetic */ CytoTalkPlugin access$000(RunPerlScript x0) {
            return x0.CytoTalkPlugin.this;
        }
    }

    public class SetCytoTalkClientFilter
    extends AbstractAction {
        SetCytoTalkClientFilter() {
            super("Set CytoTalk Client Address Filter");
        }

        public void actionPerformed(ActionEvent e) {
            CytoTalkPlugin.this.setClientFilter();
        }
    }

    public class SetCytoTalkPort
    extends AbstractAction {
        SetCytoTalkPort() {
            super("Set CytoTalk Port");
        }

        public void actionPerformed(ActionEvent e) {
            CytoTalkPlugin.this.setPort();
        }
    }

    public class StopCytoTalk
    extends AbstractAction {
        StopCytoTalk() {
            super("Stop CytoTalk");
        }

        public void actionPerformed(ActionEvent e) {
            CytoTalkPlugin.this.shutdown();
        }
    }

    public class StartCytoTalk
    extends AbstractAction {
        StartCytoTalk() {
            super("Start CytoTalk");
        }

        public void actionPerformed(ActionEvent e) {
            CytoTalkPlugin.this.startCytoTalk();
        }
    }

    protected class AboutCytoTalkPlugin
    extends AbstractAction {
        AboutCytoTalkPlugin() {
            super("About CytoTalk Plugin...");
        }

        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog((Component)CytoTalkPlugin.this.cWindow, new Object[]{"CytoTalk plugin by David Reiss", "Use R, Perl, Python, or nearly any external language to control a Cytoscape process.", "Questions or comments: dreiss@systemsbiology.org"}, "About CytoTalk plugin", 1);
        }
    }
}

