/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.cytoTalk;

import csplugins.isb.dreiss.cytoTalk.CytoTalkPlugin;
import csplugins.isb.dreiss.cytoTalk.CytoTalkSelectionListener;
import csplugins.isb.dreiss.httpdata.xmlrpc.MyXmlRpcServer;
import csplugins.trial.pshannon.dataCube.DataMatrix;
import csplugins.trial.pshannon.dataCube.DataMatrixReader;
import csplugins.trial.pshannon.dataCube.DataMatrixReaderFactory;
import cytoscape.CytoscapeWindow;
import cytoscape.GraphObjAttributes;
import cytoscape.data.ExpressionData;
import cytoscape.data.mRNAMeasurement;
import cytoscape.undo.UndoableGraphHider;
import java.awt.Cursor;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.Node;
import y.base.NodeCursor;
import y.view.Graph2DSelectionEvent;
import y.view.Graph2DSelectionListener;

public class CytoTalkHandler
implements Graph2DSelectionListener {
    static boolean SPLIT_ON_SEMIS = true;
    CytoscapeWindow cWindow;
    GraphObjAttributes nodeAttr;
    GraphObjAttributes edgeAttr;
    UndoableGraphHider graphHider;
    MyXmlRpcServer server;
    ExpressionData data;
    Map dataMatrices = null;
    Vector selection = null;
    Vector selectionListeners = null;
    boolean added = false;

    public CytoTalkHandler(CytoscapeWindow cWindow, MyXmlRpcServer server) {
        this.cWindow = cWindow;
        this.nodeAttr = cWindow.getNodeAttributes();
        this.edgeAttr = cWindow.getEdgeAttributes();
        this.graphHider = cWindow.getGraphHider();
        this.data = cWindow.getExpressionData();
        this.server = server;
    }

    public int isRunning() {
        return 1;
    }

    public boolean exposeNodeAttributes() {
        if (this.server == null) {
            return false;
        }
        try {
            this.server.addService("nodeAttr", this.nodeAttr);
        }
        catch (Exception ee) {
            System.err.println("Could not start service \"nodeAttr\": " + ee.getMessage());
            return false;
        }
        return true;
    }

    public boolean exposeEdgeAttributes() {
        if (this.server == null) {
            return false;
        }
        try {
            this.server.addService("edgeAttr", this.edgeAttr);
        }
        catch (Exception ee) {
            System.err.println("Could not start service \"edgeAttr\": " + ee.getMessage());
            return false;
        }
        return true;
    }

    public boolean exposeCytoscapeWindow() {
        if (this.server == null) {
            return false;
        }
        try {
            this.server.addService("cyWindow", this.cWindow);
        }
        catch (Exception ee) {
            System.err.println("Could not start service \"cyWindow\": " + ee.getMessage());
            return false;
        }
        return true;
    }

    public boolean exposeAll() {
        if (this.server == null) {
            return false;
        }
        this.exposeNodeAttributes();
        this.exposeEdgeAttributes();
        this.exposeCytoscapeWindow();
        try {
            this.server.addService("cyData", this.data);
        }
        catch (Exception ee) {
            System.err.println("Could not start service \"cyData\": " + ee.getMessage());
            return false;
        }
        return true;
    }

    public boolean setTitle(String title) {
        this.cWindow.setWindowTitle(title);
        return true;
    }

    public Vector getSelectedNodes() {
        Node[] nodes = this.selectedNodes();
        Vector<String> out = new Vector<String>();
        for (int i = 0; i < nodes.length; ++i) {
            out.add(this.cWindow.getCanonicalNodeName(nodes[i]));
        }
        return out;
    }

    public Vector getSelectedNodeNames() {
        Node[] nodes = this.selectedNodes();
        Vector<String> out = new Vector<String>();
        for (int i = 0; i < nodes.length; ++i) {
            out.add(nodes[i].toString());
        }
        return out;
    }

    public String getNodeName(String canonicalName) {
        return this.cWindow.getNode(canonicalName).toString();
    }

    public int countSelectedNodes() {
        return this.selectedNodes().length;
    }

    public boolean storeSelection() {
        this.selection = this.getSelectedNodes();
        return true;
    }

    public boolean doesNodeExist(String canonicalName) {
        return this.cWindow.getNode(canonicalName) != null;
    }

    public boolean isNodeSelected(String canonicalName) {
        return this.cWindow.getGraph().isSelected(this.cWindow.getNode(canonicalName));
    }

    public boolean selectionChanged() {
        Vector sel = this.getSelectedNodes();
        return sel == null && this.selection != null || this.selection == null && sel != null || this.selection.size() != sel.size() || !this.selection.equals(sel);
    }

    public Vector getAllNodes() {
        Node[] nodes = this.cWindow.getGraph().getNodeArray();
        Vector<String> out = new Vector<String>();
        for (int i = 0; i < nodes.length; ++i) {
            out.add(this.cWindow.getCanonicalNodeName(nodes[i]));
        }
        return out;
    }

    public int countAllNodes() {
        return this.cWindow.getGraph().getNodeArray().length;
    }

    public Vector getSelectedEdges() {
        Edge[] edges = this.selectedEdges();
        Vector<String> out = new Vector<String>();
        for (int i = 0; i < edges.length; ++i) {
            out.add(this.edgeAttr.getCanonicalName((Object)edges[i]));
        }
        return out;
    }

    public int countSelectedEdges() {
        return this.selectedEdges().length;
    }

    public Vector getAllEdges() {
        Edge[] edges = this.cWindow.getGraph().getEdgeArray();
        Vector<String> out = new Vector<String>();
        for (int i = 0; i < edges.length; ++i) {
            out.add(this.edgeAttr.getCanonicalName((Object)edges[i]));
        }
        return out;
    }

    public int countAllEdges() {
        return this.cWindow.getGraph().getEdgeArray().length;
    }

    public boolean clearSelection() {
        this.clearNodeSelection();
        this.clearEdgeSelection();
        return true;
    }

    public boolean clearNodeSelection() {
        this.cWindow.deselectAllNodes(true);
        return true;
    }

    public boolean clearEdgeSelection() {
        this.cWindow.getGraph().unselectEdges();
        return true;
    }

    public boolean selectNode(String canonicalName) {
        this.cWindow.selectNodesByName(new String[]{canonicalName}, false);
        return true;
    }

    public boolean deselectNode(String canonicalName) {
        this.cWindow.getGraph().setSelected(this.cWindow.getNode(canonicalName), false);
        return true;
    }

    public boolean selectNodes(Vector canonicalNames) {
        this.cWindow.selectNodesByName(canonicalNames.toArray(new String[0]), false);
        return true;
    }

    public boolean selectEdge(String canonicalName) {
        this.cWindow.selectEdges(new Edge[]{(Edge)this.edgeAttr.getGraphObject(canonicalName)}, false);
        return true;
    }

    public boolean selectEdges(Vector canonicalNames) {
        Edge[] edges = new Edge[canonicalNames.size()];
        int sz = canonicalNames.size();
        for (int i = 0; i < sz; ++i) {
            try {
                edges[i] = (Edge)this.edgeAttr.getGraphObject((String)canonicalNames.get(i));
                continue;
            }
            catch (Exception e) {
                System.err.println("Error selecting node " + canonicalNames.get(i));
            }
        }
        this.cWindow.selectEdges(edges, false);
        return true;
    }

    public Vector getNodeAttributeNames() {
        String[] out = this.nodeAttr.getAttributeNames();
        return this.stringArrayToVector(out);
    }

    public Vector getEdgeAttributeNames() {
        String[] out = this.edgeAttr.getAttributeNames();
        return this.stringArrayToVector(out);
    }

    public boolean graphHasNodeAttribute(String attr) {
        return this.nodeAttr.hasAttribute(attr);
    }

    public boolean hasNodeAttribute(String canonicalName, String attr) {
        return this.nodeAttr.hasAttribute(attr, canonicalName);
    }

    public boolean graphHasEdgeAttribute(String attr) {
        return this.edgeAttr.hasAttribute(attr);
    }

    public boolean hasEdgeAttribute(String canonicalName, String attr) {
        return this.edgeAttr.hasAttribute(attr, canonicalName);
    }

    public String getNodeSpecies(String canonicalName) {
        String out;
        Vector v = this.getNodeAttribute(canonicalName, "species");
        String string = out = v.size() > 0 ? this.getNodeAttribute(canonicalName, "species").get(0).toString() : null;
        if (out == null || out.length() <= 0) {
            out = this.cWindow.getDefaultSpecies();
        }
        return out;
    }

    public Vector getNodesWithAttribute(String attr) {
        return this.stringArrayToVector(this.nodeAttr.getObjectNames(attr));
    }

    public Vector getEdgesWithAttribute(String attr) {
        return this.stringArrayToVector(this.edgeAttr.getObjectNames(attr));
    }

    public Vector getNodeAttribute(String canonicalName, String attrName) {
        if (this.nodeAttr.hasAttribute(attrName)) {
            return this.fixVectorForXmlRpc(this.nodeAttr.getList(attrName, canonicalName));
        }
        return new Vector();
    }

    public Vector getEdgeAttribute(String canonicalName, String attrName) {
        if (this.edgeAttr.hasAttribute(attrName)) {
            return this.fixVectorForXmlRpc(this.edgeAttr.getList(attrName, canonicalName));
        }
        return new Vector();
    }

    public Vector getNodesAttribute(Vector canonicalNames, String attrName) {
        Vector<Object> out = new Vector<Object>();
        int sz = canonicalNames.size();
        for (int i = 0; i < sz; ++i) {
            if (this.nodeAttr.hasAttribute(attrName)) {
                out.add(this.getNodeAttribute((String)canonicalNames.get(i), attrName));
                continue;
            }
            out.add("");
        }
        return this.fixVectorForXmlRpc(out);
    }

    public Vector getEdgesAttribute(Vector canonicalNames, String attrName) {
        Vector<Object> out = new Vector<Object>();
        int sz = canonicalNames.size();
        for (int i = 0; i < sz; ++i) {
            if (this.edgeAttr.hasAttribute(attrName)) {
                out.add(this.getEdgeAttribute((String)canonicalNames.get(i), attrName));
                continue;
            }
            out.add("");
        }
        return this.fixVectorForXmlRpc(out);
    }

    public Hashtable getNodeAttributes(String canonicalName) {
        HashMap map = this.nodeAttr.getAttributes(canonicalName);
        return this.fixMapForXmlRpc(map);
    }

    public Hashtable getEdgeAttributes(String canonicalName) {
        HashMap map = this.edgeAttr.getAttributes(canonicalName);
        return this.fixMapForXmlRpc(map);
    }

    public Vector getNodesAttributes(Vector canonicalNames) {
        Vector<Hashtable> out = new Vector<Hashtable>();
        int sz = canonicalNames.size();
        for (int i = 0; i < sz; ++i) {
            out.add(this.getNodeAttributes((String)canonicalNames.get(i)));
        }
        return this.fixVectorForXmlRpc(out);
    }

    public Vector getEdgesAttributes(Vector canonicalNames) {
        Vector<Hashtable> out = new Vector<Hashtable>();
        int sz = canonicalNames.size();
        for (int i = 0; i < sz; ++i) {
            out.add(this.getEdgeAttributes((String)canonicalNames.get(i)));
        }
        return this.fixVectorForXmlRpc(out);
    }

    public boolean addNodeAttribute(String canonicalName, String attrName, String value) {
        try {
            this.nodeAttr.append(attrName, canonicalName, CytoTalkHandler.parseAttribute(value));
        }
        catch (Exception e) {
            System.err.println("ERROR in addNodeAttribute (1): " + canonicalName + " " + attrName + " " + value + ": " + e.getMessage());
            try {
                this.nodeAttr.append(attrName, canonicalName, (Object)value);
            }
            catch (Exception e2) {
                System.err.println("ERROR in addNodeAttribute (2): " + canonicalName + " " + attrName + " " + value + ": " + e2.getMessage());
            }
        }
        return true;
    }

    public boolean addNodeAttributes(String canonicalName, Hashtable attrs) {
        try {
            Iterator it = attrs.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                Object val = attrs.get(key);
                if (val instanceof Vector) {
                    int sz = ((Vector)val).size();
                    for (int i = 0; i < sz; ++i) {
                        this.addNodeAttribute(canonicalName, key.trim(), ((Vector)val).get(i).toString());
                    }
                    continue;
                }
                this.addNodeAttribute(canonicalName, key.trim(), attrs.get(key).toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean setNodeAttribute(String canonicalName, String attrName, String value) {
        try {
            this.nodeAttr.set(attrName, canonicalName, CytoTalkHandler.parseAttribute(value));
        }
        catch (Exception e) {
            this.nodeAttr.set(attrName, canonicalName, (Object)value);
        }
        return true;
    }

    public boolean setNodeAttributes(String canonicalName, Hashtable attrs) {
        Iterator it = attrs.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            this.deleteNodeAttribute(canonicalName, key.trim());
        }
        this.addNodeAttributes(canonicalName, attrs);
        return true;
    }

    public boolean addEdgeAttribute(String canonicalName, String attrName, String value) {
        try {
            this.edgeAttr.append(attrName, canonicalName, CytoTalkHandler.parseAttribute(value));
        }
        catch (Exception e) {
            System.err.println("ERROR in addEdgeAttribute (1): " + canonicalName + " " + attrName + " " + value + ": " + e.getMessage());
            try {
                this.edgeAttr.append(attrName, canonicalName, (Object)value);
            }
            catch (Exception e2) {
                System.err.println("ERROR in addEdgeAttribute (2): " + canonicalName + " " + attrName + " " + value + ": " + e2.getMessage());
            }
        }
        return true;
    }

    public boolean addEdgeAttributes(String canonicalName, Hashtable attrs) {
        Iterator it = attrs.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            Object val = attrs.get(key);
            if (val instanceof Vector) {
                int sz = ((Vector)val).size();
                for (int i = 0; i < sz; ++i) {
                    this.addEdgeAttribute(canonicalName, key.trim(), ((Vector)val).get(i).toString());
                }
                continue;
            }
            this.addEdgeAttribute(canonicalName, key.trim(), attrs.get(key).toString());
        }
        return true;
    }

    public boolean setEdgeAttribute(String canonicalName, String attrName, String value) {
        try {
            this.edgeAttr.set(attrName, canonicalName, CytoTalkHandler.parseAttribute(value));
        }
        catch (Exception e) {
            try {
                this.edgeAttr.set(attrName, canonicalName, (Object)value);
            }
            catch (Exception ee) {
                System.err.println("ERROR in setEdgeAttribute: " + canonicalName + " " + attrName + " " + value);
            }
        }
        return true;
    }

    public boolean setEdgeAttributes(String canonicalName, Hashtable attrs) {
        try {
            Iterator it = attrs.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next().toString();
                this.deleteEdgeAttribute(canonicalName, key.trim());
            }
            this.addEdgeAttributes(canonicalName, attrs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean deleteAllNodeAttribute(String attr) {
        this.nodeAttr.deleteAttribute(attr);
        return true;
    }

    public boolean deleteNodeAttribute(String canonicalName, String attr) {
        this.nodeAttr.deleteAttribute(attr, canonicalName);
        return true;
    }

    public boolean deleteAllEdgeAttribute(String attr) {
        this.edgeAttr.deleteAttribute(attr);
        return true;
    }

    public boolean deleteEdgeAttribute(String canonicalName, String attr) {
        this.edgeAttr.deleteAttribute(attr, canonicalName);
        return true;
    }

    public Vector getNeighbors(String canonicalName) {
        Vector<String> out = new Vector<String>();
        Node node = this.cWindow.getNode(canonicalName);
        if (node == null) {
            return out;
        }
        EdgeCursor ec = node.edges();
        while (ec.ok()) {
            Edge e = ec.edge();
            Node oppositeNode = e.opposite(node);
            out.add(this.cWindow.getCanonicalNodeName(oppositeNode));
            ec.next();
        }
        return out;
    }

    public Vector getConnectedNodes(String canonicalName) {
        Vector<String> out = new Vector<String>();
        Edge e = (Edge)this.edgeAttr.getGraphObject(canonicalName);
        out.add(this.cWindow.getCanonicalNodeName(e.source()));
        out.add(this.cWindow.getCanonicalNodeName(e.target()));
        return out;
    }

    public Vector getConnectedEdges(String canonicalName) {
        Vector<String> out = new Vector<String>();
        Node node = this.cWindow.getNode(canonicalName);
        if (node == null) {
            return out;
        }
        EdgeCursor ec = node.edges();
        while (ec.ok()) {
            out.add(this.edgeAttr.getCanonicalName((Object)ec.edge()));
            ec.next();
        }
        return out;
    }

    public String getConnectedEdge(String canonicalName1, String canonicalName2) {
        Edge e;
        Node node1 = this.cWindow.getNode(canonicalName1);
        if (node1 == null) {
            return "";
        }
        Node node2 = this.cWindow.getNode(canonicalName2);
        if (node2 == null) {
            return "";
        }
        EdgeCursor ec = node1.edges();
        while (ec.ok()) {
            e = ec.edge();
            if (e.opposite(node1) == node2) {
                return this.edgeAttr.getCanonicalName((Object)e);
            }
            ec.next();
        }
        ec = node2.edges();
        while (ec.ok()) {
            e = ec.edge();
            if (e.opposite(node2) == node1) {
                return this.edgeAttr.getCanonicalName((Object)e);
            }
            ec.next();
        }
        return "";
    }

    public Vector getNodesNeighbors(Vector canonicalNames) {
        Vector out = new Vector();
        int sz = canonicalNames.size();
        for (int i = 0; i < sz; ++i) {
            this.addVectorTo(out, this.getNeighbors((String)canonicalNames.get(i)));
        }
        return out;
    }

    public Vector getNodesConnectedEdges(Vector canonicalNames) {
        Vector out = new Vector();
        int sz = canonicalNames.size();
        for (int i = 0; i < sz; ++i) {
            this.addVectorTo(out, this.getConnectedEdges((String)canonicalNames.get(i)));
        }
        return out;
    }

    public Vector getEdgesConnectedNodes(Vector canonicalNames) {
        Vector out = new Vector();
        int sz = canonicalNames.size();
        for (int i = 0; i < sz; ++i) {
            this.addVectorTo(out, this.getConnectedNodes((String)canonicalNames.get(i)));
        }
        return out;
    }

    public Vector getNetworkAsList() {
        Vector<Vector> out = new Vector<Vector>();
        Vector edges = this.getAllEdges();
        int sz = edges.size();
        for (int i = 0; i < sz; ++i) {
            String edge = (String)edges.get(i);
            Vector pair = this.getConnectedNodes(edge);
            pair.add(edge);
            out.add(pair);
        }
        return out;
    }

    public Vector getSelectedNetworkAsList() {
        Vector<Vector> out = new Vector<Vector>();
        Vector edges = this.getSelectedEdges();
        if (edges.size() <= 0) {
            edges = this.getNodesConnectedEdges(this.getSelectedNodes());
        }
        int sz = edges.size();
        for (int i = 0; i < sz; ++i) {
            String edge = (String)edges.get(i);
            Vector pair = this.getConnectedNodes(edge);
            pair.add(edge);
            out.add(pair);
        }
        return out;
    }

    public Hashtable getNetworkAsHash() {
        Hashtable<String, Vector> out = new Hashtable<String, Vector>();
        Vector nodes = this.getAllNodes();
        int sz = nodes.size();
        for (int i = 0; i < sz; ++i) {
            String node = (String)nodes.get(i);
            Vector connected = this.getNeighbors(node);
            out.put(node, connected);
        }
        return out;
    }

    public Hashtable getSelectedNetworkAsHash() {
        Hashtable<String, Vector> out = new Hashtable<String, Vector>();
        Vector nodes = this.getSelectedNodes();
        int sz = nodes.size();
        for (int i = 0; i < sz; ++i) {
            String node = (String)nodes.get(i);
            Vector connected = this.getNeighbors(node);
            out.put(node, connected);
        }
        return out;
    }

    public Vector getNetworkAsMatrix() {
        int i;
        Vector out = new Vector();
        Vector nodes = this.getAllNodes();
        Double zero = new Double(0.0);
        Double one = new Double(1.0);
        int sz = nodes.size();
        for (i = 0; i < sz; ++i) {
            Vector v = new Vector();
            v.setSize(sz);
            out.add(v);
        }
        sz = nodes.size();
        for (i = 0; i < sz; ++i) {
            String node1 = (String)nodes.get(i);
            for (int j = 0; j < i; ++j) {
                String node2 = (String)nodes.get(j);
                String edge = this.getConnectedEdge(node1, node2);
                Double val = "".equals(edge) ? zero : one;
                ((Vector)out.get(i)).set(j, val);
                ((Vector)out.get(j)).set(i, val);
            }
            String edge = this.getConnectedEdge(node1, node1);
            Double val = "".equals(edge) ? zero : one;
            ((Vector)out.get(i)).set(i, val);
        }
        return out;
    }

    public Vector getSelectedNetworkAsMatrix() {
        int i;
        Vector out = new Vector();
        Vector nodes = this.getSelectedNodes();
        Double zero = new Double(0.0);
        Double one = new Double(1.0);
        int sz = nodes.size();
        for (i = 0; i < sz; ++i) {
            Vector v = new Vector();
            v.setSize(sz);
            out.add(v);
        }
        sz = nodes.size();
        for (i = 0; i < sz; ++i) {
            String node1 = (String)nodes.get(i);
            for (int j = 0; j < i; ++j) {
                String node2 = (String)nodes.get(j);
                String edge = this.getConnectedEdge(node1, node2);
                Double val = "".equals(edge) ? zero : one;
                ((Vector)out.get(i)).set(j, val);
                ((Vector)out.get(j)).set(i, val);
            }
            String edge = this.getConnectedEdge(node1, node1);
            Double val = "".equals(edge) ? zero : one;
            ((Vector)out.get(i)).set(i, val);
        }
        return out;
    }

    public boolean selectNeighbors(String canonicalName) {
        return this.selectNodes(this.getNeighbors(canonicalName));
    }

    public boolean selectConnectedEdges(String canonicalName) {
        return this.selectEdges(this.getConnectedEdges(canonicalName));
    }

    public boolean selectConnectedNodes(String canonicalName) {
        return this.selectNodes(this.getConnectedNodes(canonicalName));
    }

    public boolean selectNodesNeighbors(Vector canonicalNames) {
        return this.selectNodes(this.getNodesNeighbors(canonicalNames));
    }

    public boolean selectNodesConnectedEdges(Vector canonicalNames) {
        return this.selectEdges(this.getNodesConnectedEdges(canonicalNames));
    }

    public boolean selectEdgesConnectedNodes(Vector canonicalNames) {
        return this.selectNodes(this.getEdgesConnectedNodes(canonicalNames));
    }

    public boolean selectNodesWithoutAttribute(String attr) {
        this.setWaitCursor();
        Node[] nodes = this.cWindow.getGraph().getNodeArray();
        Vector<String> unselectedNodes = new Vector<String>();
        for (int i = 0; i < nodes.length; ++i) {
            String canonicalName = this.cWindow.getCanonicalNodeName(nodes[i]);
            if (this.nodeAttr.hasAttribute(attr, canonicalName)) continue;
            unselectedNodes.add(canonicalName);
        }
        this.cWindow.selectNodesByName(unselectedNodes.toArray(new String[0]));
        this.setDefaultCursor();
        return true;
    }

    public String createEdge(String canonicalName1, String edgeType, String canonicalName2) {
        Node n1 = (Node)this.nodeAttr.getGraphObject(canonicalName1);
        if (n1 == null) {
            return "";
        }
        Node n2 = (Node)this.nodeAttr.getGraphObject(canonicalName2);
        if (n2 == null) {
            return "";
        }
        Edge e = this.cWindow.getGraph().createEdge(n1, n2);
        String edgeName = canonicalName1 + " (" + edgeType + ") " + canonicalName2;
        this.edgeAttr.addNameMapping(edgeName, (Object)e);
        this.edgeAttr.set("interaction", edgeName, (Object)edgeType);
        return edgeName;
    }

    public boolean createEdges(Vector canonicalNames) {
        int sz = canonicalNames.size();
        for (int i = 0; i < sz; ++i) {
            String name = (String)canonicalNames.get(i);
            String[] toks = name.split("\\s+");
            if (toks[1].startsWith("(")) {
                toks[1] = toks[1].substring(1, toks[1].length() - 2);
            }
            this.createEdge(toks[0], toks[1], toks[2]);
        }
        return true;
    }

    public boolean createNode(String newCanonicalName) {
        Node n = this.cWindow.getGraph().createNode(100.0, 100.0, newCanonicalName);
        this.nodeAttr.addNameMapping(newCanonicalName, (Object)n);
        return true;
    }

    public boolean createNodeAt(String newCanonicalName, int x, int y, int w, int h) {
        Node n = this.cWindow.getGraph().createNode((double)x, (double)y, (double)w, (double)h, newCanonicalName);
        this.nodeAttr.addNameMapping(newCanonicalName, (Object)n);
        return true;
    }

    public boolean createNodes(Vector canonicalNames) {
        int sz = canonicalNames.size();
        for (int i = 0; i < sz; ++i) {
            this.createNode((String)canonicalNames.get(i));
        }
        return true;
    }

    public boolean redrawGraph() {
        this.cWindow.displayCommonNodeNames();
        this.cWindow.redrawGraph();
        return true;
    }

    public boolean relayoutGraph() {
        this.cWindow.applyLayout(false);
        this.redrawGraph();
        return true;
    }

    public boolean doLayout() {
        return this.relayoutGraph();
    }

    public boolean setWaitCursor() {
        this.cWindow.setCursor(Cursor.getPredefinedCursor(3));
        return true;
    }

    public boolean setDefaultCursor() {
        this.cWindow.setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    public boolean hideSelectedNodes() {
        this.graphHider.hideNodes();
        return true;
    }

    public boolean unhideSelectedNodes() {
        this.graphHider.unhideNodes();
        return true;
    }

    public boolean hideEdges() {
        this.graphHider.hideEdges();
        return true;
    }

    public boolean removeNode(String canonicalName) {
        this.cWindow.getGraph().removeNode((Node)this.nodeAttr.getGraphObject(canonicalName));
        return true;
    }

    public boolean unhideEdges() {
        this.graphHider.unhideEdges();
        return true;
    }

    public boolean hideNode(String canonicalName) {
        this.graphHider.hide((Node)this.nodeAttr.getGraphObject(canonicalName));
        return true;
    }

    public boolean hideEdge(String canonicalName) {
        this.graphHider.hide((Edge)this.edgeAttr.getGraphObject(canonicalName));
        return true;
    }

    public boolean removeEdge(String canonicalName) {
        this.cWindow.getGraph().removeEdge((Edge)this.edgeAttr.getGraphObject(canonicalName));
        return true;
    }

    public boolean unhideNode(String canonicalName) {
        this.graphHider.unhide((Node)this.nodeAttr.getGraphObject(canonicalName));
        return true;
    }

    public boolean unhideEdge(String canonicalName) {
        this.graphHider.unhide((Edge)this.edgeAttr.getGraphObject(canonicalName));
        return true;
    }

    public boolean unhideAll() {
        this.graphHider.unhideAll();
        return true;
    }

    public boolean unhideAllNodes() {
        this.graphHider.unhideNodes();
        return true;
    }

    public boolean unhideAllEdges() {
        this.graphHider.unhideEdges();
        return true;
    }

    public Vector getConditionNames() {
        if (this.data == null) {
            return new Vector();
        }
        return this.stringArrayToVector(this.data.getConditionNames());
    }

    public Vector getGeneNames() {
        if (this.data == null) {
            return new Vector();
        }
        return this.data.getGeneNamesVector();
    }

    public double getMeasurement(String gene, String condition) {
        if (this.data == null) {
            return 0.0;
        }
        return this.data.getMeasurement(gene, condition).getRatio();
    }

    public double getMeasurementSignificance(String gene, String condition) {
        if (this.data == null) {
            return 0.0;
        }
        return this.data.getMeasurement(gene, condition).getSignificance();
    }

    public Vector getMeasurements(String condition) {
        if (this.data == null) {
            return new Vector();
        }
        Vector temp = this.data.getMeasurements(condition);
        Vector<Double> out = new Vector<Double>();
        int sz = temp.size();
        for (int i = 0; i < sz; ++i) {
            out.add(new Double(((mRNAMeasurement)temp.get(i)).getRatio()));
        }
        return out;
    }

    public Vector getMeasurementSignificances(String condition) {
        if (this.data == null) {
            return new Vector();
        }
        Vector temp = this.data.getMeasurements(condition);
        Vector<Double> out = new Vector<Double>();
        int sz = temp.size();
        for (int i = 0; i < sz; ++i) {
            out.add(new Double(((mRNAMeasurement)temp.get(i)).getSignificance()));
        }
        return out;
    }

    public Vector getDataMatrixNames() {
        String[] args = this.cWindow.getConfiguration().getArgs();
        Vector<String> list = new Vector<String>();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("--matrix")) continue;
            if (i + 1 > args.length) {
                throw new IllegalArgumentException("error! no --matrix value");
            }
            list.add(args[i + 1]);
        }
        return list;
    }

    public Vector getDataMatrixRowTitles(String matrixName) {
        DataMatrix mat = this.readDataMatrix(matrixName);
        return mat != null ? this.stringArrayToVector(mat.getRowTitles()) : new Vector();
    }

    public Vector getDataMatrixColumnTitles(String matrixName) {
        DataMatrix mat = this.readDataMatrix(matrixName);
        return mat != null ? this.stringArrayToVector(mat.getColumnTitles()) : new Vector();
    }

    public Vector getDataMatrix(String matrixName) {
        DataMatrix mat = this.readDataMatrix(matrixName);
        Vector rows = this.getDataMatrixRowTitles(matrixName);
        Vector<Vector> out = new Vector<Vector>();
        int sz = rows.size();
        for (int i = 0; i < sz; ++i) {
            String rowName = (String)rows.get(i);
            out.add(this.doubleArrayToVector(this.getRow(mat, rowName)));
        }
        return out;
    }

    public double getDataMatrixValue(String matrixName, String rowName, String colName) {
        DataMatrix mat = this.readDataMatrix(matrixName);
        double[] arr = this.getRow(mat, rowName);
        Vector cols = this.getDataMatrixColumnTitles(matrixName);
        int ind = -1;
        int nRows = mat.getRowCount();
        int sz = cols.size();
        for (int i = 0; i < sz; ++i) {
            if (!((String)cols.get(i)).equals(colName)) continue;
            ind = i;
            break;
        }
        if (arr != null && ind >= 0) {
            return arr[ind];
        }
        return 0.0;
    }

    public Vector getDataMatrixRow(String matrixName, String rowName) {
        DataMatrix mat = this.readDataMatrix(matrixName);
        return this.doubleArrayToVector(mat != null ? this.getRow(mat, rowName) : new double[]{});
    }

    public Hashtable getDataMatrixRows(String matrixName, Vector rowNames) {
        DataMatrix mat = this.readDataMatrix(matrixName);
        Hashtable<String, Vector> out = new Hashtable<String, Vector>();
        int sz = rowNames.size();
        for (int i = 0; i < sz; ++i) {
            String rowName = (String)rowNames.get(i);
            out.put(rowName, this.getDataMatrixRow(matrixName, rowName));
        }
        return out;
    }

    public Hashtable getDataMatrixAsRows(String matrixName) {
        return this.getDataMatrixRows(matrixName, this.getDataMatrixRowTitles(matrixName));
    }

    public Vector getDataMatrixColumn(String matrixName, String colName) {
        DataMatrix mat = this.readDataMatrix(matrixName);
        Vector cols = this.getDataMatrixColumnTitles(matrixName);
        int ind = -1;
        int nRows = mat.getRowCount();
        int sz = cols.size();
        for (int i = 0; i < sz; ++i) {
            if (!((String)cols.get(i)).equals(colName)) continue;
            ind = i;
            break;
        }
        Vector<Double> out = new Vector<Double>();
        if (ind >= 0) {
            for (int i = 0; i < nRows; ++i) {
                out.add(new Double(mat.get(i, ind)));
            }
        }
        return out;
    }

    public Hashtable getDataMatrixColumns(String matrixName, Vector colNames) {
        DataMatrix mat = this.readDataMatrix(matrixName);
        Hashtable<String, Vector> out = new Hashtable<String, Vector>();
        int sz = colNames.size();
        for (int i = 0; i < sz; ++i) {
            String colName = (String)colNames.get(i);
            out.put(colName, this.getDataMatrixColumn(matrixName, colName));
        }
        return out;
    }

    public Hashtable getDataMatrixAsColumns(String matrixName) {
        return this.getDataMatrixColumns(matrixName, this.getDataMatrixColumnTitles(matrixName));
    }

    public boolean addSelectionListener(CytoTalkSelectionListener list) {
        if (this.selectionListeners == null) {
            this.selectionListeners = new Vector();
        }
        if (!this.selectionListeners.contains(list)) {
            this.selectionListeners.add(list);
        }
        if (!this.added) {
            this.cWindow.getGraph().addGraph2DSelectionListener((Graph2DSelectionListener)this);
        }
        this.added = true;
        return true;
    }

    public boolean removeSelectionListener(CytoTalkSelectionListener list) {
        if (this.selectionListeners.contains(list)) {
            this.selectionListeners.remove(list);
        }
        if (this.selectionListeners.size() <= 0) {
            this.cWindow.getGraph().removeGraph2DSelectionListener((Graph2DSelectionListener)this);
            this.added = false;
        }
        return true;
    }

    public int newWindowEmpty() {
        CytoscapeWindow newWindow = this.cWindow.newWindowEmpty();
        return this.startNewCytoTalk(newWindow);
    }

    public int newWindowSelectedNodes() {
        CytoscapeWindow newWindow = this.cWindow.newWindowSelectedNodesOnly();
        return this.startNewCytoTalk(newWindow);
    }

    public int newWindowSelected() {
        CytoscapeWindow newWindow = this.cWindow.newWindowSelectedNodesEdges();
        return this.startNewCytoTalk(newWindow);
    }

    public int newWindowClone() {
        CytoscapeWindow newWindow = this.cWindow.cloneGraphInNewWindow();
        return this.startNewCytoTalk(newWindow);
    }

    public boolean closeWindow() {
        this.cWindow.close();
        this.shutdown();
        return true;
    }

    public void finalize() {
        try {
            this.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void shutdown() {
        if (this.server == null) {
            return;
        }
        this.server.removeService("cy");
        this.server.shutdown();
        this.server = null;
    }

    protected int startNewCytoTalk(CytoscapeWindow newWindow) {
        if (newWindow != null) {
            try {
                int localPort = CytoTalkPlugin.STATIC_PORT++;
                MyXmlRpcServer newServer = new MyXmlRpcServer(localPort);
                final CytoTalkHandler newHandler = new CytoTalkHandler(newWindow, newServer);
                newServer.addService("cy", newHandler);
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        try {
                            newHandler.shutdown();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                newWindow.getMainFrame().addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent we) {
                        try {
                            newHandler.shutdown();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                return localPort;
            }
            catch (Exception ee) {
                System.err.println("Could not start service: " + ee.getMessage());
            }
        }
        return -1;
    }

    public String getNodeAttributeClass(String attr) {
        return this.nodeAttr.getClass(attr) != null ? this.nodeAttr.getClass(attr).getName() : "";
    }

    public Vector getUniqueNodeAttributeValues(String attr) {
        return this.objArrayToVector(this.nodeAttr.getUniqueValues(attr));
    }

    protected void addVectorTo(Vector toVec, Vector inVec) {
        int sz = inVec.size();
        for (int i = 0; i < sz; ++i) {
            if (toVec.contains(inVec.get(i))) continue;
            toVec.add(inVec.get(i));
        }
    }

    protected Vector objArrayToVector(Object[] in) {
        Vector<Object> out = new Vector<Object>();
        if (in == null) {
            return out;
        }
        for (int i = 0; i < in.length; ++i) {
            Object obj = in[i];
            if (obj instanceof Vector || obj instanceof Hashtable || obj instanceof Double || obj instanceof Integer || obj instanceof Boolean) {
                out.add(obj);
                continue;
            }
            out.add(obj.toString());
        }
        return this.fixVectorForXmlRpc(out);
    }

    protected Vector stringArrayToVector(String[] in) {
        Vector<String> out = new Vector<String>();
        if (in == null) {
            return out;
        }
        for (int i = 0; i < in.length; ++i) {
            out.add(in[i].toString());
        }
        return out;
    }

    protected Vector doubleArrayToVector(double[] in) {
        Vector<Double> out = new Vector<Double>();
        if (in == null) {
            return out;
        }
        for (int i = 0; i < in.length; ++i) {
            out.add(new Double(in[i]));
        }
        return out;
    }

    protected Hashtable fixMapForXmlRpc(Map map) {
        Hashtable out = new Hashtable();
        if (map == null) {
            return out;
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Object next = it.next();
            Object obj = map.get(next);
            if (obj instanceof String || obj instanceof Double || obj instanceof Integer || obj instanceof Boolean) {
                out.put(next, obj);
                continue;
            }
            if (obj instanceof Vector) {
                out.put(next, this.fixVectorForXmlRpc((Vector)obj));
                continue;
            }
            if (obj instanceof Map) {
                out.put(next, this.fixMapForXmlRpc((Map)obj));
                continue;
            }
            out.put(next, obj.toString());
        }
        return out;
    }

    protected Vector fixVectorForXmlRpc(Vector v) {
        Vector out = new Vector();
        int sz = v.size();
        for (int i = 0; i < sz; ++i) {
            Object obj = v.get(i);
            if (obj instanceof String || obj instanceof Double || obj instanceof Integer || obj instanceof Boolean) {
                out.add(obj);
                continue;
            }
            if (obj instanceof Vector) {
                out.add(this.fixVectorForXmlRpc((Vector)obj));
                continue;
            }
            if (obj instanceof Map) {
                out.add(this.fixMapForXmlRpc((Map)obj));
                continue;
            }
            out.add(obj.toString());
        }
        return out;
    }

    protected Node[] selectedNodes() {
        NodeCursor nc = this.cWindow.getGraph().selectedNodes();
        Node[] nodes = new Node[nc.size()];
        int i = 0;
        while (nc.ok()) {
            nodes[i++] = nc.node();
            nc.next();
        }
        return nodes;
    }

    protected Edge[] selectedEdges() {
        EdgeCursor ec = this.cWindow.getGraph().selectedEdges();
        Edge[] edges = new Edge[ec.size()];
        int i = 0;
        while (ec.ok()) {
            edges[i++] = ec.edge();
            ec.next();
        }
        return edges;
    }

    protected double[] getRow(DataMatrix mat, String rowName) {
        String[] rowTitles = mat.getRowTitles();
        for (int i = 0; i < rowTitles.length; ++i) {
            if (!rowTitles[i].equals(rowName)) continue;
            return mat.get(i);
        }
        return null;
    }

    protected DataMatrix readDataMatrix(String matName) {
        if (this.dataMatrices != null && this.dataMatrices.get(matName) != null) {
            return (DataMatrix)this.dataMatrices.get(matName);
        }
        try {
            DataMatrixReader reader = DataMatrixReaderFactory.createReader(matName);
            reader.read();
            DataMatrix[] result = reader.get();
            if (this.dataMatrices == null) {
                this.dataMatrices = new HashMap();
            }
            this.dataMatrices.put(matName, result[0]);
            return result[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void selectionStateChanged(Graph2DSelectionEvent e) {
        System.err.println("IN selectionStateChanged()");
    }

    public void onGraph2DSelectionEvent(Graph2DSelectionEvent e) {
        if (this.selectionListeners.size() > 0 && e.isNodeSelection()) {
            Node n = (Node)e.getSubject();
            boolean sel = this.cWindow.getGraph().isSelected(n);
            String canonicalName = this.nodeAttr.getCanonicalName((Object)n);
            int sz = this.selectionListeners.size();
            for (int i = 0; i < sz; ++i) {
                ((CytoTalkSelectionListener)this.selectionListeners.get(i)).nodeSelected(canonicalName, sel);
            }
        }
    }

    public boolean splitAttributesOnSemis(boolean split) {
        SPLIT_ON_SEMIS = split;
        return split;
    }

    protected static Object parseAttribute(String value) {
        if (value.startsWith("http://")) {
            try {
                return new URL(value);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ("true".equals(value = value.trim())) {
            return new Boolean(true);
        }
        if ("false".equals(value)) {
            return new Boolean(false);
        }
        int intval = CytoTalkHandler.isIntParseable(value);
        if (intval != Integer.MIN_VALUE) {
            return new Integer(intval);
        }
        double val = CytoTalkHandler.isDoubleParseable(value);
        if (!Double.isNaN(val)) {
            return new Double(val);
        }
        if (SPLIT_ON_SEMIS && value.indexOf(59) >= 0 || value.indexOf(124) >= 0) {
            String[] toks = value.indexOf(59) >= 0 ? value.split("\\;") : value.split("\\|");
            Vector<Object> out = new Vector<Object>();
            for (int i = 0; i < toks.length; ++i) {
                Object o = CytoTalkHandler.parseAttribute(toks[i]);
                if (o.getClass().isArray()) {
                    Object[] oo = (Object[])o;
                    for (int j = 0; j < oo.length; ++j) {
                        out.add(oo[j]);
                    }
                    continue;
                }
                out.add(CytoTalkHandler.parseAttribute(toks[i]));
            }
            return CytoTalkHandler.vectorToArray(out);
        }
        return value;
    }

    protected static double isDoubleParseable(String s) {
        double out = Double.NaN;
        try {
            out = Double.parseDouble(s);
        }
        catch (Exception e) {
            out = Double.NaN;
        }
        return out;
    }

    protected static int isIntParseable(String s) {
        int out = Integer.MIN_VALUE;
        try {
            out = Integer.parseInt(s);
        }
        catch (Exception e) {
            out = Integer.MIN_VALUE;
        }
        return out;
    }

    protected static Object[] vectorToArray(Vector in) {
        if (in == null || in.size() <= 0) {
            return new Object[0];
        }
        Object[] out = new Object[in.size()];
        for (int i = 0; i < in.size(); ++i) {
            out[i] = in.get(i);
        }
        return out;
    }
}

