/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.readers;

import csplugins.isb.pshannon.experiment.metadata.Condition;
import csplugins.isb.pshannon.experiment.metadata.DataSetDescription;
import csplugins.isb.pshannon.experiment.metadata.MetaData;
import csplugins.isb.pshannon.experiment.metadata.Variable;
import csplugins.isb.pshannon.experiment.readers.TextHttpIndirectFileReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class MetaDataXmlParser {
    SAXBuilder builder;
    Document doc;
    String documentSource = "unknown";
    MetaData metaData;
    String uri;

    public MetaDataXmlParser(String string) throws Exception {
        boolean bl;
        this.uri = string;
        this.builder = new SAXBuilder();
        boolean bl2 = bl = string.indexOf("://") > 0;
        if (!bl || string.startsWith("file://")) {
            String string2 = bl ? string.substring(7) : string;
            this.doc = this.builder.build((InputStream)new FileInputStream(string2));
            this.documentSource = "localFile";
        } else if (string.startsWith("http://")) {
            this.doc = this.builder.build(string);
            this.documentSource = "web";
        } else if (string.startsWith("httpIndirect://")) {
            TextHttpIndirectFileReader textHttpIndirectFileReader = new TextHttpIndirectFileReader(string);
            textHttpIndirectFileReader.read();
            String string3 = textHttpIndirectFileReader.getText();
            File file = File.createTempFile("gaggle", "xml");
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string3, 0, string3.length());
            fileWriter.close();
            this.doc = this.builder.build((InputStream)new FileInputStream(file.getAbsolutePath()));
            this.documentSource = "webIndirect";
            file.delete();
        } else {
            throw new IllegalArgumentException("unrecognized data source protocol in uri: " + string);
        }
        this.parseDocument(this.doc);
    }

    protected void parseDocument(Document document) {
        try {
            Element element = document.getRootElement();
            String string = element.getAttribute("name").getValue();
            String string2 = element.getAttribute("date").getValue();
            this.metaData = new MetaData(string, string2);
            this.metaData.setPredicates(this.parsePredicates(element));
            this.metaData.setDataSetDescriptions(this.parseDataSetDescriptions(element));
            Condition[] conditionArray = this.parseConditions(element);
            for (int i = 0; i < conditionArray.length; ++i) {
                this.metaData.addCondition(conditionArray[i]);
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("illegal xml document: " + this.uri);
        }
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    protected HashMap parsePredicates(Element element) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Element[] elementArray = element.getChildren("predicate").toArray(new Element[0]);
        for (int i = 0; i < elementArray.length; ++i) {
            Element element2 = elementArray[i];
            String string = element2.getAttribute("category").getValue();
            String string2 = element2.getAttribute("value").getValue();
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    protected ArrayList parseDataSetDescriptions(Element element) {
        ArrayList<DataSetDescription> arrayList = new ArrayList<DataSetDescription>();
        Element[] elementArray = element.getChildren("dataset").toArray(new Element[0]);
        for (int i = 0; i < elementArray.length; ++i) {
            Element element2 = elementArray[i];
            String string = element2.getAttribute("status").getValue();
            String string2 = element2.getAttribute("type").getValue();
            String string3 = element2.getChild("uri").getTextTrim();
            DataSetDescription dataSetDescription = new DataSetDescription(string3, string, string2);
            arrayList.add(dataSetDescription);
        }
        return arrayList;
    }

    protected Condition[] parseConditions(Element element) {
        Element[] elementArray = element.getChildren("condition").toArray(new Element[0]);
        ArrayList<Condition> arrayList = new ArrayList<Condition>();
        for (int i = 0; i < elementArray.length; ++i) {
            Element element2 = elementArray[i];
            String string = element2.getAttribute("alias").getValue();
            Condition condition = new Condition(string);
            Element[] elementArray2 = element2.getChildren("variable").toArray(new Element[0]);
            for (int j = 0; j < elementArray2.length; ++j) {
                Element element3 = elementArray2[j];
                String string2 = element3.getAttribute("name").getValue();
                String string3 = element3.getAttribute("value").getValue();
                Attribute attribute = element3.getAttribute("units");
                String string4 = null;
                if (attribute != null) {
                    string4 = attribute.getValue();
                }
                condition.addVariable(new Variable(string2, string3, string4));
            }
            arrayList.add(condition);
        }
        return arrayList.toArray(new Condition[0]);
    }
}

