/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.gui.movie;

import csplugins.isb.pshannon.experiment.datamatrix.LensedDataMatrix;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class MovieControllerInfoDialog
extends JDialog {
    LensedDataMatrix[] lenses;
    JButton saveChangesButton;
    JTable[] allTables;
    static final String BRIEF_DATA_TYPE_KEY = "brief type name";

    public MovieControllerInfoDialog(LensedDataMatrix[] lensedDataMatrixArray) {
        this.lenses = lensedDataMatrixArray;
        this.setTitle("Movie Matrices Info");
        this.allTables = new JTable[lensedDataMatrixArray.length];
        this.getContentPane().add(this.createGui());
    }

    public JPanel createGui() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("Dimiss");
        jButton.addActionListener(new DismissAction());
        jPanel2.add(jButton);
        this.saveChangesButton = new JButton("Save Changes");
        this.saveChangesButton.setEnabled(false);
        this.saveChangesButton.addActionListener(new SaveChangesAction());
        jPanel2.add(this.saveChangesButton);
        jPanel.add((Component)jPanel2, "South");
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel.add((Component)jTabbedPane, "Center");
        for (int i = 0; i < this.lenses.length; ++i) {
            JTable jTable;
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BorderLayout());
            this.allTables[i] = jTable = new JTable(new InfoTableModel(this.lenses[i]));
            String string = this.lenses[i].getDataTypeBriefName();
            jTable.setShowHorizontalLines(true);
            jTable.setShowVerticalLines(true);
            jTable.setPreferredScrollableViewportSize(new Dimension(300, 200));
            JScrollPane jScrollPane = new JScrollPane(jTable);
            jScrollPane.setVerticalScrollBarPolicy(22);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BorderLayout());
            jPanel4.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            jPanel4.add((Component)jScrollPane, "Center");
            jPanel3.add(jPanel4);
            jTabbedPane.add(string, jPanel3);
        }
        return jPanel;
    }

    protected void placeInCenter() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        int n = (int)graphicsConfiguration.getBounds().getHeight();
        int n2 = (int)graphicsConfiguration.getBounds().getWidth();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        this.setLocation((n2 - n3) / 2, (n - n4) / 2);
    }

    public class SaveChangesAction
    extends AbstractAction {
        SaveChangesAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < MovieControllerInfoDialog.this.allTables.length; ++i) {
                JTable jTable = MovieControllerInfoDialog.this.allTables[i];
                for (int j = 0; j < jTable.getRowCount(); ++j) {
                    String string = (String)MovieControllerInfoDialog.this.allTables[i].getValueAt(j, 0);
                    if (!string.equals(MovieControllerInfoDialog.BRIEF_DATA_TYPE_KEY)) continue;
                    String string2 = (String)MovieControllerInfoDialog.this.allTables[i].getValueAt(j, 1);
                    MovieControllerInfoDialog.this.lenses[i].setDataTypeBriefName(string2);
                }
            }
        }
    }

    public class DismissAction
    extends AbstractAction {
        DismissAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MovieControllerInfoDialog.this.dispose();
        }
    }

    class InfoTableModel
    extends AbstractTableModel {
        LensedDataMatrix lens;
        String[] columnNames = new String[]{"name", "value"};
        HashMap map;

        InfoTableModel(LensedDataMatrix lensedDataMatrix) {
            this.lens = lensedDataMatrix;
            lensedDataMatrix.enableAllRows();
            this.map = new HashMap();
            this.map.put(MovieControllerInfoDialog.BRIEF_DATA_TYPE_KEY, lensedDataMatrix.getDataTypeBriefName());
            this.map.put("uri", lensedDataMatrix.getFullName());
            this.map.put("rows", new Integer(lensedDataMatrix.getRowCount()).toString());
            this.map.put("columns", new Integer(lensedDataMatrix.getColumnCount()).toString());
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getRowCount() {
            return this.map.size();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public void setValueAt(Object object, int n, int n2) {
            String[] stringArray = this.getDataKeys();
            if (stringArray[n].equals(MovieControllerInfoDialog.BRIEF_DATA_TYPE_KEY) && n2 == 1) {
                this.map.put(MovieControllerInfoDialog.BRIEF_DATA_TYPE_KEY, (String)object);
                MovieControllerInfoDialog.this.saveChangesButton.setEnabled(true);
            }
        }

        public Object getValueAt(int n, int n2) {
            String[] stringArray = this.getDataKeys();
            String string = "";
            if (n2 == 0) {
                string = stringArray[n];
            } else if (n2 == 1) {
                string = (String)this.map.get(stringArray[n]);
            }
            return string;
        }

        public boolean isCellEditable(int n, int n2) {
            boolean bl = false;
            String[] stringArray = this.getDataKeys();
            if (stringArray[n].equals(MovieControllerInfoDialog.BRIEF_DATA_TYPE_KEY) && n2 == 1) {
                bl = true;
            }
            return bl;
        }

        public Class getColumnClass(int n) {
            return "string".getClass();
        }

        protected String[] getDataKeys() {
            return this.map.keySet().toArray(new String[0]);
        }
    }
}

