/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.gui.actions;

import csplugins.isb.pshannon.experiment.datamatrix.DataMatrix;
import csplugins.vectormath.MathVector;
import csplugins.vectormath.MathVectorFactory;
import csplugins.vectormath.ReadOnlyMathVector;
import java.util.HashMap;
import java.util.Map;

public class CorrelationFinder {
    private DataMatrix matrix;
    private Map myTable = new HashMap();

    public CorrelationFinder() {
    }

    public CorrelationFinder(DataMatrix dataMatrix) {
        this.setDataMatrix(dataMatrix);
    }

    public void setDataMatrix(DataMatrix dataMatrix) {
        this.matrix = dataMatrix;
    }

    public Map buildCorrelationTable(String string) {
        this.myTable.clear();
        if (this.matrix == null) {
            return this.myTable;
        }
        double[] dArray = this.matrix.get(string);
        if (dArray.length == 0) {
            return this.myTable;
        }
        ReadOnlyMathVector readOnlyMathVector = MathVectorFactory.makeReadOnlyVector(dArray);
        return this.buildCorrelationTable(readOnlyMathVector);
    }

    public Map buildCorrelationTable(String[] stringArray) {
        this.myTable.clear();
        if (this.matrix == null || stringArray == null || stringArray.length == 0) {
            return this.myTable;
        }
        int n = this.matrix.getColumnCount();
        double[] dArray = new double[n];
        MathVector mathVector = MathVectorFactory.makeVector(dArray);
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            double[] dArray2 = this.matrix.get(stringArray[i]);
            ReadOnlyMathVector readOnlyMathVector = MathVectorFactory.makeReadOnlyVector(dArray2);
            mathVector.add(readOnlyMathVector.copy().normalize());
            ++n2;
        }
        if (n2 == 0) {
            return this.myTable;
        }
        mathVector.times(1.0 / (double)n2);
        return this.buildCorrelationTable(mathVector);
    }

    public Map buildCorrelationTable(ReadOnlyMathVector readOnlyMathVector) {
        this.myTable.clear();
        int n = this.matrix.getColumnCount();
        if (readOnlyMathVector.size() != n) {
            return this.myTable;
        }
        String[] stringArray = this.matrix.getRowTitles();
        for (int i = 0; i < stringArray.length; ++i) {
            double[] dArray = this.matrix.get(stringArray[i]);
            ReadOnlyMathVector readOnlyMathVector2 = MathVectorFactory.makeReadOnlyVector(dArray);
            Double d = new Double(readOnlyMathVector.dotNorm(readOnlyMathVector2));
            this.myTable.put(stringArray[i], d);
        }
        return this.myTable;
    }

    public Map oldBuildCorrelationTable(ReadOnlyMathVector readOnlyMathVector) {
        this.myTable.clear();
        int n = this.matrix.getColumnCount();
        if (readOnlyMathVector.size() != n) {
            return this.myTable;
        }
        String[] stringArray = this.matrix.getRowTitles();
        for (int i = 0; i < stringArray.length; ++i) {
            double[] dArray = this.matrix.get(stringArray[i]);
            ReadOnlyMathVector readOnlyMathVector2 = MathVectorFactory.makeReadOnlyVector(dArray);
            Double d = new Double(readOnlyMathVector.dotNorm(readOnlyMathVector2));
            this.myTable.put(stringArray[i], d);
        }
        return this.myTable;
    }

    public Map getCorrelationTable() {
        return this.myTable;
    }
}

