/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.gui;

import csplugins.isb.pshannon.experiment.datamatrix.DataMatrix;
import csplugins.isb.pshannon.experiment.datamatrix.MatrixCombiner;
import csplugins.isb.pshannon.experiment.datamatrix.MatrixSlicer;
import csplugins.isb.pshannon.experiment.gui.DataMatrixViewer;
import csplugins.isb.pshannon.experiment.gui.actions.IconFactory;
import csplugins.isb.pshannon.experiment.gui.movie.MovieController;
import csplugins.isb.pshannon.experiment.metadata.MetaData;
import csplugins.isb.pshannon.experiment.metadata.MetaDataNavigator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class TreeDataViewer
implements TreeSelectionListener,
WindowListener {
    ArrayList currentTreeSelection;
    DataMatrixViewer dataMatrixViewer;
    MetaDataNavigator experimentNavigator;
    ArrayList currentlySelectedExperiments;
    ArrayList experiments;
    JFrame jframe;
    JToolBar toolbar;
    JPanel toolbarEtcPanel;
    JScrollPane treePane;
    JPanel resultsPanel;
    JSplitPane outerSplitPane;
    JTree treeWidget;
    JButton newRepositoryButton;
    JButton loadSelectedConditionsButton;
    JTextField conditionCounterTextField;
    boolean dataBrowserHasEntireWindow;
    File currentDirectory;
    int selectedConditionCount;
    MovieController movieController;
    String repository;

    public TreeDataViewer() {
        this(null);
    }

    public TreeDataViewer(String string) {
        this.repository = string;
        this.currentTreeSelection = new ArrayList();
        this.currentlySelectedExperiments = new ArrayList();
        this.experiments = new ArrayList();
        this.createFrame();
    }

    public void setMovieController(MovieController movieController) {
        this.movieController = movieController;
    }

    public JFrame getMainFrame() {
        return this.jframe;
    }

    public JToolBar getToolBar() {
        return this.toolbar;
    }

    public JPanel getToolbarEtcPanel() {
        return this.toolbarEtcPanel;
    }

    public DataMatrixViewer getDataMatrixViewer() {
        return this.dataMatrixViewer;
    }

    protected String createFrameTitle() {
        String string = "$Revision: 1.5 $";
        String string2 = "Revision: ";
        int n = string.indexOf(string2);
        int n2 = string.indexOf(" $", n += string2.length());
        String string3 = string.substring(n, n2);
        return "Data Matrix Browser " + string3;
    }

    protected void createFrame() {
        this.jframe = new JFrame();
        this.jframe.setTitle(this.createFrameTitle());
        this.jframe.setSize(800, 600);
        this.jframe.setDefaultCloseOperation(2);
        this.jframe.addWindowListener(this);
        this.currentDirectory = new File(System.getProperty("user.dir"));
        this.jframe.getContentPane().add(this.createGui());
        this.jframe.show();
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    public void windowLostFocus(WindowEvent windowEvent) {
    }

    protected void createTreeNodes(DefaultMutableTreeNode defaultMutableTreeNode, HashMap hashMap) {
        Object[] objectArray = hashMap.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(objectArray[i]);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.createTreeNodes(defaultMutableTreeNode2, (HashMap)hashMap.get(objectArray[i]));
        }
    }

    protected void updateCurrentTreeSelection(TreeSelectionEvent treeSelectionEvent) {
        TreePath[] treePathArray = treeSelectionEvent.getPaths();
        for (int i = 0; i < treePathArray.length; ++i) {
            TreePath treePath = treePathArray[i];
            boolean bl = treeSelectionEvent.isAddedPath(treePath);
            if (bl) {
                this.currentTreeSelection.add(treePath);
                continue;
            }
            if (!this.currentTreeSelection.contains(treePath)) continue;
            this.currentTreeSelection.remove(treePath);
        }
    }

    protected HashMap convertTreePathsToHash(ArrayList arrayList) {
        HashMap<String, ArrayList> hashMap = new HashMap<String, ArrayList>();
        TreePath[] treePathArray = arrayList.toArray(new TreePath[0]);
        for (int i = 0; i < treePathArray.length; ++i) {
            TreePath treePath = treePathArray[i];
            Object[] objectArray = treePath.getPath();
            String[] stringArray = new String[objectArray.length - 1];
            for (int j = 1; j < objectArray.length; ++j) {
                stringArray[j - 1] = ((DefaultMutableTreeNode)objectArray[j]).toString();
            }
            ArrayList arrayList2 = this.experimentNavigator.findExperimentKeyForPerturbation(stringArray);
            for (int j = 0; j < arrayList2.size(); ++j) {
                ArrayList arrayList3;
                String[] stringArray2 = (String[])arrayList2.get(j);
                String string = stringArray2[0];
                String string2 = stringArray2[1];
                if (string2 == null) {
                    string2 = "";
                }
                if (!hashMap.containsKey(string)) {
                    hashMap.put(string, new ArrayList());
                }
                if (!(arrayList3 = (ArrayList)hashMap.get(string)).contains(string2)) {
                    arrayList3.add(string2);
                }
                hashMap.put(string, arrayList3);
            }
        }
        return hashMap;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object object;
        this.updateCurrentTreeSelection(treeSelectionEvent);
        if (this.currentTreeSelection.size() == 0) {
            this.loadSelectedConditionsButton.setEnabled(false);
            this.conditionCounterTextField.setText("0");
            this.currentTreeSelection = new ArrayList();
            MetaData[] metaDataArray = this.currentlySelectedExperiments.toArray(new MetaData[0]);
            for (int i = 0; i < metaDataArray.length; ++i) {
                metaDataArray[i].clearSelectionCriteria();
            }
            return;
        }
        this.loadSelectedConditionsButton.setEnabled(true);
        HashMap hashMap = this.convertTreePathsToHash(this.currentTreeSelection);
        String[] stringArray = hashMap.keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            object = (ArrayList)hashMap.get(string);
        }
        if (hashMap == null || hashMap.size() == 0) {
            this.loadSelectedConditionsButton.setEnabled(false);
            this.conditionCounterTextField.setText("0");
            this.currentTreeSelection = new ArrayList();
            MetaData[] metaDataArray = this.currentlySelectedExperiments.toArray(new MetaData[0]);
            for (int i = 0; i < metaDataArray.length; ++i) {
                metaDataArray[i].clearSelectionCriteria();
            }
            return;
        }
        this.currentlySelectedExperiments = new ArrayList();
        this.selectedConditionCount = 0;
        String[] stringArray2 = hashMap.keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray2.length; ++i) {
            object = stringArray2[i];
            MetaData[] metaDataArray = this.experimentNavigator.getExperimentByPerturbationList((String)object);
            for (int j = 0; j < metaDataArray.length; ++j) {
                MetaData metaData = metaDataArray[j];
                metaData.clearSelectionCriteria();
                if (!this.currentlySelectedExperiments.contains(metaData)) {
                    this.currentlySelectedExperiments.add(metaData);
                }
                ArrayList arrayList = (ArrayList)hashMap.get(object);
                metaData = this.makeSelections(metaData, arrayList);
                this.selectedConditionCount += metaData.getSelectedConditionsAsAliases().length;
            }
        }
        this.conditionCounterTextField.setText(new Integer(this.selectedConditionCount).toString());
    }

    protected MetaData makeSelections(MetaData metaData, ArrayList arrayList) {
        String[] stringArray = arrayList.toArray(new String[0]);
        if (stringArray.length == 0) {
            metaData.selectAllConditions();
        } else if (stringArray.length == 1 && stringArray[0].length() == 0) {
            metaData.selectAllConditions();
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split(":");
                if (stringArray2.length == 1) {
                    metaData.selectConditionByName(stringArray2[0]);
                    continue;
                }
                if (stringArray2.length != 2) continue;
                String string = stringArray2[0];
                String string2 = stringArray2[1];
                metaData.addSelectionCriterion(string, string2);
            }
        }
        return metaData;
    }

    protected void expandTree() {
        boolean bl = false;
        while (!bl) {
            int n;
            for (int i = n = this.treeWidget.getRowCount(); i > 0; --i) {
                this.treeWidget.expandRow(i);
            }
            if (n != this.treeWidget.getRowCount()) continue;
            bl = true;
        }
    }

    public void addRepository(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Experiments");
        if (string != null && string.length() > 0) {
            try {
                this.experimentNavigator = new MetaDataNavigator(string);
                HashMap hashMap = this.experimentNavigator.getTree();
                this.createTreeNodes(defaultMutableTreeNode, hashMap);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.jframe, exception.getMessage());
            }
        }
        this.treeWidget = new JTree(defaultMutableTreeNode);
        this.treeWidget.getSelectionModel().setSelectionMode(4);
        this.treeWidget.addTreeSelectionListener(this);
        this.treePane.setViewportView(this.treeWidget);
    }

    protected JPanel createGui() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this.treePane = new JScrollPane();
        this.addRepository(this.repository);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)this.treePane, "Center");
        JPanel jPanel4 = new JPanel();
        JLabel jLabel = new JLabel("Selection: ");
        jPanel4.add(jLabel);
        this.conditionCounterTextField = new JTextField(5);
        this.conditionCounterTextField.setToolTipText("Number of columns explicitly selected in tree");
        jPanel4.add(this.conditionCounterTextField);
        jPanel3.add((Component)jPanel4, "South");
        this.resultsPanel = new JPanel();
        this.resultsPanel.setLayout(new BorderLayout());
        this.outerSplitPane = new JSplitPane(1, jPanel3, this.resultsPanel);
        this.outerSplitPane.setDividerLocation(200);
        this.outerSplitPane.setOneTouchExpandable(true);
        this.dataBrowserHasEntireWindow = false;
        jPanel.add((Component)this.outerSplitPane, "Center");
        JButton jButton = new JButton(IconFactory.getDismissIcon());
        jButton.addActionListener(new DismissAction());
        jButton.setBackground(Color.WHITE);
        jButton.setToolTipText("Close This Window");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 20, 5, 0);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(5, 0, 5, 20);
        jPanel5.add((Component)jButton, gridBagConstraints);
        jPanel.add((Component)jPanel5, "South");
        this.toolbar = new JToolBar();
        this.toolbarEtcPanel = new JPanel();
        this.toolbarEtcPanel.setLayout(new BorderLayout());
        this.toolbarEtcPanel.add((Component)this.toolbar, "West");
        jPanel.add((Component)this.toolbarEtcPanel, "North");
        this.newRepositoryButton = new JButton("New...");
        this.newRepositoryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeDataViewer.this.chooseNewRepositoryDirectory();
            }
        });
        this.toolbar.add(this.newRepositoryButton);
        this.loadSelectedConditionsButton = new JButton(IconFactory.getLoadSelectedConditionsIcon());
        this.loadSelectedConditionsButton.addActionListener(new LoadSelectedConditionsAction());
        this.loadSelectedConditionsButton.setBackground(Color.WHITE);
        this.loadSelectedConditionsButton.setToolTipText("Load Selected Conditions");
        this.loadSelectedConditionsButton.setEnabled(false);
        this.toolbar.add(this.loadSelectedConditionsButton);
        JButton jButton2 = new JButton(IconFactory.getExpandAndContractIcon());
        jButton2.addActionListener(new ExpandContractDataBrowserAction());
        jButton2.setToolTipText("Expand/Contract");
        jButton2.setBackground(Color.WHITE);
        this.toolbar.add(jButton2);
        return jPanel;
    }

    protected void chooseNewRepositoryDirectory() {
        File file;
        JFileChooser jFileChooser = new JFileChooser(this.currentDirectory);
        jFileChooser.setFileFilter(new RepositoryFilter());
        jFileChooser.setFileSelectionMode(2);
        int n = jFileChooser.showOpenDialog(this.jframe);
        if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            this.currentDirectory = jFileChooser.getCurrentDirectory();
            this.addRepository(file.getPath());
        }
    }

    protected DataMatrix[] combineSelectedConditions() {
        Object object;
        DataMatrix[] dataMatrixArray;
        Object object2;
        Object object3;
        String[] stringArray;
        if (this.currentlySelectedExperiments.size() == 0) {
            return new DataMatrix[0];
        }
        HashMap hashMap = new HashMap();
        for (int i = 0; i < this.currentlySelectedExperiments.size(); ++i) {
            stringArray = (String[])this.currentlySelectedExperiments.get(i);
            String string = stringArray.getTitle();
            object3 = stringArray.getSelectedConditionsAsAliases();
            if (((String[])object3).length <= 0) continue;
            object2 = new MatrixSlicer((MetaData)stringArray);
            try {
                dataMatrixArray = ((MatrixSlicer)object2).slice();
                object = dataMatrixArray.keySet().toArray(new String[0]);
                for (int j = 0; j < ((String[])object).length; ++j) {
                    Object object4 = object[j];
                    DataMatrix dataMatrix = (DataMatrix)dataMatrixArray.get(object4);
                    if (!hashMap.containsKey(object4)) {
                        hashMap.put(object4, new ArrayList());
                    }
                    ((ArrayList)hashMap.get(object4)).add(dataMatrix);
                }
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        ArrayList<DataMatrix> arrayList = new ArrayList<DataMatrix>();
        stringArray = hashMap.keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            object3 = stringArray[i];
            object2 = (ArrayList)hashMap.get(object3);
            dataMatrixArray = ((ArrayList)object2).toArray(new DataMatrix[0]);
            object = new MatrixCombiner(dataMatrixArray);
            DataMatrix dataMatrix = ((MatrixCombiner)object).combine();
            dataMatrix.setFullName("(from TreeDataViewer)");
            dataMatrix.setShortName((String)object3);
            dataMatrix.setDataTypeBriefName((String)object3);
            arrayList.add(dataMatrix);
        }
        return arrayList.toArray(new DataMatrix[0]);
    }

    public static void main(String[] stringArray) {
        TreeDataViewer treeDataViewer = new TreeDataViewer();
    }

    public class ExpandContractDataBrowserAction
    extends AbstractAction {
        ExpandContractDataBrowserAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (TreeDataViewer.this.dataBrowserHasEntireWindow) {
                int n = TreeDataViewer.this.outerSplitPane.getLastDividerLocation();
                TreeDataViewer.this.outerSplitPane.setDividerLocation(n);
                TreeDataViewer.this.dataBrowserHasEntireWindow = false;
            } else {
                TreeDataViewer.this.outerSplitPane.setDividerLocation(0);
                TreeDataViewer.this.dataBrowserHasEntireWindow = true;
            }
        }
    }

    public class LoadSelectedConditionsAction
    extends AbstractAction {
        LoadSelectedConditionsAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataMatrix[] dataMatrixArray = TreeDataViewer.this.combineSelectedConditions();
            if (dataMatrixArray.length == 0) {
                return;
            }
            if (TreeDataViewer.this.dataMatrixViewer != null) {
                for (int i = 0; i < dataMatrixArray.length; ++i) {
                    TreeDataViewer.this.dataMatrixViewer.addMatrixSpreadsheetView(dataMatrixArray[i]);
                }
            } else {
                try {
                    TreeDataViewer.this.dataMatrixViewer = new DataMatrixViewer(dataMatrixArray);
                    TreeDataViewer.this.resultsPanel.add((Component)TreeDataViewer.this.dataMatrixViewer, "Center");
                    TreeDataViewer.this.resultsPanel.paintAll(TreeDataViewer.this.resultsPanel.getGraphics());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (TreeDataViewer.this.movieController != null) {
                TreeDataViewer.this.movieController.loadMatrices();
            }
        }
    }

    public class AddSourceAction
    extends AbstractAction {
        AddSourceAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(TreeDataViewer.this.currentDirectory);
            jFileChooser.setFileSelectionMode(1);
            int n = jFileChooser.showOpenDialog(TreeDataViewer.this.jframe);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                String string = file.getPath();
                TreeDataViewer.this.currentDirectory = jFileChooser.getCurrentDirectory();
            }
        }
    }

    public class DismissAction
    extends AbstractAction {
        DismissAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreeDataViewer.this.dataMatrixViewer = null;
            TreeDataViewer.this.jframe.dispose();
            System.exit(0);
        }
    }

    class RepositoryFilter
    extends FileFilter {
        RepositoryFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            return string.endsWith(".xml");
        }

        public String getDescription() {
            return "directories and xml files";
        }
    }
}

