/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.gui;

import csplugins.isb.dtenenbaum.nameHelper.NameHelper;
import csplugins.isb.dtenenbaum.nameHelper.NameHelperFactory;
import csplugins.isb.pshannon.experiment.datamatrix.DataMatrix;
import csplugins.isb.pshannon.experiment.datamatrix.LensedDataMatrix;
import csplugins.isb.pshannon.experiment.gui.CheckBoxHeader;
import csplugins.isb.pshannon.experiment.gui.DataMatrixTableModel;
import csplugins.isb.pshannon.experiment.gui.DataMatrixView;
import csplugins.isb.pshannon.experiment.gui.MatrixViewCoordinator;
import csplugins.isb.pshannon.experiment.gui.MutableList;
import csplugins.isb.pshannon.experiment.gui.actions.CorrelationFinderDialog;
import csplugins.isb.pshannon.experiment.gui.actions.IconFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class MatrixSpreadsheet
extends JPanel
implements DataMatrixView {
    protected DataMatrix matrix;
    protected String name;
    protected LensedDataMatrix lens;
    protected NameHelper nameHelper;
    protected MatrixViewCoordinator matrixViewCoordinator;
    protected JTable table;
    protected JTextField selectionCountTextField;
    protected JButton nameTypeButton;
    private boolean sortOrderAscending = false;
    private boolean unsorted = true;
    private boolean calculateByDataWidth = false;
    HashMap columnCheckBoxHeaderMap;
    protected JPanel buttonPanel;
    protected JPanel controlPanel;
    protected JPanel movieController;
    protected MutableList rowHeader;
    protected int preferredTableWidth = 600;
    protected int preferredTableHeight = 100;
    private Timer dragTimer;
    private int dragFrom = -1;
    private int dragTo = -1;
    static /* synthetic */ Class class$csplugins$isb$pshannon$experiment$gui$MatrixSpreadsheet;

    public MatrixSpreadsheet(DataMatrix dataMatrix, MatrixViewCoordinator matrixViewCoordinator) throws Exception {
        this.matrix = dataMatrix;
        this.name = dataMatrix.getShortName();
        this.matrixViewCoordinator = matrixViewCoordinator;
        this.lens = new LensedDataMatrix(dataMatrix);
        this.nameHelper = NameHelperFactory.getNameHelper();
        this.createPanel(dataMatrix);
    }

    public MatrixSpreadsheet(DataMatrix dataMatrix) throws Exception {
        this(dataMatrix, null);
    }

    public String getClassName() {
        return "MatrixSpreadsheet";
    }

    public String getName() {
        return this.name;
    }

    public void clearSelection() {
        this.table.clearSelection();
        this.selectionCountTextField.setText("0");
        this.enableAllColumns();
    }

    public String getSpecies() {
        return this.matrix.getSpecies();
    }

    public void select(String[] stringArray) {
        this.select(this.getSpecies(), stringArray);
    }

    public void select(String string, String[] stringArray) {
        List<String> list = Arrays.asList(stringArray);
        String[] stringArray2 = this.matrix.getRowTitles();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this.lens.getRowTitles()));
        int n = arrayList.size();
        for (int i = 0; i < stringArray2.length; ++i) {
            String string2 = stringArray2[i];
            boolean bl = list.contains(string2);
            if (!bl || arrayList.contains(string2)) continue;
            this.table.getSelectionModel().addSelectionInterval(i, i);
            ++n;
        }
        String string3 = new Integer(n).toString();
        this.selectionCountTextField.setText(string3);
    }

    public String[] getSelection() {
        return this.lens.getRowTitles();
    }

    public LensedDataMatrix getLens() {
        return this.lens;
    }

    public void createPanel(DataMatrix dataMatrix) {
        String string;
        JComponent jComponent;
        Object object;
        DataMatrixTableModel dataMatrixTableModel = new DataMatrixTableModel(dataMatrix);
        this.columnCheckBoxHeaderMap = new HashMap();
        this.table = new JTable(dataMatrixTableModel);
        this.table.setShowGrid(true);
        int[] nArray = this.calculateColumnWidths(this.table, dataMatrix, this.calculateByDataWidth);
        this.rowHeader = new MutableList(dataMatrix.getRowTitles());
        this.rowHeader.setFixedCellWidth(100);
        this.rowHeader.setFixedCellHeight(this.table.getRowHeight());
        this.rowHeader.setCellRenderer(new RowHeaderRenderer(this.table));
        this.table.getColumnModel().addColumnModelListener(new TableColumnMovedListener());
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            ((TableColumn)object).setPreferredWidth(nArray[n]);
            jComponent = new CheckBoxHeader(new TableHeaderCheckboxListener());
            string = dataMatrix.getColumnTitles()[n];
            this.columnCheckBoxHeaderMap.put(string, jComponent);
            ((TableColumn)object).setHeaderRenderer((TableCellRenderer)((Object)jComponent));
            ++n;
        }
        object = this.table.getSelectionModel();
        object.addListSelectionListener(new TableSelectionListener(this.table, dataMatrix));
        this.table.setSelectionModel((ListSelectionModel)object);
        this.table.setPreferredScrollableViewportSize(new Dimension(this.preferredTableWidth, this.preferredTableHeight));
        jComponent = new JScrollPane(this.table);
        ((JScrollPane)jComponent).setRowHeaderView(this.rowHeader);
        ((JScrollPane)jComponent).setHorizontalScrollBarPolicy(32);
        this.table.setAutoResizeMode(0);
        string = dataMatrix.getShortName();
        String string2 = "";
        int n2 = string.lastIndexOf(".");
        if (n2 > 0 && n2 < string.length() - 1) {
            string2 = string.substring(n2 + 1);
        }
        if (string.indexOf(46) < 0) {
            string2 = string;
        }
        this.controlPanel = this.createControlPanel(string2);
        this.setLayout(new BorderLayout());
        this.add((Component)this.controlPanel, "North");
        this.add((Component)jComponent, "Center");
    }

    private int[] calculateColumnWidths(JTable jTable, DataMatrix dataMatrix, boolean bl) {
        String[] stringArray = dataMatrix.getColumnTitles();
        int n = stringArray.length;
        int n2 = 100;
        int[] nArray = new int[n];
        FontMetrics fontMetrics = jTable.getFontMetrics(jTable.getFont());
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4;
            String string;
            if (bl) {
                string = "";
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    String string2 = "" + dataMatrix.get(n4, i);
                    if (string2.length() <= string.length()) continue;
                    string = string2;
                }
            } else {
                string = stringArray[i];
            }
            nArray[i] = (n3 = (int)((double)(n4 = fontMetrics.stringWidth(string)) * 1.4)) > n2 ? n3 : n2;
        }
        return nArray;
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    private void doPlot(LensedDataMatrix lensedDataMatrix) {
        if (this.matrixViewCoordinator != null) {
            this.matrixViewCoordinator.doPlot(lensedDataMatrix);
        }
    }

    protected JPanel createControlPanel(String string) {
        this.controlPanel = new JPanel();
        String string2 = "<html>Change the type of name displayed<br>in the row headers</HTML>";
        this.nameTypeButton = new JButton(IconFactory.getToggleIcon());
        this.nameTypeButton.setBackground(Color.WHITE);
        this.nameTypeButton.setToolTipText(string2);
        this.nameTypeButton.setActionCommand("1");
        this.nameTypeButton.addActionListener(new NameTypeChangeListener());
        this.controlPanel.add(this.nameTypeButton);
        JButton jButton = new JButton(IconFactory.getPlotIcon());
        this.controlPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MatrixSpreadsheet.this.doPlot(MatrixSpreadsheet.this.lens);
            }
        });
        JButton jButton2 = new JButton(IconFactory.getFindCorrelationsIcon());
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CorrelationFinderDialog correlationFinderDialog = new CorrelationFinderDialog(MatrixSpreadsheet.this);
                correlationFinderDialog.pack();
                correlationFinderDialog.setVisible(true);
            }
        });
        this.controlPanel.add(jButton2);
        JButton jButton3 = new JButton(IconFactory.getSortIcon());
        jButton3.setBackground(Color.WHITE);
        jButton3.setToolTipText("<html>Sort data in alphanumeric order (in all matrices)<br>sorting by the currently selected name type.<BR>Toggles between descending and ascending sort order.</html>");
        jButton3.addActionListener(new SortButtonListener());
        this.controlPanel.add(jButton3);
        JButton jButton4 = new JButton(IconFactory.getFitColumnWidthIcon());
        jButton4.setBackground(Color.WHITE);
        jButton4.setToolTipText("Toggle column width");
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MatrixSpreadsheet.this.calculateByDataWidth = !MatrixSpreadsheet.this.calculateByDataWidth;
                MatrixSpreadsheet.this.recalculateColumnWidth();
            }
        });
        this.controlPanel.add(jButton4);
        this.selectionCountTextField = new JTextField("0", 5);
        this.selectionCountTextField.setEditable(false);
        this.controlPanel.add(new JLabel("Selected "));
        this.controlPanel.add(this.selectionCountTextField);
        JButton jButton5 = new JButton("Clear");
        jButton5.setToolTipText("Clear selections: enable all columns, deselect all rows");
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MatrixSpreadsheet.this.clearSelection();
            }
        });
        this.controlPanel.add(jButton5);
        return this.controlPanel;
    }

    protected void addActions() {
    }

    public void recalculateColumnWidth() {
        int[] nArray = this.calculateColumnWidths(this.table, this.matrix, this.calculateByDataWidth);
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setPreferredWidth(nArray[n]);
            ++n;
        }
    }

    public void doSort(boolean bl) {
        Object[] objectArray;
        Hashtable<Object, Integer> hashtable = new Hashtable<Object, Integer>();
        Hashtable<Object[], String> hashtable2 = new Hashtable<Object[], String>();
        for (int i = 0; i < this.table.getSelectedRowCount(); ++i) {
            objectArray = (Object[])this.rowHeader.getContents().getElementAt(this.table.getSelectedRows()[i]);
            hashtable2.put(objectArray, "nothing");
        }
        Object[] objectArray2 = new Object[this.rowHeader.getContents().size()];
        objectArray = new Object[this.rowHeader.getOriginalValues().size()];
        this.rowHeader.getContents().copyInto(objectArray2);
        this.rowHeader.getOriginalValues().copyInto(objectArray);
        if (bl) {
            Arrays.sort(objectArray2);
        } else {
            Arrays.sort(objectArray2, new Comparator(){

                public int compare(Object object, Object object2) {
                    Comparable comparable = (Comparable)object;
                    Comparable comparable2 = (Comparable)object2;
                    return comparable2.compareTo(comparable);
                }
            });
        }
        this.rowHeader.changeList(objectArray2);
        for (int i = 0; i < objectArray.length; ++i) {
            hashtable.put(objectArray[i], new Integer(i));
        }
        int[] nArray = new int[this.rowHeader.getContents().size()];
        for (int i = 0; i < objectArray2.length; ++i) {
            int n;
            nArray[i] = n = ((Integer)hashtable.get(objectArray2[i])).intValue();
        }
        DataMatrixTableModel dataMatrixTableModel = (DataMatrixTableModel)this.table.getModel();
        dataMatrixTableModel.setNewRowIndices(nArray);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        if (!listSelectionModel.isSelectionEmpty()) {
            this.table.clearSelection();
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                String string = (String)this.rowHeader.getContents().getElementAt(i);
                if (null == hashtable2.get(string)) continue;
                this.table.addRowSelectionInterval(i, i);
            }
        }
        this.table.repaint();
    }

    public void selectSubTable(String[] stringArray, String[] stringArray2) {
        this.clearSelection();
        this.disableAllColumns();
        if (!this.columnNamesIntersect(stringArray2)) {
            return;
        }
        if (!this.rowNamesIntersect(stringArray)) {
            return;
        }
        this.select(this.matrix.getSpecies(), stringArray);
        this.disableAllColumns();
        this.enableColumnsByName(stringArray2);
    }

    public void disableAllColumns() {
        String[] stringArray = this.columnCheckBoxHeaderMap.keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            CheckBoxHeader checkBoxHeader = (CheckBoxHeader)this.columnCheckBoxHeaderMap.get(stringArray[i]);
            checkBoxHeader.setSelected(false);
        }
        this.table.getTableHeader().resizeAndRepaint();
    }

    public void enableAllColumns() {
        String[] stringArray = this.columnCheckBoxHeaderMap.keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            CheckBoxHeader checkBoxHeader = (CheckBoxHeader)this.columnCheckBoxHeaderMap.get(stringArray[i]);
            checkBoxHeader.setSelected(true);
        }
        this.table.getTableHeader().resizeAndRepaint();
    }

    protected void enableColumnsByName(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            boolean bl = this.columnCheckBoxHeaderMap.containsKey(string);
            if (!bl) continue;
            CheckBoxHeader checkBoxHeader = (CheckBoxHeader)this.columnCheckBoxHeaderMap.get(string);
            checkBoxHeader.setSelected(true);
        }
        this.table.getTableHeader().resizeAndRepaint();
    }

    protected boolean columnNamesIntersect(String[] stringArray) {
        String[] stringArray2 = this.columnCheckBoxHeaderMap.keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!this.columnCheckBoxHeaderMap.containsKey(string)) continue;
            return true;
        }
        return false;
    }

    protected boolean rowNamesIntersect(String[] stringArray) {
        List<String> list = Arrays.asList(stringArray);
        String[] stringArray2 = this.matrix.getRowTitles();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!list.contains(stringArray2[i])) continue;
            return true;
        }
        return false;
    }

    class SortButtonListener
    implements ActionListener {
        SortButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MatrixSpreadsheet.this.unsorted = false;
            MatrixSpreadsheet.this.doSort(MatrixSpreadsheet.this.sortOrderAscending);
            MatrixSpreadsheet.this.sortOrderAscending = !MatrixSpreadsheet.this.sortOrderAscending;
        }
    }

    class NameTypeChangeListener
    implements ActionListener {
        static final /* synthetic */ boolean $assertionsDisabled;

        NameTypeChangeListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            String string2;
            String[] stringArray = MatrixSpreadsheet.this.matrix.getRowTitles();
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < MatrixSpreadsheet.this.rowHeader.getOriginalValues().size(); ++i) {
                String string3 = (String)MatrixSpreadsheet.this.rowHeader.getOriginalValues().get(i);
                string2 = null;
                string = stringArray[i];
                if (!$assertionsDisabled && !string.equals(MatrixSpreadsheet.this.rowHeader.getOriginalName(string3))) {
                    throw new AssertionError();
                }
                string2 = MatrixSpreadsheet.this.nameHelper.getName(MatrixSpreadsheet.this.nameHelper.getCategoryList()[1], string3);
                if (MatrixSpreadsheet.this.nameTypeButton.getActionCommand().equals("0")) {
                    vector.add(string);
                    continue;
                }
                if (null != string2) {
                    vector.add(string2);
                    continue;
                }
                vector.add(string3 == null ? "" : string3);
            }
            MatrixSpreadsheet.this.rowHeader.setOriginalValues(vector);
            Object[] objectArray = new String[MatrixSpreadsheet.this.rowHeader.getModel().getSize()];
            if (MatrixSpreadsheet.this.nameTypeButton.getActionCommand().equals("0")) {
                for (int i = 0; i < MatrixSpreadsheet.this.rowHeader.getModel().getSize(); ++i) {
                    string2 = (String)MatrixSpreadsheet.this.rowHeader.getModel().getElementAt(i);
                    objectArray[i] = MatrixSpreadsheet.this.rowHeader.getOriginalName(string2);
                }
            } else {
                for (int i = 0; i < MatrixSpreadsheet.this.rowHeader.getModel().getSize(); ++i) {
                    string2 = (String)MatrixSpreadsheet.this.rowHeader.getModel().getElementAt(i);
                    string = null;
                    string = MatrixSpreadsheet.this.nameHelper.getName(MatrixSpreadsheet.this.nameHelper.getCategoryList()[1], string2);
                    objectArray[i] = null != string ? string : (string2 == null ? "" : string2);
                }
            }
            MatrixSpreadsheet.this.rowHeader.changeList(objectArray);
            if (MatrixSpreadsheet.this.nameTypeButton.getActionCommand().equals("0")) {
                MatrixSpreadsheet.this.nameTypeButton.setActionCommand("1");
            } else {
                MatrixSpreadsheet.this.nameTypeButton.setActionCommand("0");
            }
        }

        static {
            $assertionsDisabled = !(class$csplugins$isb$pshannon$experiment$gui$MatrixSpreadsheet == null ? (class$csplugins$isb$pshannon$experiment$gui$MatrixSpreadsheet = MatrixSpreadsheet.class$("csplugins.isb.pshannon.experiment.gui.MatrixSpreadsheet")) : class$csplugins$isb$pshannon$experiment$gui$MatrixSpreadsheet).desiredAssertionStatus();
        }
    }

    class TableSelectionListener
    implements ListSelectionListener {
        JTable table;
        DataMatrix matrix;

        TableSelectionListener(JTable jTable, DataMatrix dataMatrix) {
            this.table = jTable;
            this.matrix = dataMatrix;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            DataMatrixTableModel dataMatrixTableModel = (DataMatrixTableModel)this.table.getModel();
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            MatrixSpreadsheet.this.lens.disableAllRows();
            int[] nArray = this.table.getSelectedRows();
            MatrixSpreadsheet.this.selectionCountTextField.setText("" + nArray.length);
            int[] nArray2 = new int[nArray.length];
            String[] stringArray = new String[nArray2.length];
            for (int i = 0; i < nArray.length; ++i) {
                String string;
                String string2 = (String)MatrixSpreadsheet.this.rowHeader.getContents().get(nArray[i]);
                stringArray[i] = string = MatrixSpreadsheet.this.rowHeader.getOriginalName(string2);
                nArray2[i] = MatrixSpreadsheet.this.lens.getRowIndex(string);
            }
            MatrixSpreadsheet.this.lens.enableRows(nArray2);
        }
    }

    class TableHeaderCheckboxListener
    implements ItemListener {
        TableHeaderCheckboxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (!(object instanceof AbstractButton)) {
                return;
            }
            String string = ((AbstractButton)object).getText();
            boolean bl = itemEvent.getStateChange() == 1;
            int n = ((CheckBoxHeader)itemEvent.getItem()).getColumn();
            MatrixSpreadsheet.this.lens.setColumnState(n, bl);
        }
    }

    class TableColumnMovedListener
    implements TableColumnModelListener {
        TableColumnMovedListener() {
        }

        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            if (tableColumnModelEvent.getFromIndex() == tableColumnModelEvent.getToIndex()) {
                return;
            }
            MatrixSpreadsheet.this.dragTo = tableColumnModelEvent.getToIndex();
            if (!MatrixSpreadsheet.this.dragTimer.isRunning()) {
                MatrixSpreadsheet.this.dragFrom = tableColumnModelEvent.getFromIndex();
                MatrixSpreadsheet.this.dragTimer.start();
                return;
            }
        }

        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnMarginChanged(ChangeEvent changeEvent) {
        }

        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }
    }

    class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer {
        RowHeaderRenderer(JTable jTable) {
            JTableHeader jTableHeader = jTable.getTableHeader();
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            this.setForeground(jTableHeader.getForeground());
            this.setBackground(jTableHeader.getBackground());
            JLabel jLabel = new JLabel();
            this.setBackground(jLabel.getBackground());
            this.setFont(jTableHeader.getFont());
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            DataMatrixTableModel dataMatrixTableModel = (DataMatrixTableModel)MatrixSpreadsheet.this.table.getModel();
            int n2 = dataMatrixTableModel.getCorrectRowIndex(n);
            String string = MatrixSpreadsheet.this.lens.getUnderlyingMatrix().getRowTitles()[n2];
            String string2 = MatrixSpreadsheet.this.nameHelper.getName(MatrixSpreadsheet.this.nameHelper.getCategoryList()[1], string);
            this.setText(object == null ? "" : object.toString());
            if (null != object) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string);
                if (!string2.equals(string)) {
                    stringBuffer.append(" (" + string2 + ")");
                }
                this.setToolTipText(stringBuffer.toString());
            }
            return this;
        }
    }
}

