/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.gui;

import csplugins.isb.dtenenbaum.nameHelper.NameHelper;
import csplugins.isb.dtenenbaum.nameHelper.NameHelperFactory;
import csplugins.isb.pshannon.experiment.datamatrix.DataMatrix;
import csplugins.isb.pshannon.experiment.datamatrix.LensedDataMatrix;
import csplugins.isb.pshannon.experiment.gui.DataMatrixView;
import csplugins.isb.pshannon.experiment.gui.MatrixPlotter;
import csplugins.isb.pshannon.experiment.gui.MatrixSpreadsheet;
import csplugins.isb.pshannon.experiment.gui.MatrixViewCoordinator;
import csplugins.isb.pshannon.experiment.metadata.MetaData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class DataMatrixViewer
extends JPanel
implements MatrixViewCoordinator,
ClipboardOwner {
    protected JTabbedPane tabbedPane;
    protected File currentDirectory;
    protected NameHelper nameHelper;
    protected MetaData metaData = null;
    protected DataMatrix[] matrices;
    protected JPanel buttonPanel;
    protected JPanel controlPanel;
    protected JPanel movieController;
    private JButton butNameType;
    protected JToolBar toolbar;
    private Date lastModificationTime = new Date();
    ArrayList allViews;
    protected HashMap plotTabNames = new HashMap();
    int currentTabIndex = -1;

    public DataMatrixViewer(DataMatrix[] dataMatrixArray, MetaData metaData) throws Exception {
        this.matrices = dataMatrixArray;
        this.currentDirectory = new File(System.getProperty("user.dir"));
        this.metaData = metaData;
        this.nameHelper = NameHelperFactory.getNameHelper();
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.allViews = new ArrayList();
        this.add((Component)this.createGui(dataMatrixArray), "Center");
    }

    public DataMatrixViewer(DataMatrix[] dataMatrixArray) throws Exception {
        this(dataMatrixArray, null);
    }

    JTabbedPane createGui(DataMatrix[] dataMatrixArray) {
        this.toolbar = new JToolBar();
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolbar, "North");
        this.addActions();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setUI(new MyTabbedPaneUI());
        for (int i = 0; i < dataMatrixArray.length; ++i) {
            this.addMatrixSpreadsheetView(dataMatrixArray[i]);
        }
        return this.tabbedPane;
    }

    protected void addActions() {
    }

    public JToolBar getToolBar() {
        return this.toolbar;
    }

    public void addActionToToolbar(AbstractAction abstractAction) {
        this.toolbar.add(abstractAction);
    }

    public void addButtonToToolbar(JButton jButton) {
        jButton.setBackground(Color.WHITE);
        this.toolbar.add(jButton);
    }

    private void placeInCenter() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        int n = (int)graphicsConfiguration.getBounds().getHeight();
        int n2 = (int)graphicsConfiguration.getBounds().getWidth();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        this.setLocation((n2 - n3) / 2, (n - n4) / 2);
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public LensedDataMatrix[] getAllLenses() {
        DataMatrixView[] dataMatrixViewArray = this.allViews.toArray(new DataMatrixView[0]);
        ArrayList<LensedDataMatrix> arrayList = new ArrayList<LensedDataMatrix>();
        for (int i = 0; i < dataMatrixViewArray.length; ++i) {
            if (!dataMatrixViewArray[i].getClassName().equals("MatrixSpreadsheet")) continue;
            MatrixSpreadsheet matrixSpreadsheet = (MatrixSpreadsheet)dataMatrixViewArray[i];
            arrayList.add(matrixSpreadsheet.getLens());
        }
        return arrayList.toArray(new LensedDataMatrix[0]);
    }

    public void select(String string, String[] stringArray) {
        DataMatrixView[] dataMatrixViewArray = this.allViews.toArray(new DataMatrixView[0]);
        for (int i = 0; i < dataMatrixViewArray.length; ++i) {
            dataMatrixViewArray[i].select(string, stringArray);
        }
    }

    public void clearSelections() {
        DataMatrixView[] dataMatrixViewArray = this.allViews.toArray(new DataMatrixView[0]);
        for (int i = 0; i < dataMatrixViewArray.length; ++i) {
            dataMatrixViewArray[i].clearSelection();
        }
    }

    public String getSpecies() {
        int n = this.tabbedPane.getSelectedIndex();
        DataMatrixView dataMatrixView = (DataMatrixView)this.allViews.get(n);
        return dataMatrixView.getSpecies();
    }

    public String[] getSelection() {
        int n = this.tabbedPane.getSelectedIndex();
        DataMatrixView dataMatrixView = (DataMatrixView)this.allViews.get(n);
        String[] stringArray = ((DataMatrixView)this.allViews.get(n)).getSelection();
        return stringArray;
    }

    public LensedDataMatrix[] getCongruentLenses() {
        DataMatrixView[] dataMatrixViewArray = this.allViews.toArray(new DataMatrixView[0]);
        Object[] objectArray = new String[]{""};
        Object[] objectArray2 = new String[]{""};
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        ArrayList<LensedDataMatrix> arrayList = new ArrayList<LensedDataMatrix>();
        for (int i = 0; i < dataMatrixViewArray.length; ++i) {
            LensedDataMatrix lensedDataMatrix;
            if (!dataMatrixViewArray[i].getClassName().equals("MatrixSpreadsheet")) continue;
            MatrixSpreadsheet matrixSpreadsheet = (MatrixSpreadsheet)dataMatrixViewArray[i];
            if (!bl) {
                bl = true;
                lensedDataMatrix = matrixSpreadsheet.getLens();
                objectArray = lensedDataMatrix.getRowTitles();
                objectArray2 = lensedDataMatrix.getColumnTitles();
                n = lensedDataMatrix.getRowCount();
                n2 = lensedDataMatrix.getColumnCount();
                arrayList.add(lensedDataMatrix);
                continue;
            }
            lensedDataMatrix = matrixSpreadsheet.getLens();
            if (lensedDataMatrix.getRowCount() != n || lensedDataMatrix.getColumnCount() != n2 || !Arrays.equals(lensedDataMatrix.getRowTitles(), objectArray) || !Arrays.equals(lensedDataMatrix.getColumnTitles(), objectArray2)) continue;
            arrayList.add(lensedDataMatrix);
        }
        return arrayList.toArray(new LensedDataMatrix[0]);
    }

    public void handleCluster(String[] stringArray, String[] stringArray2) {
        DataMatrixView[] dataMatrixViewArray = this.allViews.toArray(new DataMatrixView[0]);
        for (int i = 0; i < dataMatrixViewArray.length; ++i) {
            if (!dataMatrixViewArray[i].getClassName().equals("MatrixSpreadsheet")) continue;
            MatrixSpreadsheet matrixSpreadsheet = (MatrixSpreadsheet)dataMatrixViewArray[i];
            matrixSpreadsheet.selectSubTable(stringArray, stringArray2);
        }
    }

    public Date getLastModificationTime() {
        return this.lastModificationTime;
    }

    public void addMatrixSpreadsheetView(DataMatrix dataMatrix) {
        String string = dataMatrix.getShortName();
        try {
            MatrixSpreadsheet matrixSpreadsheet = new MatrixSpreadsheet(dataMatrix, this);
            this.allViews.add(matrixSpreadsheet);
            this.tabbedPane.add(string, matrixSpreadsheet);
            this.lastModificationTime = new Date();
        }
        catch (Exception exception) {
            System.err.println("error creating spreadsheet panel for " + string + ": " + exception.getMessage());
        }
    }

    public void doBroadcast(String[] stringArray) {
    }

    public void doMatrixBroadcast(String[] stringArray) {
    }

    public void doPlot(LensedDataMatrix lensedDataMatrix) {
        String string = lensedDataMatrix.getShortName();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(lensedDataMatrix.getShortName());
        stringBuffer.append(" (plot");
        int n = 0;
        if (this.plotTabNames.containsKey(string)) {
            n = (Integer)this.plotTabNames.get(string);
        }
        this.plotTabNames.put(string, new Integer(++n));
        if (n > 1) {
            stringBuffer.append(" #");
            stringBuffer.append(new Integer(n).toString());
        }
        stringBuffer.append(")");
        String string2 = stringBuffer.toString();
        MatrixPlotter matrixPlotter = new MatrixPlotter(string2, "Conditions", "y", lensedDataMatrix, this.nameHelper);
        this.allViews.add(matrixPlotter);
        this.tabbedPane.add(string2, matrixPlotter);
        this.tabbedPane.setSelectedIndex(this.tabbedPane.getTabCount() - 1);
    }

    static /* synthetic */ Date access$502(DataMatrixViewer dataMatrixViewer, Date date) {
        dataMatrixViewer.lastModificationTime = date;
        return dataMatrixViewer.lastModificationTime;
    }

    class MyTabbedPaneUI
    extends BasicTabbedPaneUI {
        protected void paintTab(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
            super.paintTab(graphics, n, rectangleArray, n2, rectangle, rectangle2);
            Rectangle rectangle3 = rectangleArray[n2];
            graphics.setColor(Color.black);
            graphics.drawRect(rectangle3.x + 5, rectangle3.y + 5, 10, 10);
            graphics.drawLine(rectangle3.x + 5, rectangle3.y + 5, rectangle3.x + 15, rectangle3.y + 15);
            graphics.drawLine(rectangle3.x + 15, rectangle3.y + 5, rectangle3.x + 5, rectangle3.y + 15);
        }

        protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
            return super.calculateTabWidth(n, n2, fontMetrics) + 20;
        }

        protected MouseListener createMouseListener() {
            return new MyMouseHandler();
        }

        class MyMouseHandler
        extends BasicTabbedPaneUI.MouseHandler {
            public MyMouseHandler() {
                super(MyTabbedPaneUI.this);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                ((MyTabbedPaneUI)MyTabbedPaneUI.this).DataMatrixViewer.this.currentTabIndex = -1;
                int n3 = MyTabbedPaneUI.this.tabPane.getTabCount();
                for (int i = 0; i < n3; ++i) {
                    if (!MyTabbedPaneUI.this.rects[i].contains(n, n2)) continue;
                    ((MyTabbedPaneUI)MyTabbedPaneUI.this).DataMatrixViewer.this.currentTabIndex = i;
                    break;
                }
                if (((MyTabbedPaneUI)MyTabbedPaneUI.this).DataMatrixViewer.this.currentTabIndex >= 0) {
                    Rectangle rectangle = MyTabbedPaneUI.this.rects[((MyTabbedPaneUI)MyTabbedPaneUI.this).DataMatrixViewer.this.currentTabIndex];
                    if ((n -= rectangle.x) >= 5 && n <= 15 && (n2 -= rectangle.y) >= 5 && n2 <= 15) {
                        try {
                            SwingUtilities.invokeLater(new Runnable(this){
                                private final /* synthetic */ MyMouseHandler this$2;
                                {
                                    this.this$2 = myMouseHandler;
                                }

                                public void run() {
                                    MyTabbedPaneUI.access$000((MyTabbedPaneUI)MyMouseHandler.access$400((MyMouseHandler)this.this$2)).tabbedPane.remove(MyTabbedPaneUI.access$000((MyTabbedPaneUI)MyMouseHandler.access$400((MyMouseHandler)this.this$2)).currentTabIndex);
                                    MyTabbedPaneUI.access$000((MyTabbedPaneUI)MyMouseHandler.access$400((MyMouseHandler)this.this$2)).allViews.remove(MyTabbedPaneUI.access$000((MyTabbedPaneUI)MyMouseHandler.access$400((MyMouseHandler)this.this$2)).currentTabIndex);
                                    DataMatrixViewer.access$502(MyTabbedPaneUI.access$000(MyMouseHandler.access$400(this.this$2)), new Date());
                                }
                            });
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            }

            static /* synthetic */ MyTabbedPaneUI access$400(MyMouseHandler myMouseHandler) {
                return myMouseHandler.MyTabbedPaneUI.this;
            }
        }
    }
}

