/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment;

import csplugins.isb.pshannon.experiment.ExperimentRepository;
import csplugins.isb.pshannon.experiment.datamatrix.DataMatrix;
import csplugins.isb.pshannon.experiment.metadata.DataSetDescription;
import csplugins.isb.pshannon.experiment.metadata.MetaData;
import csplugins.isb.pshannon.experiment.readers.DataMatrixFileReader;
import csplugins.isb.pshannon.experiment.readers.MetaDataXmlParser;
import java.io.File;
import java.util.ArrayList;

public class FileRepository
extends ExperimentRepository {
    File directory;
    File singleXmlFile;
    boolean repositoryIsDirectory;

    public FileRepository(String string) {
        this(string, false);
    }

    public FileRepository(String string, boolean bl) {
        super(string, bl);
        File file = new File(this.path);
        if (!file.canRead()) {
            throw new IllegalArgumentException("cannot read repository file or directory: '" + this.path + "'");
        }
        if (file.isDirectory()) {
            this.directory = new File(this.path);
            this.repositoryIsDirectory = true;
        } else {
            if (!file.getPath().endsWith(".xml")) {
                throw new IllegalArgumentException("single file 'repository' needs .xml extension");
            }
            this.singleXmlFile = new File(this.path);
            this.repositoryIsDirectory = false;
        }
    }

    public String[] getExperimentNames() {
        if (!this.repositoryIsDirectory) {
            return new String[]{this.singleXmlFile.getName()};
        }
        String[] stringArray = this.directory.list();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(".xml")) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[0]);
    }

    public MetaData getMetaData(String string) throws Exception {
        String string2 = this.protocol + "://" + this.path;
        if (this.repositoryIsDirectory) {
            string2 = string2 + "/" + string;
        }
        MetaDataXmlParser metaDataXmlParser = new MetaDataXmlParser(string2);
        return metaDataXmlParser.getMetaData();
    }

    public DataMatrix getDataSet(DataSetDescription dataSetDescription) throws Exception {
        String string = dataSetDescription.getUri();
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader(string);
        dataMatrixFileReader.read();
        return dataMatrixFileReader.get();
    }
}

