/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dtenenbaum.plot2d;

import csplugins.isb.dtenenbaum.nameHelper.NameHelper;
import csplugins.isb.dtenenbaum.nameHelper.NameHelperFactory;
import csplugins.isb.dtenenbaum.plot2d.UnsortedXYSeries;
import csplugins.isb.dtenenbaum.plot2d.XYMetaData;
import csplugins.isb.pshannon.experiment.datamatrix.LensedDataMatrix;
import csplugins.isb.pshannon.experiment.gui.actions.IconFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.SymbolicAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.labels.SymbolicXYItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;

public class Plot2DPanel
extends JPanel {
    private String[] symbolicNames;
    private JComboBox cb;
    private String title;
    private String xAxisLabel;
    private String yAxisLabel;
    private ChartPanel chartPanel;
    private XYPlot plot;
    private int maxCols = 0;
    private XYSeriesCollection dataset;
    private JPanel statusPanel;
    private JButton butName;
    private NameHelper nameHelper = null;
    private JLabel lblY = new JLabel("   Y:");
    private JLabel lblRow = new JLabel("   Row:");
    private JLabel lblXAxis = new JLabel();
    private Hashtable savedPaints;
    private ItemListSelectionListener ilsl;
    private JScrollPane statusScroll;
    private JFreeChart chart;
    private JButton dismissButton;
    private JButton toggleButton;
    private static final int UNIT = 20;
    private static final int MIN_WIDTH = 333;
    private int width;
    private int cbWidth;
    private JList itemList;
    protected boolean allowLiveUpdate = false;
    private LensedDataMatrix dm = null;
    private String[] nameCategories = null;

    public Plot2DPanel() {
        this("", "", "", null, null);
    }

    public Plot2DPanel(String string) {
        this(string, "", "", null, null);
    }

    public Plot2DPanel(NameHelper nameHelper) {
        this("", "", "", null, nameHelper);
    }

    public Plot2DPanel(String string, NameHelper nameHelper) {
        this(string, "", "", null, nameHelper);
    }

    public Plot2DPanel(String string, String string2, String string3, LensedDataMatrix lensedDataMatrix, NameHelper nameHelper) {
        this.title = string;
        this.xAxisLabel = string2;
        this.yAxisLabel = string3;
        this.dm = lensedDataMatrix;
        if (null == nameHelper) {
            nameHelper = NameHelperFactory.getNameHelper();
        }
        this.nameCategories = nameHelper.getCategoryList();
        this.nameHelper = nameHelper;
        this.allowLiveUpdate = true;
        this.initUI();
        this.show();
        this.allowLiveUpdate = false;
    }

    private void initUI() {
        JComponent jComponent;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.add((Component)jPanel, "West");
        this.butName = new JButton(IconFactory.getToggleIcon());
        this.butName.setBackground(Color.WHITE);
        this.butName.setToolTipText("Toggle the type of name displayed in the list.");
        this.butName.setActionCommand(this.nameHelper.getCategoryList()[0]);
        this.butName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Plot2DPanel.this.butName.getActionCommand().equals(Plot2DPanel.this.nameHelper.getCategoryList()[0])) {
                    Plot2DPanel.this.butName.setActionCommand(Plot2DPanel.this.nameHelper.getCategoryList()[1]);
                } else {
                    Plot2DPanel.this.butName.setActionCommand(Plot2DPanel.this.nameHelper.getCategoryList()[0]);
                }
                Plot2DPanel.this.itemList.repaint();
            }
        });
        this.itemList = new JList();
        this.ilsl = new ItemListSelectionListener();
        this.itemList.addListSelectionListener(this.ilsl);
        JScrollPane jScrollPane = new JScrollPane(this.itemList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        if (null != this.nameCategories) {
            jComponent = new JPanel();
            jComponent.add(this.butName);
            jPanel.add((Component)jComponent, "North");
        }
        jPanel.add((Component)jScrollPane, "Center");
        jComponent = new JButton("Show All");
        jComponent.setToolTipText("Clears any selections in the list of names.");
        class ClearAction
        extends AbstractAction {
            ClearAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Plot2DPanel.this.itemList.clearSelection();
                Plot2DPanel.this.resetColors();
            }
        }
        ((AbstractButton)jComponent).setAction(new ClearAction());
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jComponent);
        jPanel.add((Component)jPanel2, "South");
        JPanel jPanel3 = new JPanel();
        this.add((Component)jPanel3, "Center");
        jPanel3.setLayout(new BorderLayout());
        this.dataset = new XYSeriesCollection();
        this.chart = this.createChart((XYDataset)this.dataset);
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.setHorizontalZoom(true);
        this.chartPanel.setVerticalZoom(true);
        this.chartPanel.setMouseZoomable(true);
        LineBorder lineBorder = new LineBorder(Color.BLACK, 5);
        this.chartPanel.setBorder((Border)lineBorder);
        this.chartPanel.addChartMouseListener((ChartMouseListener)new ML());
        this.chartPanel.setHorizontalZoom(false);
        this.chartPanel.setVerticalZoom(false);
        this.chartPanel.setMouseZoomable(true);
        this.chartPanel.setSize(300, 300);
        this.chartPanel.setPreferredSize(new Dimension(300, 300));
        this.statusPanel = new JPanel();
        LineBorder lineBorder2 = new LineBorder(Color.BLACK, 2);
        this.statusPanel.setLayout(new GridLayout(1, 3));
        Font font = this.lblY.getFont();
        Font font2 = new Font(font.getFontName(), font.getStyle(), 12);
        this.lblY.setFont(font2);
        this.lblRow.setFont(font2);
        this.lblXAxis.setFont(font2);
        this.statusPanel.add(this.lblY);
        this.statusPanel.add(this.lblRow);
        if ("".equals(this.xAxisLabel)) {
            this.xAxisLabel = "Condition";
        }
        this.lblXAxis.setText("   " + this.xAxisLabel + ": ");
        this.statusPanel.add(this.lblXAxis);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)this.chartPanel, "Center");
        jPanel4.add((Component)this.statusPanel, "South");
        jPanel3.add((Component)jPanel4, "Center");
        this.toggleButton = new JButton("Hide Condition Names");
        this.toggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Plot2DPanel.this.toggleButton.getText().indexOf("Hide") > -1) {
                    Plot2DPanel.this.toggleButton.setText("Show Condition Names");
                    Plot2DPanel.this.toggleConditionNames(false);
                } else {
                    Plot2DPanel.this.toggleButton.setText("Hide Condition Names");
                    Plot2DPanel.this.toggleConditionNames(true);
                }
            }
        });
        JPanel jPanel5 = new JPanel();
        jPanel5.add(this.toggleButton);
        jPanel3.add((Component)jPanel5, "South");
        this.dismissButton = new JButton(IconFactory.getDismissIcon());
        this.dismissButton.setBackground(Color.WHITE);
        this.dismissButton.setToolTipText("Closes this window.");
        this.dismissButton.setActionCommand("dismiss");
        this.dismissButton.addActionListener(new DismissAction());
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        this.cb = new JComboBox();
        if (null != this.dm) {
            JCheckBox jCheckBox = new JCheckBox();
        }
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (Plot2DPanel.this.width == 0) {
                    return;
                }
                JPanel jPanel = (JPanel)componentEvent.getSource();
                if (jPanel.getWidth() == Plot2DPanel.this.width) {
                    return;
                }
                if (Plot2DPanel.this.width / 20 == jPanel.getWidth() / 20) {
                    jPanel.setSize(Plot2DPanel.this.getSize());
                    return;
                }
                if (jPanel.getWidth() < 333) {
                    jPanel.setSize(333, jPanel.getHeight());
                }
                Plot2DPanel.this.width = jPanel.getWidth();
                Plot2DPanel.this.repaint();
            }
        });
    }

    private void oldInitUI() {
        GridBagConstraints gridBagConstraints;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.butName = new JButton(IconFactory.getToggleIcon());
        this.butName.setBackground(Color.WHITE);
        this.butName.setToolTipText("Toggle the type of name displayed in the list.");
        this.butName.setActionCommand(this.nameHelper.getCategoryList()[0]);
        this.butName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Plot2DPanel.this.butName.getActionCommand().equals(Plot2DPanel.this.nameHelper.getCategoryList()[0])) {
                    Plot2DPanel.this.butName.setActionCommand(Plot2DPanel.this.nameHelper.getCategoryList()[1]);
                } else {
                    Plot2DPanel.this.butName.setActionCommand(Plot2DPanel.this.nameHelper.getCategoryList()[0]);
                }
                Plot2DPanel.this.itemList.repaint();
            }
        });
        this.itemList = new JList();
        this.ilsl = new ItemListSelectionListener();
        this.itemList.addListSelectionListener(this.ilsl);
        JScrollPane jScrollPane = new JScrollPane(this.itemList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        if (null != this.nameCategories) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            this.add((Component)this.butName, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = null != this.nameCategories ? 1 : 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        this.add((Component)jScrollPane, gridBagConstraints);
        JButton jButton = new JButton("Clear");
        jButton.setToolTipText("Clears any selections in the list of names.");
        class ClearAction
        extends AbstractAction {
            public ClearAction() {
                super("Clear");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Plot2DPanel.this.itemList.clearSelection();
                Plot2DPanel.this.resetColors();
            }
        }
        jButton.setAction(new ClearAction());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        this.add((Component)jButton, gridBagConstraints);
        this.dataset = new XYSeriesCollection();
        this.chart = this.createChart((XYDataset)this.dataset);
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.setHorizontalZoom(true);
        this.chartPanel.setVerticalZoom(true);
        this.chartPanel.setMouseZoomable(true);
        LineBorder lineBorder = new LineBorder(Color.BLACK, 5);
        this.chartPanel.setBorder((Border)lineBorder);
        this.chartPanel.addChartMouseListener((ChartMouseListener)new ML());
        this.chartPanel.setHorizontalZoom(false);
        this.chartPanel.setVerticalZoom(false);
        this.chartPanel.setMouseZoomable(true);
        this.chartPanel.setSize(300, 300);
        this.chartPanel.setPreferredSize(new Dimension(300, 300));
        this.statusPanel = new JPanel();
        LineBorder lineBorder2 = new LineBorder(Color.BLACK, 2);
        this.statusPanel.setLayout(new GridLayout(3, 1));
        Font font = this.lblY.getFont();
        Font font2 = new Font(font.getFontName(), font.getStyle(), 12);
        this.lblY.setFont(font2);
        this.lblRow.setFont(font2);
        this.lblXAxis.setFont(font2);
        this.statusPanel.add(this.lblY);
        this.statusPanel.add(this.lblRow);
        if ("".equals(this.xAxisLabel)) {
            this.xAxisLabel = "Condition";
        }
        this.lblXAxis.setText("   " + this.xAxisLabel + ": ");
        this.statusPanel.add(this.lblXAxis);
        JSplitPane jSplitPane = new JSplitPane(0, (Component)this.chartPanel, this.statusPanel);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(275);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)jSplitPane, gridBagConstraints);
        this.toggleButton = new JButton("Hide Condition Names");
        this.toggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Plot2DPanel.this.toggleButton.getText().indexOf("Hide") > -1) {
                    Plot2DPanel.this.toggleButton.setText("Show Condition Names");
                    Plot2DPanel.this.toggleConditionNames(false);
                } else {
                    Plot2DPanel.this.toggleButton.setText("Hide Condition Names");
                    Plot2DPanel.this.toggleConditionNames(true);
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        this.add((Component)this.toggleButton, gridBagConstraints);
        this.dismissButton = new JButton(IconFactory.getDismissIcon());
        this.dismissButton.setBackground(Color.WHITE);
        this.dismissButton.setToolTipText("Closes this window.");
        this.dismissButton.setActionCommand("dismiss");
        this.dismissButton.addActionListener(new DismissAction());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 13;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.cb = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        if (null != this.dm) {
            JCheckBox jCheckBox = new JCheckBox();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 7;
        }
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (Plot2DPanel.this.width == 0) {
                    return;
                }
                JPanel jPanel = (JPanel)componentEvent.getSource();
                if (jPanel.getWidth() == Plot2DPanel.this.width) {
                    return;
                }
                if (Plot2DPanel.this.width / 20 == jPanel.getWidth() / 20) {
                    jPanel.setSize(Plot2DPanel.this.getSize());
                    return;
                }
                if (jPanel.getWidth() < 333) {
                    jPanel.setSize(333, jPanel.getHeight());
                }
                Plot2DPanel.this.width = jPanel.getWidth();
                Plot2DPanel.this.repaint();
            }
        });
    }

    public void addDismissListener(ActionListener actionListener) {
        this.dismissButton.addActionListener(actionListener);
    }

    public void addChartMouseListener(ChartMouseListener chartMouseListener) {
        this.chartPanel.addChartMouseListener(chartMouseListener);
    }

    public boolean getAllowLiveUpdate() {
        return this.allowLiveUpdate;
    }

    public void setAllowLiveUpdate(boolean bl) {
        this.allowLiveUpdate = bl;
    }

    private UnsortedXYSeries getSeries(String string) {
        if (this.dataset.getSeriesCount() == 0) {
            UnsortedXYSeries unsortedXYSeries = new UnsortedXYSeries(string);
            this.dataset.addSeries((XYSeries)unsortedXYSeries);
            return unsortedXYSeries;
        }
        for (int i = 0; i < this.dataset.getSeriesCount(); ++i) {
            if (!this.dataset.getSeries(i).getName().equals(string)) continue;
            return (UnsortedXYSeries)this.dataset.getSeries(i);
        }
        UnsortedXYSeries unsortedXYSeries = new UnsortedXYSeries(string);
        this.dataset.addSeries((XYSeries)unsortedXYSeries);
        return unsortedXYSeries;
    }

    private void addPoints(UnsortedXYSeries unsortedXYSeries, double[] dArray, double[] dArray2) {
        boolean bl = false;
        if (null == dArray) {
            bl = true;
            dArray = new double[dArray2.length];
        }
        for (int i = 0; i < dArray2.length; ++i) {
            if (bl) {
                dArray[i] = i;
            }
            unsortedXYSeries.add(dArray[i], dArray2[i]);
        }
    }

    private void addData(String string, double[] dArray) {
        UnsortedXYSeries unsortedXYSeries = this.getSeries(string);
        this.addPoints(unsortedXYSeries, null, dArray);
    }

    private JFreeChart createChart(XYDataset xYDataset) {
        File file = new File(this.yAxisLabel);
        String string = file.getName();
        NumberAxis numberAxis = new NumberAxis(string);
        if (null == this.symbolicNames || "".equals(this.symbolicNames[0])) {
            if (null == this.dm) {
                this.symbolicNames = new String[1];
                this.symbolicNames[0] = "";
            } else {
                this.symbolicNames = this.dm.getColumnTitles();
            }
        }
        SymbolicAxis symbolicAxis = new SymbolicAxis(this.xAxisLabel, this.symbolicNames);
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer(3, (XYToolTipGenerator)new SymbolicXYItemLabelGenerator());
        this.plot = new XYPlot(xYDataset, (ValueAxis)symbolicAxis, (ValueAxis)numberAxis, (XYItemRenderer)standardXYItemRenderer);
        this.plot.setDomainGridlinesVisible(true);
        this.plot.setRangeGridlinesVisible(true);
        JFreeChart jFreeChart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.plot, false);
        this.plot.getDomainAxis().setVerticalTickLabels(true);
        AbstractRenderer abstractRenderer = (AbstractRenderer)this.plot.getRenderer();
        Rectangle2D.Double double_ = new Rectangle2D.Double(-1.75, -1.75, 3.5, 3.5);
        XYItemRenderer xYItemRenderer = this.plot.getRenderer();
        xYItemRenderer.setShape((Shape)double_);
        this.plot.getRenderer().setToolTipGenerator((XYToolTipGenerator)new ToolTipGenerator());
        return jFreeChart;
    }

    private void resetStatusPanel() {
        this.lblY.setText("   Y:");
        this.lblRow.setText("   Row:");
        this.lblXAxis.setText("   " + this.xAxisLabel + ":");
    }

    public void setSize(Dimension dimension) {
        int n = dimension.getWidth() < 333.0 ? 333 : (int)dimension.getWidth();
        super.setSize(n, (int)dimension.getHeight());
    }

    public void setSize(int n, int n2) {
        this.setSize(new Dimension(n, n2));
    }

    private void resetColors() {
        XYItemRenderer xYItemRenderer = this.plot.getRenderer();
        for (int i = 0; i < this.dataset.getSeriesCount(); ++i) {
            xYItemRenderer.setSeriesPaint(i, (Paint)this.savedPaints.get(this.dataset.getSeriesName(i)));
        }
    }

    private void setupItemList() {
        this.itemList.setCellRenderer(new SelectorListRenderer());
        LegendItemCollection legendItemCollection = this.plot.getLegendItems();
        Vector<ListItem> vector = new Vector<ListItem>();
        this.savedPaints = new Hashtable();
        for (int i = 0; i < legendItemCollection.getItemCount(); ++i) {
            LegendItem legendItem = legendItemCollection.get(i);
            String string = this.nameHelper.getName(this.nameHelper.getCategoryList()[1], legendItem.getLabel());
            ListItem listItem = new ListItem(legendItem, string);
            vector.add(listItem);
            this.savedPaints.put(legendItem.getLabel(), legendItem.getPaint());
        }
        this.itemList.setListData(vector);
    }

    public void show() {
        if (null != this.dm) {
            boolean bl = this.allowLiveUpdate;
            this.populateFromLens(this.dm, true);
            this.allowLiveUpdate = bl;
        }
        this.setupItemList();
        this.width = this.getWidth();
        super.show();
        this.setSize(this.getSize());
    }

    public void toggleConditionNames(boolean bl) {
        SymbolicAxis symbolicAxis = (SymbolicAxis)this.plot.getDomainAxis();
        String[] stringArray = new String[this.symbolicNames.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "";
        }
        symbolicAxis = bl ? new SymbolicAxis(this.xAxisLabel, this.symbolicNames) : new SymbolicAxis(this.xAxisLabel, stringArray);
        symbolicAxis.setVerticalTickLabels(true);
        this.plot.setDomainAxis((ValueAxis)symbolicAxis);
    }

    public synchronized void populateFromLens(LensedDataMatrix lensedDataMatrix, boolean bl) {
        if (!this.allowLiveUpdate) {
            return;
        }
        bl = true;
        boolean bl2 = false;
        if (this.symbolicNames.length != lensedDataMatrix.getColumnTitles().length) {
            bl2 = true;
        } else {
            for (int i = 0; i < this.symbolicNames.length; ++i) {
                if (this.symbolicNames[i].equals(lensedDataMatrix.getColumnTitles()[i])) continue;
                bl2 = true;
                break;
            }
        }
        if (bl2) {
            SymbolicAxis symbolicAxis = (SymbolicAxis)this.plot.getDomainAxis();
            this.symbolicNames = lensedDataMatrix.getColumnTitles();
            symbolicAxis = new SymbolicAxis(this.xAxisLabel, this.symbolicNames);
            symbolicAxis.setVerticalTickLabels(true);
            this.plot.getRenderer().setToolTipGenerator((XYToolTipGenerator)new ToolTipGenerator());
            this.plot.setDomainAxis((ValueAxis)symbolicAxis);
        }
        File file = new File(lensedDataMatrix.getUnderlyingMatrix().getShortName());
        this.resetStatusPanel();
        this.dataset.removeAllSeries();
        this.yAxisLabel = file.getName();
        if (lensedDataMatrix.getRowCount() == 0) {
            return;
        }
        for (int i = 0; i < lensedDataMatrix.getRowCount(); ++i) {
            double[] dArray = lensedDataMatrix.get(i);
            this.addData(lensedDataMatrix.getRowTitles()[i], dArray);
        }
        if (bl) {
            this.chart = this.createChart((XYDataset)this.dataset);
            if (this.toggleButton.getText().indexOf("Show") > -1) {
                this.toggleConditionNames(false);
            }
        }
        if (this.chartPanel != null) {
            this.chartPanel.setChart(this.chart);
        }
        this.setupItemList();
        this.resetColors();
        this.repaint();
    }

    public void placeInCenter() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        int n = (int)graphicsConfiguration.getBounds().getHeight();
        int n2 = (int)graphicsConfiguration.getBounds().getWidth();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        this.setLocation((n2 - n3) / 2, (n - n4) / 2);
    }

    class SelectorListRenderer
    implements ListCellRenderer {
        SelectorListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            LegendItem legendItem = null;
            Object var7_7 = null;
            ListItem listItem = null;
            String string = null;
            if (!(object instanceof ListItem)) {
                return null;
            }
            listItem = (ListItem)object;
            legendItem = listItem.getLegendItem();
            string = listItem.getAlternameName();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout());
            Font font = new Font(jList.getFont().getName(), 0, jList.getFont().getSize() - 2);
            String string2 = Plot2DPanel.this.nameHelper.getName(Plot2DPanel.this.butName.getActionCommand(), legendItem.getLabel());
            String string3 = legendItem.getLabel();
            if (!string.equals(legendItem.getLabel())) {
                string3 = string3 + " (" + string + ")";
            }
            jPanel.setToolTipText(string3);
            JButton jButton = new JButton(string2);
            jButton.setSize(new Dimension(20, 20));
            jButton.setForeground((Color)legendItem.getPaint());
            JLabel jLabel = new JLabel();
            Color color = jLabel.getBackground();
            jPanel.add(jButton);
            return jPanel;
        }
    }

    class ItemListSelectionListener
    implements ListSelectionListener {
        ItemListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n;
            Object object;
            Object object2;
            ListItem listItem;
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            JList jList = (JList)listSelectionEvent.getSource();
            Object[] objectArray = jList.getSelectedValues();
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            for (int i = 0; i < objectArray.length; ++i) {
                listItem = (ListItem)objectArray[i];
                object2 = listItem.getLegendItem();
                hashtable.put(object2.getLabel(), "~");
            }
            LegendItemCollection legendItemCollection = Plot2DPanel.this.plot.getLegendItems();
            listItem = Plot2DPanel.this.plot.getRenderer();
            object2 = new Color(230, 230, 230);
            XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            Hashtable<Object, String> hashtable3 = new Hashtable<Object, String>();
            for (int i = 0; i < Plot2DPanel.this.dataset.getSeriesCount(); ++i) {
                object = new Integer(i);
                hashtable2.put(Plot2DPanel.this.dataset.getSeriesName(i), object);
                hashtable3.put(object, Plot2DPanel.this.dataset.getSeriesName(i));
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                int n2 = (Integer)hashtable2.get(object);
                xYSeriesCollection.addSeries(Plot2DPanel.this.dataset.getSeries(n2));
            }
            for (n = 0; n < Plot2DPanel.this.dataset.getSeriesCount(); ++n) {
                try {
                    String string = Plot2DPanel.this.dataset.getSeriesName(n);
                    if (null != hashtable.get(new Integer(n))) {
                        Plot2DPanel.this.dataset.removeSeries(n);
                        continue;
                    }
                    listItem.setSeriesPaint(n, (Paint)object2);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    System.out.println("caught ex");
                }
            }
            for (n = 0; n < xYSeriesCollection.getSeriesCount(); ++n) {
                String string = xYSeriesCollection.getSeriesName(n);
                Plot2DPanel.this.dataset.addSeries(xYSeriesCollection.getSeries(n));
                int n3 = (Integer)hashtable2.get(string);
                listItem.setSeriesPaint(Plot2DPanel.this.dataset.getSeriesCount() - 1, (Paint)Plot2DPanel.this.savedPaints.get(xYSeriesCollection.getSeriesName(n)));
            }
            Plot2DPanel.this.chartPanel.repaint();
        }
    }

    class ListItem {
        private LegendItem li;
        private String alternateName;

        protected ListItem(LegendItem legendItem, String string) {
            this.li = legendItem;
            this.alternateName = string;
        }

        protected LegendItem getLegendItem() {
            return this.li;
        }

        protected String getAlternameName() {
            return this.alternateName;
        }
    }

    class ML
    implements ChartMouseListener {
        ML() {
        }

        public void chartMouseClicked(ChartMouseEvent chartMouseEvent) {
            ChartEntity chartEntity = chartMouseEvent.getEntity();
            String string = null;
            try {
                string = chartEntity.getShapeType();
            }
            catch (NullPointerException nullPointerException) {
                Plot2DPanel.this.resetStatusPanel();
                return;
            }
            XYMetaData xYMetaData = XYMetaData.parseToolTip(chartEntity.getToolTipText());
            Plot2DPanel.this.lblY.setText("   Y: " + xYMetaData.getY());
            Plot2DPanel.this.lblRow.setText("   Row: " + xYMetaData.getRow());
            try {
                Plot2DPanel.this.lblXAxis.setText("   " + Plot2DPanel.this.xAxisLabel + ": " + xYMetaData.getXTickName());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void chartMouseMoved(ChartMouseEvent chartMouseEvent) {
        }
    }

    class ToolTipGenerator
    implements XYToolTipGenerator {
        ToolTipGenerator() {
        }

        public String generateToolTip(XYDataset xYDataset, int n, int n2) {
            double d = (Double)xYDataset.getXValue(n, n2);
            double d2 = (Double)xYDataset.getYValue(n, n2);
            String string = xYDataset.getSeriesName(n);
            String string2 = null;
            string2 = Plot2DPanel.this.nameHelper.getName(Plot2DPanel.this.nameHelper.getDefaultCategory(), string);
            String string3 = Plot2DPanel.this.nameHelper.getName(Plot2DPanel.this.nameHelper.getCategoryList()[1], string);
            String string4 = "";
            if (d % 1.0 == 0.0) {
                try {
                    string4 = Plot2DPanel.this.xAxisLabel + "=" + Plot2DPanel.this.symbolicNames[(int)d];
                }
                catch (Exception exception) {
                    string4 = Plot2DPanel.this.xAxisLabel + "=Unknown";
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>" + string4 + "<br>y=" + d2 + "<br>row=" + string);
            if (null != string2 && string != string2) {
                stringBuffer.append(", " + string2);
            }
            if (!string3.equals(string2)) {
                stringBuffer.append(" (" + string3 + ")");
            }
            stringBuffer.append("</html>");
            return stringBuffer.toString();
        }
    }

    public class DismissAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("Plot2DPanel.dismiss ()");
        }
    }
}

