/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dtenenbaum.plot2d;

import csplugins.isb.dtenenbaum.nameHelper.NameHelper;
import csplugins.isb.dtenenbaum.nameHelper.NameHelperFactory;
import csplugins.isb.dtenenbaum.plot2d.UnsortedXYSeries;
import csplugins.isb.dtenenbaum.plot2d.XYMetaData;
import csplugins.isb.pshannon.experiment.datamatrix.LensedDataMatrix;
import csplugins.isb.pshannon.experiment.gui.actions.IconFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.SymbolicAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.labels.SymbolicXYItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;

public class Plot2D
extends JFrame {
    private String[] symbolicNames;
    private JComboBox cb;
    private String title;
    private String xAxisLabel;
    private String yAxisLabel;
    private ChartPanel chartPanel;
    private XYPlot plot;
    private int maxCols = 0;
    private XYSeriesCollection dataset;
    private JPanel statusPanel;
    private JButton butName;
    private NameHelper nameHelper = null;
    private JLabel lblY = new JLabel("   Y:");
    private JLabel lblRow = new JLabel("   Row:");
    private JLabel lblXAxis = new JLabel();
    private Hashtable savedPaints;
    private ItemListSelectionListener ilsl;
    private JScrollPane statusScroll;
    private JFreeChart chart;
    private JButton dismissButton;
    private JButton toggleButton;
    private static final int UNIT = 20;
    private static final int MIN_WIDTH = 333;
    private int width;
    private int cbWidth;
    private JList itemList;
    private boolean allowLiveUpdate = false;
    private LensedDataMatrix dm = null;
    private String[] nameCategories = null;

    public Plot2D() {
        this("", "", "", null, null);
    }

    public Plot2D(String string) {
        this(string, "", "", null, null);
    }

    public Plot2D(NameHelper nameHelper) {
        this("", "", "", null, nameHelper);
    }

    public Plot2D(String string, NameHelper nameHelper) {
        this(string, "", "", null, nameHelper);
    }

    public Plot2D(String string, String string2, String string3, LensedDataMatrix lensedDataMatrix, NameHelper nameHelper) {
        super("Plotter - " + string);
        this.title = string;
        this.xAxisLabel = string2;
        this.yAxisLabel = string3;
        this.dm = lensedDataMatrix;
        if (null == nameHelper) {
            nameHelper = NameHelperFactory.getNameHelper();
        }
        this.nameCategories = nameHelper.getCategoryList();
        this.nameHelper = nameHelper;
        this.initUI();
    }

    private void initUI() {
        GridBagConstraints gridBagConstraints;
        this.setSize(300, 400);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        this.butName = new JButton(IconFactory.getToggleIcon());
        this.butName.setBackground(Color.WHITE);
        this.butName.setToolTipText("Toggle the type of name displayed in the list.");
        this.butName.setActionCommand(this.nameHelper.getCategoryList()[0]);
        this.butName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Plot2D.this.butName.getActionCommand().equals(Plot2D.this.nameHelper.getCategoryList()[0])) {
                    Plot2D.this.butName.setActionCommand(Plot2D.this.nameHelper.getCategoryList()[1]);
                } else {
                    Plot2D.this.butName.setActionCommand(Plot2D.this.nameHelper.getCategoryList()[0]);
                }
                Plot2D.this.itemList.repaint();
            }
        });
        this.itemList = new JList();
        this.ilsl = new ItemListSelectionListener();
        this.itemList.addListSelectionListener(this.ilsl);
        JScrollPane jScrollPane = new JScrollPane(this.itemList);
        if (null != this.nameCategories) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            this.getContentPane().add((Component)this.butName, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = null != this.nameCategories ? 1 : 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)jScrollPane, gridBagConstraints);
        JButton jButton = new JButton("Clear");
        jButton.setToolTipText("Clears any selections in the list of names.");
        class ClearAction
        extends AbstractAction {
            public ClearAction() {
                super("Clear");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Plot2D.this.itemList.clearSelection();
                Plot2D.this.resetColors();
            }
        }
        jButton.setAction(new ClearAction());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        this.getContentPane().add((Component)jButton, gridBagConstraints);
        this.dataset = new XYSeriesCollection();
        this.chart = this.createChart((XYDataset)this.dataset);
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.setHorizontalZoom(true);
        this.chartPanel.setVerticalZoom(true);
        this.chartPanel.setMouseZoomable(true);
        LineBorder lineBorder = new LineBorder(Color.BLACK, 5);
        this.chartPanel.setBorder((Border)lineBorder);
        this.chartPanel.addChartMouseListener((ChartMouseListener)new ML());
        this.chartPanel.setHorizontalZoom(false);
        this.chartPanel.setVerticalZoom(false);
        this.chartPanel.setMouseZoomable(true);
        this.chartPanel.setSize(300, 300);
        this.chartPanel.setPreferredSize(new Dimension(300, 300));
        this.statusPanel = new JPanel();
        LineBorder lineBorder2 = new LineBorder(Color.BLACK, 2);
        this.statusPanel.setLayout(new GridLayout(3, 1));
        Font font = this.lblY.getFont();
        Font font2 = new Font(font.getFontName(), font.getStyle(), 12);
        this.lblY.setFont(font2);
        this.lblRow.setFont(font2);
        this.lblXAxis.setFont(font2);
        this.statusPanel.add(this.lblY);
        this.statusPanel.add(this.lblRow);
        if ("".equals(this.xAxisLabel)) {
            this.xAxisLabel = "Condition";
        }
        this.lblXAxis.setText("   " + this.xAxisLabel + ": ");
        this.statusPanel.add(this.lblXAxis);
        JSplitPane jSplitPane = new JSplitPane(0, (Component)this.chartPanel, this.statusPanel);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(275);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)jSplitPane, gridBagConstraints);
        this.toggleButton = new JButton("Hide Condition Names");
        this.toggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Plot2D.this.toggleButton.getText().indexOf("Hide") > -1) {
                    Plot2D.this.toggleButton.setText("Show Condition Names");
                    Plot2D.this.toggleConditionNames(false);
                } else {
                    Plot2D.this.toggleButton.setText("Hide Condition Names");
                    Plot2D.this.toggleConditionNames(true);
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.toggleButton, gridBagConstraints);
        this.dismissButton = new JButton(IconFactory.getDismissIcon());
        this.dismissButton.setBackground(Color.WHITE);
        this.dismissButton.setToolTipText("Closes this window.");
        this.dismissButton.setActionCommand("dismiss");
        this.dismissButton.addActionListener(new DismissAction(this));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 13;
        this.getContentPane().add((Component)this.dismissButton, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.cb = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        if (null != this.dm) {
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setSelected(this.allowLiveUpdate);
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    Plot2D.this.allowLiveUpdate = jCheckBox.isSelected();
                }
            });
            JLabel jLabel = new JLabel("Enable Live Update");
            font = jLabel.getFont();
            font2 = new Font(font.getFontName(), font.getStyle(), 9);
            jLabel.setFont(font2);
            String string = "Checking this box means that the plot will change in real time if the underlying data changes.";
            jCheckBox.setToolTipText(string);
            jLabel.setToolTipText(string);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)jCheckBox, "West");
            jPanel2.add((Component)jLabel, "Center");
            jPanel2.setBorder(new EtchedBorder());
            jPanel.add((Component)jPanel2, "Center");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 7;
            this.getContentPane().add((Component)jPanel2, gridBagConstraints);
        }
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (Plot2D.this.width == 0) {
                    return;
                }
                JFrame jFrame = (JFrame)componentEvent.getSource();
                if (jFrame.getWidth() == Plot2D.this.width) {
                    return;
                }
                if (Plot2D.this.width / 20 == jFrame.getWidth() / 20) {
                    jFrame.setSize(Plot2D.this.getSize());
                    return;
                }
                if (jFrame.getWidth() < 333) {
                    jFrame.setSize(333, jFrame.getHeight());
                }
                Plot2D.this.width = jFrame.getWidth();
                Plot2D.this.repaint();
            }
        });
    }

    public void addDismissListener(ActionListener actionListener) {
        this.dismissButton.addActionListener(actionListener);
    }

    public void addChartMouseListener(ChartMouseListener chartMouseListener) {
        this.chartPanel.addChartMouseListener(chartMouseListener);
    }

    public boolean getAllowLiveUpdate() {
        return this.allowLiveUpdate;
    }

    public void setAllowLiveUpdate(boolean bl) {
        this.allowLiveUpdate = bl;
    }

    private UnsortedXYSeries getSeries(String string) {
        if (this.dataset.getSeriesCount() == 0) {
            UnsortedXYSeries unsortedXYSeries = new UnsortedXYSeries(string);
            this.dataset.addSeries((XYSeries)unsortedXYSeries);
            return unsortedXYSeries;
        }
        for (int i = 0; i < this.dataset.getSeriesCount(); ++i) {
            if (!this.dataset.getSeries(i).getName().equals(string)) continue;
            return (UnsortedXYSeries)this.dataset.getSeries(i);
        }
        UnsortedXYSeries unsortedXYSeries = new UnsortedXYSeries(string);
        this.dataset.addSeries((XYSeries)unsortedXYSeries);
        return unsortedXYSeries;
    }

    private void addPoints(UnsortedXYSeries unsortedXYSeries, double[] dArray, double[] dArray2) {
        boolean bl = false;
        if (null == dArray) {
            bl = true;
            dArray = new double[dArray2.length];
        }
        for (int i = 0; i < dArray2.length; ++i) {
            if (bl) {
                dArray[i] = i;
            }
            unsortedXYSeries.add(dArray[i], dArray2[i]);
        }
    }

    private void addData(String string, double[] dArray) {
        UnsortedXYSeries unsortedXYSeries = this.getSeries(string);
        this.addPoints(unsortedXYSeries, null, dArray);
    }

    private JFreeChart createChart(XYDataset xYDataset) {
        File file = new File(this.yAxisLabel);
        String string = file.getName();
        NumberAxis numberAxis = new NumberAxis(string);
        if (null == this.symbolicNames || "".equals(this.symbolicNames[0])) {
            if (null == this.dm) {
                this.symbolicNames = new String[1];
                this.symbolicNames[0] = "";
            } else {
                this.symbolicNames = this.dm.getColumnTitles();
            }
        }
        SymbolicAxis symbolicAxis = new SymbolicAxis(this.xAxisLabel, this.symbolicNames);
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer(3, (XYToolTipGenerator)new SymbolicXYItemLabelGenerator());
        this.plot = new XYPlot(xYDataset, (ValueAxis)symbolicAxis, (ValueAxis)numberAxis, (XYItemRenderer)standardXYItemRenderer);
        this.plot.setDomainGridlinesVisible(true);
        this.plot.setRangeGridlinesVisible(true);
        JFreeChart jFreeChart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.plot, false);
        this.plot.getDomainAxis().setVerticalTickLabels(true);
        AbstractRenderer abstractRenderer = (AbstractRenderer)this.plot.getRenderer();
        Rectangle2D.Double double_ = new Rectangle2D.Double(-1.75, -1.75, 3.5, 3.5);
        XYItemRenderer xYItemRenderer = this.plot.getRenderer();
        xYItemRenderer.setShape((Shape)double_);
        this.plot.getRenderer().setToolTipGenerator((XYToolTipGenerator)new ToolTipGenerator());
        return jFreeChart;
    }

    private void resetStatusPanel() {
        this.lblY.setText("   Y:");
        this.lblRow.setText("   Row:");
        this.lblXAxis.setText("   " + this.xAxisLabel + ":");
    }

    public void setSize(Dimension dimension) {
        int n = dimension.getWidth() < 333.0 ? 333 : (int)dimension.getWidth();
        super.setSize(n, (int)dimension.getHeight());
    }

    public void setSize(int n, int n2) {
        this.setSize(new Dimension(n, n2));
    }

    private void resetColors() {
        XYItemRenderer xYItemRenderer = this.plot.getRenderer();
        for (int i = 0; i < this.dataset.getSeriesCount(); ++i) {
            xYItemRenderer.setSeriesPaint(i, (Paint)this.savedPaints.get(this.dataset.getSeriesName(i)));
        }
    }

    private void setupItemList() {
        this.itemList.setCellRenderer(new SelectorListRenderer());
        LegendItemCollection legendItemCollection = this.plot.getLegendItems();
        Vector<ListItem> vector = new Vector<ListItem>();
        this.savedPaints = new Hashtable();
        for (int i = 0; i < legendItemCollection.getItemCount(); ++i) {
            LegendItem legendItem = legendItemCollection.get(i);
            String string = this.nameHelper.getName(this.nameHelper.getCategoryList()[1], legendItem.getLabel());
            ListItem listItem = new ListItem(legendItem, string);
            vector.add(listItem);
            this.savedPaints.put(legendItem.getLabel(), legendItem.getPaint());
        }
        this.itemList.setListData(vector);
    }

    public void show() {
        if (null != this.dm) {
            boolean bl = this.allowLiveUpdate;
            this.allowLiveUpdate = true;
            this.populateFromLens(this.dm, true);
            this.allowLiveUpdate = bl;
        }
        this.setupItemList();
        this.width = this.getWidth();
        super.show();
        this.setSize(this.getSize());
    }

    public void toggleConditionNames(boolean bl) {
        SymbolicAxis symbolicAxis = (SymbolicAxis)this.plot.getDomainAxis();
        String[] stringArray = new String[this.symbolicNames.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "";
        }
        symbolicAxis = bl ? new SymbolicAxis(this.xAxisLabel, this.symbolicNames) : new SymbolicAxis(this.xAxisLabel, stringArray);
        symbolicAxis.setVerticalTickLabels(true);
        this.plot.setDomainAxis((ValueAxis)symbolicAxis);
    }

    public synchronized void populateFromLens(LensedDataMatrix lensedDataMatrix, boolean bl) {
        if (!this.allowLiveUpdate) {
            return;
        }
        bl = true;
        boolean bl2 = false;
        if (this.symbolicNames.length != lensedDataMatrix.getColumnTitles().length) {
            bl2 = true;
        } else {
            for (int i = 0; i < this.symbolicNames.length; ++i) {
                if (this.symbolicNames[i].equals(lensedDataMatrix.getColumnTitles()[i])) continue;
                bl2 = true;
                break;
            }
        }
        if (bl2) {
            SymbolicAxis symbolicAxis = (SymbolicAxis)this.plot.getDomainAxis();
            this.symbolicNames = lensedDataMatrix.getColumnTitles();
            symbolicAxis = new SymbolicAxis(this.xAxisLabel, this.symbolicNames);
            symbolicAxis.setVerticalTickLabels(true);
            this.plot.getRenderer().setToolTipGenerator((XYToolTipGenerator)new ToolTipGenerator());
            this.plot.setDomainAxis((ValueAxis)symbolicAxis);
        }
        File file = new File(lensedDataMatrix.getUnderlyingMatrix().getShortName());
        this.setTitle("Plotter - " + file.getName());
        this.resetStatusPanel();
        this.dataset.removeAllSeries();
        this.yAxisLabel = file.getName();
        if (lensedDataMatrix.getRowCount() == 0) {
            return;
        }
        for (int i = 0; i < lensedDataMatrix.getRowCount(); ++i) {
            double[] dArray = lensedDataMatrix.get(i);
            this.addData(lensedDataMatrix.getRowTitles()[i], dArray);
        }
        if (bl) {
            this.chart = this.createChart((XYDataset)this.dataset);
            if (this.toggleButton.getText().indexOf("Show") > -1) {
                this.toggleConditionNames(false);
            }
        }
        if (this.chartPanel != null) {
            this.chartPanel.setChart(this.chart);
        }
        this.setupItemList();
        this.resetColors();
        this.repaint();
    }

    public void placeInCenter() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        int n = (int)graphicsConfiguration.getBounds().getHeight();
        int n2 = (int)graphicsConfiguration.getBounds().getWidth();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        this.setLocation((n2 - n3) / 2, (n - n4) / 2);
    }

    class SelectorListRenderer
    implements ListCellRenderer {
        SelectorListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            LegendItem legendItem = null;
            Object var7_7 = null;
            ListItem listItem = null;
            String string = null;
            if (!(object instanceof ListItem)) {
                return null;
            }
            listItem = (ListItem)object;
            legendItem = listItem.getLegendItem();
            string = listItem.getAlternameName();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout());
            JLabel jLabel = new JLabel();
            Font font = new Font(jList.getFont().getName(), 0, jList.getFont().getSize() - 2);
            jLabel.setFont(font);
            jLabel.setOpaque(true);
            String string2 = Plot2D.this.nameHelper.getName(Plot2D.this.butName.getActionCommand(), legendItem.getLabel());
            jLabel.setText(string2);
            String string3 = legendItem.getLabel();
            if (!string.equals(legendItem.getLabel())) {
                string3 = string3 + " (" + string + ")";
            }
            jLabel.setToolTipText(string3);
            jPanel.setToolTipText(string3);
            JButton jButton = new JButton("");
            jButton.setBackground((Color)legendItem.getPaint());
            JLabel jLabel2 = new JLabel();
            Color color = jLabel2.getBackground();
            jPanel.add(jButton);
            jPanel.add(jLabel);
            if (bl) {
                jLabel.setBackground(color);
            } else {
                jLabel.setBackground(Color.WHITE);
            }
            return jPanel;
        }
    }

    class ItemListSelectionListener
    implements ListSelectionListener {
        ItemListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n;
            Object object;
            Object object2;
            ListItem listItem;
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            JList jList = (JList)listSelectionEvent.getSource();
            Object[] objectArray = jList.getSelectedValues();
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            for (int i = 0; i < objectArray.length; ++i) {
                listItem = (ListItem)objectArray[i];
                object2 = listItem.getLegendItem();
                hashtable.put(object2.getLabel(), "~");
            }
            LegendItemCollection legendItemCollection = Plot2D.this.plot.getLegendItems();
            listItem = Plot2D.this.plot.getRenderer();
            object2 = new Color(230, 230, 230);
            XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            Hashtable<Object, String> hashtable3 = new Hashtable<Object, String>();
            for (int i = 0; i < Plot2D.this.dataset.getSeriesCount(); ++i) {
                object = new Integer(i);
                hashtable2.put(Plot2D.this.dataset.getSeriesName(i), object);
                hashtable3.put(object, Plot2D.this.dataset.getSeriesName(i));
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                int n2 = (Integer)hashtable2.get(object);
                xYSeriesCollection.addSeries(Plot2D.this.dataset.getSeries(n2));
            }
            for (n = 0; n < Plot2D.this.dataset.getSeriesCount(); ++n) {
                try {
                    String string = Plot2D.this.dataset.getSeriesName(n);
                    if (null != hashtable.get(new Integer(n))) {
                        Plot2D.this.dataset.removeSeries(n);
                        continue;
                    }
                    listItem.setSeriesPaint(n, (Paint)object2);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    System.out.println("caught ex");
                }
            }
            for (n = 0; n < xYSeriesCollection.getSeriesCount(); ++n) {
                String string = xYSeriesCollection.getSeriesName(n);
                Plot2D.this.dataset.addSeries(xYSeriesCollection.getSeries(n));
                int n3 = (Integer)hashtable2.get(string);
                listItem.setSeriesPaint(Plot2D.this.dataset.getSeriesCount() - 1, (Paint)Plot2D.this.savedPaints.get(xYSeriesCollection.getSeriesName(n)));
            }
            Plot2D.this.chartPanel.repaint();
        }
    }

    class ListItem {
        private LegendItem li;
        private String alternateName;

        protected ListItem(LegendItem legendItem, String string) {
            this.li = legendItem;
            this.alternateName = string;
        }

        protected LegendItem getLegendItem() {
            return this.li;
        }

        protected String getAlternameName() {
            return this.alternateName;
        }
    }

    class ML
    implements ChartMouseListener {
        ML() {
        }

        public void chartMouseClicked(ChartMouseEvent chartMouseEvent) {
            ChartEntity chartEntity = chartMouseEvent.getEntity();
            String string = null;
            try {
                string = chartEntity.getShapeType();
            }
            catch (NullPointerException nullPointerException) {
                Plot2D.this.resetStatusPanel();
                return;
            }
            XYMetaData xYMetaData = XYMetaData.parseToolTip(chartEntity.getToolTipText());
            Plot2D.this.lblY.setText("   Y: " + xYMetaData.getY());
            Plot2D.this.lblRow.setText("   Row: " + xYMetaData.getRow());
            try {
                Plot2D.this.lblXAxis.setText("   " + Plot2D.this.xAxisLabel + ": " + xYMetaData.getXTickName());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void chartMouseMoved(ChartMouseEvent chartMouseEvent) {
        }
    }

    class ToolTipGenerator
    implements XYToolTipGenerator {
        ToolTipGenerator() {
        }

        public String generateToolTip(XYDataset xYDataset, int n, int n2) {
            double d = (Double)xYDataset.getXValue(n, n2);
            double d2 = (Double)xYDataset.getYValue(n, n2);
            String string = xYDataset.getSeriesName(n);
            String string2 = null;
            string2 = Plot2D.this.nameHelper.getName(Plot2D.this.nameHelper.getDefaultCategory(), string);
            String string3 = Plot2D.this.nameHelper.getName(Plot2D.this.nameHelper.getCategoryList()[1], string);
            String string4 = "";
            if (d % 1.0 == 0.0) {
                try {
                    string4 = Plot2D.this.xAxisLabel + "=" + Plot2D.this.symbolicNames[(int)d];
                }
                catch (Exception exception) {
                    string4 = Plot2D.this.xAxisLabel + "=Unknown";
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>" + string4 + "<br>y=" + d2 + "<br>row=" + string);
            if (null != string2 && string != string2) {
                stringBuffer.append(", " + string2);
            }
            if (!string3.equals(string2)) {
                stringBuffer.append(" (" + string3 + ")");
            }
            stringBuffer.append("</html>");
            return stringBuffer.toString();
        }
    }

    public class DismissAction
    extends AbstractAction {
        private JFrame frame;

        DismissAction(JFrame jFrame) {
            this.frame = jFrame;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.frame.dispose();
        }
    }
}

