/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dtenenbaum.jython.console;

import csplugins.isb.dtenenbaum.jython.console.PythonScriptFileFilter;
import csplugins.isb.dtenenbaum.jython.console.SPyConsole;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class SaveScriptAction
extends AbstractAction {
    SPyConsole _console = null;
    boolean _debug = true;
    protected static File _currentFile;
    protected static JFileChooser _fileChooser;
    protected boolean _prompt;

    public SaveScriptAction(SPyConsole sPyConsole, boolean bl) {
        super(bl ? "Save Script As..." : "Save Script...");
        this._console = sPyConsole;
        this._prompt = bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this._prompt) {
            this.saveDialog();
        } else {
            this.saveFile();
        }
    }

    public void saveFile(String string) throws IOException {
        File file = string == null ? null : new File(string);
        this.saveFile(file);
    }

    public void saveFile(File file) throws IOException {
        byte[] byArray = this._console.getText().getBytes();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
        _currentFile = file;
    }

    public boolean saveDialog() {
        if (_fileChooser == null) {
            _fileChooser = new JFileChooser(System.getProperty("user.dir"));
            _fileChooser.addChoosableFileFilter(new PythonScriptFileFilter());
            if (_currentFile != null) {
                _fileChooser.setCurrentDirectory(_currentFile);
            }
        }
        _fileChooser.setDialogType(1);
        if (_fileChooser.showSaveDialog(this._console.getAppFrame()) != 0) {
            return false;
        }
        try {
            this.saveFile(_fileChooser.getSelectedFile());
        }
        catch (IOException iOException) {
            if (this._debug) {
                iOException.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public boolean saveFile() {
        boolean bl = false;
        if (_currentFile == null) {
            bl = this.saveDialog();
        } else {
            try {
                this.saveFile(_currentFile);
                bl = true;
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this._console.getAppFrame(), "Could not save the file.", "SME Python Interface", 0);
            }
        }
        return bl;
    }
}

