/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dtenenbaum.jython.console;

import csplugins.isb.dtenenbaum.jython.console.PythonScriptFileFilter;
import csplugins.isb.dtenenbaum.jython.console.SPyConsole;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

public class LoadScriptAction
extends AbstractAction {
    SPyConsole console = null;
    static String driver_dir = System.getProperty("user.dir");
    static File lastDirectoryAccessed = new File(driver_dir, "../UserCode/");

    public LoadScriptAction(SPyConsole sPyConsole) {
        super("Load Script...");
        this.console = sPyConsole;
    }

    public static File getScriptFile(JFrame jFrame) {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        PythonScriptFileFilter pythonScriptFileFilter = new PythonScriptFileFilter();
        jFileChooser.addChoosableFileFilter(pythonScriptFileFilter);
        jFileChooser.setFileFilter(pythonScriptFileFilter);
        if (lastDirectoryAccessed != null) {
            jFileChooser.setCurrentDirectory(lastDirectoryAccessed);
        }
        if ((n = jFileChooser.showOpenDialog(jFrame)) != 0) {
            return null;
        }
        if (jFileChooser.getSelectedFile() == null) {
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        if (!file.exists()) {
            return null;
        }
        lastDirectoryAccessed = file;
        return file;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        File file = LoadScriptAction.getScriptFile(this.console.getAppFrame());
        String string = this.loadFile(file);
        if (string != null) {
            this.console.executeCommandSet(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadFile(File file) {
        if (file == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        System.out.println("Loading JPython script [ " + file.getName() + " ]");
        try {
            String string;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string + "\r\n");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Cannot find specified file: " + file.getName() + ". Please check the spelling");
        }
        catch (IOException iOException) {
            System.out.println("IO Exception!");
            iOException.printStackTrace();
        }
        finally {
            return stringBuffer.toString();
        }
    }
}

