/*
 * Decompiled with CFR 0.152.
 */
package csplugins.layout.jgraphaddons;

import cern.colt.map.OpenIntDoubleHashMap;
import cytoscape.layout.AbstractLayout;
import cytoscape.view.CyNetworkView;
import giny.view.NodeView;
import java.util.Iterator;

public class SpringEmbeddedLayoutAlgorithm
extends AbstractLayout {
    public static final String SPRING_EMBEDDED_DISP = "SpringEmbeddedDisp";
    public static final String SPRING_EMBEDDED_POS = "SpringEmbeddedPos";

    public SpringEmbeddedLayoutAlgorithm(CyNetworkView view) {
        super(view);
    }

    protected void initializeLocation() {
    }

    public Object construct() {
        int iterations;
        this.initialize();
        int[] nodes = this.network.getNodeIndicesArray();
        int[] edges = this.network.getEdgeIndicesArray();
        double W = this.getCurrentSize().getWidth();
        double L = this.getCurrentSize().getHeight();
        double area = W * L;
        OpenIntDoubleHashMap xdisp = new OpenIntDoubleHashMap();
        OpenIntDoubleHashMap ydisp = new OpenIntDoubleHashMap();
        double k = Math.sqrt(area / (double)nodes.length);
        this.lengthOfTask = iterations = 10;
        this.currentProgress = 0;
        ++this.currentProgress;
        double percent = this.currentProgress * 100 / this.lengthOfTask;
        this.statMessage = "Completed " + percent + "%";
        for (int i = 0; i < iterations; ++i) {
            double vPx;
            ++this.currentProgress;
            percent = this.currentProgress * 100 / this.lengthOfTask;
            this.statMessage = "Completed " + percent + "%";
            for (int vCount = 0; vCount < nodes.length; ++vCount) {
                double vx = xdisp.get(nodes[vCount]);
                double vy = ydisp.get(nodes[vCount]);
                for (int uCount = 0; uCount < nodes.length; ++uCount) {
                    if (nodes[uCount] == nodes[vCount]) continue;
                    double ux = this.networkView.getNodeDoubleProperty(nodes[uCount], 0);
                    double uy = this.networkView.getNodeDoubleProperty(nodes[uCount], 1);
                    double deltax = vx - ux;
                    double deltay = vy - uy;
                    double fr = this.fr(this.norm(deltax, deltay), k);
                    double deltaNormX = deltax / this.norm(deltax, deltay);
                    double dispX = deltaNormX * fr;
                    double deltaNormY = deltay / this.norm(deltax, deltay);
                    double dispY = deltaNormY * fr;
                    vx += dispX;
                    vy += dispY;
                }
                xdisp.put(nodes[vCount], vx);
                ydisp.put(nodes[vCount], vy);
            }
            for (int cellCount = 0; cellCount < edges.length; ++cellCount) {
                int u;
                int v = this.network.getEdgeSourceIndex(edges[cellCount]);
                if (v == (u = this.network.getEdgeSourceIndex(edges[cellCount]))) continue;
                vPx = this.networkView.getNodeDoubleProperty(v, 0);
                double vPy = this.networkView.getNodeDoubleProperty(v, 1);
                double uPx = this.networkView.getNodeDoubleProperty(u, 0);
                double uPy = this.networkView.getNodeDoubleProperty(u, 1);
                double vDx = xdisp.get(v);
                double vDy = ydisp.get(v);
                double uDx = xdisp.get(u);
                double uDy = ydisp.get(u);
                double deltax = vPx - uPx;
                double deltay = vPy - uPy;
                double fa = this.fa(this.norm(deltax, deltay), k);
                double deltaNormX = deltax / this.norm(deltax, deltay);
                double deltaNormY = deltay / this.norm(deltax, deltay);
                double dispX = deltaNormX * fa;
                double dispY = deltaNormY * fa;
                uDx += dispX;
                uDy += dispY;
                xdisp.put(v, vDx -= dispX);
                ydisp.put(v, vDy -= dispY);
                xdisp.put(u, uDx);
                ydisp.put(u, uDy);
            }
            double t = Math.sqrt(W * W + L * L) * ((double)iterations / (double)(i + 1) / (double)iterations);
            for (int vCount = 0; vCount < nodes.length; ++vCount) {
                vPx = this.networkView.getNodeDoubleProperty(nodes[vCount], 0);
                double vPy = this.networkView.getNodeDoubleProperty(nodes[vCount], 1);
                double vDx = xdisp.get(nodes[vCount]);
                double vDy = ydisp.get(nodes[vCount]);
                double dispNormX = vDx / this.norm(vDx, vDy);
                double minX = Math.min(Math.abs(vDx), t);
                double dispNormY = vDy / this.norm(vDx, vDy);
                double minY = Math.min(Math.abs(vDy), t);
                this.networkView.setNodeDoubleProperty(nodes[vCount], 0, vPx += dispNormX * minX);
                this.networkView.setNodeDoubleProperty(nodes[vCount], 1, vPy += dispNormY * minY);
            }
        }
        Iterator nod = this.networkView.getNodeViewsIterator();
        while (nod.hasNext()) {
            ((NodeView)nod.next()).setNodePosition(true);
        }
        return null;
    }

    protected double fa(double x, double k) {
        double force = x * x / k;
        return force;
    }

    protected double fr(double x, double k) {
        double force = k * k / x;
        return force;
    }

    protected double norm(double x, double y) {
        double norm = Math.sqrt(x * x + y * y);
        return norm;
    }
}

