/*
 * Decompiled with CFR 0.152.
 */
package csplugins.layout.jgraphaddons;

import cern.colt.list.IntArrayList;
import cern.colt.map.OpenIntIntHashMap;
import cytoscape.CyNetwork;
import cytoscape.layout.AbstractLayout;
import cytoscape.view.CyNetworkView;
import giny.model.GraphPerspective;
import giny.util.GraphPartition;
import giny.view.NodeView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RadialTreeLayoutAlgorithm
extends AbstractLayout {
    public static final String KEY_WIDTH = "Width";
    public static final String KEY_HEIGHT = "Height";
    public static final String KEY_CENTRE_X = "CentreX";
    public static final String KEY_CENTRE_Y = "CentreY";
    public static final String KEY_RADIUS_X = "RadiusX";
    public static final String KEY_RADIUS_Y = "RadiusY";
    private static final String RADIAL_TREE_VISITED = "RadialTreeVisited";
    private static final double TWO_PI = Math.PI * 2;
    private double RADIUSX;
    private double RADIUSY;
    private double ROOTX;
    private double ROOTY;
    CyNetwork parent;
    OpenIntIntHashMap radialTreeVisited;
    int layoutStep;
    List partions;

    public RadialTreeLayoutAlgorithm(CyNetworkView view) {
        super(view);
        this.network = view.getNetwork();
        this.parent = (CyNetwork)this.network;
        this.partions = GraphPartition.partition((GraphPerspective)this.parent);
        this.lengthOfTask = this.partions.size();
    }

    protected void initialize_local() {
    }

    protected void initialize_local_node_view(NodeView v) {
    }

    public void advancePositions() {
    }

    public String getName() {
        return "RadialTreeLayoutAlgorithm";
    }

    public Object construct() {
        double last_x = 0.0;
        double last_y = 0.0;
        double sum_x = 0.0;
        double sum_y = 0.0;
        Iterator i = this.partions.iterator();
        double node_count = this.parent.getNodeCount();
        node_count = Math.sqrt(node_count);
        node_count *= 100.0;
        double _x = 0.0;
        double _y = 0.0;
        double incr = 20.0;
        boolean ones = false;
        double small_x = Double.MAX_VALUE;
        while (i.hasNext()) {
            int[] nodes = (int[])i.next();
            if (nodes.length == 0) continue;
            this.network = this.parent.createGraphPerspective(nodes, this.parent.getConnectingEdgeIndicesArray(nodes));
            if (nodes.length != 1) {
                this.initialize();
                this.radialTreeVisited = new OpenIntIntHashMap(this.network.getNodeCount());
                int[] roots = this.getRoots();
                TreeNode tree = this.getSpanningTree(roots);
                if (null == tree) {
                    return null;
                }
                double depth = tree.getDepth();
                double WIDTH = this.getCurrentSize().getWidth();
                this.ROOTX = WIDTH / 2.0;
                this.RADIUSX = this.ROOTX / depth;
                double HEIGHT = this.getCurrentSize().getHeight();
                this.ROOTY = HEIGHT / 2.0;
                this.RADIUSY = this.ROOTY / depth;
                this.layoutTree0(tree);
                this.move(sum_x, sum_y);
                sum_x += this.currentSize.getWidth();
            } else {
                if (!ones) {
                    ones = true;
                    incr = 20.0;
                    _x = 0.0;
                    _y = sum_y + last_y;
                    if (small_x == Double.MAX_VALUE) {
                        small_x = 0.0;
                    }
                }
                if (_x > node_count) {
                    _y += incr;
                    _x = 0.0;
                } else {
                    _x += incr;
                }
                this.setSingle(_x, _y);
            }
            if (this.currentSize.getHeight() > last_y) {
                last_y = this.currentSize.getHeight();
            }
            if (!(sum_x > node_count)) continue;
            sum_x = 0.0;
            sum_y += last_y;
            last_y = 0.0;
        }
        Iterator n = this.networkView.getNodeViewsIterator();
        while (n.hasNext()) {
            ((NodeView)n.next()).setNodePosition(true);
        }
        return null;
    }

    private void layoutTree0(TreeNode node) {
        node.angle = 0.0;
        node.x = this.ROOTX;
        node.y = this.ROOTY;
        node.rightBisector = 0.0;
        node.rightTangent = 0.0;
        node.leftBisector = Math.PI * 2;
        node.leftTangent = Math.PI * 2;
        int node_index = node.getNode();
        this.placeView(node_index, this.ROOTX, this.ROOTY);
        if (node_index != 0) {
            System.out.println("Placed root: " + node_index + this.network.getNode(node_index).getIdentifier() + " X: " + this.ROOTX + " Y: " + this.ROOTY);
        } else {
            System.out.println("ghost root:" + node.getChildren().size());
        }
        ArrayList<TreeNode> parent = new ArrayList<TreeNode>(1);
        parent.add(node);
        this.layoutTreeN(1, parent);
    }

    private void layoutTreeN(int level, List nodes) {
        double prevAngle = 0.0;
        TreeNode firstParent = null;
        TreeNode prevParent = null;
        ArrayList<TreeNode> parentNodes = new ArrayList<TreeNode>();
        Iterator nitr = nodes.iterator();
        while (nitr.hasNext()) {
            TreeNode parent = (TreeNode)nitr.next();
            List children = parent.getChildren();
            double rightLimit = parent.rightLimit();
            double angleSpace = (parent.leftLimit() - rightLimit) / (double)children.size();
            Iterator itr = children.iterator();
            double i = 0.5;
            while (itr.hasNext()) {
                TreeNode node = (TreeNode)itr.next();
                int node_index = node.getNode();
                node.angle = rightLimit + i * angleSpace;
                node.x = this.ROOTX + (double)level * this.RADIUSX * Math.cos(node.angle);
                node.y = this.ROOTY + (double)level * this.RADIUSY * Math.sin(node.angle);
                this.placeView(node_index, node.x, node.y);
                if (node.hasChildren()) {
                    parentNodes.add(node);
                    if (null == firstParent) {
                        firstParent = node;
                    }
                    double prevGap = node.angle - prevAngle;
                    node.rightBisector = node.angle - prevGap / 2.0;
                    if (null != prevParent) {
                        prevParent.leftBisector = node.rightBisector;
                    }
                    double arcAngle = (double)level / ((double)level + 1.0);
                    double arc = 2.0 * Math.asin(arcAngle);
                    node.leftTangent = node.angle + arc;
                    node.rightTangent = node.angle - arc;
                    prevAngle = node.angle;
                    prevParent = node;
                }
                i += 1.0;
            }
        }
        if (null != firstParent) {
            double remaningAngle = Math.PI * 2 - prevParent.angle;
            firstParent.rightBisector = (firstParent.angle - remaningAngle) / 2.0;
            prevParent.leftBisector = firstParent.rightBisector < 0.0 ? firstParent.rightBisector + Math.PI * 2 + Math.PI * 2 : firstParent.rightBisector + Math.PI * 2;
        }
        if (parentNodes.size() > 0) {
            this.layoutTreeN(level + 1, parentNodes);
        }
    }

    private void placeView(int node_index, double x, double y) {
        this.networkView.setNodeDoubleProperty(node_index, 0, x);
        this.networkView.setNodeDoubleProperty(node_index, 1, y);
    }

    private int[] getRoots() {
        int[] nodes = this.network.getNodeIndicesArray();
        IntArrayList roots = new IntArrayList();
        for (int i = 0; i < nodes.length; ++i) {
            if (this.network.getInDegree(nodes[i], false) != 0 || this.network.getOutDegree(nodes[i], true) == 0) continue;
            roots.add(nodes[i]);
        }
        roots.trimToSize();
        return roots.elements();
    }

    private TreeNode getSpanningTree(int[] roots) {
        TreeNode node;
        int[] nodes = this.network.getNodeIndicesArray();
        if (roots.length == 0) {
            roots = new int[]{nodes[(int)((double)nodes.length * Math.random())]};
        }
        if (roots.length > 1) {
            node = new TreeNode(0);
            this.buildSpanningTree(node, roots);
        } else {
            node = new TreeNode(roots[0]);
            this.radialTreeVisited.put(roots[0], 1);
            this.buildSpanningTree(node, this.network.neighborsArray(roots[0]));
        }
        return node;
    }

    private void buildSpanningTree(TreeNode node, int[] children) {
        TreeNode childNode;
        for (int i = 0; i < children.length; ++i) {
            if (this.radialTreeVisited.get(this.network.getRootGraphNodeIndex(children[i])) == 1) continue;
            this.radialTreeVisited.put(this.network.getRootGraphNodeIndex(children[i]), 1);
            childNode = new TreeNode(this.network.getRootGraphNodeIndex(children[i]));
            node.addChild(childNode);
        }
        Iterator itr = node.getChildren().iterator();
        while (itr.hasNext()) {
            childNode = (TreeNode)itr.next();
            this.buildSpanningTree(childNode, this.network.neighborsArray(childNode.getNode()));
        }
    }

    private static class TreeNode {
        private int node;
        private List children = new ArrayList();
        public double angle;
        public double x;
        public double y;
        public double rightBisector;
        public double leftBisector;
        public double rightTangent;
        public double leftTangent;

        TreeNode(int node) {
            this.node = node;
        }

        public int getDepth() {
            int depth = 1;
            Iterator itr = this.children.iterator();
            while (itr.hasNext()) {
                TreeNode node = (TreeNode)itr.next();
                int childDepth = node.getDepth();
                if (childDepth < depth) continue;
                depth = childDepth + 1;
            }
            return depth;
        }

        public int getNode() {
            return this.node;
        }

        public void addChild(TreeNode node) {
            this.children.add(node);
        }

        public List getChildren() {
            return this.children;
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }

        public double leftLimit() {
            return Math.min(this.normalize(this.leftBisector), this.leftTangent);
        }

        public double rightLimit() {
            return Math.max(this.normalize(this.rightBisector), this.rightTangent);
        }

        private double normalize(double angle) {
            return angle;
        }
    }
}

