/*
 * Decompiled with CFR 0.152.
 */
package csplugins.layout;

import cern.colt.map.OpenIntObjectHashMap;
import cern.colt.map.PrimeFinder;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cytoscape.CyNetwork;
import cytoscape.layout.AbstractLayout;
import cytoscape.view.CyNetworkView;
import giny.model.GraphPerspective;
import giny.model.Node;
import giny.util.GraphPartition;
import giny.view.NodeView;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ISOMLayout
extends AbstractLayout {
    private int maxEpoch = 2000;
    private int epoch;
    private int radiusConstantTime;
    private int radius;
    private int minRadius;
    private double adaption;
    private double initialAdaption;
    private double minAdaption;
    private double factor;
    private double coolingFactor;
    private boolean trace;
    private boolean done;
    private Vector queue;
    private String status = null;
    private OpenIntObjectHashMap nodeIndexToDataMap;
    private double globalX;
    private double globalY;
    CyNetwork parent;
    List partions;
    Iterator i;
    double percent;

    public ISOMLayout(CyNetworkView view) {
        super(view);
        System.out.println("Initialize_Local");
        this.parent = (CyNetwork)this.network;
        this.partions = GraphPartition.partition((GraphPerspective)this.parent);
        this.i = this.partions.iterator();
        this.lengthOfTask = this.partions.size() * this.maxEpoch;
    }

    public Object construct() {
        Object nodes;
        double last_x = 0.0;
        double last_y = 0.0;
        double sum_x = 0.0;
        double sum_y = 0.0;
        double _x = 0.0;
        double _y = 0.0;
        double incr = 100.0;
        boolean ones = false;
        double small_x = Double.MAX_VALUE;
        double node_count = this.parent.getNodeCount();
        node_count = Math.sqrt(node_count);
        node_count *= 100.0;
        ++this.currentProgress;
        this.percent = this.currentProgress * 100 / this.lengthOfTask;
        this.statMessage = "Completed " + this.percent + "%";
        while (this.i.hasNext()) {
            nodes = (int[])this.i.next();
            if (((Object)nodes).length == 0) continue;
            this.network = this.parent.createGraphPerspective((int[])nodes, this.parent.getConnectingEdgeIndicesArray((int[])nodes));
            if (((Object)nodes).length != 1) {
                this.prepare();
                this.initialize();
                this.do_it();
                this.move(sum_x, sum_y);
                sum_x += this.currentSize.getWidth();
            } else {
                if (!ones) {
                    System.out.println("Got to singletons");
                    ones = true;
                    incr = 20.0;
                    _x = 0.0;
                    _y = sum_y + last_y;
                    if (small_x == Double.MAX_VALUE) {
                        small_x = 0.0;
                    }
                }
                if (_x > node_count) {
                    _y += incr;
                    _x = 0.0;
                } else {
                    _x += incr;
                }
                System.out.println("Move to x: " + _x + " y: " + _y);
                this.setSingle(_x, _y);
            }
            if (this.currentSize.getHeight() > last_y) {
                last_y = this.currentSize.getHeight();
            }
            if (!(sum_x > node_count)) continue;
            sum_x = 0.0;
            sum_y += last_y;
            last_y = 0.0;
        }
        nodes = this.networkView.getNodeViewsIterator();
        while (nodes.hasNext()) {
            ((NodeView)nodes.next()).setNodePosition(true);
        }
        this.done = true;
        return null;
    }

    public void prepare() {
        this.nodeIndexToDataMap = new OpenIntObjectHashMap(PrimeFinder.nextPrime((int)this.network.getNodeCount()));
        this.queue = new Vector();
        this.trace = false;
    }

    public void do_it() {
        while (this.epoch < this.maxEpoch) {
            this.advancePositions();
        }
    }

    public String getName() {
        return "ISOM Layout";
    }

    public String getStatus() {
        return this.status;
    }

    protected void initialize_local() {
        this.done = false;
        this.epoch = 1;
        this.radiusConstantTime = 100;
        this.radius = 5;
        this.minRadius = 1;
        this.adaption = this.initialAdaption = 0.9;
        this.minAdaption = 0.0;
        this.coolingFactor = 2.0;
    }

    protected void initialize_local_node_view(NodeView v) {
        ISOMVertexData vd = this.getISOMVertexData(v);
        if (vd == null) {
            vd = new ISOMVertexData();
            this.nodeIndexToDataMap.put(v.getRootGraphIndex(), (Object)vd);
        }
        vd.visited = false;
    }

    public void advancePositions() {
        this.status = "epoch: " + this.epoch + "; ";
        ++this.currentProgress;
        this.percent = this.currentProgress * 100 / this.lengthOfTask;
        this.statMessage = "Completed " + this.percent + "%";
        if (this.epoch < this.maxEpoch) {
            this.adjust();
            this.updateParameters();
            this.status = this.status + " status: running";
        } else {
            this.status = this.status + "adaption: " + this.adaption + "; ";
            this.status = this.status + "status: done";
            this.done = true;
        }
    }

    private synchronized void adjust() {
        ISOMVertexData tempISOM = new ISOMVertexData();
        this.globalX = 10.0 + Math.random() * this.getCurrentSize().getWidth();
        this.globalY = 10.0 + Math.random() * this.getCurrentSize().getHeight();
        NodeView winner = this.getNodeView(this.globalX, this.globalY);
        Iterator iter = this.network.nodesIterator();
        while (iter.hasNext()) {
            NodeView v = this.networkView.getNodeView((Node)iter.next());
            ISOMVertexData ivd = this.getISOMVertexData(v);
            ivd.distance = 0;
            ivd.visited = false;
        }
        this.adjustVertex(winner);
    }

    private synchronized void updateParameters() {
        ++this.epoch;
        double factor = Math.exp(-1.0 * this.coolingFactor * (1.0 * (double)this.epoch / (double)this.maxEpoch));
        this.adaption = Math.max(this.minAdaption, factor * this.initialAdaption);
        if (this.radius > this.minRadius && this.epoch % this.radiusConstantTime == 0) {
            --this.radius;
        }
    }

    private synchronized void adjustVertex(NodeView v) {
        this.queue.removeAllElements();
        ISOMVertexData ivd = this.getISOMVertexData(v);
        ivd.distance = 0;
        ivd.visited = true;
        this.queue.add(v);
        while (!this.queue.isEmpty()) {
            NodeView current = (NodeView)this.queue.remove(0);
            ISOMVertexData currData = this.getISOMVertexData(current);
            int current_index = current.getRootGraphIndex();
            double current_x = this.networkView.getNodeDoubleProperty(current_index, 0);
            double current_y = this.networkView.getNodeDoubleProperty(current_index, 1);
            double dx = this.globalX - current_x;
            double dy = this.globalY - current_y;
            double factor = this.adaption / Math.pow(2.0, currData.distance);
            this.networkView.setNodeDoubleProperty(current_index, 0, current_x + factor * dx);
            this.networkView.setNodeDoubleProperty(current_index, 1, current_y + factor * dy);
            if (currData.distance >= this.radius) continue;
            int[] neighbors = this.network.neighborsArray(current_index);
            for (int neighbor_index = 0; neighbor_index < neighbors.length; ++neighbor_index) {
                NodeView child = this.networkView.getNodeView(this.network.getRootGraphNodeIndex(neighbors[neighbor_index]));
                ISOMVertexData childData = this.getISOMVertexData(child);
                if (childData.visited) continue;
                childData.visited = true;
                childData.distance = currData.distance + 1;
                this.queue.addElement(child);
            }
        }
    }

    public ISOMVertexData getISOMVertexData(NodeView v) {
        return (ISOMVertexData)this.nodeIndexToDataMap.get(v.getRootGraphIndex());
    }

    public ISOMVertexData getISOMVertexData(int v) {
        return (ISOMVertexData)this.nodeIndexToDataMap.get(v);
    }

    public boolean isIncremental() {
        return true;
    }

    public boolean incrementsAreDone() {
        return false;
    }

    public static class ISOMVertexData {
        public DoubleMatrix1D disp;
        int distance;
        boolean visited;

        public ISOMVertexData() {
            this.initialize();
        }

        public void initialize() {
            this.disp = new DenseDoubleMatrix1D(2);
            this.distance = 0;
            this.visited = false;
        }

        public double getXDisp() {
            return this.disp.get(0);
        }

        public double getYDisp() {
            return this.disp.get(1);
        }

        public void setDisp(double x, double y) {
            this.disp.set(0, x);
            this.disp.set(1, y);
        }

        public void incrementDisp(double x, double y) {
            this.disp.set(0, this.disp.get(0) + x);
            this.disp.set(1, this.disp.get(1) + y);
        }

        public void decrementDisp(double x, double y) {
            this.disp.set(0, this.disp.get(0) - x);
            this.disp.set(1, this.disp.get(1) - y);
        }
    }
}

