/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import y.io.BadVersionException;
import y.view.NodeRealizer;
import y.view.Util;

public class ShapeNodeRealizer
extends NodeRealizer {
    public static final byte RECT = 0;
    public static final byte ROUND_RECT = 1;
    public static final byte ELLIPSE = 2;
    public static final byte PARALLELOGRAM = 3;
    public static final byte HEXAGON = 4;
    public static final byte TRIANGLE = 5;
    public static final byte RECT_3D = 6;
    public static final byte OCTAGON = 7;
    public static final byte DIAMOND = 8;
    public static final byte TRAPEZOID = 9;
    public static final byte TRAPEZOID_2 = 10;
    protected Shape shape;
    private byte ab;
    private static final double ac = 5.0;
    private static final double aa = 1.2217304763960306;
    private static Rectangle2D z = new Rectangle2D.Double();

    public ShapeNodeRealizer() {
        this(0, 0.0, 0.0, "");
    }

    public ShapeNodeRealizer(byte by) {
        this(by, 0.0, 0.0, "");
    }

    public ShapeNodeRealizer(byte by, double d2, double d3, String string) {
        super(d2, d3, string);
        this.setShapeType(by);
    }

    public ShapeNodeRealizer(NodeRealizer nodeRealizer) {
        super(nodeRealizer);
        if (nodeRealizer instanceof ShapeNodeRealizer) {
            this.setShapeType(((ShapeNodeRealizer)nodeRealizer).getShapeType());
        } else {
            this.setShapeType((byte)0);
        }
    }

    public NodeRealizer createCopy(NodeRealizer nodeRealizer) {
        return new ShapeNodeRealizer(nodeRealizer);
    }

    public void setCenter(double d2, double d3) {
        this.a(d2 - this.getWidth() / 2.0, d3 - this.getHeight() / 2.0);
    }

    public void setLocation(double d2, double d3) {
        this.a(d2, d3);
    }

    private void a(double d2, double d3) {
        if (this.shape instanceof RectangularShape) {
            super.setLocation(d2, d3);
            ((RectangularShape)this.shape).setFrame(this.x, this.y, this.width, this.height);
        } else if (this.shape instanceof GeneralPath) {
            ((GeneralPath)this.shape).transform(AffineTransform.getTranslateInstance(d2 - this.x, d3 - this.y));
            super.setLocation(d2, d3);
        }
    }

    public void moveBy(double d2, double d3) {
        this.a(this.getX() + d2, this.getY() + d3);
    }

    public void setSize(double d2, double d3) {
        if (this.shape instanceof RectangularShape) {
            super.setSize(d2, d3);
            ((RectangularShape)this.shape).setFrame(this.x, this.y, d2, d3);
        } else if (this.shape instanceof GeneralPath) {
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.getCenterX(), this.getCenterY());
            affineTransform.scale(d2 / this.width, d3 / this.height);
            affineTransform.translate(-this.getCenterX(), -this.getCenterY());
            ((GeneralPath)this.shape).transform(affineTransform);
            super.setSize(d2, d3);
        } else {
            super.setSize(d2, d3);
        }
    }

    private double c() {
        return this.width / 2.0;
    }

    public void setShapeType(byte by) {
        switch (by) {
            case 2: {
                this.shape = new Ellipse2D.Double(this.x, this.y, this.width, this.height);
                break;
            }
            case 0: 
            case 6: {
                this.shape = new Rectangle2D.Double(this.x, this.y, this.width, this.height);
                break;
            }
            case 1: {
                this.shape = new RoundRectangle2D.Double(this.x, this.y, this.width, this.height, 8.0, 8.0);
                break;
            }
            case 3: {
                GeneralPath generalPath = new GeneralPath(0, 5);
                generalPath = new GeneralPath(0, 5);
                generalPath.moveTo((float)(this.x + this.width * 0.1), (float)this.y);
                generalPath.lineTo((float)(this.x + this.width), (float)this.y);
                generalPath.lineTo((float)(this.x + this.width * 0.9), (float)(this.y + this.height));
                generalPath.lineTo((float)this.x, (float)(this.y + this.height));
                generalPath.closePath();
                this.shape = generalPath;
                break;
            }
            case 4: {
                GeneralPath generalPath = new GeneralPath(0, 6);
                generalPath.moveTo((float)this.x, (float)(this.y + this.height / 2.0));
                generalPath.lineTo((float)(this.x + this.width * 0.1), (float)this.y);
                generalPath.lineTo((float)(this.x + this.width * 0.9), (float)this.y);
                generalPath.lineTo((float)(this.x + this.width), (float)(this.y + this.height / 2.0));
                generalPath.lineTo((float)(this.x + this.width * 0.9), (float)(this.y + this.height));
                generalPath.lineTo((float)(this.x + this.width * 0.1), (float)(this.y + this.height));
                generalPath.closePath();
                this.shape = generalPath;
                break;
            }
            case 5: {
                GeneralPath generalPath = new GeneralPath(0, 3);
                generalPath.moveTo((float)(this.x + this.width / 2.0), (float)this.y);
                generalPath.lineTo((float)(this.x + this.width), (float)(this.y + this.height));
                generalPath.lineTo((float)this.x, (float)(this.y + this.height));
                generalPath.closePath();
                this.shape = generalPath;
                break;
            }
            case 7: {
                double d2 = Math.sqrt(2.0);
                double d3 = this.width / (2.0 + d2);
                double d4 = this.height / (2.0 + d2);
                GeneralPath generalPath = new GeneralPath(0, 8);
                generalPath.moveTo((float)this.x, (float)(this.y + d4));
                generalPath.lineTo((float)(this.x + d3), (float)this.y);
                generalPath.lineTo((float)(this.x + this.width - d3), (float)this.y);
                generalPath.lineTo((float)(this.x + this.width), (float)(this.y + d4));
                generalPath.lineTo((float)(this.x + this.width), (float)(this.y + this.height - d4));
                generalPath.lineTo((float)(this.x + this.width - d3), (float)(this.y + this.height));
                generalPath.lineTo((float)(this.x + d3), (float)(this.y + this.height));
                generalPath.lineTo((float)this.x, (float)(this.y + this.height - d4));
                generalPath.closePath();
                this.shape = generalPath;
                break;
            }
            case 8: {
                GeneralPath generalPath = new GeneralPath(0, 4);
                generalPath.moveTo((float)this.x, (float)(this.y + this.height * 0.5));
                generalPath.lineTo((float)(this.x + this.width * 0.5), (float)this.y);
                generalPath.lineTo((float)(this.x + this.width), (float)(this.y + this.height * 0.5));
                generalPath.lineTo((float)(this.x + this.width * 0.5), (float)(this.y + this.height));
                generalPath.closePath();
                this.shape = generalPath;
                break;
            }
            case 9: {
                GeneralPath generalPath = new GeneralPath(0, 4);
                generalPath.moveTo((float)this.x, (float)(this.y + this.height));
                generalPath.lineTo((float)(this.x + this.width * 0.25), (float)this.y);
                generalPath.lineTo((float)(this.x + this.width * 0.75), (float)this.y);
                generalPath.lineTo((float)(this.x + this.width), (float)(this.y + this.height));
                generalPath.closePath();
                this.shape = generalPath;
                break;
            }
            case 10: {
                GeneralPath generalPath = new GeneralPath(0, 4);
                generalPath.moveTo((float)this.x, (float)this.y);
                generalPath.lineTo((float)(this.x + this.width), (float)this.y);
                generalPath.lineTo((float)(this.x + this.width * 0.75), (float)(this.y + this.height));
                generalPath.lineTo((float)(this.x + this.width * 0.25), (float)(this.y + this.height));
                generalPath.closePath();
                this.shape = generalPath;
            }
        }
        this.ab = by;
        this.setEdgesDirty();
    }

    public byte getShapeType() {
        return this.ab;
    }

    protected void paintNode(Graphics2D graphics2D) {
        Color color = this.getFillColor();
        Color color2 = this.getFillColor2();
        if (this.isSelected()) {
            this.paintHotSpots(graphics2D);
            color = color.darker();
            if (color2 != null) {
                color2 = color2.darker();
            }
        }
        if (color2 == null || this.ab == 6 || color.equals(color2)) {
            graphics2D.setColor(color);
        } else {
            graphics2D.setPaint(new GradientPaint((float)(this.getX() + this.getWidth() / 3.0), (float)this.getY(), color, (float)(this.getX() + this.getWidth()), (float)this.getY(), color2, true));
        }
        if (this.ab == 6) {
            graphics2D.fill3DRect((int)this.x, (int)this.y, (int)this.width, (int)this.height, true);
        } else {
            if (!this.isTransparent()) {
                graphics2D.fill(this.shape);
            }
            graphics2D.setStroke(this.getLineType());
            graphics2D.setColor(this.getLineColor());
            if (this.ab == 2) {
                Util.alias(graphics2D);
                graphics2D.draw(this.shape);
                Util.unalias(graphics2D);
            } else {
                graphics2D.draw(this.shape);
            }
        }
        this.paintText(graphics2D);
    }

    public boolean contains(double d2, double d3) {
        z.setRect(d2 - 5.0, d3 - 5.0, 10.0, 10.0);
        if (this.isTransparent()) {
            return this.shape.intersects(z) && (!this.shape.contains(d2 - 5.0, d3 - 5.0) || !this.shape.contains(d2 + 5.0, d3 - 5.0) || !this.shape.contains(d2 - 5.0, d3 + 5.0) || !this.shape.contains(d2 + 5.0, d3 + 5.0));
        }
        return this.shape.contains(d2, d3);
    }

    public boolean findIntersection(double d2, double d3, double d4, double d5, Point2D point2D) {
        if (d2 == d4 && d3 == d5) {
            return false;
        }
        if (this.ab == 2 && d2 == this.getCenterX() && d3 == this.getCenterY()) {
            double d6;
            double d7;
            if (!this.contains(d2, d3) || this.contains(d4, d5)) {
                return false;
            }
            double d8 = d4 - this.getCenterX();
            double d9 = d5 - this.getCenterY();
            if (this.width < 1.0E-6 || this.height < 1.0E-6) {
                d7 = 0.0;
                d6 = 0.0;
            } else {
                double d10 = Math.abs(d9 / d8);
                d7 = this.width * this.height / 4.0 * Math.sqrt(1.0 / (d10 * d10 * this.width * this.width / 4.0 + this.height * this.height / 4.0));
                d6 = this.height / 2.0 * Math.sqrt(1.0 - d7 * d7 / (this.width * this.width / 4.0));
                if (d8 < 0.0) {
                    d7 = -d7;
                }
                if (d9 < 0.0) {
                    d6 = -d6;
                }
            }
            point2D.setLocation(this.getCenterX() + d7, this.getCenterY() + d6);
        } else if (this.ab == 0 && d2 == this.getCenterX() && d3 == this.getCenterY()) {
            this.findBBIntersection(d2, d3, d4, d5, point2D);
        } else {
            super.findIntersection(d2, d3, d4, d5, point2D);
        }
        return true;
    }

    public void write(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(0);
        super.write(objectOutputStream);
        objectOutputStream.writeByte(this.ab);
    }

    public void read(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        switch (objectInputStream.readByte()) {
            case 0: {
                super.read(objectInputStream);
                this.setShapeType(objectInputStream.readByte());
                break;
            }
            default: {
                throw new BadVersionException();
            }
        }
    }

    public static Map shapeTypeToStringMap() {
        HashMap<Byte, String> hashMap = new HashMap<Byte, String>(23);
        hashMap.put(new Byte(0), "Rectangle");
        hashMap.put(new Byte(1), "Round Rect");
        hashMap.put(new Byte(2), "Ellipse");
        hashMap.put(new Byte(3), "Parallelogram");
        hashMap.put(new Byte(4), "Hexagon");
        hashMap.put(new Byte(5), "Triangle");
        hashMap.put(new Byte(6), "Rectangle 3D");
        hashMap.put(new Byte(7), "Octagon");
        hashMap.put(new Byte(8), "Diamond");
        hashMap.put(new Byte(9), "Trapezoid");
        hashMap.put(new Byte(10), "Trapezoid 2");
        return hashMap;
    }
}

