/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.Cursor;
import java.awt.geom.Point2D;
import y.util.D;
import y.view.PopupMode;
import y.view.Scroller;
import y.view.ViewContainer;
import y.view.ViewMode;

public class NavigationMode
extends ViewMode {
    private int bu;
    private int bt;
    private double br;
    private double bq;
    private Scroller bp;
    private PopupMode bs;

    public NavigationMode(ViewContainer viewContainer) {
        super(viewContainer);
        this.setName("NAVIGATION_MODE");
    }

    public NavigationMode() {
        this.setName("NAVIGATION_MODE");
    }

    public void activate(boolean bl) {
        super.activate(bl);
        if (bl) {
            this.view.setScrollBarPolicy(21, 31);
            this.view.setViewCursor(Cursor.getPredefinedCursor(0));
            this.view.updateView();
        }
    }

    public PopupMode getPopupMode() {
        return this.bs;
    }

    public void setPopupMode(PopupMode popupMode) {
        D.bug(this, (Object)"setting the popup");
        this.bs = popupMode;
    }

    public void mousePressedLeft(double d2, double d3) {
        this.bu = this.originalX;
        this.bt = this.originalY;
        Point2D point2D = this.view.getCenter();
        this.br = point2D.getX();
        this.bq = point2D.getY();
        this.view.setViewCursor(Cursor.getPredefinedCursor(13));
    }

    public void mousePressedRight(double d2, double d3) {
        if (this.getPopupMode() == null) {
            this.bu = this.originalX;
            this.bt = this.originalY;
            this.bp = new Scroller(this.view, d2, d3);
            Thread thread = new Thread(this.bp);
            thread.start();
        } else {
            this.setChild(this.getPopupMode(), this.lastPressEvent, null, null);
        }
    }

    public void mouseReleasedRight(double d2, double d3) {
        if (this.getPopupMode() == null) {
            this.bp.stopScroller();
        }
    }

    public void mouseReleasedLeft(double d2, double d3) {
        this.view.setViewCursor(Cursor.getPredefinedCursor(0));
    }

    public void mouseDraggedLeft(double d2, double d3) {
        double d4 = this.originalX - this.bu;
        double d5 = this.originalY - this.bt;
        this.view.setCenter(this.br - d4 / this.view.getZoom(), this.bq - d5 / this.view.getZoom());
        this.view.updateView();
    }

    public void mouseDraggedRight(double d2, double d3) {
        if (this.bp != null) {
            this.bp.setDirection(this.originalX - this.bu, this.originalY - this.bt);
        }
    }
}

