/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.Cursor;
import y.base.DataProvider;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.EdgeMap;
import y.base.NodeCursor;
import y.base.YCursor;
import y.util.Maps;
import y.view.BendCursor;
import y.view.Graph2D;
import y.view.NodeRealizer;
import y.view.ViewContainer;
import y.view.ViewMode;

public class MoveSelectionMode
extends ViewMode {
    private double cg;
    private double cd;
    private double cc;
    private double cb;
    private boolean cf;
    private NodeCursor ce;
    private BendCursor ca;

    public MoveSelectionMode(ViewContainer viewContainer) {
        super(viewContainer);
    }

    public MoveSelectionMode() {
    }

    public void mouseShiftPressedLeft(double d2, double d3) {
        this.d(d2, d3);
    }

    public void mousePressedLeft(double d2, double d3) {
        this.d(d2, d3);
    }

    public void mouseReleasedLeft(double d2, double d3) {
        d2 = this.getGridX(d2);
        d3 = this.getGridY(d3);
        Graph2D graph2D = this.getGraph2D();
        this.view.updateWorldRect();
        this.view.setDrawingMode(0);
        this.selectionMovedAction(d2 - this.cg, d3 - this.cd, d2, d3);
        graph2D.updateViews();
        this.reactivateParent();
    }

    public void mouseDraggedLeft(double d2, double d3) {
        d2 = this.getGridX(d2);
        d3 = this.getGridY(d3);
        Graph2D graph2D = this.getGraph2D();
        if (this.cf && this.f() && this.isGridMode()) {
            if (this.ce.ok()) {
                NodeRealizer nodeRealizer = graph2D.getRealizer(this.ce.node());
                nodeRealizer.setCenter(d2, d3);
            }
            if (this.ca.ok()) {
                this.ca.bend().setLocation(d2, d3);
            }
            this.cf = false;
            this.cc = d2;
            this.cb = d3;
        } else {
            this.cg = this.getGridX(this.cg);
            this.cd = this.getGridY(this.cd);
            this.cc = this.getGridX(this.cc);
            this.cb = this.getGridY(this.cb);
            d2 = this.getGridX(d2);
            d3 = this.getGridY(d3);
            double d4 = d2 - this.cc;
            double d5 = d3 - this.cb;
            this.cc = d2;
            this.cb = d3;
            this.getGraph2D().moveBends(this.ca, d4, d5);
            this.getGraph2D().moveNodes(this.ce, d4, d5);
        }
        this.selectionOnMove(d2 - this.cg, d3 - this.cd, d2, d3);
        this.view.updateView();
    }

    protected void selectionOnMove(double d2, double d3, double d4, double d5) {
    }

    protected void selectionMovedAction(double d2, double d3, double d4, double d5) {
    }

    void d(double d2, double d3) {
        Graph2D graph2D = this.getGraph2D();
        this.cf = true;
        this.cg = this.cc = d2;
        this.cd = this.cb = d3;
        this.view.updateView();
        this.view.setDrawingMode(1);
        this.view.setViewCursor(Cursor.getPredefinedCursor(13));
        this.ce = graph2D.selectedNodes();
        this.ca = graph2D.selectedBends();
        graph2D.firePreEvent();
        if (this.ca.ok()) {
            YCursor yCursor;
            int n = 0;
            EdgeCursor edgeCursor = graph2D.edges();
            while (edgeCursor.ok()) {
                n += graph2D.getRealizer(edgeCursor.edge()).bendCount();
                edgeCursor.next();
            }
            boolean[] blArray = new boolean[n];
            EdgeMap edgeMap = Maps.createIndexEdgeMap(new boolean[graph2D.E()]);
            while (this.ca.ok()) {
                edgeMap.setBool(this.ca.bend().getEdge(), true);
                this.ca.next();
            }
            EdgeList edgeList = new EdgeList(graph2D.edges(), (DataProvider)edgeMap);
            int n2 = 0;
            EdgeCursor edgeCursor2 = graph2D.edges();
            while (edgeCursor2.ok()) {
                yCursor = graph2D.getRealizer(edgeCursor2.edge()).bends();
                while (yCursor.ok()) {
                    if (yCursor.bend().isSelected()) {
                        blArray[n2] = true;
                    }
                    yCursor.next();
                    ++n2;
                }
                edgeCursor2.next();
            }
            graph2D.backupRealizers(edgeList.edges());
            n2 = 0;
            yCursor = graph2D.edges();
            while (yCursor.ok()) {
                BendCursor bendCursor = graph2D.getRealizer(yCursor.edge()).bends();
                while (bendCursor.ok()) {
                    if (blArray[n2]) {
                        bendCursor.bend().setSelected(true);
                    }
                    bendCursor.next();
                    ++n2;
                }
                yCursor.next();
            }
            this.ca = graph2D.selectedBends();
        }
        this.getGraph2D().backupRealizers(this.ce);
        this.ce.toFirst();
        graph2D.firePostEvent();
    }

    private boolean f() {
        return this.ca.size() + this.ce.size() == 1;
    }
}

