/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import y.view.Graph2DCanvas;
import y.view.Graph2DRenderer;
import y.view.Graph2DView;

public class Graph2DPrinter
implements Printable {
    private Graph2DView d;
    private int g = 1;
    private int a = 1;
    private byte b = 1;
    private boolean c = false;
    private double e = 1.0;
    private byte f = 0;
    public static final byte SCALING_AUTO = 0;
    public static final byte SCALING_FIX = 1;
    public static final byte CLIP_VIEW = 0;
    public static final byte CLIP_GRAPH = 1;

    public Graph2DPrinter(Graph2DView graph2DView) {
        this.d = graph2DView;
    }

    public void setPrintPosterCoords(boolean bl) {
        this.c = bl;
    }

    public boolean getPrintPosterCoords() {
        return this.c;
    }

    public void setPosterRows(int n) {
        this.g = n;
    }

    public void setPosterColumns(int n) {
        this.a = n;
    }

    public int getPosterRows() {
        return this.g;
    }

    public int getPosterColumns() {
        return this.a;
    }

    public void setClipType(byte by) {
        this.b = by;
    }

    public byte getClipType() {
        return this.b;
    }

    public void setScalingFactor(double d2) {
        this.e = d2;
    }

    public double getScalingFactor() {
        return this.e;
    }

    public void setScalingType(byte by) {
        this.f = by;
    }

    public byte getScalingType() {
        return this.f;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        double d2;
        int n2;
        int n3;
        double d3;
        double d4;
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        Rectangle rectangle = graphics2D.getClipBounds();
        if (rectangle == null) {
            throw new IllegalArgumentException("Graphics.getClip() must be non-null!");
        }
        double d5 = pageFormat.getImageableX();
        double d6 = pageFormat.getImageableY();
        double d7 = pageFormat.getImageableWidth();
        double d8 = pageFormat.getImageableHeight();
        Rectangle rectangle2 = null;
        switch (this.getClipType()) {
            case 0: {
                rectangle2 = this.d.getVisibleRect();
                break;
            }
            default: {
                rectangle2 = this.d.getGraph2D().getBoundingBox();
                rectangle2.setFrame(rectangle2.x - 2, rectangle2.y - 2, rectangle2.width + 4, rectangle2.height + 4);
            }
        }
        double d9 = rectangle2.getWidth();
        double d10 = rectangle2.getHeight();
        double d11 = rectangle2.getX();
        double d12 = rectangle2.getY();
        switch (this.f) {
            case 1: {
                d4 = d9 * this.e;
                d3 = d10 * this.e;
                n3 = (int)Math.ceil(d4 / d7);
                n2 = (int)Math.ceil(d3 / d8);
                d2 = this.e;
                d4 = d7 * (double)n3;
                d3 = d8 * (double)n2;
                break;
            }
            case 0: {
                n3 = this.a;
                n2 = this.g;
                d4 = d7 * (double)n3;
                d3 = d8 * (double)n2;
                if (d4 / d3 > d9 / d10) {
                    d2 = d3 / d10;
                    break;
                }
                d2 = d4 / d9;
                break;
            }
            default: {
                throw new RuntimeException("Undefined ScalingType: " + this.f);
            }
        }
        if (n >= n2 * n3) {
            return 1;
        }
        double d13 = 0.0;
        double d14 = 0.0;
        d13 = Math.max(0.0, (d4 - d9 * d2) / 2.0);
        d14 = Math.max(0.0, (d3 - d10 * d2) / 2.0);
        int n4 = n % n3;
        int n5 = n / n3;
        AffineTransform affineTransform2 = new AffineTransform(affineTransform);
        affineTransform2.translate(d5 + d13 - d11 * d2 - d7 * (double)n4, d6 + d14 - d12 * d2 - d8 * (double)n5);
        affineTransform2.scale(d2, d2);
        graphics2D.setTransform(affineTransform2);
        Rectangle rectangle3 = new Rectangle(rectangle2);
        Rectangle rectangle4 = graphics2D.getClipBounds();
        Rectangle rectangle5 = rectangle4.intersection(rectangle3);
        graphics2D.setClip(rectangle5);
        this.d.getBackgroundRenderer().paint(graphics2D, rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height);
        this.d.i(graphics2D);
        Graph2DRenderer graph2DRenderer = this.d.getGraph2DRenderer();
        graph2DRenderer.paint(graphics2D, this.d.getGraph2D());
        this.d.h(graphics2D);
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(rectangle);
        graphics2D.setColor(Color.black);
        if (this.getPrintPosterCoords()) {
            this.a(graphics2D, "[" + (n4 + 1) + ',' + (n5 + 1) + "]", (int)(d5 + 15.0), (int)(d6 + 15.0));
        }
        if (Graph2DCanvas.b()) {
            Graph2DCanvas.a(graphics2D, d5 + 10.0, d6 + d8 - 14.0);
        }
        return 0;
    }

    private void a(Graphics2D graphics2D, String string, int n, int n2) {
        TextLayout textLayout = new TextLayout(string, graphics2D.getFont(), graphics2D.getFontRenderContext());
        graphics2D.setColor(Color.white);
        Rectangle2D rectangle2D = textLayout.getBounds();
        rectangle2D.setRect(rectangle2D.getX() + (double)n - 2.0, rectangle2D.getY() + (double)n2 - 2.0, rectangle2D.getWidth() + 4.0, rectangle2D.getHeight() + 4.0);
        graphics2D.fill(rectangle2D);
        graphics2D.setColor(Color.black);
        textLayout.draw(graphics2D, n, n2);
    }
}

