/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.Cursor;
import y.base.Edge;
import y.base.Node;
import y.base.NodeCursor;
import y.view.Bend;
import y.view.CreateEdgeMode;
import y.view.EdgeLabel;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.HitInfo;
import y.view.HotSpotMode;
import y.view.MoveLabelMode;
import y.view.MovePortMode;
import y.view.MoveSelectionMode;
import y.view.MoveViewPortMode;
import y.view.NodeLabel;
import y.view.NodeRealizer;
import y.view.Port;
import y.view.SelectionBoxMode;
import y.view.Selections;
import y.view.ViewContainer;
import y.view.ViewMode;

public class EditMode
extends ViewMode {
    private HitInfo at;
    private boolean as;
    private boolean au;
    private int ap;
    private Node ak;
    static final int am = 0;
    static final int an = 1;
    static final int ad = 2;
    static final int ai = 3;
    static final int aa = 4;
    static final int ab = 5;
    static final int ac = 6;
    static final int z = 7;
    static final int ao = 8;
    static final int y = 9;
    static final int w = 10;
    private double ae;
    private double ah;
    protected ViewMode popupMode;
    protected ViewMode hotSpotMode;
    protected ViewMode selectionBoxMode;
    protected ViewMode createEdgeMode;
    protected ViewMode moveSelectionMode;
    protected ViewMode moveLabelMode;
    protected ViewMode movePortMode;
    boolean ar = true;
    boolean v = true;
    boolean aj = true;
    boolean x = true;
    boolean al = true;
    boolean aq = true;
    boolean af = false;
    boolean ag = false;

    public EditMode(ViewContainer viewContainer) {
        super(viewContainer);
        this.setName("EDIT_MODE");
        this.c();
    }

    public EditMode() {
        this.setName("EDIT_MODE");
        this.c();
    }

    private void c() {
        this.hotSpotMode = this.createHotSpotMode();
        this.selectionBoxMode = this.createSelectionBoxMode();
        this.createEdgeMode = this.createCreateEdgeMode();
        this.moveSelectionMode = this.createMoveSelectionMode();
        this.moveLabelMode = this.createMoveLabelMode();
        this.movePortMode = this.createMovePortMode();
        this.popupMode = this.createPopupMode();
    }

    protected ViewMode createHotSpotMode() {
        return new HotSpotMode();
    }

    protected ViewMode createMovePortMode() {
        return new MovePortMode();
    }

    protected ViewMode createMoveLabelMode() {
        return new MoveLabelMode();
    }

    protected ViewMode createMoveSelectionMode() {
        return new MoveSelectionMode();
    }

    protected ViewMode createCreateEdgeMode() {
        return new CreateEdgeMode();
    }

    protected ViewMode createSelectionBoxMode() {
        return new SelectionBoxMode();
    }

    protected ViewMode createPopupMode() {
        return null;
    }

    public void activate(boolean bl) {
        super.activate(bl);
        if (bl) {
            this.view.setScrollBarPolicy(20, 30);
            this.view.setViewCursor(Cursor.getPredefinedCursor(0));
            this.view.updateView();
        }
    }

    public void allowNodeCreation(boolean bl) {
        this.ar = bl;
    }

    public void allowEdgeCreation(boolean bl) {
        this.v = bl;
    }

    public void allowBendCreation(boolean bl) {
        this.aj = bl;
        if (this.createEdgeMode instanceof CreateEdgeMode) {
            ((CreateEdgeMode)this.createEdgeMode).allowBendCreation(bl);
        }
    }

    public void allowMoveSelection(boolean bl) {
        this.x = bl;
    }

    public void allowMoving(boolean bl) {
        this.aq = bl;
    }

    public void allowResizeNodes(boolean bl) {
        this.al = bl;
    }

    public boolean doAllowNodeCreation() {
        return this.ar;
    }

    public boolean doAllowEdgeCreation() {
        return this.v;
    }

    public boolean doAllowBendCreation() {
        return this.aj;
    }

    public boolean doAllowMoveSelection() {
        return this.x;
    }

    public boolean doAllowMoving() {
        return this.aq && this.popupMode == null;
    }

    public boolean doAllowResizeNodes() {
        return this.al;
    }

    public void showNodeTips(boolean bl) {
        this.af = bl;
    }

    public boolean doShowNodeTips() {
        return this.af;
    }

    public void showEdgeTips(boolean bl) {
        this.ag = bl;
    }

    public boolean doShowEdgeTips() {
        return this.ag;
    }

    public ViewMode getPopupMode() {
        return this.popupMode;
    }

    public void setPopupMode(ViewMode viewMode) {
        this.popupMode = viewMode;
    }

    public ViewMode getMoveSelectionMode() {
        return this.moveSelectionMode;
    }

    public void setMoveSelectionMode(ViewMode viewMode) {
        this.moveSelectionMode = viewMode;
    }

    public ViewMode getCreateEdgeMode() {
        return this.createEdgeMode;
    }

    public void setCreateEdgeMode(ViewMode viewMode) {
        this.createEdgeMode = viewMode;
    }

    public ViewMode getSelectionBoxMode() {
        return this.selectionBoxMode;
    }

    public void setSelectionBoxMode(ViewMode viewMode) {
        this.selectionBoxMode = viewMode;
    }

    public void mousePressedLeft(double d2, double d3) {
        this.a(d2, d3, false);
    }

    public void mouseShiftPressedLeft(double d2, double d3) {
        this.a(d2, d3, true);
    }

    public void mouseReleasedLeft(double d2, double d3) {
        Graph2D graph2D = this.getGraph2D();
        if (!this.as) {
            switch (this.ap) {
                case 0: {
                    if (!graph2D.isSelectionEmpty() || !this.doAllowNodeCreation()) {
                        graph2D.unselectAll();
                        graph2D.updateViews();
                        break;
                    }
                    Node node = graph2D.createNode(this.getGridX(d2), this.getGridY(d3));
                    if (graph2D.getLabelText(node).equals("")) {
                        graph2D.setLabelText(node, "" + graph2D.nodeCount());
                    }
                    this.nodeCreated(node);
                    graph2D.updateViews();
                    break;
                }
                case 1: {
                    this.nodeClicked(this.getLastHitInfo().getHitNode());
                    graph2D.unselectAll();
                    Selections.selectNodeAndSelfLoopBends(graph2D, this.getLastHitInfo().getHitNode());
                    graph2D.updateViews();
                    break;
                }
                case 3: {
                    graph2D.unselectAll();
                    this.getLastHitInfo().getHitBend().setSelected(true);
                    graph2D.updateViews();
                    break;
                }
                case 5: {
                    graph2D.unselectAll();
                    graph2D.setSelected(this.getLastHitInfo().getHitEdge(), true);
                    graph2D.updateViews();
                    break;
                }
                case 2: {
                    this.nodeClicked(this.getLastHitInfo().getHitNode());
                }
            }
        }
    }

    public void mouseShiftReleasedLeft(double d2, double d3) {
        Graph2D graph2D = this.getGraph2D();
        if (!this.as) {
            switch (this.ap) {
                case 1: {
                    if (graph2D.selectedEdges().ok()) {
                        graph2D.unselectAll();
                    }
                    Selections.selectNodeAndSelfLoopBends(graph2D, this.getLastHitInfo().getHitNode());
                    graph2D.updateViews();
                    break;
                }
                case 3: {
                    if (graph2D.selectedEdges().ok()) {
                        graph2D.unselectAll();
                    }
                    this.getLastHitInfo().getHitBend().setSelected(true);
                    graph2D.updateViews();
                    break;
                }
                case 5: {
                    if (graph2D.selectedNodes().ok() || graph2D.selectedBends().ok()) {
                        graph2D.unselectAll();
                    }
                    graph2D.setSelected(this.getLastHitInfo().getHitEdge(), true);
                    graph2D.updateViews();
                    break;
                }
                case 6: {
                    graph2D.setSelected(this.getLastHitInfo().getHitEdge(), false);
                    graph2D.updateViews();
                    break;
                }
                case 4: {
                    this.getLastHitInfo().getHitBend().setSelected(false);
                    graph2D.updateViews();
                    break;
                }
                case 2: {
                    Selections.deselectNodeAndSelfLoopBends(graph2D, this.getLastHitInfo().getHitNode());
                    graph2D.updateViews();
                }
            }
        }
    }

    public void mousePressedRight(double d2, double d3) {
        if (this.doAllowMoving()) {
            this.setChild(new MoveViewPortMode(), this.lastPressEvent, null);
        } else {
            ViewMode viewMode = this.getPopupMode();
            if (viewMode != null) {
                this.setChild(viewMode, this.lastPressEvent, null);
            }
        }
    }

    public void mouseDraggedLeft(double d2, double d3) {
        Graph2D graph2D = this.getGraph2D();
        HitInfo hitInfo = this.getHitInfo(d2, d3);
        boolean bl = !this.as;
        this.as = true;
        switch (this.ap) {
            case 0: {
                this.setChild(this.getSelectionBoxMode(), this.lastPressEvent, this.lastDragEvent);
                break;
            }
            case 1: {
                Node node = hitInfo.getHitNode();
                if (node != this.ak && this.doAllowEdgeCreation()) {
                    this.setChild(this.getCreateEdgeMode(), this.lastPressEvent, this.lastDragEvent);
                    break;
                }
                if (this.doAllowEdgeCreation() || !bl) break;
                graph2D.unselectAll();
                Selections.selectNodeAndSelfLoopBends(graph2D, this.at.getHitNode());
                if (!this.doAllowMoveSelection()) break;
                this.setChild(this.moveSelectionMode, this.lastPressEvent, this.lastDragEvent);
                break;
            }
            case 2: {
                if (!bl || graph2D.isSelectionEmpty() || !this.doAllowMoveSelection()) break;
                this.setChild(this.moveSelectionMode, this.lastPressEvent, this.lastDragEvent);
                break;
            }
            case 3: {
                if (!bl) break;
                graph2D.unselectNodes();
                graph2D.unselectBends();
                this.at.getHitBend().setSelected(true);
                if (!this.doAllowMoveSelection()) break;
                this.setChild(this.moveSelectionMode, this.lastPressEvent, this.lastDragEvent);
                break;
            }
            case 4: {
                if (!bl || graph2D.isSelectionEmpty() || !this.doAllowMoveSelection()) break;
                this.setChild(this.moveSelectionMode, this.lastPressEvent, this.lastDragEvent);
                break;
            }
            case 7: {
                if (!bl) break;
                graph2D.unselectAll();
                this.setChild(this.moveLabelMode, this.lastPressEvent, this.lastDragEvent);
                break;
            }
            case 8: {
                if (!bl) break;
                graph2D.unselectAll();
                this.setChild(this.moveLabelMode, this.lastPressEvent, this.lastDragEvent);
                break;
            }
            case 5: 
            case 6: {
                if (!bl || !this.aj) break;
                graph2D.unselectAll();
                graph2D.updateViews();
                Bend bend = graph2D.getRealizer(this.at.getHitEdge()).insertBend(this.ae, this.ah);
                if (bend == null) break;
                bend.setSelected(true);
                if (!this.doAllowMoveSelection()) break;
                this.setChild(this.moveSelectionMode, this.lastPressEvent, this.lastDragEvent);
                break;
            }
            case 9: {
                this.setChild(this.hotSpotMode, this.lastPressEvent, this.lastDragEvent);
                break;
            }
            case 10: {
                this.setChild(this.movePortMode, this.lastPressEvent, this.lastDragEvent);
            }
        }
    }

    public void mouseMoved(double d2, double d3) {
        NodeRealizer nodeRealizer;
        Graph2D graph2D = this.getGraph2D();
        HitInfo hitInfo = this.getHitInfo(d2, d3);
        NodeCursor nodeCursor = graph2D.selectedNodes();
        String string = null;
        if (hitInfo.getHitNode() != null) {
            if (this.doShowNodeTips()) {
                string = this.getNodeTip(hitInfo.getHitNode());
            }
        } else if (hitInfo.getHitEdge() != null && this.doShowEdgeTips()) {
            string = this.getEdgeTip(hitInfo.getHitEdge());
        }
        this.view.setToolTipText(string);
        if (this.doAllowMoving()) {
            while (nodeCursor.ok()) {
                nodeRealizer = graph2D.getRealizer(nodeCursor.node());
                if (nodeRealizer.contains(d2, d3)) {
                    this.view.setViewCursor(Cursor.getPredefinedCursor(13));
                    return;
                }
                nodeCursor.next();
            }
        }
        if (this.doAllowBendCreation() && hitInfo.getHitEdge() != null) {
            this.view.setViewCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        if (this.doAllowResizeNodes()) {
            nodeCursor.toFirst();
            while (nodeCursor.ok()) {
                Node node = (Node)nodeCursor.current();
                nodeRealizer = graph2D.getRealizer(node);
                if (nodeRealizer.hotSpotHit(d2, d3) != 8) {
                    this.view.setViewCursor(HotSpotMode.getCursor(nodeRealizer.hotSpotHit(d2, d3)));
                    return;
                }
                nodeCursor.next();
            }
        }
        this.view.setViewCursor(Cursor.getPredefinedCursor(0));
    }

    private void a(double d2, double d3, boolean bl) {
        Port port;
        this.at = this.getHitInfo(d2, d3);
        this.as = false;
        this.au = bl;
        this.ae = d2;
        this.ah = d3;
        Graph2D graph2D = this.getGraph2D();
        if (this.doAllowResizeNodes()) {
            NodeCursor nodeCursor = graph2D.nodes();
            while (nodeCursor.ok()) {
                NodeRealizer nodeRealizer = graph2D.getRealizer(nodeCursor.node());
                if (nodeRealizer.isSelected() && nodeRealizer.hotSpotHit(d2, d3) != 8) {
                    this.ap = 9;
                    return;
                }
                nodeCursor.next();
            }
        }
        if ((port = this.at.getHitPort()) != null) {
            this.ap = 10;
            return;
        }
        this.ak = this.at.getHitNode();
        if (this.ak != null) {
            this.ap = graph2D.isSelected(this.ak) ? 2 : 1;
            return;
        }
        Bend bend = this.at.getHitBend();
        if (bend != null) {
            this.ap = bend.isSelected() ? 4 : 3;
            return;
        }
        Edge edge = this.at.getHitEdge();
        if (edge != null) {
            this.ap = graph2D.isSelected(edge) ? 6 : 5;
            return;
        }
        NodeLabel nodeLabel = this.at.getHitNodeLabel();
        if (nodeLabel != null) {
            this.ap = 7;
            return;
        }
        EdgeLabel edgeLabel = this.at.getHitEdgeLabel();
        if (edgeLabel != null) {
            this.ap = 8;
            return;
        }
        this.ap = 0;
    }

    protected String getNodeTip(Node node) {
        return this.getGraph2D().getLabelText(node);
    }

    protected String getEdgeTip(Edge edge) {
        EdgeRealizer edgeRealizer = this.getGraph2D().getRealizer(edge);
        if (edgeRealizer.labelCount() > 0) {
            return edgeRealizer.getLabel(0).getText();
        }
        return null;
    }

    protected void nodeCreated(Node node) {
    }

    protected void nodeClicked(Node node) {
    }

    public ViewMode getMoveLabelMode() {
        return this.moveLabelMode;
    }

    public void setMoveLabelMode(ViewMode viewMode) {
        this.moveLabelMode = viewMode;
    }

    public ViewMode getMovePortMode() {
        return this.movePortMode;
    }

    public void setMovePortMode(ViewMode viewMode) {
        this.movePortMode = viewMode;
    }

    public ViewMode getHotSpotMode() {
        return this.hotSpotMode;
    }

    public void setHotSpotMode(ViewMode viewMode) {
        this.hotSpotMode = viewMode;
    }
}

