/*
 * Decompiled with CFR 0.152.
 */
package y.util;

import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.base.YCursor;
import y.base.if;

public class GraphHider {
    private Graph a;
    protected EdgeList hiddenEdges;
    protected NodeList hiddenNodes;

    public GraphHider(Graph graph) {
        this.a = graph;
        this.hiddenEdges = new EdgeList();
        this.hiddenNodes = new NodeList();
    }

    public void hideAll() {
        NodeCursor nodeCursor = this.a.nodes();
        while (nodeCursor.ok()) {
            this.hide(nodeCursor.node());
            nodeCursor.next();
        }
    }

    public void hideEdges() {
        EdgeCursor edgeCursor = this.a.edges();
        while (edgeCursor.ok()) {
            this.hide(edgeCursor.edge());
            edgeCursor.next();
        }
    }

    public void hideSelfLoops() {
        EdgeCursor edgeCursor = this.a.edges();
        while (edgeCursor.ok()) {
            if (edgeCursor.edge().isSelfLoop()) {
                this.hide(edgeCursor.edge());
            }
            edgeCursor.next();
        }
    }

    public void simplifyGraph() {
        this.hideSelfLoops();
        this.hideMultipleEdges();
    }

    public void hideMultipleEdges() {
        NodeMap nodeMap = this.a.createNodeMap();
        NodeCursor nodeCursor = this.a.nodes();
        while (nodeCursor.ok()) {
            if if_;
            if if_2;
            Object object;
            Node node = nodeCursor.node();
            EdgeCursor edgeCursor = node.edges();
            while (edgeCursor.ok()) {
                object = edgeCursor.edge();
                if_2 = ((Edge)object).opposite(node);
                if_ = (Edge)nodeMap.get(if_2);
                if (if_ != object) {
                    if (if_ == null) {
                        nodeMap.set(if_2, object);
                    } else {
                        this.hide((Edge)object);
                    }
                }
                edgeCursor.next();
            }
            object = node.edges();
            while (object.ok()) {
                if_2 = object.edge();
                if_ = ((Edge)if_2).opposite(node);
                nodeMap.set(if_, null);
                object.next();
            }
            nodeCursor.next();
        }
        this.a.disposeNodeMap(nodeMap);
    }

    public void unhideAll() {
        this.unhideNodes();
        this.unhideEdges();
    }

    public void unhideNodes() {
        while (!this.hiddenNodes.isEmpty()) {
            Node node = this.hiddenNodes.popNode();
            if (this.a.contains(node)) continue;
            this.unhide(node);
        }
    }

    public void unhideEdges() {
        while (!this.hiddenEdges.isEmpty()) {
            Edge edge = this.hiddenEdges.popEdge();
            if (this.a.contains(edge)) continue;
            this.unhide(edge);
        }
    }

    public void hide(Node node) {
        EdgeCursor edgeCursor = node.edges();
        while (edgeCursor.ok()) {
            this.hiddenEdges.push(edgeCursor.edge());
            this.a.hide(edgeCursor.edge());
            edgeCursor.next();
        }
        this.hiddenNodes.push(node);
        this.a.hide(node);
    }

    public void hide(Edge edge) {
        this.hiddenEdges.push(edge);
        this.a.hide(edge);
    }

    public void hide(EdgeList edgeList) {
        EdgeCursor edgeCursor = edgeList.edges();
        while (edgeCursor.ok()) {
            this.hide(edgeCursor.edge());
            edgeCursor.next();
        }
    }

    public void hide(NodeList nodeList) {
        NodeCursor nodeCursor = nodeList.nodes();
        while (nodeCursor.ok()) {
            this.hide(nodeCursor.node());
            nodeCursor.next();
        }
    }

    public void hide(EdgeCursor edgeCursor) {
        while (edgeCursor.ok()) {
            this.hide(edgeCursor.edge());
            edgeCursor.next();
        }
    }

    public void hide(NodeCursor nodeCursor) {
        while (nodeCursor.ok()) {
            this.hide(nodeCursor.node());
            nodeCursor.next();
        }
    }

    public void hide(YCursor yCursor) {
        while (yCursor.ok()) {
            Object object = yCursor.current();
            if (object instanceof Node) {
                this.hide((Node)object);
            } else if (object instanceof Edge) {
                this.hide((Edge)object);
            } else {
                throw new ClassCastException("Node or Edge expected");
            }
            yCursor.next();
        }
    }

    public static void unhideSubgraph(Graph graph, EdgeCursor edgeCursor) {
        edgeCursor.toFirst();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            if (!graph.contains(edge.source())) {
                graph.unhide(edge.source());
            }
            if (!graph.contains(edge.target())) {
                graph.unhide(edge.target());
            }
            if (!graph.contains(edge)) {
                graph.unhide(edge);
            }
            edgeCursor.next();
        }
    }

    public static void hideSubgraph(Graph graph, EdgeCursor edgeCursor) {
        edgeCursor.toFirst();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            if (graph.contains(edge)) {
                graph.hide(edge);
            }
            if (edge.source().degree() == 0) {
                graph.hide(edge.source());
            }
            if (edge.target().degree() == 0) {
                graph.hide(edge.target());
            }
            edgeCursor.next();
        }
    }

    public Graph getGraph() {
        return this.a;
    }

    protected void unhide(Edge edge) {
        this.a.unhide(edge);
    }

    protected void unhide(Node node) {
        this.a.unhide(node);
    }
}

