/*
 * Decompiled with CFR 0.152.
 */
package y.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import y.util.ObjectStore;
import y.util.ObjectStringConversion;
import y.util.ObjectStringConverter;
import y.util.ResourceResolver;

public class GlobalProperties
extends Properties {
    private PropertyChangeSupport d;
    private static GlobalProperties c = new GlobalProperties();
    private Map a;
    private ObjectStringConversion b;

    private GlobalProperties() {
        this.getConversion();
        this.d = new PropertyChangeSupport(this);
        this.a = new WeakHashMap();
    }

    protected static void installInstance(GlobalProperties globalProperties) {
        if (globalProperties == null) {
            throw new NullPointerException("Cannot install null instance.");
        }
        c = globalProperties;
    }

    public void addObjectStore(Object object, ObjectStore objectStore) {
        this.a.put(object, objectStore);
    }

    public void store(Object object) {
        ObjectStore objectStore = (ObjectStore)this.a.get(object);
        if (objectStore != null) {
            objectStore.store(object, this, this.b);
        }
    }

    public void restore(Object object) {
        ObjectStore objectStore = (ObjectStore)this.a.get(object);
        if (objectStore != null) {
            objectStore.restore(object, this, this.b);
        }
    }

    public void storeAll() {
        Iterator iterator = this.a.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ((ObjectStore)entry.getValue()).store(entry.getKey(), this, this.b);
        }
    }

    public void restoreAll() {
        Iterator iterator = this.a.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ((ObjectStore)entry.getValue()).restore(entry.getKey(), this, this.b);
        }
    }

    public void load() throws IOException {
        this.load(this.getProfileResource());
    }

    protected File getProfileFilePath() {
        try {
            String string = System.getProperty("user.home");
            return new File(new File(string, ".yed"), "settings.ypf");
        }
        catch (SecurityException securityException) {
            return new File("settings.ypf");
        }
    }

    protected URL getProfileResource() {
        return ResourceResolver.getResource("profile", ".yed/settings.ypf", ".yed/settings.ypf");
    }

    public void store() throws IOException {
        URL uRL = this.getProfileResource();
        File file = uRL != null ? new File(uRL.getFile()) : this.getProfileFilePath();
        this.store(file);
    }

    public void load(URL uRL) throws IOException {
        InputStream inputStream;
        if (uRL != null && (inputStream = uRL.openStream()) != null) {
            super.load(inputStream);
        }
    }

    public void store(File file) throws IOException {
        if (file != null && (!file.exists() || file.canWrite())) {
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IOException("Could not create parent directory. " + file.getParentFile());
            }
        } else {
            throw new IOException("File not writable! " + file.toString());
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        super.store(fileOutputStream, "yFiles GlobalProperties");
        fileOutputStream.close();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.d.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.d.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.d.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.d.removePropertyChangeListener(string, propertyChangeListener);
    }

    public static GlobalProperties getInstance() {
        return c;
    }

    public Object put(Object object, Object object2) {
        if (object2 == null || object2 instanceof String) {
            String string = this.getProperty((String)object);
            Object object3 = object2 == null ? super.remove(object) : super.put(object, object2);
            this.d.firePropertyChange((String)object, string, object2);
            return object3;
        }
        String string = this.getConversion().convertToString(object2, object2.getClass());
        return this.setProperty((String)object, string);
    }

    public ObjectStringConverter getConversion() {
        if (this.b == null) {
            this.b = ObjectStringConversion.getInstance();
        }
        return this.b;
    }

    public Object getProperty(String string, Class clazz) {
        String string2 = this.getProperty(string);
        if (string2 != null) {
            return this.getConversion().convertToObject(string2, clazz);
        }
        return null;
    }

    public void setProperty(String string, boolean bl) {
        String string2 = this.getConversion().convertToString(bl ? Boolean.TRUE : Boolean.FALSE, Boolean.TYPE);
        this.setProperty(string, string2);
    }

    public void setProperty(String string, float f2) {
        String string2 = this.getConversion().convertToString(new Float(f2), Float.TYPE);
        this.setProperty(string, string2);
    }

    public void setProperty(String string, double d2) {
        String string2 = this.getConversion().convertToString(new Float(d2), Double.TYPE);
        this.setProperty(string, string2);
    }

    public void setProperty(String string, int n) {
        String string2 = this.getConversion().convertToString(new Integer(n), Integer.TYPE);
        this.setProperty(string, string2);
    }

    public void setProperty(String string, byte by) {
        String string2 = this.getConversion().convertToString(new Byte(by), Byte.TYPE);
        this.setProperty(string, string2);
    }
}

