/*
 * Decompiled with CFR 0.152.
 */
package y.util;

import java.util.Comparator;
import y.base.DataProvider;
import y.base.Edge;
import y.base.Node;

public class Comparators {
    public static Comparator createIntDataSourceComparator(DataProvider dataProvider) {
        return new _a(dataProvider);
    }

    public static Comparator createIntDataTargetComparator(DataProvider dataProvider) {
        return new _do(dataProvider);
    }

    public static Comparator createDoubleDataSourceComparator(DataProvider dataProvider) {
        return new _for(dataProvider);
    }

    public static Comparator createDoubleDataTargetComparator(DataProvider dataProvider) {
        return new _new(dataProvider);
    }

    public static Comparator createIntDataComparator(DataProvider dataProvider) {
        return new _int(dataProvider);
    }

    public static Comparator createDoubleDataComparator(DataProvider dataProvider) {
        return new _if(dataProvider);
    }

    public static Comparator createComparableComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Comparable)object).compareTo(object2);
            }
        };
    }

    private static class _int
    implements Comparator {
        DataProvider a;

        public _int(DataProvider dataProvider) {
            this.a = dataProvider;
        }

        public int compare(Object object, Object object2) {
            return this.a.getInt(object) - this.a.getInt(object2);
        }
    }

    private static class _if
    implements Comparator {
        DataProvider a;

        public _if(DataProvider dataProvider) {
            this.a = dataProvider;
        }

        public int compare(Object object, Object object2) {
            double d2 = this.a.getDouble(object) - this.a.getDouble(object2);
            return d2 > 0.0 ? 1 : (d2 < 0.0 ? -1 : 0);
        }
    }

    private static class _new
    implements Comparator {
        DataProvider a;

        public _new(DataProvider dataProvider) {
            this.a = dataProvider;
        }

        public int compare(Object object, Object object2) {
            Node node = ((Edge)object).target();
            Node node2 = ((Edge)object2).target();
            double d2 = this.a.getDouble(node) - this.a.getDouble(node2);
            return d2 > 0.0 ? 1 : (d2 < 0.0 ? -1 : 0);
        }
    }

    private static class _for
    implements Comparator {
        DataProvider a;

        public _for(DataProvider dataProvider) {
            this.a = dataProvider;
        }

        public int compare(Object object, Object object2) {
            Node node = ((Edge)object).source();
            Node node2 = ((Edge)object2).source();
            double d2 = this.a.getDouble(node) - this.a.getDouble(node2);
            return d2 > 0.0 ? 1 : (d2 < 0.0 ? -1 : 0);
        }
    }

    private static class _do
    implements Comparator {
        DataProvider a;

        public _do(DataProvider dataProvider) {
            this.a = dataProvider;
        }

        public int compare(Object object, Object object2) {
            Node node = ((Edge)object).target();
            Node node2 = ((Edge)object2).target();
            return this.a.getInt(node) - this.a.getInt(node2);
        }
    }

    private static class _a
    implements Comparator {
        DataProvider a;

        public _a(DataProvider dataProvider) {
            this.a = dataProvider;
        }

        public int compare(Object object, Object object2) {
            Node node = ((Edge)object).source();
            Node node2 = ((Edge)object2).source();
            return this.a.getInt(node) - this.a.getInt(node2);
        }
    }
}

