/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import y.base.NodeCursor;
import y.base.NodeMap;
import y.layout.BendConverter;
import y.layout.CompositeLayoutStage;
import y.layout.organic.ShuffleLayouter;
import y.module.LayoutModule;
import y.option.OptionHandler;
import y.view.Graph2D;

public class ShuffleLayoutModule
extends LayoutModule {
    final String[] bl = new String[]{"INTERSECTION_BOX", "NODE_CENTER"};
    private static final String bp = "SHUFFLELAYOUT";
    private static final String bk = "NODE_CENTER";
    private static final String bq = "INTERSECTION_BOX";
    private static final String bm = "HORIZONTAL_OVERLAP_CRITERIUM";
    private static final String bo = "MINIMAL_NODE_DISTANCE";
    private static final String bn = "MOVE_BENDS";

    public ShuffleLayoutModule() {
        super(bp, "Roland Wiese, Sebastian Mueller", "Removes Node Overlaps");
    }

    public OptionHandler createOptionHandler() {
        ShuffleLayouter shuffleLayouter = new ShuffleLayouter();
        OptionHandler optionHandler = new OptionHandler(this.getModuleName());
        optionHandler.addInt(bo, (int)shuffleLayouter.getMinimalNodeDistance(), 0, 200);
        optionHandler.addEnum(bm, this.bl, shuffleLayouter.getHorizontalOverlapCriterium());
        optionHandler.addBool(bn, true);
        return optionHandler;
    }

    protected void mainrun() {
        OptionHandler optionHandler = this.getOptionHandler();
        ShuffleLayouter shuffleLayouter = new ShuffleLayouter();
        Graph2D graph2D = this.getGraph2D();
        NodeMap nodeMap = graph2D.createNodeMap();
        graph2D.addDataProvider(ShuffleLayouter.MINIMAL_DISTANCE_DPKEY, nodeMap);
        double d2 = optionHandler.getInt(bo);
        NodeCursor nodeCursor = graph2D.nodes();
        while (nodeCursor.ok()) {
            nodeMap.setDouble(nodeCursor.node(), d2);
            nodeCursor.next();
        }
        shuffleLayouter.setMinimalNodeDistance(0.0);
        shuffleLayouter.setSimpleModeActive(false);
        shuffleLayouter.setBarycenterModeActive(true);
        if (optionHandler.get(bm).equals(this.bl[0])) {
            shuffleLayouter.setHorizontalOverlapCriterium((byte)0);
        } else {
            shuffleLayouter.setHorizontalOverlapCriterium((byte)1);
        }
        if (optionHandler.getBool(bn)) {
            CompositeLayoutStage compositeLayoutStage = new CompositeLayoutStage(new BendConverter(1.0), shuffleLayouter);
            this.launchLayouter(compositeLayoutStage, true);
        } else {
            this.launchLayouter(shuffleLayouter, true);
        }
        graph2D.removeDataProvider(ShuffleLayouter.MINIMAL_DISTANCE_DPKEY);
        graph2D.disposeNodeMap(nodeMap);
    }
}

