/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import y.base.Edge;
import y.base.EdgeCursor;
import y.layout.CompositeLayoutStage;
import y.layout.LabelLayoutDataRefinement;
import y.layout.LabelLayoutTranslator;
import y.layout.LabelRanking;
import y.layout.LayoutStage;
import y.layout.OrientationLayouter;
import y.layout.PortConstraint;
import y.layout.PortConstraintKeys;
import y.layout.hierarchic.AsIsLayerer;
import y.layout.hierarchic.BFSLayerer;
import y.layout.hierarchic.ClassicLayerSequencer;
import y.layout.hierarchic.HierarchicLayouter;
import y.layout.hierarchic.LayerSequencer;
import y.layout.hierarchic.Layerer;
import y.layout.hierarchic.TopologicalLayerer;
import y.layout.hierarchic.WeightedLayerer;
import y.layout.labeling.AbstractLabelingAlgorithm;
import y.layout.labeling.GreedyMISLabeling;
import y.module.LayoutModule;
import y.option.OptionHandler;
import y.util.DataProviderAdapter;
import y.view.EdgeLabel;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.Selections;

public class HierarchicLayoutModule
extends LayoutModule {
    private static final String d2 = "EDGE_LABEL_MODEL";
    private static final String dp = "EDGE_LABELING";
    private static final String d3 = "LABELING";
    private static final String d6 = "REMOVE_FALSE_CROSSINGS";
    private static final String ed = "USE_TRANSPOSITION";
    private static final String dg = "WEIGHT_HEURISTIC";
    private static final String c2 = "NODE_ORDER";
    private static final String d9 = "RANKING_POLICY";
    private static final String cz = "NODE_RANK";
    private static final String c5 = "ACT_ON_SELECTION_ONLY";
    private static final String dj = "BACKLOOP_ROUTING";
    private static final String eb = "EDGE_ROUTING";
    private static final String d8 = "NODE_PLACEMENT";
    private static final String c4 = "ORIENTATION";
    private static final String dw = "MAXIMAL_DURATION";
    private static final String dc = "MINIMAL_EDGE_DISTANCE";
    private static final String c8 = "MINIMAL_NODE_DISTANCE";
    private static final String dv = "MINIMAL_LAYER_DISTANCE";
    private static final String c3 = "LAYOUT";
    private static final String db = "HIERARCHIC";
    private static final String ec = "FREE";
    private static final String dz = "SIDE_SLIDER";
    private static final String de = "CENTER_SLIDER";
    private static final String dl = "AS_IS";
    private static final String c1 = "BEST";
    private static final String dy = "GENERIC";
    private static final String dt = "NONE";
    private static final String d1 = "ORTHOGONAL";
    private static final String d5 = "POLYLINE";
    private static final String dx = "TREE";
    private static final String du = "LINEAR_SEGMENTS";
    private static final String dm = "PENDULUM";
    private static final String c7 = "MEDIAN";
    private static final String dq = "BARYCENTER";
    private static final String dd = "SIMPLEX";
    private static final String da = "TIGHT_TREE";
    private static final String cy = "DOWNSHIFT_NODES";
    private static final String c0 = "NO_RERANKING";
    private static final String dn = "BFS";
    private static final String df = "RIGHT_TO_LEFT";
    private static final String c6 = "BOTTOM_TO_TOP";
    private static final String dr = "LEFT_TO_RIGHT";
    private static final String d7 = "TOP_TO_BOTTOM";
    private static final String[] c9 = new String[]{"TOP_TO_BOTTOM", "LEFT_TO_RIGHT", "BOTTOM_TO_TOP", "RIGHT_TO_LEFT"};
    private static final String[] d0 = new String[]{"NO_RERANKING", "DOWNSHIFT_NODES", "TIGHT_TREE", "SIMPLEX", "AS_IS", "BFS"};
    private static final String[] di = new String[]{"BARYCENTER", "MEDIAN"};
    private static final String[] dh = new String[]{"PENDULUM", "LINEAR_SEGMENTS", "POLYLINE", "TREE", "SIMPLEX"};
    private static final String[] dk = new String[]{"POLYLINE", "ORTHOGONAL"};
    private static final String[] d4 = new String[]{"NONE", "HIERARCHIC", "GENERIC"};
    private static final String[] ea = new String[]{"BEST", "AS_IS", "CENTER_SLIDER", "SIDE_SLIDER", "FREE"};
    private HierarchicLayouter ds;

    public HierarchicLayoutModule() {
        super(db, "Roland Wiese, Markus Eiglsperger", "Sugiyama based layout");
    }

    public OptionHandler createOptionHandler() {
        this.b();
        OptionHandler optionHandler = new OptionHandler(this.getModuleName());
        optionHandler.useSection(c3);
        optionHandler.addInt(dv, (int)this.ds.getMinimalLayerDistance());
        optionHandler.addInt(c8, (int)this.ds.getMinimalNodeDistance());
        optionHandler.addInt(dc, (int)this.ds.getMinimalEdgeDistance());
        optionHandler.addInt(dw, 5);
        optionHandler.addEnum(c4, c9, 0);
        optionHandler.addEnum(d8, dh, this.ds.getLayoutStyle());
        optionHandler.addEnum(eb, dk, this.ds.getRoutingStyle());
        optionHandler.addBool(dj, false);
        optionHandler.addBool(c5, false);
        optionHandler.useSection(cz);
        optionHandler.addEnum(d9, d0, 2);
        ClassicLayerSequencer classicLayerSequencer = new ClassicLayerSequencer();
        optionHandler.useSection(c2);
        optionHandler.addEnum(dg, di, classicLayerSequencer.getWeightHeuristic());
        optionHandler.addBool(ed, classicLayerSequencer.getUseTransposition());
        optionHandler.addBool(d6, this.ds.getRemoveFalseCrossings());
        optionHandler.useSection(d3);
        optionHandler.addEnum(dp, d4, 0);
        optionHandler.addEnum(d2, ea, 0);
        return optionHandler;
    }

    public void mainrun() {
        ClassicLayerSequencer classicLayerSequencer;
        Object object;
        Object object2;
        this.b();
        OptionHandler optionHandler = this.getOptionHandler();
        this.ds.setRemoveFalseCrossings(optionHandler.getBool(d6));
        this.ds.setMaximalDuration(optionHandler.getInt(dw) * 1000);
        this.ds.setMinimalNodeDistance(optionHandler.getInt(c8));
        this.ds.setMinimalEdgeDistance(optionHandler.getInt(dc));
        this.ds.setMinimalLayerDistance(optionHandler.getInt(dv));
        OrientationLayouter orientationLayouter = (OrientationLayouter)this.ds.getOrientationLayouter();
        if (optionHandler.get(c4).equals(d7)) {
            orientationLayouter.setOrientation((byte)0);
        } else if (optionHandler.get(c4).equals(dr)) {
            orientationLayouter.setOrientation((byte)1);
        } else if (optionHandler.get(c4).equals(c6)) {
            orientationLayouter.setOrientation((byte)2);
        } else if (optionHandler.get(c4).equals(df)) {
            orientationLayouter.setOrientation((byte)3);
        }
        String string = optionHandler.getString(dp);
        if (!string.equals(dt)) {
            this.a(string, optionHandler.getString(d2));
            if (string.equals(dy)) {
                object2 = new GreedyMISLabeling();
                ((AbstractLabelingAlgorithm)object2).setPlaceNodeLabels(false);
                ((AbstractLabelingAlgorithm)object2).setPlaceEdgeLabels(true);
                ((AbstractLabelingAlgorithm)object2).setProfitModel(new LabelRanking());
                this.ds.setLabelLayouter((LayoutStage)object2);
                this.ds.setLabelLayouterEnabled(true);
            } else if (string.equals(db)) {
                object2 = new CompositeLayoutStage();
                ((CompositeLayoutStage)object2).appendStage(new LabelLayoutTranslator());
                ((CompositeLayoutStage)object2).appendStage(new LabelLayoutDataRefinement());
                this.ds.setLabelLayouter((LayoutStage)object2);
                this.ds.setLabelLayouterEnabled(true);
            }
        } else {
            this.ds.setLabelLayouterEnabled(false);
        }
        object2 = optionHandler.getString(d8);
        if (((String)object2).equals(dm)) {
            this.ds.setLayoutStyle((byte)0);
        } else if (((String)object2).equals(d5)) {
            this.ds.setLayoutStyle((byte)2);
        } else if (((String)object2).equals(du)) {
            this.ds.setLayoutStyle((byte)1);
        } else if (((String)object2).equals(dx)) {
            this.ds.setLayoutStyle((byte)3);
        } else if (((String)object2).equals(dd)) {
            this.ds.setLayoutStyle((byte)4);
        }
        String string2 = optionHandler.getString(eb);
        if (string2.equals(d5)) {
            this.ds.setRoutingStyle((byte)0);
        } else if (string2.equals(d1)) {
            this.ds.setRoutingStyle((byte)1);
        }
        this.ds.setSubgraphLayouterEnabled(optionHandler.getBool(c5));
        String string3 = optionHandler.getString(d9);
        if (string3.equals(dl)) {
            this.ds.setLayerer(new AsIsLayerer());
        } else if (string3.equals(dd)) {
            this.ds.setLayerer(new WeightedLayerer());
        } else if (string3.equals(dn)) {
            this.ds.setLayerer(new BFSLayerer());
            this.getGraph2D().addDataProvider(BFSLayerer.CORE_NODES, Selections.createSelectionNodeMap(this.getGraph2D()));
        } else {
            object = new TopologicalLayerer();
            if (string3.equals(c0)) {
                ((TopologicalLayerer)object).setRankingPolicy((byte)0);
            } else if (string3.equals(cy)) {
                ((TopologicalLayerer)object).setRankingPolicy((byte)1);
            } else if (string3.equals(da)) {
                ((TopologicalLayerer)object).setRankingPolicy((byte)2);
            }
            this.ds.setLayerer((Layerer)object);
        }
        object = optionHandler.getString(dg);
        LayerSequencer layerSequencer = this.ds.getLayerSequencer();
        if (layerSequencer instanceof ClassicLayerSequencer) {
            classicLayerSequencer = (ClassicLayerSequencer)layerSequencer;
            if (((String)object).equals(c7)) {
                classicLayerSequencer.setWeightHeuristic((byte)1);
            } else {
                classicLayerSequencer.setWeightHeuristic((byte)0);
            }
            classicLayerSequencer.setUseTransposition(optionHandler.getBool(ed));
            this.ds.setLayerSequencer(classicLayerSequencer);
        }
        classicLayerSequencer = null;
        if (optionHandler.getBool(dj)) {
            PortConstraint portConstraint = null;
            PortConstraint portConstraint2 = null;
            switch (orientationLayouter.getOrientation()) {
                case 0: {
                    portConstraint = PortConstraint.create((byte)2);
                    portConstraint2 = PortConstraint.create((byte)1);
                    break;
                }
                case 1: {
                    portConstraint = PortConstraint.create((byte)4);
                    portConstraint2 = PortConstraint.create((byte)8);
                    break;
                }
                case 3: {
                    portConstraint = PortConstraint.create((byte)8);
                    portConstraint2 = PortConstraint.create((byte)4);
                    break;
                }
                case 2: {
                    portConstraint = PortConstraint.create((byte)1);
                    portConstraint2 = PortConstraint.create((byte)2);
                }
            }
            _a _a2 = new _a(portConstraint);
            _a _a3 = new _a(portConstraint2);
            this.getGraph2D().addDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY, _a2);
            this.getGraph2D().addDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY, _a3);
        }
        this.launchLayouter(this.ds);
        if (optionHandler.getBool(dj)) {
            this.getGraph2D().removeDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY);
            this.getGraph2D().removeDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY);
        }
        if (classicLayerSequencer != null) {
            this.getGraph2D().removeDataProvider(ClassicLayerSequencer.GROUP_KEY);
        }
        this.getGraph2D().removeDataProvider(BFSLayerer.CORE_NODES);
    }

    void a(String string, String string2) {
        if (string.equals(dt) || string2.equals(dl)) {
            return;
        }
        if (string2.equals(c1)) {
            if (string.equals(dy)) {
                string2 = dz;
            } else if (string.equals(db)) {
                string2 = ec;
            }
        }
        byte by = 6;
        int n = 32;
        if (string2.equals(de)) {
            by = 5;
            n = 8;
        } else if (string2.equals(ec)) {
            by = 4;
            n = 8;
        }
        Graph2D graph2D = this.getGraph2D();
        EdgeCursor edgeCursor = graph2D.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            EdgeRealizer edgeRealizer = graph2D.getRealizer(edge);
            int n2 = 0;
            while (n2 < edgeRealizer.labelCount()) {
                EdgeLabel edgeLabel = edgeRealizer.getLabel(n2);
                edgeLabel.setModel(by);
                int n3 = edgeLabel.getPreferredPlacement() & 7;
                edgeLabel.setPreferredPlacement((byte)(n | n3));
                ++n2;
            }
            edgeCursor.next();
        }
    }

    public void dispose() {
        this.ds = null;
    }

    private void b() {
        if (this.ds == null) {
            this.ds = new HierarchicLayouter();
        }
    }

    private static class _a
    extends DataProviderAdapter {
        private PortConstraint t;

        _a(PortConstraint portConstraint) {
            this.t = portConstraint;
        }

        public Object get(Object object) {
            Edge edge = (Edge)object;
            if (edge.isSelfLoop()) {
                return PortConstraint.create((byte)0);
            }
            return this.t;
        }
    }
}

