/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import y.layout.circular.CircularLayouter;
import y.layout.circular.SingleCycleLayouter;
import y.layout.tree.BalloonLayouter;
import y.module.LayoutModule;
import y.option.OptionHandler;

public class CircularLayoutModule
extends LayoutModule {
    private static final String eu = "CIRCULAR";
    private static final String et = "ALLOW_OVERLAPS";
    private static final String ew = "COMPACTNESS_FACTOR";
    private static final String eq = "MAXIMAL_DEVIATION_ANGLE";
    private static final String e1 = "MINIMAL_EDGE_LENGTH";
    private static final String eo = "PREFERRED_CHILD_WEDGE";
    private static final String ex = "TREE";
    private static final String er = "FIXED_RADIUS";
    private static final String el = "CHOOSE_RADIUS_AUTOMATICALLY";
    private static final String ey = "MINIMAL_NODE_DISTANCE";
    private static final String em = "CYCLE";
    private static final String ev = "ACT_ON_SELECTION_ONLY";
    private static final String e2 = "LAYOUT_STYLE";
    private static final String es = "GENERAL";
    private static final String ez = "SINGLE_CYCLE";
    private static final String en = "BCC_ISOLATED";
    private static final String ep = "BCC_COMPACT";
    static final String[] e0 = new String[]{"BCC_COMPACT", "BCC_ISOLATED", "SINGLE_CYCLE"};

    public CircularLayoutModule() {
        super(eu, "Roland Wiese", "Circular Layout");
    }

    public OptionHandler createOptionHandler() {
        CircularLayouter circularLayouter = new CircularLayouter();
        SingleCycleLayouter singleCycleLayouter = circularLayouter.getSingleCycleLayouter();
        BalloonLayouter balloonLayouter = circularLayouter.getBalloonLayouter();
        OptionHandler optionHandler = new OptionHandler(this.getModuleName());
        optionHandler.useSection(es);
        optionHandler.addEnum(e2, e0, circularLayouter.getLayoutStyle());
        optionHandler.addBool(ev, false);
        optionHandler.useSection(em);
        optionHandler.addInt(ey, singleCycleLayouter.getMinimalNodeDistance(), 0, 999);
        optionHandler.addBool(el, singleCycleLayouter.getAutomaticRadius());
        optionHandler.addInt(er, (int)singleCycleLayouter.getFixedRadius(), 50, 800);
        optionHandler.useSection(ex);
        optionHandler.addInt(eo, balloonLayouter.getPreferredChildWedge(), 1, 359);
        optionHandler.addInt(e1, balloonLayouter.getMinimalEdgeLength(), 5, 400);
        optionHandler.addInt(eq, circularLayouter.getMaximalDeviationAngle(), 10, 360);
        optionHandler.addDouble(ew, balloonLayouter.getCompactnessFactor(), 0.1, 0.9);
        optionHandler.addBool(et, balloonLayouter.getAllowOverlaps());
        return optionHandler;
    }

    public void mainrun() {
        OptionHandler optionHandler = this.getOptionHandler();
        CircularLayouter circularLayouter = new CircularLayouter();
        SingleCycleLayouter singleCycleLayouter = circularLayouter.getSingleCycleLayouter();
        BalloonLayouter balloonLayouter = circularLayouter.getBalloonLayouter();
        if (optionHandler.getString(e2).equals(ep)) {
            circularLayouter.setLayoutStyle(CircularLayouter.BCC_COMPACT);
        } else if (optionHandler.getString(e2).equals(en)) {
            circularLayouter.setLayoutStyle(CircularLayouter.BCC_ISOLATED);
        } else {
            circularLayouter.setLayoutStyle(CircularLayouter.SINGLE_CYCLE);
        }
        circularLayouter.setSubgraphLayouterEnabled(optionHandler.getBool(ev));
        circularLayouter.setMaximalDeviationAngle(optionHandler.getInt(eq));
        singleCycleLayouter.setMinimalNodeDistance(optionHandler.getInt(ey));
        singleCycleLayouter.setAutomaticRadius(optionHandler.getBool(el));
        singleCycleLayouter.setFixedRadius(optionHandler.getInt(er));
        balloonLayouter.setPreferredChildWedge(optionHandler.getInt(eo));
        balloonLayouter.setMinimalEdgeLength(optionHandler.getInt(e1));
        balloonLayouter.setCompactnessFactor(optionHandler.getDouble(ew));
        balloonLayouter.setAllowOverlaps(optionHandler.getBool(et));
        this.launchLayouter(circularLayouter);
    }
}

