/*
 * Decompiled with CFR 0.152.
 */
package y.layout.tree;

import y.algo.Trees;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeMap;
import y.base.WrongGraphStructure;
import y.layout.CanonicMultiStageLayouter;
import y.layout.EdgeLayout;
import y.layout.LayoutGraph;
import y.layout.LayoutTool;
import y.layout.tree.if;

public class HVTreeLayouter
extends CanonicMultiStageLayouter {
    public static final Object SUBTREE_ORIENTATION = new Object();
    public static final Object HORIZONTAL_SUBTREE = new Object();
    public static final Object VERTICAL_SUBTREE = new Object();
    private NodeMap kg;
    private if ke;
    protected LayoutGraph graph;
    private double kf = 10.0;
    private double kd = 10.0;

    public void setHorizontalSpace(double d2) {
        this.kf = d2;
    }

    public double getHorizontalSpace() {
        return this.kf;
    }

    public void setVerticalSpace(double d2) {
        this.kd = d2;
    }

    public double getVerticalSpace() {
        return this.kd;
    }

    public void doLayoutCore(LayoutGraph layoutGraph) {
        if (!Trees.isTree(layoutGraph)) {
            throw new WrongGraphStructure("Graph is not a tree");
        }
        LayoutTool.resetPaths(layoutGraph);
        this.graph = layoutGraph;
        EdgeList edgeList = Trees.directTree(layoutGraph);
        this.ke = new if(layoutGraph);
        Node node = this.ke.c();
        this.kg = layoutGraph.createNodeMap();
        this.j(node);
        this.n(node);
        layoutGraph.disposeNodeMap(this.kg);
        while (!edgeList.isEmpty()) {
            LayoutTool.reverseEdgeLayout(layoutGraph.getLayout(edgeList.popEdge()));
        }
    }

    public boolean canLayoutCore(LayoutGraph layoutGraph) {
        return Trees.isTree(layoutGraph);
    }

    protected boolean isVerticalRoot(Node node) {
        DataProvider dataProvider = this.graph.getDataProvider(SUBTREE_ORIENTATION);
        if (dataProvider == null) {
            return false;
        }
        return dataProvider.get(node) == VERTICAL_SUBTREE;
    }

    protected boolean isHorizontalRoot(Node node) {
        DataProvider dataProvider = this.graph.getDataProvider(SUBTREE_ORIENTATION);
        if (dataProvider == null) {
            return true;
        }
        return dataProvider.get(node) == HORIZONTAL_SUBTREE;
    }

    void n(Node node) {
        if (this.isVerticalRoot(node)) {
            this.k(node);
        } else if (this.isHorizontalRoot(node)) {
            this.l(node);
        }
    }

    void j(Node node) {
        if (this.isVerticalRoot(node)) {
            this.m(node);
        } else if (this.isHorizontalRoot(node)) {
            this.o(node);
        }
    }

    void o(Node node) {
        _a _a2 = new _a();
        _a2.b = this.graph.getWidth(node);
        _a2.a = this.graph.getHeight(node);
        this.kg.set(node, _a2);
        if (!this.ke.c(node)) {
            double d2 = 0.0;
            double d3 = 0.0;
            NodeCursor nodeCursor = node.successors();
            while (nodeCursor.ok()) {
                Node node2 = nodeCursor.node();
                this.j(node2);
                _a _a3 = (_a)this.kg.get(node2);
                d2 = Math.max(d2, _a3.a);
                d3 += _a3.b + this.kf;
                nodeCursor.next();
            }
            _a2.a = _a2.a + this.kd + d2;
            _a2.b += d3;
        }
    }

    void m(Node node) {
        _a _a2 = new _a();
        _a2.b = this.graph.getWidth(node);
        _a2.a = this.graph.getHeight(node);
        this.kg.set(node, _a2);
        if (!this.ke.c(node)) {
            double d2 = 0.0;
            double d3 = 0.0;
            NodeCursor nodeCursor = node.successors();
            while (nodeCursor.ok()) {
                Node node2 = nodeCursor.node();
                this.j(node2);
                _a _a3 = (_a)this.kg.get(node2);
                d2 = Math.max(d2, _a3.b);
                d3 += _a3.a + this.kd;
                nodeCursor.next();
            }
            _a2.b = _a2.b + this.kf + d2;
            _a2.a += d3;
        }
    }

    void k(Node node) {
        _a _a2 = (_a)this.kg.get(node);
        double d2 = this.graph.getY(node) + this.graph.getHeight(node) + this.kd;
        double d3 = this.graph.getX(node) + this.graph.getWidth(node) + this.kf;
        EdgeCursor edgeCursor = node.outEdges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            Node node2 = edge.target();
            _a _a3 = (_a)this.kg.get(node2);
            this.graph.setLocation(node2, d3, d2);
            d2 += _a3.a + this.kd;
            this.n(node2);
            EdgeLayout edgeLayout = this.graph.getLayout(edge);
            edgeLayout.clearPoints();
            edgeLayout.addPoint(this.graph.getCenterX(node), this.graph.getCenterY(node2));
            edgeCursor.next();
        }
    }

    void l(Node node) {
        _a _a2 = (_a)this.kg.get(node);
        double d2 = this.graph.getY(node) + this.graph.getHeight(node) + this.kd;
        double d3 = this.graph.getX(node) + this.graph.getWidth(node) + this.kf;
        EdgeCursor edgeCursor = node.outEdges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            Node node2 = edge.target();
            _a _a3 = (_a)this.kg.get(node2);
            this.graph.setLocation(node2, d3, d2);
            d3 += _a3.b + this.kf;
            this.n(node2);
            EdgeLayout edgeLayout = this.graph.getLayout(edge);
            edgeLayout.clearPoints();
            edgeLayout.addPoint(this.graph.getCenterX(node2), this.graph.getCenterY(node));
            edgeCursor.next();
        }
    }

    class _a {
        double b;
        double a;
        double d;
        double c;

        _a() {
        }
    }
}

