/*
 * Decompiled with CFR 0.152.
 */
package y.layout.transformer;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Vector;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.Node;
import y.base.NodeCursor;
import y.base.YCursor;
import y.base.YList;
import y.geom.Geom;
import y.geom.YDimension;
import y.geom.YPoint;
import y.geom.YPointCursor;
import y.geom.YPointPath;
import y.layout.CanonicMultiStageLayouter;
import y.layout.EdgeLayout;
import y.layout.LayoutGraph;
import y.layout.NodeLayout;

public class GraphTransformer
extends CanonicMultiStageLayouter {
    public static final int MIRROR_XAXIS = 0;
    public static final int MIRROR_YAXIS = 1;
    public static final int ROTATE = 2;
    public static final int SCALE = 3;
    private int jd = 3;
    private double jf = 0.0;
    private boolean je = false;
    private double jh = 1.0;
    private double jg = 1.0;
    private boolean jc = false;
    private double jb;
    private double ji;

    public GraphTransformer() {
        this.setComponentLayouterEnabled(false);
        this.setSelfLoopLayouterEnabled(false);
        this.setParallelEdgeLayouterEnabled(false);
    }

    public void setOperation(int n) {
        this.jd = n;
        if (n != 2) {
            this.jc = false;
        }
    }

    public int getOperation() {
        return this.jd;
    }

    public void setRotationAngle(double d2) {
        this.jf = d2;
    }

    public double getRotationAngle() {
        return this.jf;
    }

    public void setScaleNodeSize(boolean bl) {
        this.je = bl;
    }

    public boolean getScaleNodeSize() {
        return this.je;
    }

    public void setScaleFactor(double d2) {
        this.jh = this.jg = d2;
    }

    public void setScaleFactors(double d2, double d3) {
        this.jh = d2;
        this.jg = d3;
    }

    public double getScaleFactorY() {
        return this.jg;
    }

    public double getScaleFactorX() {
        return this.jh;
    }

    public boolean canLayoutCore(LayoutGraph layoutGraph) {
        return true;
    }

    public void doLayoutCore(LayoutGraph layoutGraph) {
        Rectangle rectangle = layoutGraph.getBoundingBox();
        if (rectangle.getWidth() <= 0.0 || rectangle.getHeight() <= 0.0) {
            return;
        }
        switch (this.jd) {
            case 0: {
                Object object;
                Object object2;
                NodeCursor nodeCursor = layoutGraph.nodes();
                while (nodeCursor.ok()) {
                    object2 = nodeCursor.node();
                    object = layoutGraph.getCenter((Node)object2);
                    layoutGraph.setCenter((Node)object2, GraphTransformer.a((YPoint)object, rectangle));
                    nodeCursor.next();
                }
                object2 = layoutGraph.edges();
                while (object2.ok()) {
                    object = object2.edge();
                    YPoint yPoint = layoutGraph.getSourcePointRel((Edge)object);
                    layoutGraph.setSourcePointRel((Edge)object, new YPoint(yPoint.getX(), -yPoint.getY()));
                    YPoint yPoint2 = layoutGraph.getTargetPointRel((Edge)object);
                    layoutGraph.setTargetPointRel((Edge)object, new YPoint(yPoint2.getX(), -yPoint2.getY()));
                    Vector<YPoint> vector = new Vector<YPoint>();
                    YPointCursor yPointCursor = layoutGraph.getPoints((Edge)object).points();
                    while (yPointCursor.ok()) {
                        vector.add(GraphTransformer.a(yPointCursor.point(), rectangle));
                        yPointCursor.next();
                    }
                    layoutGraph.setPoints((Edge)object, new YPointPath(vector));
                    object2.next();
                }
                break;
            }
            case 1: {
                Object object;
                Object object3;
                NodeCursor nodeCursor = layoutGraph.nodes();
                while (nodeCursor.ok()) {
                    object3 = nodeCursor.node();
                    object = layoutGraph.getCenter((Node)object3);
                    layoutGraph.setCenter((Node)object3, GraphTransformer.b((YPoint)object, rectangle));
                    nodeCursor.next();
                }
                object3 = new Vector();
                object = layoutGraph.edges();
                while (object.ok()) {
                    Edge edge = object.edge();
                    YPoint yPoint = layoutGraph.getSourcePointRel(edge);
                    layoutGraph.setSourcePointRel(edge, new YPoint(-yPoint.getX(), yPoint.getY()));
                    YPoint yPoint3 = layoutGraph.getTargetPointRel(edge);
                    layoutGraph.setTargetPointRel(edge, new YPoint(-yPoint3.getX(), yPoint3.getY()));
                    ((Vector)object3).clear();
                    YPointCursor yPointCursor = layoutGraph.getPoints(edge).points();
                    while (yPointCursor.ok()) {
                        ((Vector)object3).add(GraphTransformer.b(yPointCursor.point(), rectangle));
                        yPointCursor.next();
                    }
                    layoutGraph.setPoints(edge, new YPointPath((Vector)object3));
                    object.next();
                }
                break;
            }
            case 2: {
                GraphTransformer.a(layoutGraph, this.jf, rectangle);
                break;
            }
            case 3: {
                Object object;
                AffineTransform affineTransform = new AffineTransform();
                double d2 = rectangle.getX() + rectangle.getWidth() / 2.0;
                double d3 = rectangle.getY() + rectangle.getHeight() / 2.0;
                Point2D.Double double_ = new Point2D.Double();
                affineTransform.translate(d2, d3);
                affineTransform.scale(this.jh, this.jg);
                affineTransform.translate(-d2, -d3);
                NodeCursor nodeCursor = layoutGraph.nodes();
                while (nodeCursor.ok()) {
                    object = nodeCursor.node();
                    ((Point2D)double_).setLocation(layoutGraph.getCenterX((Node)object), layoutGraph.getCenterY((Node)object));
                    affineTransform.transform(double_, double_);
                    layoutGraph.setCenter((Node)object, ((Point2D)double_).getX(), ((Point2D)double_).getY());
                    if (this.je) {
                        layoutGraph.setSize((Node)object, layoutGraph.getWidth((Node)object) * this.jh, layoutGraph.getHeight((Node)object) * this.jg);
                    }
                    nodeCursor.next();
                }
                object = new Vector();
                EdgeCursor edgeCursor = layoutGraph.edges();
                while (edgeCursor.ok()) {
                    Edge edge = edgeCursor.edge();
                    ((Vector)object).clear();
                    YPointCursor yPointCursor = layoutGraph.getPoints(edge).points();
                    while (yPointCursor.ok()) {
                        YPoint yPoint = yPointCursor.point();
                        ((Point2D)double_).setLocation(yPoint.getX(), yPoint.getY());
                        affineTransform.transform(double_, double_);
                        ((Vector)object).add(new YPoint(((Point2D)double_).getX(), ((Point2D)double_).getY()));
                        yPointCursor.next();
                    }
                    layoutGraph.setPoints(edge, new YPointPath((Vector)object));
                    edgeCursor.next();
                }
                break;
            }
        }
    }

    private static void a(LayoutGraph layoutGraph, double d2, Rectangle rectangle) {
        Object object;
        AffineTransform affineTransform = new AffineTransform();
        double d3 = rectangle.getX() + rectangle.getWidth() / 2.0;
        double d4 = rectangle.getY() + rectangle.getHeight() / 2.0;
        Point2D.Double double_ = new Point2D.Double();
        affineTransform.translate(d3, d4);
        affineTransform.rotate(Math.toRadians(d2));
        affineTransform.translate(-d3, -d4);
        NodeCursor nodeCursor = layoutGraph.nodes();
        while (nodeCursor.ok()) {
            object = nodeCursor.node();
            ((Point2D)double_).setLocation(layoutGraph.getCenterX((Node)object), layoutGraph.getCenterY((Node)object));
            affineTransform.transform(double_, double_);
            layoutGraph.setCenter((Node)object, ((Point2D)double_).getX(), ((Point2D)double_).getY());
            nodeCursor.next();
        }
        object = new Vector();
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            ((Vector)object).clear();
            YPointCursor yPointCursor = layoutGraph.getPoints(edge).points();
            while (yPointCursor.ok()) {
                YPoint yPoint = yPointCursor.point();
                ((Point2D)double_).setLocation(yPoint.getX(), yPoint.getY());
                affineTransform.transform(double_, double_);
                ((Vector)object).add(new YPoint(((Point2D)double_).getX(), ((Point2D)double_).getY()));
                yPointCursor.next();
            }
            layoutGraph.setPoints(edge, new YPointPath((Vector)object));
            edgeCursor.next();
        }
    }

    public static double applyBestFitRotationAngle(LayoutGraph layoutGraph, double d2, double d3) {
        double d4 = GraphTransformer.findBestFitRotationAngle(layoutGraph, d2, d3);
        GraphTransformer.a(layoutGraph, d4, layoutGraph.getBoundingBox());
        return d4;
    }

    public static double findBestFitRotationAngle(LayoutGraph layoutGraph, double d2, double d3) {
        if (layoutGraph.nodeCount() > 1) {
            YList yList = GraphTransformer.x(layoutGraph);
            double d4 = Double.MAX_VALUE;
            double d5 = 0.0;
            double d6 = 0.0;
            while (d6 < 360.0) {
                YDimension yDimension = GraphTransformer.a(yList, d6);
                double d7 = Math.abs(yDimension.getWidth() * d3 - d2 * yDimension.getHeight());
                if (d7 < d4) {
                    d4 = d7;
                    d5 = d6;
                }
                d6 += 10.0;
            }
            return d5;
        }
        return 0.0;
    }

    public static double[] scaleToRect(LayoutGraph layoutGraph, Rectangle rectangle) {
        Object object;
        Object object2;
        double[] dArray = new double[2];
        if (layoutGraph.nodeCount() == 0) {
            return dArray;
        }
        Node node = null;
        Node node2 = null;
        Object object3 = null;
        Object object4 = null;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        double d5 = -1.7976931348623157E308;
        NodeCursor nodeCursor = layoutGraph.nodes();
        while (nodeCursor.ok()) {
            object2 = nodeCursor.node();
            NodeLayout nodeLayout = layoutGraph.getLayout((Node)object2);
            if (nodeLayout.getX() < d2) {
                d2 = nodeLayout.getX();
                node = object2;
            }
            if (nodeLayout.getX() + nodeLayout.getWidth() > d4) {
                d4 = nodeLayout.getX() + nodeLayout.getWidth();
                node2 = object2;
            }
            if (nodeLayout.getY() < d3) {
                d3 = nodeLayout.getY();
                object3 = object2;
            }
            if (nodeLayout.getY() + nodeLayout.getHeight() > d5) {
                d5 = nodeLayout.getY() + nodeLayout.getHeight();
                object4 = object2;
            }
            nodeCursor.next();
        }
        object2 = new Rectangle((int)layoutGraph.getCenterX(node), (int)layoutGraph.getCenterY((Node)object3), (int)(layoutGraph.getCenterX(node2) - layoutGraph.getCenterX(node)), (int)(layoutGraph.getCenterY((Node)object4) - layoutGraph.getCenterY((Node)object3)));
        double d6 = layoutGraph.getWidth(node) / 2.0;
        double d7 = layoutGraph.getWidth(node2) / 2.0;
        double d8 = layoutGraph.getHeight((Node)object3) / 2.0;
        double d9 = layoutGraph.getHeight((Node)object4) / 2.0;
        Rectangle rectangle2 = new Rectangle((int)(rectangle.getX() + d6), (int)(rectangle.getY() + d7), (int)(rectangle.getWidth() - d6 - d7), (int)(rectangle.getHeight() - d8 - d9));
        if (((Rectangle)object2).getWidth() <= 1.0 || ((Rectangle)object2).getHeight() <= 1.0) {
            dArray[0] = 1.0;
            dArray[1] = 1.0;
            return dArray;
        }
        double d10 = rectangle2.getWidth() / ((Rectangle)object2).getWidth();
        double d11 = rectangle2.getHeight() / ((Rectangle)object2).getHeight();
        dArray[0] = d10;
        dArray[1] = d11;
        NodeCursor nodeCursor2 = layoutGraph.nodes();
        while (nodeCursor2.ok()) {
            object = nodeCursor2.node();
            layoutGraph.setCenter((Node)object, layoutGraph.getCenterX((Node)object) * d10, layoutGraph.getCenterY((Node)object) * d11);
            nodeCursor2.next();
        }
        object = new Vector();
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            ((Vector)object).clear();
            YPointCursor yPointCursor = layoutGraph.getPoints(edge).points();
            while (yPointCursor.ok()) {
                YPoint yPoint = yPointCursor.point();
                ((Vector)object).add(new YPoint(yPoint.getX() * d10, yPoint.getY() * d11));
                yPointCursor.next();
            }
            layoutGraph.setPoints(edge, new YPointPath((Vector)object));
            edgeCursor.next();
        }
        object2 = layoutGraph.getBoundingBox();
        double d12 = rectangle.getX() - ((Rectangle)object2).getX();
        double d13 = rectangle.getY() - ((Rectangle)object2).getY();
        GraphTransformer.translate(layoutGraph, d12, d13);
        return dArray;
    }

    public static void translate(LayoutGraph layoutGraph, double d2, double d3) {
        Object object;
        NodeCursor nodeCursor = layoutGraph.nodes();
        while (nodeCursor.ok()) {
            object = nodeCursor.node();
            layoutGraph.setCenter((Node)object, layoutGraph.getCenterX((Node)object) + d2, layoutGraph.getCenterY((Node)object) + d3);
            nodeCursor.next();
        }
        object = new Vector();
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            ((Vector)object).clear();
            YPointCursor yPointCursor = layoutGraph.getPoints(edge).points();
            while (yPointCursor.ok()) {
                YPoint yPoint = yPointCursor.point();
                ((Vector)object).add(new YPoint(yPoint.getX() + d2, yPoint.getY() + d3));
                yPointCursor.next();
            }
            layoutGraph.setPoints(edge, new YPointPath((Vector)object));
            edgeCursor.next();
        }
    }

    private static YPoint a(YPoint yPoint, Rectangle rectangle) {
        return new YPoint(yPoint.getX(), 2.0 * rectangle.getY() + rectangle.getHeight() - yPoint.getY());
    }

    private static YPoint b(YPoint yPoint, Rectangle rectangle) {
        return new YPoint(2.0 * rectangle.getX() + rectangle.getWidth() - yPoint.getX(), yPoint.getY());
    }

    private static YList x(LayoutGraph layoutGraph) {
        Object object;
        YList yList = new YList();
        NodeCursor nodeCursor = layoutGraph.nodes();
        while (nodeCursor.ok()) {
            object = layoutGraph.getLayout(nodeCursor.node());
            yList.add(new YPoint(object.getX() + object.getWidth() / 2.0, object.getY() + object.getHeight() / 2.0));
            nodeCursor.next();
        }
        object = layoutGraph.edges();
        while (object.ok()) {
            EdgeLayout edgeLayout = layoutGraph.getLayout(object.edge());
            int n = 0;
            while (n < edgeLayout.pointCount()) {
                yList.add(edgeLayout.getPoint(n));
                ++n;
            }
            object.next();
        }
        return Geom.calcConvexHull(yList);
    }

    private static YDimension a(YList yList, double d2) {
        d2 = Math.toRadians(d2);
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        double d5 = Double.MAX_VALUE;
        double d6 = -1.7976931348623157E308;
        double d7 = Math.cos(d2);
        double d8 = Math.sin(d2);
        YCursor yCursor = yList.cursor();
        while (yCursor.ok()) {
            YPoint yPoint = (YPoint)yCursor.current();
            double d9 = yPoint.getX() * d7 - yPoint.getY() * d8;
            double d10 = yPoint.getX() * d8 + yPoint.getY() * d7;
            if (d9 < d3) {
                d3 = d9;
            }
            if (d10 < d5) {
                d5 = d10;
            }
            if (d9 > d4) {
                d4 = d9;
            }
            if (d10 > d4) {
                d6 = d10;
            }
            yCursor.next();
        }
        return new YDimension(d4 - d3, d6 - d5);
    }
}

