/*
 * Decompiled with CFR 0.152.
 */
package y.layout.planar;

import java.util.ArrayList;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.util.YRandom;

public class VertexOrder {
    protected Graph graph;
    protected boolean allowRandomization;
    protected int[] degree;
    protected boolean[] selected;
    protected ArrayList graphNodes;
    protected ArrayList neighbors;
    protected ArrayList candidateList;
    protected YRandom random;
    protected long seed = 1306737L;

    public void setGraph(Graph graph) {
        this.graph = graph;
        this.degree = new int[graph.nodeCount()];
        this.selected = new boolean[graph.nodeCount()];
        this.graphNodes = new ArrayList(graph.nodeCount());
        this.neighbors = new ArrayList(graph.nodeCount());
        this.candidateList = new ArrayList(graph.nodeCount());
        this.random = new YRandom(this.seed);
    }

    public void setAllowRandomization(boolean bl) {
        this.allowRandomization = bl;
    }

    public void computeVertexOrder(NodeList nodeList) {
        this.initDegrees();
        nodeList.clear();
        this.graphNodes.clear();
        NodeCursor nodeCursor = this.graph.nodes();
        while (nodeCursor.ok()) {
            this.graphNodes.add(nodeCursor.node());
            nodeCursor.next();
        }
        this.getMinDegreeNodes(this.graphNodes, this.candidateList);
        if (this.candidateList.isEmpty()) {
            throw new RuntimeException("Graph consists only of directed circles");
        }
        this.selectNode(this.graphNodes, this.candidateList, this.neighbors, nodeList);
        while (!this.graphNodes.isEmpty()) {
            this.getMinDegreeNodes(this.neighbors, this.candidateList);
            if (this.candidateList.isEmpty()) {
                this.getMinDegreeNodes(this.graphNodes, this.candidateList);
            }
            if (this.candidateList.isEmpty()) {
                throw new RuntimeException("Graph contains a directed circle");
            }
            this.selectNode(this.graphNodes, this.candidateList, this.neighbors, nodeList);
        }
    }

    protected void initDegrees() {
        int n = 0;
        while (n < this.graph.N()) {
            this.degree[n] = 0;
            this.selected[n] = false;
            ++n;
        }
        EdgeCursor edgeCursor = this.graph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            int n2 = edge.target().index();
            this.degree[n2] = this.degree[n2] + 1;
            int n3 = edge.source().index();
            this.degree[n3] = this.degree[n3] + 1;
            edgeCursor.next();
        }
    }

    protected void getMinDegreeNodes(ArrayList arrayList, ArrayList arrayList2) {
        arrayList2.clear();
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        while (n2 < arrayList.size()) {
            Node node = (Node)arrayList.get(n2);
            int n3 = this.degree[node.index()];
            if (n3 < n) {
                n = n3;
                arrayList2.clear();
            }
            if (n3 == n) {
                arrayList2.add(node);
            }
            ++n2;
        }
    }

    public void selectNode(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, NodeList nodeList) {
        Node node = this.allowRandomization ? this.randomSelectNode(arrayList2) : (Node)arrayList2.get(0);
        arrayList.remove(node);
        nodeList.add(node);
        arrayList3.clear();
        this.selected[node.index()] = true;
        EdgeCursor edgeCursor = node.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            Node node2 = edge.opposite(node);
            int n = node2.index();
            if (!this.selected[n]) {
                int n2 = n;
                this.degree[n2] = this.degree[n2] - 1;
                arrayList3.add(node2);
            }
            edgeCursor.next();
        }
    }

    protected Node randomSelectNode(ArrayList arrayList) {
        if (arrayList.size() == 0) {
            throw new RuntimeException("Given an empty list!");
        }
        int n = this.random.nextInt(arrayList.size());
        return (Node)arrayList.get(n);
    }
}

