/*
 * Decompiled with CFR 0.152.
 */
package y.layout.organic;

import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeMap;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeMap;
import y.base.YList;
import y.geom.YPoint;
import y.layout.LayoutGraph;
import y.layout.LayoutStage;
import y.layout.LayoutTool;
import y.layout.Layouter;
import y.util.DataProviderAdapter;

public class SplitEdgeLayoutStage
implements LayoutStage {
    Layouter ae;
    double ad = 100.0;

    public void setSplitSegmentLength(double d2) {
        this.ad = d2;
    }

    public double getSplitSegmentLength() {
        return this.ad;
    }

    public boolean canLayout(LayoutGraph layoutGraph) {
        return true;
    }

    public void doLayout(LayoutGraph layoutGraph) {
        if (this.ae != null) {
            final NodeMap nodeMap = layoutGraph.createNodeMap();
            EdgeMap edgeMap = layoutGraph.createEdgeMap();
            this.a(layoutGraph, nodeMap, edgeMap, this.getSplitSegmentLength());
            final DataProvider dataProvider = layoutGraph.getDataProvider(Layouter.SELECTED_EDGES);
            final DataProvider dataProvider2 = layoutGraph.getDataProvider(Layouter.SELECTED_NODES);
            DataProviderAdapter dataProviderAdapter = new DataProviderAdapter(){

                public boolean getBool(Object object) {
                    Object object2 = nodeMap.get(object);
                    if (object2 != null) {
                        if (dataProvider != null) {
                            return dataProvider.getBool(object2);
                        }
                        return false;
                    }
                    return dataProvider2.getBool(object);
                }
            };
            layoutGraph.addDataProvider(Layouter.SELECTED_NODES, dataProviderAdapter);
            this.ae.doLayout(layoutGraph);
            layoutGraph.addDataProvider(Layouter.SELECTED_NODES, dataProvider2);
            this.a(layoutGraph, nodeMap);
            layoutGraph.disposeNodeMap(nodeMap);
            layoutGraph.disposeEdgeMap(edgeMap);
        }
    }

    private void a(LayoutGraph layoutGraph, NodeMap nodeMap, EdgeMap edgeMap, double d2) {
        Edge[] edgeArray = layoutGraph.getEdgeArray();
        int n = 0;
        while (n < edgeArray.length) {
            this.a(layoutGraph, edgeArray[n], nodeMap, edgeMap, d2);
            ++n;
        }
    }

    private void a(LayoutGraph layoutGraph, Edge edge, NodeMap nodeMap, EdgeMap edgeMap, double d2) {
        double d3 = LayoutTool.getPathLength(layoutGraph, edge);
        int n = (int)(d3 / d2);
        if (n <= 1) {
            return;
        }
        int n2 = n - 1;
        d2 = d3 / (double)n;
        YList yList = layoutGraph.getPathList(edge);
        YPoint yPoint = (YPoint)yList.pop();
        YPoint yPoint2 = null;
        Node node = edge.source();
        Edge edge2 = edgeMap.get(edge) == null ? edge : (Edge)edgeMap.get(edge);
        double d4 = 0.0;
        while (!yList.isEmpty()) {
            yPoint2 = yPoint;
            yPoint = (YPoint)yList.pop();
            double d5 = YPoint.distance(yPoint2, yPoint);
            double d6 = (yPoint.x - yPoint2.x) / d5;
            double d7 = (yPoint.y - yPoint2.y) / d5;
            double d8 = d2 - d4;
            if (d8 < d5) {
                while (d8 < d5) {
                    double d9 = yPoint2.x + d8 * d6;
                    double d10 = yPoint2.y + d8 * d7;
                    Node node2 = layoutGraph.createNode();
                    layoutGraph.setCenter(node2, d9, d10);
                    nodeMap.set(node2, edge2);
                    Edge edge3 = layoutGraph.createEdge(node, node2);
                    edgeMap.set(edge3, edge2);
                    node = node2;
                    d8 += d2;
                }
                d4 = d5 - (d8 - d2);
                continue;
            }
            d4 += d5;
        }
        Edge edge4 = layoutGraph.createEdge(node, edge.target());
        edgeMap.set(edge4, edge2);
        layoutGraph.hide(edge);
    }

    private void a(LayoutGraph layoutGraph, int n) {
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            int n2 = 0;
            while (n2 < n) {
                this.b(layoutGraph, edge);
                ++n2;
            }
            edgeCursor.next();
        }
    }

    private void b(LayoutGraph layoutGraph, Edge edge) {
        if (layoutGraph.getLayout(edge).pointCount() == 0) {
            return;
        }
        YList yList = layoutGraph.getPathList(edge);
        YPoint yPoint = (YPoint)yList.pop();
        YList yList2 = new YList();
        while (!yList.isEmpty()) {
            YPoint yPoint2 = (YPoint)yList.pop();
            YPoint yPoint3 = YPoint.midPoint(yPoint, yPoint2);
            yList2.add(yPoint3);
            yPoint = yPoint2;
        }
        layoutGraph.setPoints(edge, yList2);
    }

    private void a(LayoutGraph layoutGraph, NodeMap nodeMap) {
        Object object;
        NodeCursor nodeCursor = layoutGraph.nodes();
        while (nodeCursor.ok()) {
            object = nodeCursor.node();
            Edge edge = (Edge)nodeMap.get(object);
            if (edge != null && !layoutGraph.contains(edge)) {
                YPoint yPoint;
                Node node = ((Node)object).inEdges().edge().source();
                while (nodeMap.get(node) != null) {
                    object = node;
                    node = ((Node)object).inEdges().edge().source();
                }
                layoutGraph.unhide(edge);
                Edge edge2 = ((Node)object).firstInEdge();
                YList yList = new YList();
                YPoint yPoint2 = null;
                while (nodeMap.get(edge2.target()) != null) {
                    yPoint = layoutGraph.getSourcePointAbs(edge2);
                    if (!yPoint.equals(yPoint2)) {
                        yList.add(yPoint);
                    }
                    yList.splice(layoutGraph.getPointList(edge2));
                    yPoint2 = layoutGraph.getTargetPointAbs(edge2);
                    if (!yPoint2.equals(yPoint)) {
                        yList.add(yPoint2);
                    }
                    edge2 = edge2.target().firstOutEdge();
                }
                yPoint = layoutGraph.getSourcePointAbs(edge2);
                if (!yPoint.equals(yPoint2)) {
                    yList.add(yPoint);
                }
                yList.splice(layoutGraph.getPointList(edge2));
                yPoint2 = layoutGraph.getTargetPointAbs(edge2);
                if (!yPoint2.equals(yPoint)) {
                    yList.add(yPoint2);
                }
                layoutGraph.setPath(edge, yList);
            }
            nodeCursor.next();
        }
        object = layoutGraph.nodes();
        while (object.ok()) {
            if (nodeMap.get(object.node()) != null) {
                layoutGraph.removeNode(object.node());
            }
            object.next();
        }
    }

    double b(LayoutGraph layoutGraph) {
        double d2 = 0.0;
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            d2 += this.a(layoutGraph, edgeCursor.edge());
            edgeCursor.next();
        }
        return d2 / (double)layoutGraph.E();
    }

    double a(LayoutGraph layoutGraph, Edge edge) {
        return LayoutTool.getNodeDistance(layoutGraph, edge.source(), edge.target());
    }

    public Layouter getCoreLayouter() {
        return this.ae;
    }

    public void setCoreLayouter(Layouter layouter) {
        this.ae = layouter;
    }
}

