/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import y.base.YList;
import y.geom.LineSegment;
import y.geom.YDimension;
import y.geom.YPoint;
import y.geom.YPointCursor;
import y.geom.YPointPath;
import y.geom.YRectangle;
import y.geom.YVector;
import y.layout.EdgeLabelCandidate;
import y.layout.EdgeLabelLayout;
import y.layout.EdgeLabelLayoutImpl;
import y.layout.EdgeLabelModel;
import y.layout.EdgeLayout;
import y.layout.LayoutTool;
import y.layout.NodeLayout;
import y.layout.a;

public class SliderEdgeLabelModel
implements EdgeLabelModel {
    public static final byte CENTER_SLIDER = 0;
    public static final byte SIDE_SLIDER = 1;
    public static final byte CENTER_RATIO = 0;
    public static final byte TAIL_RATIO = 1;
    public static final byte HEAD_RATIO = 2;
    public static final byte LEFT_RATIO = 3;
    public static final byte RIGHT_RATIO = 4;
    private double n = 1.0;
    private double k = 1.0;
    private double m = 1.0;
    private byte l;

    public SliderEdgeLabelModel(byte by) {
        this.l = by;
    }

    public void setDistances(double d2, double d3) {
        this.n = d2;
        this.k = d3;
    }

    public void setDensity(double d2) {
        this.m = d2;
    }

    public Object getDefaultParameter() {
        if (this.l == 1) {
            return new ModelParameter(0, 0.0, new YVector(0.0, 0.0), 2, 0.0);
        }
        return new ModelParameter(0, 0.5, new YVector(0.0, 0.0), 0, 0.0);
    }

    public YPoint getLabelPlacement(YDimension yDimension, EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2, Object object) {
        ModelParameter modelParameter = (ModelParameter)object;
        int n = modelParameter.getSegmentNumber();
        byte by = modelParameter.getLabelPosition();
        double d2 = modelParameter.getRatio();
        YVector yVector = modelParameter.getOffsetVector();
        YPointPath yPointPath = LayoutTool.getEdgeClippedOnBB(edgeLayout, nodeLayout, nodeLayout2, 10.0);
        LineSegment lineSegment = yPointPath.getLineSegment(n);
        if (lineSegment == null) {
            return new YPoint(nodeLayout.getX(), nodeLayout.getY());
        }
        YPoint yPoint = lineSegment.getFirstEndPoint();
        YPoint yPoint2 = lineSegment.getSecondEndPoint();
        YPoint yPoint3 = this.a(d2, yPoint, yPoint2, yDimension, by);
        YPoint yPoint4 = YVector.add(yPoint3, yVector);
        yPoint4 = YPoint.add(yPoint4, yPoint);
        return yPoint4;
    }

    public YList getLabelCandidates(EdgeLabelLayout edgeLabelLayout, EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2) {
        byte[] byArray = SliderEdgeLabelModel.a(this.l);
        YRectangle yRectangle = edgeLabelLayout.getBox();
        double d2 = yRectangle.getWidth();
        double d3 = yRectangle.getHeight();
        YList yList = new YList();
        YPointPath yPointPath = LayoutTool.getEdgeClippedOnBB(edgeLayout, nodeLayout, nodeLayout2, 10.0);
        YPointCursor yPointCursor = yPointPath.points();
        if (!yPointCursor.ok()) {
            YPoint yPoint = new YPoint(nodeLayout.getX(), nodeLayout.getY());
            EdgeLabelCandidate edgeLabelCandidate = new EdgeLabelCandidate(yPoint, (YDimension)yRectangle, (Object)edgeLabelLayout, null);
            return yList;
        }
        double[] dArray = new double[yPointPath.length() - 1];
        double[] dArray2 = new double[yPointPath.length() - 1];
        double d4 = this.a(yPointPath, dArray, dArray2);
        YPoint yPoint = yPointCursor.point();
        yPointCursor.next();
        int n = 0;
        while (yPointCursor.ok()) {
            YPoint yPoint2 = yPoint;
            yPoint = yPointCursor.point();
            double d5 = yPoint.getX() - yPoint2.getX();
            double d6 = yPoint.getY() - yPoint2.getY();
            double[] dArray3 = this.a(d5, d6, d2, d3);
            int n2 = 0;
            while (n2 < byArray.length) {
                boolean bl = false;
                if (byArray[n2] == 0) {
                    bl = true;
                }
                YVector yVector = this.getOffsetVec(d5, d6, d2, d3, byArray[n2]);
                YVector yVector2 = YVector.getNormal(yVector);
                yVector2.scale(this.n);
                int n3 = 0;
                do {
                    ++n3;
                    int n4 = 0;
                    while (n4 < dArray3.length) {
                        double d7 = dArray3[n4];
                        YPoint yPoint3 = this.a(d7, yPoint2, yPoint, yRectangle, byArray[n2]);
                        YPoint yPoint4 = YVector.add(yPoint3, yVector2);
                        yPoint4 = YPoint.add(yPoint4, yPoint2);
                        double d8 = dArray2[n] / d4 + d7 * dArray[n];
                        ModelParameter modelParameter = new ModelParameter(n, d7, yVector2, byArray[n2], d8);
                        EdgeLabelCandidate edgeLabelCandidate = new EdgeLabelCandidate(yPoint4, (YDimension)yRectangle, (Object)modelParameter, edgeLabelLayout, bl);
                        yList.add(edgeLabelCandidate);
                        ++n4;
                    }
                    yVector2.add(yVector);
                } while (YVector.add(yVector2, yVector).length() < this.k && this.l != 0 && n3 < 5);
                ++n2;
            }
            yPointCursor.next();
            ++n;
        }
        return yList;
    }

    public Object createModelParameter(YRectangle yRectangle, EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2) {
        EdgeLabelLayoutImpl edgeLabelLayoutImpl = new EdgeLabelLayoutImpl();
        edgeLabelLayoutImpl.setBox(yRectangle);
        YList yList = this.getLabelCandidates(edgeLabelLayoutImpl, edgeLayout, nodeLayout, nodeLayout2);
        if (yList.isEmpty()) {
            return this.getDefaultParameter();
        }
        return a.a(yList, yRectangle.getLocation()).getModelParameter();
    }

    public YVector getOffsetVec(double d2, double d3, double d4, double d5, byte by) {
        if (by == 0) {
            return new YVector(0.0, 0.0);
        }
        double d6 = Math.abs(d2);
        double d7 = Math.abs(d3);
        double d8 = d3 / d2;
        d4 = Math.max(0.01, d4);
        d5 = Math.max(0.01, d5);
        double d9 = d5 / d4;
        double d10 = d4 * 0.5;
        double d11 = d5 * 0.5;
        if (d7 < d6 * d9) {
            double d12 = d11 + Math.abs(d10 * d8);
            if (SliderEdgeLabelModel.b(by, d2, d3)) {
                return new YVector(0.0, -d12);
            }
            return new YVector(0.0, d12);
        }
        double d13 = d10 + Math.abs(d11 / d8);
        if (SliderEdgeLabelModel.a(by, d2, d3)) {
            return new YVector(-d13, 0.0);
        }
        return new YVector(d13, 0.0);
    }

    private static final byte[] a(byte by) {
        if (by == 0) {
            byte[] byArray = new byte[]{0};
            return byArray;
        }
        if (by == 1) {
            byte[] byArray = new byte[]{3, 4};
            return byArray;
        }
        throw new IllegalArgumentException("Unknown model mode " + by);
    }

    private double[] a(double d2, double d3, double d4, double d5) {
        d2 = Math.abs(d2);
        int n = (d3 = Math.abs(d3)) < d2 * d5 / (d4 = Math.max(0.01, d4)) ? Math.max(2, (int)Math.floor(d2 / d4)) : Math.max(2, (int)Math.floor(d3 / d5));
        n = (int)((double)n + (this.m - 1.0) * (double)(n - 1));
        n = Math.min(n, 20);
        double d6 = 1.0 / (double)(n - 1);
        double[] dArray = new double[n];
        int n2 = n - 2;
        while (n2 > 0) {
            dArray[n2] = d6 * (double)n2;
            --n2;
        }
        dArray[n - 1] = 1.0;
        return dArray;
    }

    private YPoint a(double d2, YPoint yPoint, YPoint yPoint2, YDimension yDimension, byte by) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9 = yPoint2.getX() - yPoint.getX();
        double d10 = yPoint2.getY() - yPoint.getY();
        double d11 = Math.abs(d9);
        double d12 = Math.abs(d10);
        double d13 = d10 / d9;
        double d14 = Math.max(0.01, yDimension.getWidth());
        double d15 = Math.max(0.01, yDimension.getHeight());
        double d16 = d15 / d14;
        double d17 = d14 * 0.5;
        double d18 = d15 * 0.5;
        if (d12 < d11 * d16) {
            d8 = d9 > 0.0 ? 1.0 + d17 : -(1.0 + d17);
            d7 = d9 - d8;
            d6 = d13 * d8;
            d5 = d10 - d6;
            if (by != 0) {
                d4 = d18 + Math.abs(d17 * d13);
                if (SliderEdgeLabelModel.b(by, d9, d10)) {
                    d6 -= d4;
                    d5 -= d4;
                } else {
                    d6 += d4;
                    d5 += d4;
                }
            }
        } else {
            d4 = 1.0 / d13;
            d6 = d10 > 0.0 ? 1.0 + d18 : -(1.0 + d18);
            d5 = d10 - d6;
            d8 = d6 / d13;
            d7 = d9 - d8;
            if (by != 0) {
                d3 = d17 + Math.abs(d18 * d4);
                if (SliderEdgeLabelModel.a(by, d9, d10)) {
                    d8 -= d3;
                    d7 -= d3;
                } else {
                    d8 += d3;
                    d7 += d3;
                }
            }
        }
        d4 = d7 - d8;
        d3 = d5 - d6;
        if (d4 * d9 < 0.0 || d3 * d10 < 0.0) {
            return new YPoint((d8 + d7) * 0.5 - d17, (d6 + d5) * 0.5 - d18);
        }
        return new YPoint(d8 + d4 * d2 - d17, d6 + d3 * d2 - d18);
    }

    private static boolean b(byte by, double d2, double d3) {
        if (by == 2) {
            return true;
        }
        if (by == 1) {
            return false;
        }
        if (d2 > 0.0 && by == 3) {
            return true;
        }
        return d2 < 0.0 && by == 4;
    }

    private static boolean a(byte by, double d2, double d3) {
        if (by == 2) {
            return true;
        }
        if (by == 1) {
            return false;
        }
        if (d3 > 0.0 && by == 4) {
            return true;
        }
        return d3 < 0.0 && by == 3;
    }

    private double a(YPointPath yPointPath, double[] dArray, double[] dArray2) {
        double d2;
        YPoint yPoint = null;
        YPoint yPoint2 = null;
        YPointCursor yPointCursor = yPointPath.points();
        if (!yPointCursor.ok()) {
            return 0.0;
        }
        double d3 = 0.0;
        yPoint = yPointCursor.point();
        yPointCursor.next();
        while (yPointCursor.ok()) {
            yPoint2 = yPoint;
            yPoint = yPointCursor.point();
            d2 = yPoint2.getX() - yPoint.getX();
            double d4 = yPoint2.getY() - yPoint.getY();
            d3 += Math.sqrt(d2 * d2 + d4 * d4);
            yPointCursor.next();
        }
        yPointCursor = yPointPath.points();
        yPoint = yPointCursor.point();
        yPointCursor.next();
        d2 = 0.0;
        int n = 0;
        while (yPointCursor.ok()) {
            yPoint2 = yPoint;
            yPoint = yPointCursor.point();
            double d5 = yPoint2.getX() - yPoint.getX();
            double d6 = yPoint2.getY() - yPoint.getY();
            double d7 = Math.sqrt(d5 * d5 + d6 * d6);
            dArray2[n] = d2;
            dArray[n] = d7 / d3;
            d2 += d7;
            ++n;
            yPointCursor.next();
        }
        return d3;
    }

    public static class ModelParameter {
        private int d;
        private double b;
        private double c;
        private YVector a;
        private byte e;

        public ModelParameter(int n, double d2, YVector yVector, byte by, double d3) {
            this.d = n;
            this.b = d2;
            this.a = new YVector(yVector);
            this.e = by;
            this.c = d3;
        }

        public int getSegmentNumber() {
            return this.d;
        }

        public double getRatio() {
            return this.b;
        }

        public YVector getOffsetVector() {
            return this.a;
        }

        public byte getLabelPosition() {
            return this.e;
        }

        public double getAbsRatio() {
            return this.c;
        }
    }
}

