/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import y.base.DataProvider;
import y.base.Edge;
import y.layout.LayoutGraph;
import y.layout.PortConstraintKeys;

public class PortConstraint
implements PortConstraintKeys {
    public static final byte ANY_SIDE = 0;
    public static final byte NORTH = 1;
    public static final byte SOUTH = 2;
    public static final byte EAST = 4;
    public static final byte WEST = 8;
    private static final PortConstraint ix = new PortConstraint(0);
    private static final PortConstraint ir = new PortConstraint(1);
    private static final PortConstraint iv = new PortConstraint(2);
    private static final PortConstraint iq = new PortConstraint(4);
    private static final PortConstraint iw = new PortConstraint(8);
    private static final PortConstraint ip = new PortConstraint(0, true);
    private static final PortConstraint in = new PortConstraint(4, true);
    private static final PortConstraint io = new PortConstraint(8, true);
    private static final PortConstraint im = new PortConstraint(1, true);
    private static final PortConstraint it = new PortConstraint(2, true);
    private byte is;
    private boolean iu;

    public PortConstraint() {
        this(0);
    }

    public PortConstraint(byte by) {
        this.is = by;
    }

    public PortConstraint(byte by, boolean bl) {
        this(by);
        this.iu = bl;
    }

    public boolean isStrong() {
        return this.iu;
    }

    public byte getSide() {
        return this.is;
    }

    public boolean isAtNorth() {
        return this.is == 1;
    }

    public boolean isAtSouth() {
        return this.is == 2;
    }

    public boolean isAtEast() {
        return this.is == 4;
    }

    public boolean isAtWest() {
        return this.is == 8;
    }

    public boolean isAtAnySide() {
        return this.is == 0;
    }

    public static boolean hasPC(LayoutGraph layoutGraph, Edge edge) {
        return PortConstraint.hasSPC(layoutGraph, edge) || PortConstraint.hasTPC(layoutGraph, edge);
    }

    public static boolean hasSPC(LayoutGraph layoutGraph, Edge edge) {
        PortConstraint portConstraint = PortConstraint.getSPC(layoutGraph, edge);
        return portConstraint != null && (portConstraint.is != 0 || portConstraint.iu);
    }

    public static boolean hasTPC(LayoutGraph layoutGraph, Edge edge) {
        PortConstraint portConstraint = PortConstraint.getTPC(layoutGraph, edge);
        return portConstraint != null && (portConstraint.is != 0 || portConstraint.iu);
    }

    public static PortConstraint getSPC(LayoutGraph layoutGraph, Edge edge) {
        DataProvider dataProvider = layoutGraph.getDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY);
        if (dataProvider == null) {
            return null;
        }
        return (PortConstraint)dataProvider.get(edge);
    }

    public static PortConstraint getTPC(LayoutGraph layoutGraph, Edge edge) {
        DataProvider dataProvider = layoutGraph.getDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY);
        if (dataProvider == null) {
            return null;
        }
        return (PortConstraint)dataProvider.get(edge);
    }

    public static PortConstraint create(byte by) {
        return PortConstraint.create(by, false);
    }

    public static PortConstraint create(byte by, boolean bl) {
        if (bl) {
            switch (by) {
                case 0: {
                    return ip;
                }
                case 1: {
                    return im;
                }
                case 2: {
                    return it;
                }
                case 4: {
                    return in;
                }
                case 8: {
                    return io;
                }
            }
            return null;
        }
        switch (by) {
            case 0: {
                return ix;
            }
            case 1: {
                return ir;
            }
            case 2: {
                return iv;
            }
            case 4: {
                return iq;
            }
            case 8: {
                return iw;
            }
        }
        return null;
    }

    public String toString() {
        if (this.is == 0) {
            if (this.iu) {
                return "ANY_SIDE [strong] [-]";
            }
            return "ANY_SIDE [-]";
        }
        String string = null;
        switch (this.is) {
            case 1: {
                string = "NORTH";
                break;
            }
            case 2: {
                string = "SOUTH";
                break;
            }
            case 4: {
                string = "EAST";
                break;
            }
            case 8: {
                string = "WEST";
            }
        }
        if (this.iu) {
            string = string + " [strong] ";
        }
        return string;
    }
}

