/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.YList;
import y.geom.YDimension;
import y.geom.YPoint;
import y.geom.YRectangle;
import y.layout.AbstractLayoutStage;
import y.layout.CopiedLayoutGraph;
import y.layout.EdgeLabelCandidate;
import y.layout.EdgeLabelLayout;
import y.layout.EdgeLabelLayoutImpl;
import y.layout.EdgeLabelModel;
import y.layout.EdgeLayout;
import y.layout.LabelCandidate;
import y.layout.LabelLayoutConstants;
import y.layout.LabelLayoutData;
import y.layout.LabelLayoutKeys;
import y.layout.LayoutGraph;
import y.layout.NodeLayout;
import y.layout.ProfitModel;
import y.layout.SliderEdgeLabelModel;
import y.layout.labeling.AbstractLabelingAlgorithm;
import y.layout.labeling.GreedyMISLabeling;

public class LabelLayoutDataRefinement
extends AbstractLayoutStage {
    private AbstractLabelingAlgorithm cb = new GreedyMISLabeling();

    public LabelLayoutDataRefinement() {
        this.cb.setRemoveEdgeOverlaps(true);
        this.cb.setRemoveNodeOverlaps(true);
    }

    public void setInternalLabelingAlgorithm(AbstractLabelingAlgorithm abstractLabelingAlgorithm) {
        this.cb = abstractLabelingAlgorithm;
    }

    public AbstractLabelingAlgorithm getInternalLabelingAlgorithm() {
        return this.cb;
    }

    public boolean canLayout(LayoutGraph layoutGraph) {
        return true;
    }

    public void doLayout(LayoutGraph layoutGraph) {
        this.getCoreLayouter().doLayout(layoutGraph);
        this.m(layoutGraph);
    }

    private void m(LayoutGraph layoutGraph) {
        LabelLayoutConstants[] labelLayoutConstantsArray;
        Object object;
        Edge edge;
        Object object2;
        CopiedLayoutGraph copiedLayoutGraph = new CopiedLayoutGraph(layoutGraph);
        YList yList = new YList();
        DataProvider dataProvider = layoutGraph.getDataProvider(LabelLayoutKeys.EDGE_LABEL_LAYOUT_KEY);
        EdgeCursor edgeCursor = copiedLayoutGraph.edges();
        while (edgeCursor.ok()) {
            object2 = edgeCursor.edge();
            edge = (Edge)copiedLayoutGraph.getOriginalEdge((Edge)object2);
            object = layoutGraph.getLabelLayout((Edge)object2);
            labelLayoutConstantsArray = (LabelLayoutData[])dataProvider.get(edge);
            int n = 0;
            while (n < ((EdgeLabelLayout[])object).length) {
                LabelLayoutData labelLayoutData = labelLayoutConstantsArray[n];
                byte by = labelLayoutData.getPreferredPlacement();
                if ((by & 1) != 0 || (by & 2) != 0) {
                    EdgeLabelLayoutImpl edgeLabelLayoutImpl = (EdgeLabelLayoutImpl)object[n];
                    edgeLabelLayoutImpl.setEdgeLabelModel(new _a(labelLayoutData, (Edge)object2));
                    edgeLabelLayoutImpl.setPreferredPlacement(labelLayoutData.getPreferredPlacement());
                    yList.add(edgeLabelLayoutImpl);
                }
                ++n;
            }
            edgeCursor.next();
        }
        if (yList.isEmpty()) {
            return;
        }
        this.cb.setProfitModel(new _if());
        this.cb.label(copiedLayoutGraph, new YList(), yList);
        object2 = copiedLayoutGraph.edges();
        while (object2.ok()) {
            edge = object2.edge();
            object = (Edge)copiedLayoutGraph.getOriginalEdge(edge);
            labelLayoutConstantsArray = layoutGraph.getLabelLayout(edge);
            LabelLayoutData[] labelLayoutDataArray = (LabelLayoutData[])dataProvider.get(object);
            int n = 0;
            while (n < labelLayoutConstantsArray.length) {
                LabelLayoutData labelLayoutData = labelLayoutDataArray[n];
                byte by = labelLayoutData.getPreferredPlacement();
                if ((by & 1) != 0 || (by & 2) != 0) {
                    LabelLayoutConstants labelLayoutConstants = labelLayoutConstantsArray[n];
                    EdgeLabelModel edgeLabelModel = labelLayoutConstants.getLabelModel();
                    YPoint yPoint = edgeLabelModel.getLabelPlacement(new YDimension(labelLayoutData.getWidth(), labelLayoutData.getHeight()), copiedLayoutGraph.getEdgeLayout(edge), copiedLayoutGraph.getNodeLayout(edge.source()), copiedLayoutGraph.getNodeLayout(edge.target()), labelLayoutConstants.getModelParameter());
                    labelLayoutData.setLocation(yPoint.x, yPoint.y);
                }
                ++n;
            }
            object2.next();
        }
    }

    class _if
    implements ProfitModel {
        _if() {
        }

        public double getProfit(LabelCandidate labelCandidate) {
            if (!(labelCandidate.getOwner() instanceof EdgeLabelLayout)) {
                return 1.0;
            }
            EdgeLabelLayout edgeLabelLayout = (EdgeLabelLayout)labelCandidate.getOwner();
            byte by = edgeLabelLayout.getPreferredPlacement();
            Object object = labelCandidate.getParameter();
            if (object instanceof SliderEdgeLabelModel.ModelParameter) {
                SliderEdgeLabelModel.ModelParameter modelParameter = (SliderEdgeLabelModel.ModelParameter)object;
                if ((by & 1) != 0) {
                    return 1.0 - modelParameter.getAbsRatio();
                }
                if ((by & 2) != 0) {
                    return modelParameter.getAbsRatio();
                }
                return Math.abs(0.5 - modelParameter.getAbsRatio()) + 0.5;
            }
            return 0.9;
        }
    }

    private static class _a
    implements EdgeLabelModel {
        SliderEdgeLabelModel b;
        LabelLayoutData a;
        Edge c;

        _a(LabelLayoutData labelLayoutData, Edge edge) {
            this.c = edge;
            this.a = labelLayoutData;
            this.b = this.a() ? new SliderEdgeLabelModel(1) : new SliderEdgeLabelModel(0);
        }

        boolean a() {
            byte by = this.a.getPreferredPlacement();
            return (by & 0x10) != 0 || (by & 0x20) != 0;
        }

        public Object createModelParameter(YRectangle yRectangle, EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2) {
            throw new UnsupportedOperationException();
        }

        public Object getDefaultParameter() {
            LayoutGraph layoutGraph = (LayoutGraph)this.c.getGraph();
            EdgeLayout edgeLayout = layoutGraph.getLayout(this.c);
            NodeLayout nodeLayout = layoutGraph.getLayout(this.c.source());
            NodeLayout nodeLayout2 = layoutGraph.getLayout(this.c.target());
            return this.b.createModelParameter(new YRectangle(this.a.getX(), this.a.getY(), this.a.getWidth(), this.a.getHeight()), edgeLayout, nodeLayout, nodeLayout2);
        }

        /*
         * Unable to fully structure code
         */
        public YList getLabelCandidates(EdgeLabelLayout var1_1, EdgeLayout var2_2, NodeLayout var3_3, NodeLayout var4_4) {
            var5_5 = (SliderEdgeLabelModel.ModelParameter)this.b.createModelParameter(new YRectangle(this.a.getX(), this.a.getY(), this.a.getWidth(), this.a.getHeight()), var2_2, var3_3, var4_4);
            var6_6 = this.a.getPreferredPlacement() & 7;
            var7_7 = this.a.getPreferredPlacement() & 56;
            var8_8 = this.b.getLabelCandidates(var1_1, var2_2, var3_3, var4_4);
            var9_9 = var8_8.firstCell();
            while (var9_9 != null) {
                block7: {
                    block6: {
                        var10_10 = (EdgeLabelCandidate)var9_9.getInfo();
                        var11_11 = (SliderEdgeLabelModel.ModelParameter)var10_10.getParameter();
                        if (var6_6 != 1) break block6;
                        if (!(var11_11.getAbsRatio() >= var5_5.getAbsRatio())) ** GOTO lbl-1000
                        var8_8.removeCell(var9_9);
                        break block7;
                    }
                    if (var6_6 == 2 && var11_11.getAbsRatio() <= var5_5.getAbsRatio()) {
                        var8_8.removeCell(var9_9);
                    } else if ((var7_7 & 16) == 0 && var11_11.getLabelPosition() == 3) {
                        var8_8.removeCell(var9_9);
                    } else if ((var7_7 & 32) == 0 && var11_11.getLabelPosition() == 4) {
                        var8_8.removeCell(var9_9);
                    }
                }
                var9_9 = var9_9.succ();
            }
            var10_10 = new EdgeLabelCandidate(new YPoint(this.a.getX(), this.a.getY()), new YDimension(this.a.getWidth(), this.a.getHeight()), (Object)var5_5, var1_1, this.a() == false);
            var8_8.add(var10_10);
            return var8_8;
        }

        public YPoint getLabelPlacement(YDimension yDimension, EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2, Object object) {
            return this.b.getLabelPlacement(yDimension, edgeLayout, nodeLayout, nodeLayout2, object);
        }
    }
}

