/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import y.base.Edge;
import y.base.EdgeCursor;
import y.base.Node;
import y.base.YList;
import y.geom.YDimension;
import y.geom.YPoint;
import y.layout.LayoutGraph;
import y.layout.NodeLabelCandidate;
import y.layout.NodeLabelLayout;
import y.layout.NodeLabelModel;
import y.layout.NodeLayout;

public class EdgeOppositeNodeLabelModel
implements NodeLabelModel {
    private LayoutGraph b;
    private Node a;

    public EdgeOppositeNodeLabelModel(LayoutGraph layoutGraph, Node node) {
        this.b = layoutGraph;
        this.a = node;
    }

    public Object getDefaultParameter() {
        return null;
    }

    public YPoint getLabelPlacement(YDimension yDimension, NodeLayout nodeLayout, Object object) {
        double d2 = nodeLayout.getX();
        double d3 = nodeLayout.getY();
        Node node = this.a;
        if (node.degree() > 0) {
            double d4 = 0.0;
            double d5 = 0.0;
            EdgeCursor edgeCursor = node.edges();
            while (edgeCursor.ok()) {
                Edge edge = edgeCursor.edge();
                Node node2 = edge.opposite(node);
                d4 += this.b.getCenterX(node) - this.b.getCenterX(node2);
                d5 += this.b.getCenterY(node) - this.b.getCenterY(node2);
                edgeCursor.next();
            }
            if ((d4 /= (double)node.degree()) != 0.0 || (d5 /= (double)node.degree()) != 0.0) {
                double d6 = Math.sqrt(d4 * d4 + d5 * d5);
                double d7 = Math.sqrt(this.b.getHeight(node) * this.b.getHeight(node) + this.b.getWidth(node) * this.b.getWidth(node));
                d4 = d4 * (d7 + 10.0) / d6;
                d5 = d5 * (d7 + 10.0) / d6;
                return new YPoint(d2 + d4, d3 + d5);
            }
        }
        d2 = nodeLayout.getX() + (nodeLayout.getWidth() - yDimension.getWidth()) / 2.0;
        d3 = nodeLayout.getY() + nodeLayout.getHeight();
        return new YPoint(d2, d3);
    }

    public YList getLabelCandidates(NodeLabelLayout nodeLabelLayout, NodeLayout nodeLayout) {
        YList yList = new YList();
        yList.add(new NodeLabelCandidate(this.getLabelPlacement(nodeLabelLayout.getBox(), nodeLayout, null), (YDimension)nodeLabelLayout.getBox(), null, nodeLabelLayout));
        return yList;
    }

    public class ModelParameter {
        double a;
        double b;

        public ModelParameter() {
            this.a = 0.0;
            this.b = 0.0;
        }

        public ModelParameter(double d2, double d3) {
            this.a = d2;
            this.b = d3;
        }

        public YPoint getPoint() {
            return new YPoint(this.a, this.b);
        }

        public void setPoint(double d2, double d3) {
            this.a = d2;
            this.b = d3;
        }
    }
}

