/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import java.util.Hashtable;
import y.base.Edge;
import y.base.EdgeMap;
import y.base.GraphInterface;
import y.base.Node;
import y.base.NodeMap;
import y.base.YCursor;
import y.layout.DefaultEdgeLayout;
import y.layout.DefaultNodeLayout;
import y.layout.EdgeLabelLayout;
import y.layout.EdgeLayout;
import y.layout.GraphLayout;
import y.layout.LayoutGraph;
import y.layout.NodeLabelLayout;
import y.layout.NodeLayout;

public class DefaultLayoutGraph
extends LayoutGraph {
    private NodeMap ap;
    private EdgeMap as;
    protected NodeMap nodeLabelMap;
    protected EdgeMap edgeLabelMap;
    protected Hashtable nodeLabelFeatureMap = new Hashtable();
    protected Hashtable edgeLabelFeatureMap = new Hashtable();
    private NodeMap at;
    private EdgeMap ao;
    private GraphInterface ar;
    private GraphLayout an;
    private boolean aq;

    public DefaultLayoutGraph() {
        this.ap = this.createNodeMap();
        this.nodeLabelMap = this.createNodeMap();
        this.as = this.createEdgeMap();
        this.edgeLabelMap = this.createEdgeMap();
    }

    public DefaultLayoutGraph(LayoutGraph layoutGraph, YCursor yCursor) {
        super(layoutGraph, yCursor);
        this.ap = this.createNodeMap();
        this.as = this.createEdgeMap();
        this.nodeLabelMap = this.createNodeMap();
        this.edgeLabelMap = this.createEdgeMap();
    }

    public DefaultLayoutGraph(DefaultLayoutGraph defaultLayoutGraph, YCursor yCursor) {
        this((LayoutGraph)defaultLayoutGraph, yCursor);
    }

    public NodeLayout getLayout(Node node) {
        NodeLayout nodeLayout = (NodeLayout)this.ap.get(node);
        if (nodeLayout == null) {
            nodeLayout = this.createNodeLayout();
            this.ap.set(node, nodeLayout);
        }
        return nodeLayout;
    }

    public void setLayout(Node node, NodeLayout nodeLayout) {
        this.ap.set(node, nodeLayout);
    }

    public EdgeLayout getLayout(Edge edge) {
        EdgeLayout edgeLayout = (EdgeLayout)this.as.get(edge);
        if (edgeLayout == null) {
            edgeLayout = this.createEdgeLayout();
            this.as.set(edge, edgeLayout);
        }
        return edgeLayout;
    }

    public NodeLabelLayout[] getLabelLayout(Node node) {
        NodeLabelLayout[] nodeLabelLayoutArray = (NodeLabelLayout[])this.nodeLabelMap.get(node);
        if (nodeLabelLayoutArray == null) {
            nodeLabelLayoutArray = new NodeLabelLayout[]{};
            this.nodeLabelMap.set(node, nodeLabelLayoutArray);
        }
        return nodeLabelLayoutArray;
    }

    public void setLabelLayout(Node node, NodeLabelLayout nodeLabelLayout) {
        NodeLabelLayout[] nodeLabelLayoutArray = new NodeLabelLayout[]{nodeLabelLayout};
        this.nodeLabelMap.set(node, nodeLabelLayoutArray);
        this.nodeLabelFeatureMap.put(nodeLabelLayout, node);
    }

    public void setLabelLayout(Edge edge, EdgeLabelLayout[] edgeLabelLayoutArray) {
        this.edgeLabelMap.set(edge, edgeLabelLayoutArray);
        int n = 0;
        while (n < edgeLabelLayoutArray.length) {
            this.edgeLabelFeatureMap.put(edgeLabelLayoutArray[n], edge);
            ++n;
        }
    }

    public EdgeLabelLayout[] getLabelLayout(Edge edge) {
        EdgeLabelLayout[] edgeLabelLayoutArray = (EdgeLabelLayout[])this.edgeLabelMap.get(edge);
        if (edgeLabelLayoutArray == null) {
            edgeLabelLayoutArray = new EdgeLabelLayout[]{};
            this.edgeLabelMap.set(edge, edgeLabelLayoutArray);
        }
        return edgeLabelLayoutArray;
    }

    public Node getFeature(NodeLabelLayout nodeLabelLayout) {
        return (Node)this.nodeLabelFeatureMap.get(nodeLabelLayout);
    }

    public Edge getFeature(EdgeLabelLayout edgeLabelLayout) {
        return (Edge)this.edgeLabelFeatureMap.get(edgeLabelLayout);
    }

    protected EdgeLayout createEdgeLayout() {
        return new DefaultEdgeLayout();
    }

    protected NodeLayout createNodeLayout() {
        return new DefaultNodeLayout();
    }
}

