/*
 * Decompiled with CFR 0.152.
 */
package y.io.gml;

import java.io.IOException;
import y.base.Node;
import y.io.gml.GMLEncoder;
import y.io.gml.ObjectEncoder;
import y.view.Graph2D;
import y.view.NodeRealizer;

public class NodeObjectEncoder
implements ObjectEncoder {
    private ObjectEncoder j;
    private ObjectEncoder k;

    public NodeObjectEncoder() {
        this(null, null);
    }

    public NodeObjectEncoder(ObjectEncoder objectEncoder, ObjectEncoder objectEncoder2) {
        this.j = objectEncoder;
        this.k = objectEncoder2;
    }

    public void encode(Object object, GMLEncoder gMLEncoder) throws IOException {
        Node node = (Node)object;
        Graph2D graph2D = (Graph2D)node.getGraph();
        NodeRealizer nodeRealizer = graph2D.getRealizer(node);
        gMLEncoder.addAttribute("id", node.index());
        String string = nodeRealizer.getLabelText();
        gMLEncoder.addAttribute("label", string);
        if (this.j != null) {
            gMLEncoder.beginSection("graphics");
            this.j.encode(nodeRealizer, gMLEncoder);
            gMLEncoder.endSection();
        }
        if (this.k != null) {
            int n = 0;
            while (n < nodeRealizer.labelCount()) {
                gMLEncoder.beginSection("LabelGraphics");
                this.k.encode(nodeRealizer.getLabel(n), gMLEncoder);
                gMLEncoder.endSection();
                ++n;
            }
        }
    }

    public ObjectEncoder getLabelEncoder() {
        return this.k;
    }

    public void setLabelEncoder(ObjectEncoder objectEncoder) {
        this.k = objectEncoder;
    }

    public ObjectEncoder getRealizerEncoder() {
        return this.j;
    }

    public void setRealizerEncoder(ObjectEncoder objectEncoder) {
        this.j = objectEncoder;
    }
}

