/*
 * Decompiled with CFR 0.152.
 */
package y.io.gml;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;

public class GMLEncoder {
    private int d;
    private Writer c;
    private StringBuffer b = new StringBuffer(100);
    private String a;

    public GMLEncoder(Writer writer) {
        this.b.append("\t\t\t\t");
        this.d = 0;
        this.c = writer;
        this.a = System.getProperty("line.separator");
    }

    protected void writeIndentation() throws IOException {
        int n = this.d;
        while (this.b.length() < n) {
            this.b.append(this.b.toString());
        }
        this.c.write(this.b.toString(), 0, n);
    }

    public void beginSection(String string) throws IOException {
        this.writeIndentation();
        this.c.write(string);
        this.c.write(this.a);
        this.writeIndentation();
        this.c.write("[" + this.a);
        ++this.d;
    }

    protected void writeAttribute(String string, String string2) throws IOException {
        this.writeIndentation();
        this.c.write(string);
        this.c.write(9);
        this.c.write(string2);
        this.c.write(this.a);
    }

    public void addAttribute(String string, double d2) throws IOException {
        this.writeAttribute(string, Double.toString(d2));
    }

    public void addAttribute(String string, int n) throws IOException {
        this.writeAttribute(string, Integer.toString(n));
    }

    public void addAttribute(String string, Number number) throws IOException {
        this.writeAttribute(string, number.toString());
    }

    public void addAttribute(String string, boolean bl) throws IOException {
        this.writeAttribute(string, bl ? "1" : "0");
    }

    public void addAttribute(String string, String string2) throws IOException {
        this.writeAttribute(string, this.sanatize(string2));
    }

    public void addAttribute(String string, Object object) throws IOException {
        if (object != null) {
            if (object instanceof Double) {
                this.addAttribute(string, (Double)object);
            } else if (object instanceof Integer) {
                this.addAttribute(string, (Integer)object);
            } else if (object instanceof Number) {
                this.addAttribute(string, ((Number)object).doubleValue());
            } else if (object instanceof Collection) {
                this.addAttributes(string, "item", (Collection)object);
            } else {
                this.addAttribute(string, object.toString());
            }
        } else {
            this.addAttribute(string, "null");
        }
    }

    public void addAttributes(String string, String string2, Collection collection) throws IOException {
        this.beginSection(string);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addAttribute(string2, iterator.next());
        }
        this.endSection();
    }

    protected String sanatize(String string) {
        if (string.indexOf(10) < 0 && string.indexOf(38) < 0 && string.indexOf(34) < 0) {
            return '\"' + string + '\"';
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 5);
        stringBuffer.append('\"');
        int n = 0;
        while (n < string.length()) {
            char c2 = string.charAt(n);
            switch (c2) {
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
            ++n;
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public void endSection() throws IOException {
        --this.d;
        this.writeIndentation();
        this.c.write("]" + this.a);
    }

    public int getLevel() {
        return this.d;
    }
}

